/*
 * $Id$
 */

package org.apache.maven.continuum.model.system;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;
import org.apache.maven.continuum.model.project.BuildDefinition;
import org.apache.maven.continuum.model.project.BuildDefinitionTemplate;
import org.apache.maven.continuum.model.project.BuildResult;
import org.apache.maven.continuum.model.project.ContinuumDatabase;
import org.apache.maven.continuum.model.project.Project;
import org.apache.maven.continuum.model.project.ProjectDependency;
import org.apache.maven.continuum.model.project.ProjectDeveloper;
import org.apache.maven.continuum.model.project.ProjectGroup;
import org.apache.maven.continuum.model.project.ProjectNotifier;
import org.apache.maven.continuum.model.project.Schedule;
import org.apache.maven.continuum.model.scm.ChangeFile;
import org.apache.maven.continuum.model.scm.ChangeSet;
import org.apache.maven.continuum.model.scm.ScmResult;
import org.apache.maven.continuum.model.scm.SuiteResult;
import org.apache.maven.continuum.model.scm.TestCaseFailure;
import org.apache.maven.continuum.model.scm.TestResult;
import org.apache.maven.continuum.project.ContinuumProjectState;

/**
 * 
 *         Configures one method for notifying users/developers
 * when a build breaks.
 *       
 * 
 * @version $Revision$ $Date$
 */
public class NotificationAddress implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field type
     */
    private String type = "mail";

    /**
     * Field address
     */
    private String address;

    /**
     * Field configuration
     */
    private java.util.Map configuration;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addConfiguration
     * 
     * @param key
     * @param value
     */
    public void addConfiguration(Object key, String value)
    {
        getConfiguration().put( key, value );
    } //-- void addConfiguration(Object, String) 

    /**
     * Get null
     */
    public String getAddress()
    {
        return this.address;
    } //-- String getAddress() 

    /**
     * Method getConfiguration
     */
    public java.util.Map getConfiguration()
    {
        if ( this.configuration == null )
        {
            this.configuration = new java.util.HashMap();
        }
        
        return this.configuration;
    } //-- java.util.Map getConfiguration() 

    /**
     * Get The mechanism used to deliver notifications.
     */
    public String getType()
    {
        return this.type;
    } //-- String getType() 

    /**
     * Set null
     * 
     * @param address
     */
    public void setAddress(String address)
    {
        this.address = address;
    } //-- void setAddress(String) 

    /**
     * Set Extended configuration specific to this notifier goes
     * here.
     * 
     * @param configuration
     */
    public void setConfiguration(java.util.Map configuration)
    {
        this.configuration = configuration;
    } //-- void setConfiguration(java.util.Map) 

    /**
     * Set The mechanism used to deliver notifications.
     * 
     * @param type
     */
    public void setType(String type)
    {
        this.type = type;
    } //-- void setType(String) 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
