/*
 * $Id$
 */

package org.apache.maven.continuum.model.system;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;
import org.apache.maven.continuum.model.project.BuildDefinition;
import org.apache.maven.continuum.model.project.BuildDefinitionTemplate;
import org.apache.maven.continuum.model.project.BuildResult;
import org.apache.maven.continuum.model.project.ContinuumDatabase;
import org.apache.maven.continuum.model.project.Project;
import org.apache.maven.continuum.model.project.ProjectDependency;
import org.apache.maven.continuum.model.project.ProjectDeveloper;
import org.apache.maven.continuum.model.project.ProjectGroup;
import org.apache.maven.continuum.model.project.ProjectNotifier;
import org.apache.maven.continuum.model.project.Schedule;
import org.apache.maven.continuum.model.scm.ChangeFile;
import org.apache.maven.continuum.model.scm.ChangeSet;
import org.apache.maven.continuum.model.scm.ScmResult;
import org.apache.maven.continuum.model.scm.SuiteResult;
import org.apache.maven.continuum.model.scm.TestCaseFailure;
import org.apache.maven.continuum.model.scm.TestResult;
import org.apache.maven.continuum.project.ContinuumProjectState;

/**
 * null
 * 
 * @version $Revision$ $Date$
 */
public class Installation implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field type
     */
    private String type;

    /**
     * Field varValue
     */
    private String varValue;

    /**
     * Field varName
     */
    private String varName;

    /**
     * Field name
     */
    private String name;

    /**
     * Field installationId
     */
    private int installationId = 0;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method equals
     * 
     * @param other
     */
    public boolean equals(Object other)
    {
        if ( this == other)
        {
            return true;
        }
        
        if ( !(other instanceof Installation) )
        {
            return false;
        }
        
        Installation that = (Installation) other;
        boolean result = true;
        result = result && installationId== that.installationId;
        return result;
    } //-- boolean equals(Object) 

    /**
     * Get null
     */
    public int getInstallationId()
    {
        return this.installationId;
    } //-- int getInstallationId() 

    /**
     * Get null
     */
    public String getName()
    {
        return this.name;
    } //-- String getName() 

    /**
     * Get null
     */
    public String getType()
    {
        return this.type;
    } //-- String getType() 

    /**
     * Get null
     */
    public String getVarName()
    {
        return this.varName;
    } //-- String getVarName() 

    /**
     * Get null
     */
    public String getVarValue()
    {
        return this.varValue;
    } //-- String getVarValue() 

    /**
     * Method hashCode
     */
    public int hashCode()
    {
        int result = 17;
        long tmp;
        result = 37 * result + (int) installationId;
        return result;
    } //-- int hashCode() 

    /**
     * Set null
     * 
     * @param installationId
     */
    public void setInstallationId(int installationId)
    {
        this.installationId = installationId;
    } //-- void setInstallationId(int) 

    /**
     * Set null
     * 
     * @param name
     */
    public void setName(String name)
    {
        this.name = name;
    } //-- void setName(String) 

    /**
     * Set null
     * 
     * @param type
     */
    public void setType(String type)
    {
        this.type = type;
    } //-- void setType(String) 

    /**
     * Set null
     * 
     * @param varName
     */
    public void setVarName(String varName)
    {
        this.varName = varName;
    } //-- void setVarName(String) 

    /**
     * Set null
     * 
     * @param varValue
     */
    public void setVarValue(String varValue)
    {
        this.varValue = varValue;
    } //-- void setVarValue(String) 

    /**
     * Method toString
     */
    public java.lang.String toString()
    {
        StringBuffer buf = new StringBuffer();
        buf.append( "installationId = '" );
        buf.append( getInstallationId() + "'" );
        return buf.toString();
    } //-- java.lang.String toString() 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
