/*
 * $Id$
 */

package org.apache.maven.continuum.model.scm;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;
import org.apache.maven.continuum.model.project.BuildDefinition;
import org.apache.maven.continuum.model.project.BuildDefinitionTemplate;
import org.apache.maven.continuum.model.project.BuildResult;
import org.apache.maven.continuum.model.project.ContinuumDatabase;
import org.apache.maven.continuum.model.project.Project;
import org.apache.maven.continuum.model.project.ProjectDependency;
import org.apache.maven.continuum.model.project.ProjectDeveloper;
import org.apache.maven.continuum.model.project.ProjectGroup;
import org.apache.maven.continuum.model.project.ProjectNotifier;
import org.apache.maven.continuum.model.project.Schedule;
import org.apache.maven.continuum.model.system.Installation;
import org.apache.maven.continuum.model.system.NotificationAddress;
import org.apache.maven.continuum.model.system.Profile;
import org.apache.maven.continuum.model.system.SystemConfiguration;
import org.apache.maven.continuum.project.ContinuumProjectState;

/**
 * null
 * 
 * @version $Revision$ $Date$
 */
public class TestResult implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field testCount
     */
    private int testCount = 0;

    /**
     * Field failureCount
     */
    private int failureCount = 0;

    /**
     * Field totalTime
     */
    private long totalTime = 0;

    /**
     * Field suiteResults
     */
    private java.util.List suiteResults;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addSuiteResult
     * 
     * @param suiteResult
     */
    public void addSuiteResult(SuiteResult suiteResult)
    {
        if ( !(suiteResult instanceof SuiteResult) )
        {
            throw new ClassCastException( "TestResult.addSuiteResults(suiteResult) parameter must be instanceof " + SuiteResult.class.getName() );
        }
        getSuiteResults().add( suiteResult );
    } //-- void addSuiteResult(SuiteResult) 

    /**
     * Get null
     */
    public int getFailureCount()
    {
        return this.failureCount;
    } //-- int getFailureCount() 

    /**
     * Method getSuiteResults
     */
    public java.util.List getSuiteResults()
    {
        if ( this.suiteResults == null )
        {
            this.suiteResults = new java.util.ArrayList();
        }
        
        return this.suiteResults;
    } //-- java.util.List getSuiteResults() 

    /**
     * Get null
     */
    public int getTestCount()
    {
        return this.testCount;
    } //-- int getTestCount() 

    /**
     * Get null
     */
    public long getTotalTime()
    {
        return this.totalTime;
    } //-- long getTotalTime() 

    /**
     * Method removeSuiteResult
     * 
     * @param suiteResult
     */
    public void removeSuiteResult(SuiteResult suiteResult)
    {
        if ( !(suiteResult instanceof SuiteResult) )
        {
            throw new ClassCastException( "TestResult.removeSuiteResults(suiteResult) parameter must be instanceof " + SuiteResult.class.getName() );
        }
        getSuiteResults().remove( suiteResult );
    } //-- void removeSuiteResult(SuiteResult) 

    /**
     * Set null
     * 
     * @param failureCount
     */
    public void setFailureCount(int failureCount)
    {
        this.failureCount = failureCount;
    } //-- void setFailureCount(int) 

    /**
     * Set null
     * 
     * @param suiteResults
     */
    public void setSuiteResults(java.util.List suiteResults)
    {
        this.suiteResults = suiteResults;
    } //-- void setSuiteResults(java.util.List) 

    /**
     * Set null
     * 
     * @param testCount
     */
    public void setTestCount(int testCount)
    {
        this.testCount = testCount;
    } //-- void setTestCount(int) 

    /**
     * Set null
     * 
     * @param totalTime
     */
    public void setTotalTime(long totalTime)
    {
        this.totalTime = totalTime;
    } //-- void setTotalTime(long) 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
