/*
 * $Id$
 */

package org.apache.maven.continuum.model.scm;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;
import org.apache.maven.continuum.model.project.BuildDefinition;
import org.apache.maven.continuum.model.project.BuildDefinitionTemplate;
import org.apache.maven.continuum.model.project.BuildResult;
import org.apache.maven.continuum.model.project.ContinuumDatabase;
import org.apache.maven.continuum.model.project.Project;
import org.apache.maven.continuum.model.project.ProjectDependency;
import org.apache.maven.continuum.model.project.ProjectDeveloper;
import org.apache.maven.continuum.model.project.ProjectGroup;
import org.apache.maven.continuum.model.project.ProjectNotifier;
import org.apache.maven.continuum.model.project.Schedule;
import org.apache.maven.continuum.model.system.Installation;
import org.apache.maven.continuum.model.system.NotificationAddress;
import org.apache.maven.continuum.model.system.Profile;
import org.apache.maven.continuum.model.system.SystemConfiguration;
import org.apache.maven.continuum.project.ContinuumProjectState;

/**
 * null
 * 
 * @version $Revision$ $Date$
 */
public class SuiteResult implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field name
     */
    private String name;

    /**
     * Field testCount
     */
    private int testCount = 0;

    /**
     * Field failureCount
     */
    private int failureCount = 0;

    /**
     * Field totalTime
     */
    private long totalTime = 0;

    /**
     * Field failures
     */
    private java.util.List failures;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addFailure
     * 
     * @param testCaseFailure
     */
    public void addFailure(TestCaseFailure testCaseFailure)
    {
        if ( !(testCaseFailure instanceof TestCaseFailure) )
        {
            throw new ClassCastException( "SuiteResult.addFailures(testCaseFailure) parameter must be instanceof " + TestCaseFailure.class.getName() );
        }
        getFailures().add( testCaseFailure );
    } //-- void addFailure(TestCaseFailure) 

    /**
     * Get null
     */
    public int getFailureCount()
    {
        return this.failureCount;
    } //-- int getFailureCount() 

    /**
     * Method getFailures
     */
    public java.util.List getFailures()
    {
        if ( this.failures == null )
        {
            this.failures = new java.util.ArrayList();
        }
        
        return this.failures;
    } //-- java.util.List getFailures() 

    /**
     * Get null
     */
    public String getName()
    {
        return this.name;
    } //-- String getName() 

    /**
     * Get null
     */
    public int getTestCount()
    {
        return this.testCount;
    } //-- int getTestCount() 

    /**
     * Get null
     */
    public long getTotalTime()
    {
        return this.totalTime;
    } //-- long getTotalTime() 

    /**
     * Method removeFailure
     * 
     * @param testCaseFailure
     */
    public void removeFailure(TestCaseFailure testCaseFailure)
    {
        if ( !(testCaseFailure instanceof TestCaseFailure) )
        {
            throw new ClassCastException( "SuiteResult.removeFailures(testCaseFailure) parameter must be instanceof " + TestCaseFailure.class.getName() );
        }
        getFailures().remove( testCaseFailure );
    } //-- void removeFailure(TestCaseFailure) 

    /**
     * Set null
     * 
     * @param failureCount
     */
    public void setFailureCount(int failureCount)
    {
        this.failureCount = failureCount;
    } //-- void setFailureCount(int) 

    /**
     * Set null
     * 
     * @param failures
     */
    public void setFailures(java.util.List failures)
    {
        this.failures = failures;
    } //-- void setFailures(java.util.List) 

    /**
     * Set null
     * 
     * @param name
     */
    public void setName(String name)
    {
        this.name = name;
    } //-- void setName(String) 

    /**
     * Set null
     * 
     * @param testCount
     */
    public void setTestCount(int testCount)
    {
        this.testCount = testCount;
    } //-- void setTestCount(int) 

    /**
     * Set null
     * 
     * @param totalTime
     */
    public void setTotalTime(long totalTime)
    {
        this.totalTime = totalTime;
    } //-- void setTotalTime(long) 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
