/*
 * $Id$
 */

package org.apache.maven.continuum.model.scm;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;
import org.apache.maven.continuum.model.project.BuildDefinition;
import org.apache.maven.continuum.model.project.BuildDefinitionTemplate;
import org.apache.maven.continuum.model.project.BuildResult;
import org.apache.maven.continuum.model.project.ContinuumDatabase;
import org.apache.maven.continuum.model.project.Project;
import org.apache.maven.continuum.model.project.ProjectDependency;
import org.apache.maven.continuum.model.project.ProjectDeveloper;
import org.apache.maven.continuum.model.project.ProjectGroup;
import org.apache.maven.continuum.model.project.ProjectNotifier;
import org.apache.maven.continuum.model.project.Schedule;
import org.apache.maven.continuum.model.system.Installation;
import org.apache.maven.continuum.model.system.NotificationAddress;
import org.apache.maven.continuum.model.system.Profile;
import org.apache.maven.continuum.model.system.SystemConfiguration;
import org.apache.maven.continuum.project.ContinuumProjectState;

/**
 * null
 * 
 * @version $Revision$ $Date$
 */
public class ChangeSet implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field id
     */
    private String id;

    /**
     * Field author
     */
    private String author;

    /**
     * Field comment
     */
    private String comment;

    /**
     * Field date
     */
    private long date = 0;

    /**
     * Field files
     */
    private java.util.List files;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addFile
     * 
     * @param changeFile
     */
    public void addFile(ChangeFile changeFile)
    {
        if ( !(changeFile instanceof ChangeFile) )
        {
            throw new ClassCastException( "ChangeSet.addFiles(changeFile) parameter must be instanceof " + ChangeFile.class.getName() );
        }
        getFiles().add( changeFile );
    } //-- void addFile(ChangeFile) 

    /**
     * Get null
     */
    public String getAuthor()
    {
        return this.author;
    } //-- String getAuthor() 

    /**
     * Get null
     */
    public String getComment()
    {
        return this.comment;
    } //-- String getComment() 

    /**
     * Get null
     */
    public long getDate()
    {
        return this.date;
    } //-- long getDate() 

    /**
     * Method getFiles
     */
    public java.util.List getFiles()
    {
        if ( this.files == null )
        {
            this.files = new java.util.ArrayList();
        }
        
        return this.files;
    } //-- java.util.List getFiles() 

    /**
     * Get null
     */
    public String getId()
    {
        return this.id;
    } //-- String getId() 

    /**
     * Method removeFile
     * 
     * @param changeFile
     */
    public void removeFile(ChangeFile changeFile)
    {
        if ( !(changeFile instanceof ChangeFile) )
        {
            throw new ClassCastException( "ChangeSet.removeFiles(changeFile) parameter must be instanceof " + ChangeFile.class.getName() );
        }
        getFiles().remove( changeFile );
    } //-- void removeFile(ChangeFile) 

    /**
     * Set null
     * 
     * @param author
     */
    public void setAuthor(String author)
    {
        this.author = author;
    } //-- void setAuthor(String) 

    /**
     * Set null
     * 
     * @param comment
     */
    public void setComment(String comment)
    {
        this.comment = comment;
    } //-- void setComment(String) 

    /**
     * Set null
     * 
     * @param date
     */
    public void setDate(long date)
    {
        this.date = date;
    } //-- void setDate(long) 

    /**
     * Set null
     * 
     * @param files
     */
    public void setFiles(java.util.List files)
    {
        this.files = files;
    } //-- void setFiles(java.util.List) 

    /**
     * Set null
     * 
     * @param id
     */
    public void setId(String id)
    {
        this.id = id;
    } //-- void setId(String) 


            /**
             * @return Returns string representation of the changeset
             */
            public String toString()
            {
                String result = author + "\n" + date + "\n";

                if ( files != null )
                {
                    for ( java.util.Iterator i = files.iterator(); i.hasNext(); )
                    {
                        ChangeFile file = (ChangeFile) i.next();

                        result += file + "\n";
                    }
                }

                result += comment;

                return result;
            }

            /**
             * @see java.lang.Object#equals(java.lang.Object)
             */
            public boolean equals( Object obj )
            {
                if ( obj instanceof ChangeSet )
                {
                    ChangeSet changeSet = (ChangeSet) obj;

                    if ( toString().equals( changeSet.toString() ) )
                    {
                        return true;
                    }
                }

                return false;
            }

            public java.util.Date getDateAsDate()
            {
                if ( date > 0 )
                {
                    return new java.util.Date( date );
                }

                return null;
            }
          
    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
