/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.model.project.io.stax;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javanet.staxutils.IndentingXMLStreamWriter;
import javax.jdo.spi.PersistenceCapable;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.maven.continuum.model.project.BuildDefinition;
import org.apache.maven.continuum.model.project.BuildResult;
import org.apache.maven.continuum.model.project.ContinuumDatabase;
import org.apache.maven.continuum.model.project.Project;
import org.apache.maven.continuum.model.project.ProjectDependency;
import org.apache.maven.continuum.model.project.ProjectDeveloper;
import org.apache.maven.continuum.model.project.ProjectGroup;
import org.apache.maven.continuum.model.project.ProjectNotifier;
import org.apache.maven.continuum.model.project.Schedule;
import org.apache.maven.continuum.model.scm.ChangeFile;
import org.apache.maven.continuum.model.scm.ChangeSet;
import org.apache.maven.continuum.model.scm.ScmResult;
import org.apache.maven.continuum.model.scm.SuiteResult;
import org.apache.maven.continuum.model.scm.TestCaseFailure;
import org.apache.maven.continuum.model.scm.TestResult;
import org.apache.maven.continuum.model.system.Installation;
import org.apache.maven.continuum.model.system.NotificationAddress;
import org.apache.maven.continuum.model.system.Profile;
import org.apache.maven.continuum.model.system.SystemConfiguration;
import org.apache.maven.continuum.project.ContinuumProjectState;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class ContinuumStaxWriter {
    private int curId;
    private Map idMap = new HashMap();

    public void write(Writer writer, ContinuumDatabase continuumDatabase) throws IOException, XMLStreamException {
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        boolean supportWindowsLineEndings = false;
        if (factory.isPropertySupported("com.ctc.wstx.outputEscapeCr")) {
            factory.setProperty("com.ctc.wstx.outputEscapeCr", Boolean.FALSE);
            supportWindowsLineEndings = true;
        }
        if (factory.isPropertySupported("org.codehaus.stax2.automaticEmptyElements")) {
            factory.setProperty("org.codehaus.stax2.automaticEmptyElements", Boolean.FALSE);
        }
        IndentingXMLStreamWriter serializer = new IndentingXMLStreamWriter(factory.createXMLStreamWriter(writer));
        if (supportWindowsLineEndings) {
            serializer.setNewLine(serializer.getLineSeparator());
        }
        serializer.writeStartDocument(continuumDatabase.getModelEncoding(), "1.0");
        this.writeContinuumDatabase(continuumDatabase, "continuumDatabase", (XMLStreamWriter)serializer);
        serializer.writeEndDocument();
    }

    private void writeBuildDefinition(BuildDefinition buildDefinition, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (buildDefinition != null) {
            serializer.writeStartElement(tagName);
            if (buildDefinition.getId() != 0) {
                serializer.writeStartElement("id");
                serializer.writeCharacters(String.valueOf(buildDefinition.getId()));
                serializer.writeEndElement();
            }
            if (buildDefinition.isDefaultForProject()) {
                serializer.writeStartElement("defaultForProject");
                serializer.writeCharacters(String.valueOf(buildDefinition.isDefaultForProject()));
                serializer.writeEndElement();
            }
            if (buildDefinition.getGoals() != null) {
                serializer.writeStartElement("goals");
                serializer.writeCharacters(buildDefinition.getGoals());
                serializer.writeEndElement();
            }
            if (buildDefinition.getArguments() != null) {
                serializer.writeStartElement("arguments");
                serializer.writeCharacters(buildDefinition.getArguments());
                serializer.writeEndElement();
            }
            if (buildDefinition.getBuildFile() != null) {
                serializer.writeStartElement("buildFile");
                serializer.writeCharacters(buildDefinition.getBuildFile());
                serializer.writeEndElement();
            }
            if (buildDefinition.isBuildFresh()) {
                serializer.writeStartElement("buildFresh");
                serializer.writeCharacters(String.valueOf(buildDefinition.isBuildFresh()));
                serializer.writeEndElement();
            }
            if (buildDefinition.getSchedule() != null) {
                serializer.writeStartElement("schedule");
                serializer.writeAttribute("id", String.valueOf(buildDefinition.getSchedule().getId()));
                serializer.writeEndElement();
            }
            if (buildDefinition.getProfile() != null) {
                serializer.writeStartElement("profile");
                serializer.writeAttribute("id", String.valueOf(buildDefinition.getProfile().getId()));
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeBuildResult(BuildResult buildResult, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (buildResult != null) {
            serializer.writeStartElement(tagName);
            if (buildResult.getProject() != null) {
                serializer.writeStartElement("project");
                serializer.writeAttribute("id", String.valueOf(buildResult.getProject().getId()));
                serializer.writeEndElement();
            }
            if (buildResult.getBuildDefinition() != null) {
                serializer.writeStartElement("buildDefinition");
                serializer.writeAttribute("id", String.valueOf(buildResult.getBuildDefinition().getId()));
                serializer.writeEndElement();
            }
            if (buildResult.getId() != 0) {
                serializer.writeStartElement("id");
                serializer.writeCharacters(String.valueOf(buildResult.getId()));
                serializer.writeEndElement();
            }
            if (buildResult.getBuildNumber() != 0) {
                serializer.writeStartElement("buildNumber");
                serializer.writeCharacters(String.valueOf(buildResult.getBuildNumber()));
                serializer.writeEndElement();
            }
            if (buildResult.getState() != 0) {
                serializer.writeStartElement("state");
                serializer.writeCharacters(String.valueOf(buildResult.getState()));
                serializer.writeEndElement();
            }
            if (buildResult.getTrigger() != 0) {
                serializer.writeStartElement("trigger");
                serializer.writeCharacters(String.valueOf(buildResult.getTrigger()));
                serializer.writeEndElement();
            }
            if (buildResult.getStartTime() != 0L) {
                serializer.writeStartElement("startTime");
                serializer.writeCharacters(String.valueOf(buildResult.getStartTime()));
                serializer.writeEndElement();
            }
            if (buildResult.getEndTime() != 0L) {
                serializer.writeStartElement("endTime");
                serializer.writeCharacters(String.valueOf(buildResult.getEndTime()));
                serializer.writeEndElement();
            }
            if (buildResult.getError() != null) {
                serializer.writeStartElement("error");
                serializer.writeCharacters(buildResult.getError());
                serializer.writeEndElement();
            }
            if (buildResult.isSuccess()) {
                serializer.writeStartElement("success");
                serializer.writeCharacters(String.valueOf(buildResult.isSuccess()));
                serializer.writeEndElement();
            }
            if (buildResult.getExitCode() != 0) {
                serializer.writeStartElement("exitCode");
                serializer.writeCharacters(String.valueOf(buildResult.getExitCode()));
                serializer.writeEndElement();
            }
            if (buildResult.getScmResult() != null) {
                this.writeScmResult(buildResult.getScmResult(), "scmResult", serializer);
            }
            if (buildResult.getTestResult() != null) {
                this.writeTestResult(buildResult.getTestResult(), "testResult", serializer);
            }
            if (buildResult.getModifiedDependencies() != null && buildResult.getModifiedDependencies().size() > 0) {
                serializer.writeStartElement("modifiedDependencies");
                for (ProjectDependency o : buildResult.getModifiedDependencies()) {
                    this.writeProjectDependency(o, "modifiedDependency", serializer);
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeChangeFile(ChangeFile changeFile, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (changeFile != null) {
            serializer.writeStartElement(tagName);
            if (changeFile.getName() != null) {
                serializer.writeStartElement("name");
                serializer.writeCharacters(changeFile.getName());
                serializer.writeEndElement();
            }
            if (changeFile.getRevision() != null) {
                serializer.writeStartElement("revision");
                serializer.writeCharacters(changeFile.getRevision());
                serializer.writeEndElement();
            }
            if (changeFile.getStatus() != null) {
                serializer.writeStartElement("status");
                serializer.writeCharacters(changeFile.getStatus());
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeChangeSet(ChangeSet changeSet, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (changeSet != null) {
            serializer.writeStartElement(tagName);
            if (changeSet.getId() != null) {
                serializer.writeStartElement("id");
                serializer.writeCharacters(changeSet.getId());
                serializer.writeEndElement();
            }
            if (changeSet.getAuthor() != null) {
                serializer.writeStartElement("author");
                serializer.writeCharacters(changeSet.getAuthor());
                serializer.writeEndElement();
            }
            if (changeSet.getComment() != null) {
                serializer.writeStartElement("comment");
                serializer.writeCharacters(changeSet.getComment());
                serializer.writeEndElement();
            }
            if (changeSet.getDate() != 0L) {
                serializer.writeStartElement("date");
                serializer.writeCharacters(String.valueOf(changeSet.getDate()));
                serializer.writeEndElement();
            }
            if (changeSet.getFiles() != null && changeSet.getFiles().size() > 0) {
                serializer.writeStartElement("files");
                for (ChangeFile o : changeSet.getFiles()) {
                    this.writeChangeFile(o, "file", serializer);
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeContinuumDatabase(ContinuumDatabase continuumDatabase, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (continuumDatabase != null) {
            serializer.writeStartElement(tagName);
            if (continuumDatabase.getProjectGroups() != null && continuumDatabase.getProjectGroups().size() > 0) {
                serializer.writeStartElement("projectGroups");
                for (PersistenceCapable o : continuumDatabase.getProjectGroups()) {
                    this.writeProjectGroup((ProjectGroup)o, "projectGroup", serializer);
                }
                serializer.writeEndElement();
            }
            if (continuumDatabase.getSystemConfiguration() != null) {
                this.writeSystemConfiguration(continuumDatabase.getSystemConfiguration(), "systemConfiguration", serializer);
            }
            if (continuumDatabase.getInstallations() != null && continuumDatabase.getInstallations().size() > 0) {
                serializer.writeStartElement("installations");
                for (PersistenceCapable o : continuumDatabase.getInstallations()) {
                    this.writeInstallation((Installation)o, "installation", serializer);
                }
                serializer.writeEndElement();
            }
            if (continuumDatabase.getSchedules() != null && continuumDatabase.getSchedules().size() > 0) {
                serializer.writeStartElement("schedules");
                for (PersistenceCapable o : continuumDatabase.getSchedules()) {
                    this.writeSchedule((Schedule)o, "schedule", serializer);
                }
                serializer.writeEndElement();
            }
            if (continuumDatabase.getProfiles() != null && continuumDatabase.getProfiles().size() > 0) {
                serializer.writeStartElement("profiles");
                for (PersistenceCapable o : continuumDatabase.getProfiles()) {
                    this.writeProfile((Profile)o, "profile", serializer);
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeContinuumProjectState(ContinuumProjectState continuumProjectState, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (continuumProjectState != null) {
            serializer.writeStartElement(tagName);
            if (continuumProjectState.getName() != null) {
                serializer.writeStartElement("name");
                serializer.writeCharacters(continuumProjectState.getName());
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    public void writeDom(Xpp3Dom dom, XMLStreamWriter serializer) throws XMLStreamException {
        serializer.writeStartElement(dom.getName());
        String[] attributeNames = dom.getAttributeNames();
        for (int i = 0; i < attributeNames.length; ++i) {
            String attributeName = attributeNames[i];
            serializer.writeAttribute(attributeName, dom.getAttribute(attributeName));
        }
        Xpp3Dom[] children = dom.getChildren();
        for (int i = 0; i < children.length; ++i) {
            this.writeDom(children[i], serializer);
        }
        String value = dom.getValue();
        if (value != null) {
            serializer.writeCharacters(value);
        }
        serializer.writeEndElement();
    }

    private void writeInstallation(Installation installation, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (installation != null) {
            serializer.writeStartElement(tagName);
            if (installation.getType() != null) {
                serializer.writeStartElement("type");
                serializer.writeCharacters(installation.getType());
                serializer.writeEndElement();
            }
            if (installation.getVarValue() != null) {
                serializer.writeStartElement("varValue");
                serializer.writeCharacters(installation.getVarValue());
                serializer.writeEndElement();
            }
            if (installation.getVarName() != null) {
                serializer.writeStartElement("varName");
                serializer.writeCharacters(installation.getVarName());
                serializer.writeEndElement();
            }
            if (installation.getName() != null) {
                serializer.writeStartElement("name");
                serializer.writeCharacters(installation.getName());
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeNotificationAddress(NotificationAddress notificationAddress, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (notificationAddress != null) {
            serializer.writeStartElement(tagName);
            if (notificationAddress.getType() != null && !notificationAddress.getType().equals("mail")) {
                serializer.writeStartElement("type");
                serializer.writeCharacters(notificationAddress.getType());
                serializer.writeEndElement();
            }
            if (notificationAddress.getAddress() != null) {
                serializer.writeStartElement("address");
                serializer.writeCharacters(notificationAddress.getAddress());
                serializer.writeEndElement();
            }
            if (notificationAddress.getConfiguration() != null && notificationAddress.getConfiguration().size() > 0) {
                serializer.writeStartElement("configuration");
                for (String key : notificationAddress.getConfiguration().keySet()) {
                    String value = (String)notificationAddress.getConfiguration().get(key);
                    serializer.writeStartElement("" + key + "");
                    serializer.writeCharacters(value);
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeProfile(Profile profile, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (profile != null) {
            serializer.writeStartElement(tagName);
            if (profile.getId() != 0) {
                serializer.writeStartElement("id");
                serializer.writeCharacters(String.valueOf(profile.getId()));
                serializer.writeEndElement();
            }
            if (profile.isActive()) {
                serializer.writeStartElement("active");
                serializer.writeCharacters(String.valueOf(profile.isActive()));
                serializer.writeEndElement();
            }
            if (profile.getName() != null) {
                serializer.writeStartElement("name");
                serializer.writeCharacters(profile.getName());
                serializer.writeEndElement();
            }
            if (profile.getDescription() != null) {
                serializer.writeStartElement("description");
                serializer.writeCharacters(profile.getDescription());
                serializer.writeEndElement();
            }
            if (profile.getScmMode() != 0) {
                serializer.writeStartElement("scmMode");
                serializer.writeCharacters(String.valueOf(profile.getScmMode()));
                serializer.writeEndElement();
            }
            if (profile.isBuildWithoutChanges()) {
                serializer.writeStartElement("buildWithoutChanges");
                serializer.writeCharacters(String.valueOf(profile.isBuildWithoutChanges()));
                serializer.writeEndElement();
            }
            if (profile.getJdk() != null) {
                serializer.writeStartElement("jdk");
                serializer.writeAttribute("name", profile.getJdk().getName());
                serializer.writeEndElement();
            }
            if (profile.getBuilder() != null) {
                serializer.writeStartElement("builder");
                serializer.writeAttribute("name", profile.getBuilder().getName());
                serializer.writeEndElement();
            }
            if (profile.getEnvironmentVariables() != null && profile.getEnvironmentVariables().size() > 0) {
                serializer.writeStartElement("environmentVariables");
                for (Installation o : profile.getEnvironmentVariables()) {
                    serializer.writeStartElement("environmentVariable");
                    serializer.writeAttribute("name", o.getName());
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeProject(Project project, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (project != null) {
            serializer.writeStartElement(tagName);
            if (project.getId() != 0) {
                serializer.writeStartElement("id");
                serializer.writeCharacters(String.valueOf(project.getId()));
                serializer.writeEndElement();
            }
            if (project.getGroupId() != null) {
                serializer.writeStartElement("groupId");
                serializer.writeCharacters(project.getGroupId());
                serializer.writeEndElement();
            }
            if (project.getArtifactId() != null) {
                serializer.writeStartElement("artifactId");
                serializer.writeCharacters(project.getArtifactId());
                serializer.writeEndElement();
            }
            if (project.getExecutorId() != null) {
                serializer.writeStartElement("executorId");
                serializer.writeCharacters(project.getExecutorId());
                serializer.writeEndElement();
            }
            if (project.getName() != null) {
                serializer.writeStartElement("name");
                serializer.writeCharacters(project.getName());
                serializer.writeEndElement();
            }
            if (project.getDescription() != null) {
                serializer.writeStartElement("description");
                serializer.writeCharacters(project.getDescription());
                serializer.writeEndElement();
            }
            if (project.getUrl() != null) {
                serializer.writeStartElement("url");
                serializer.writeCharacters(project.getUrl());
                serializer.writeEndElement();
            }
            if (project.getScmUrl() != null) {
                serializer.writeStartElement("scmUrl");
                serializer.writeCharacters(project.getScmUrl());
                serializer.writeEndElement();
            }
            if (project.getScmTag() != null) {
                serializer.writeStartElement("scmTag");
                serializer.writeCharacters(project.getScmTag());
                serializer.writeEndElement();
            }
            if (project.getScmUsername() != null) {
                serializer.writeStartElement("scmUsername");
                serializer.writeCharacters(project.getScmUsername());
                serializer.writeEndElement();
            }
            if (project.getScmPassword() != null) {
                serializer.writeStartElement("scmPassword");
                serializer.writeCharacters(project.getScmPassword());
                serializer.writeEndElement();
            }
            if (project.isScmUseCache()) {
                serializer.writeStartElement("scmUseCache");
                serializer.writeCharacters(String.valueOf(project.isScmUseCache()));
                serializer.writeEndElement();
            }
            if (project.getVersion() != null) {
                serializer.writeStartElement("version");
                serializer.writeCharacters(project.getVersion());
                serializer.writeEndElement();
            }
            if (project.getState() != 1) {
                serializer.writeStartElement("state");
                serializer.writeCharacters(String.valueOf(project.getState()));
                serializer.writeEndElement();
            }
            if (project.getOldState() != 0) {
                serializer.writeStartElement("oldState");
                serializer.writeCharacters(String.valueOf(project.getOldState()));
                serializer.writeEndElement();
            }
            if (project.getLatestBuildId() != 0) {
                serializer.writeStartElement("latestBuildId");
                serializer.writeCharacters(String.valueOf(project.getLatestBuildId()));
                serializer.writeEndElement();
            }
            if (project.getBuildNumber() != 0) {
                serializer.writeStartElement("buildNumber");
                serializer.writeCharacters(String.valueOf(project.getBuildNumber()));
                serializer.writeEndElement();
            }
            if (project.getWorkingDirectory() != null) {
                serializer.writeStartElement("workingDirectory");
                serializer.writeCharacters(project.getWorkingDirectory());
                serializer.writeEndElement();
            }
            if (project.getBuildResults() != null && project.getBuildResults().size() > 0) {
                serializer.writeStartElement("buildResults");
                for (PersistenceCapable o : project.getBuildResults()) {
                    this.writeBuildResult((BuildResult)o, "buildResult", serializer);
                }
                serializer.writeEndElement();
            }
            if (project.getCheckoutResult() != null) {
                this.writeScmResult(project.getCheckoutResult(), "checkoutResult", serializer);
            }
            if (project.getDevelopers() != null && project.getDevelopers().size() > 0) {
                serializer.writeStartElement("developers");
                for (PersistenceCapable o : project.getDevelopers()) {
                    this.writeProjectDeveloper((ProjectDeveloper)o, "developer", serializer);
                }
                serializer.writeEndElement();
            }
            if (project.getParent() != null) {
                this.writeProjectDependency(project.getParent(), "parent", serializer);
            }
            if (project.getDependencies() != null && project.getDependencies().size() > 0) {
                serializer.writeStartElement("dependencies");
                for (PersistenceCapable o : project.getDependencies()) {
                    this.writeProjectDependency((ProjectDependency)o, "dependency", serializer);
                }
                serializer.writeEndElement();
            }
            if (project.getProjectGroup() != null) {
                serializer.writeStartElement("projectGroup");
                serializer.writeAttribute("id", String.valueOf(project.getProjectGroup().getId()));
                serializer.writeEndElement();
            }
            if (project.getNotifiers() != null && project.getNotifiers().size() > 0) {
                serializer.writeStartElement("notifiers");
                for (PersistenceCapable o : project.getNotifiers()) {
                    this.writeProjectNotifier((ProjectNotifier)o, "notifier", serializer);
                }
                serializer.writeEndElement();
            }
            if (project.getBuildDefinitions() != null && project.getBuildDefinitions().size() > 0) {
                serializer.writeStartElement("buildDefinitions");
                for (PersistenceCapable o : project.getBuildDefinitions()) {
                    this.writeBuildDefinition((BuildDefinition)o, "buildDefinition", serializer);
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeProjectDependency(ProjectDependency projectDependency, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (projectDependency != null) {
            serializer.writeStartElement(tagName);
            if (projectDependency.getGroupId() != null) {
                serializer.writeStartElement("groupId");
                serializer.writeCharacters(projectDependency.getGroupId());
                serializer.writeEndElement();
            }
            if (projectDependency.getArtifactId() != null) {
                serializer.writeStartElement("artifactId");
                serializer.writeCharacters(projectDependency.getArtifactId());
                serializer.writeEndElement();
            }
            if (projectDependency.getVersion() != null) {
                serializer.writeStartElement("version");
                serializer.writeCharacters(projectDependency.getVersion());
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeProjectDeveloper(ProjectDeveloper projectDeveloper, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (projectDeveloper != null) {
            serializer.writeStartElement(tagName);
            if (projectDeveloper.getScmId() != null) {
                serializer.writeStartElement("scmId");
                serializer.writeCharacters(projectDeveloper.getScmId());
                serializer.writeEndElement();
            }
            if (projectDeveloper.getName() != null) {
                serializer.writeStartElement("name");
                serializer.writeCharacters(projectDeveloper.getName());
                serializer.writeEndElement();
            }
            if (projectDeveloper.getEmail() != null) {
                serializer.writeStartElement("email");
                serializer.writeCharacters(projectDeveloper.getEmail());
                serializer.writeEndElement();
            }
            if (projectDeveloper.getContinuumId() != 0) {
                serializer.writeStartElement("continuumId");
                serializer.writeCharacters(String.valueOf(projectDeveloper.getContinuumId()));
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeProjectGroup(ProjectGroup projectGroup, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (projectGroup != null) {
            serializer.writeStartElement(tagName);
            if (projectGroup.getId() != 0) {
                serializer.writeStartElement("id");
                serializer.writeCharacters(String.valueOf(projectGroup.getId()));
                serializer.writeEndElement();
            }
            if (projectGroup.getGroupId() != null) {
                serializer.writeStartElement("groupId");
                serializer.writeCharacters(projectGroup.getGroupId());
                serializer.writeEndElement();
            }
            if (projectGroup.getName() != null) {
                serializer.writeStartElement("name");
                serializer.writeCharacters(projectGroup.getName());
                serializer.writeEndElement();
            }
            if (projectGroup.getDescription() != null) {
                serializer.writeStartElement("description");
                serializer.writeCharacters(projectGroup.getDescription());
                serializer.writeEndElement();
            }
            if (projectGroup.getProjects() != null && projectGroup.getProjects().size() > 0) {
                serializer.writeStartElement("projects");
                for (PersistenceCapable o : projectGroup.getProjects()) {
                    this.writeProject((Project)o, "project", serializer);
                }
                serializer.writeEndElement();
            }
            if (projectGroup.getNotifiers() != null && projectGroup.getNotifiers().size() > 0) {
                serializer.writeStartElement("notifiers");
                for (PersistenceCapable o : projectGroup.getNotifiers()) {
                    this.writeProjectNotifier((ProjectNotifier)o, "notifier", serializer);
                }
                serializer.writeEndElement();
            }
            if (projectGroup.getBuildDefinitions() != null && projectGroup.getBuildDefinitions().size() > 0) {
                serializer.writeStartElement("buildDefinitions");
                for (PersistenceCapable o : projectGroup.getBuildDefinitions()) {
                    this.writeBuildDefinition((BuildDefinition)o, "buildDefinition", serializer);
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeProjectNotifier(ProjectNotifier projectNotifier, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (projectNotifier != null) {
            serializer.writeStartElement(tagName);
            if (projectNotifier.getId() != 0) {
                serializer.writeStartElement("id");
                serializer.writeCharacters(String.valueOf(projectNotifier.getId()));
                serializer.writeEndElement();
            }
            if (projectNotifier.getType() != null && !projectNotifier.getType().equals("mail")) {
                serializer.writeStartElement("type");
                serializer.writeCharacters(projectNotifier.getType());
                serializer.writeEndElement();
            }
            if (projectNotifier.getFrom() != 0) {
                serializer.writeStartElement("from");
                serializer.writeCharacters(String.valueOf(projectNotifier.getFrom()));
                serializer.writeEndElement();
            }
            if (!projectNotifier.isEnabled()) {
                serializer.writeStartElement("enabled");
                serializer.writeCharacters(String.valueOf(projectNotifier.isEnabled()));
                serializer.writeEndElement();
            }
            if (projectNotifier.getRecipientType() != 0) {
                serializer.writeStartElement("recipientType");
                serializer.writeCharacters(String.valueOf(projectNotifier.getRecipientType()));
                serializer.writeEndElement();
            }
            if (!projectNotifier.isSendOnSuccess()) {
                serializer.writeStartElement("sendOnSuccess");
                serializer.writeCharacters(String.valueOf(projectNotifier.isSendOnSuccess()));
                serializer.writeEndElement();
            }
            if (!projectNotifier.isSendOnFailure()) {
                serializer.writeStartElement("sendOnFailure");
                serializer.writeCharacters(String.valueOf(projectNotifier.isSendOnFailure()));
                serializer.writeEndElement();
            }
            if (!projectNotifier.isSendOnError()) {
                serializer.writeStartElement("sendOnError");
                serializer.writeCharacters(String.valueOf(projectNotifier.isSendOnError()));
                serializer.writeEndElement();
            }
            if (!projectNotifier.isSendOnWarning()) {
                serializer.writeStartElement("sendOnWarning");
                serializer.writeCharacters(String.valueOf(projectNotifier.isSendOnWarning()));
                serializer.writeEndElement();
            }
            if (projectNotifier.getConfiguration() != null && projectNotifier.getConfiguration().size() > 0) {
                serializer.writeStartElement("configuration");
                for (String key : projectNotifier.getConfiguration().keySet()) {
                    String value = (String)projectNotifier.getConfiguration().get(key);
                    serializer.writeStartElement("" + key + "");
                    serializer.writeCharacters(value);
                    serializer.writeEndElement();
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeSchedule(Schedule schedule, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (schedule != null) {
            serializer.writeStartElement(tagName);
            if (schedule.getId() != 0) {
                serializer.writeStartElement("id");
                serializer.writeCharacters(String.valueOf(schedule.getId()));
                serializer.writeEndElement();
            }
            if (schedule.isActive()) {
                serializer.writeStartElement("active");
                serializer.writeCharacters(String.valueOf(schedule.isActive()));
                serializer.writeEndElement();
            }
            if (schedule.getName() != null) {
                serializer.writeStartElement("name");
                serializer.writeCharacters(schedule.getName());
                serializer.writeEndElement();
            }
            if (schedule.getDescription() != null) {
                serializer.writeStartElement("description");
                serializer.writeCharacters(schedule.getDescription());
                serializer.writeEndElement();
            }
            if (schedule.getDelay() != 0) {
                serializer.writeStartElement("delay");
                serializer.writeCharacters(String.valueOf(schedule.getDelay()));
                serializer.writeEndElement();
            }
            if (schedule.getMaxJobExecutionTime() != 3600) {
                serializer.writeStartElement("maxJobExecutionTime");
                serializer.writeCharacters(String.valueOf(schedule.getMaxJobExecutionTime()));
                serializer.writeEndElement();
            }
            if (schedule.getCronExpression() != null) {
                serializer.writeStartElement("cronExpression");
                serializer.writeCharacters(schedule.getCronExpression());
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeScmResult(ScmResult scmResult, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (scmResult != null) {
            serializer.writeStartElement(tagName);
            if (scmResult.isSuccess()) {
                serializer.writeStartElement("success");
                serializer.writeCharacters(String.valueOf(scmResult.isSuccess()));
                serializer.writeEndElement();
            }
            if (scmResult.getCommandLine() != null) {
                serializer.writeStartElement("commandLine");
                serializer.writeCharacters(scmResult.getCommandLine());
                serializer.writeEndElement();
            }
            if (scmResult.getProviderMessage() != null) {
                serializer.writeStartElement("providerMessage");
                serializer.writeCharacters(scmResult.getProviderMessage());
                serializer.writeEndElement();
            }
            if (scmResult.getCommandOutput() != null) {
                serializer.writeStartElement("commandOutput");
                serializer.writeCharacters(scmResult.getCommandOutput());
                serializer.writeEndElement();
            }
            if (scmResult.getException() != null) {
                serializer.writeStartElement("exception");
                serializer.writeCharacters(scmResult.getException());
                serializer.writeEndElement();
            }
            if (scmResult.getChanges() != null && scmResult.getChanges().size() > 0) {
                serializer.writeStartElement("changes");
                for (ChangeSet o : scmResult.getChanges()) {
                    this.writeChangeSet(o, "change", serializer);
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeSuiteResult(SuiteResult suiteResult, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (suiteResult != null) {
            serializer.writeStartElement(tagName);
            if (suiteResult.getName() != null) {
                serializer.writeStartElement("name");
                serializer.writeCharacters(suiteResult.getName());
                serializer.writeEndElement();
            }
            if (suiteResult.getTestCount() != 0) {
                serializer.writeStartElement("testCount");
                serializer.writeCharacters(String.valueOf(suiteResult.getTestCount()));
                serializer.writeEndElement();
            }
            if (suiteResult.getFailureCount() != 0) {
                serializer.writeStartElement("failureCount");
                serializer.writeCharacters(String.valueOf(suiteResult.getFailureCount()));
                serializer.writeEndElement();
            }
            if (suiteResult.getTotalTime() != 0L) {
                serializer.writeStartElement("totalTime");
                serializer.writeCharacters(String.valueOf(suiteResult.getTotalTime()));
                serializer.writeEndElement();
            }
            if (suiteResult.getFailures() != null && suiteResult.getFailures().size() > 0) {
                serializer.writeStartElement("failures");
                for (TestCaseFailure o : suiteResult.getFailures()) {
                    this.writeTestCaseFailure(o, "failure", serializer);
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeSystemConfiguration(SystemConfiguration systemConfiguration, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (systemConfiguration != null) {
            serializer.writeStartElement(tagName);
            if (!systemConfiguration.isGuestAccountEnabled()) {
                serializer.writeStartElement("guestAccountEnabled");
                serializer.writeCharacters(String.valueOf(systemConfiguration.isGuestAccountEnabled()));
                serializer.writeEndElement();
            }
            if (systemConfiguration.getDefaultScheduleDescription() != null && !systemConfiguration.getDefaultScheduleDescription().equals("Run hourly")) {
                serializer.writeStartElement("defaultScheduleDescription");
                serializer.writeCharacters(systemConfiguration.getDefaultScheduleDescription());
                serializer.writeEndElement();
            }
            if (systemConfiguration.getDefaultScheduleCronExpression() != null && !systemConfiguration.getDefaultScheduleCronExpression().equals("0 0 * * * ?")) {
                serializer.writeStartElement("defaultScheduleCronExpression");
                serializer.writeCharacters(systemConfiguration.getDefaultScheduleCronExpression());
                serializer.writeEndElement();
            }
            if (systemConfiguration.getWorkingDirectory() != null && !systemConfiguration.getWorkingDirectory().equals("working-directory")) {
                serializer.writeStartElement("workingDirectory");
                serializer.writeCharacters(systemConfiguration.getWorkingDirectory());
                serializer.writeEndElement();
            }
            if (systemConfiguration.getBuildOutputDirectory() != null && !systemConfiguration.getBuildOutputDirectory().equals("build-output-directory")) {
                serializer.writeStartElement("buildOutputDirectory");
                serializer.writeCharacters(systemConfiguration.getBuildOutputDirectory());
                serializer.writeEndElement();
            }
            if (systemConfiguration.getDeploymentRepositoryDirectory() != null) {
                serializer.writeStartElement("deploymentRepositoryDirectory");
                serializer.writeCharacters(systemConfiguration.getDeploymentRepositoryDirectory());
                serializer.writeEndElement();
            }
            if (systemConfiguration.getBaseUrl() != null) {
                serializer.writeStartElement("baseUrl");
                serializer.writeCharacters(systemConfiguration.getBaseUrl());
                serializer.writeEndElement();
            }
            if (systemConfiguration.isInitialized()) {
                serializer.writeStartElement("initialized");
                serializer.writeCharacters(String.valueOf(systemConfiguration.isInitialized()));
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeTestCaseFailure(TestCaseFailure testCaseFailure, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (testCaseFailure != null) {
            serializer.writeStartElement(tagName);
            if (testCaseFailure.getName() != null) {
                serializer.writeStartElement("name");
                serializer.writeCharacters(testCaseFailure.getName());
                serializer.writeEndElement();
            }
            if (testCaseFailure.getException() != null) {
                serializer.writeStartElement("exception");
                serializer.writeCharacters(testCaseFailure.getException());
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }

    private void writeTestResult(TestResult testResult, String tagName, XMLStreamWriter serializer) throws IOException, XMLStreamException {
        if (testResult != null) {
            serializer.writeStartElement(tagName);
            if (testResult.getTestCount() != 0) {
                serializer.writeStartElement("testCount");
                serializer.writeCharacters(String.valueOf(testResult.getTestCount()));
                serializer.writeEndElement();
            }
            if (testResult.getFailureCount() != 0) {
                serializer.writeStartElement("failureCount");
                serializer.writeCharacters(String.valueOf(testResult.getFailureCount()));
                serializer.writeEndElement();
            }
            if (testResult.getTotalTime() != 0L) {
                serializer.writeStartElement("totalTime");
                serializer.writeCharacters(String.valueOf(testResult.getTotalTime()));
                serializer.writeEndElement();
            }
            if (testResult.getSuiteResults() != null && testResult.getSuiteResults().size() > 0) {
                serializer.writeStartElement("suiteResults");
                for (SuiteResult o : testResult.getSuiteResults()) {
                    this.writeSuiteResult(o, "suiteResult", serializer);
                }
                serializer.writeEndElement();
            }
            serializer.writeEndElement();
        }
    }
}

