/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.model.project;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.Permission;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import javax.jdo.JDODetachedFieldAccessException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.PersistenceManager;
import javax.jdo.identity.IntIdentity;
import javax.jdo.spi.Detachable;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.JDOPermission;
import javax.jdo.spi.PersistenceCapable;
import javax.jdo.spi.StateManager;
import org.apache.maven.continuum.model.project.BuildDefinition;
import org.apache.maven.continuum.model.project.BuildResult;
import org.apache.maven.continuum.model.project.ProjectDependency;
import org.apache.maven.continuum.model.project.ProjectDeveloper;
import org.apache.maven.continuum.model.project.ProjectGroup;
import org.apache.maven.continuum.model.project.ProjectNotifier;
import org.apache.maven.continuum.model.scm.ScmResult;

public class Project
implements Serializable,
PersistenceCapable,
Detachable {
    private int id;
    private String groupId;
    private String artifactId;
    private String executorId;
    private String name;
    private String description;
    private String url;
    private String scmUrl;
    private String scmTag;
    private String scmUsername;
    private String scmPassword;
    private boolean scmUseCache;
    private String version;
    private int state;
    private int oldState;
    private int latestBuildId;
    private int buildNumber;
    private String workingDirectory;
    private List buildResults;
    private ScmResult checkoutResult;
    private List developers;
    private ProjectDependency parent;
    private List dependencies;
    private ProjectGroup projectGroup;
    private List notifiers;
    private List buildDefinitions;
    private String modelEncoding;
    protected transient /* synthetic */ StateManager jdoStateManager;
    protected transient /* synthetic */ byte jdoFlags;
    protected /* synthetic */ Object[] jdoDetachedState;
    private static final /* synthetic */ byte[] jdoFieldFlags;
    private static final /* synthetic */ Class jdoPersistenceCapableSuperclass;
    private static final /* synthetic */ Class[] jdoFieldTypes;
    private static final /* synthetic */ String[] jdoFieldNames;
    private static final /* synthetic */ int jdoInheritedFieldCount;
    private static final /* synthetic */ long serialVersionUID;

    static {
        serialVersionUID = -9198080884409372652L;
        jdoFieldNames = Project.__jdoFieldNamesInit();
        jdoFieldTypes = Project.__jdoFieldTypesInit();
        jdoFieldFlags = Project.__jdoFieldFlagsInit();
        jdoInheritedFieldCount = Project.__jdoGetInheritedFieldCount();
        jdoPersistenceCapableSuperclass = Project.__jdoPersistenceCapableSuperclassInit();
        JDOImplHelper.registerClass((Class)Project.___jdo$loadClass("org.apache.maven.continuum.model.project.Project"), (String[])jdoFieldNames, (Class[])jdoFieldTypes, (byte[])jdoFieldFlags, (Class)jdoPersistenceCapableSuperclass, (PersistenceCapable)new Project());
    }

    public void addBuildDefinition(BuildDefinition buildDefinition) {
        if (!(buildDefinition instanceof BuildDefinition)) {
            throw new ClassCastException("Project.addBuildDefinitions(buildDefinition) parameter must be instanceof " + BuildDefinition.class.getName());
        }
        this.getBuildDefinitions().add(buildDefinition);
    }

    public void addBuildResult(BuildResult buildResult) {
        if (!(buildResult instanceof BuildResult)) {
            throw new ClassCastException("Project.addBuildResults(buildResult) parameter must be instanceof " + BuildResult.class.getName());
        }
        this.getBuildResults().add(buildResult);
        buildResult.createProjectAssociation(this);
    }

    public void addDependency(ProjectDependency projectDependency) {
        if (!(projectDependency instanceof ProjectDependency)) {
            throw new ClassCastException("Project.addDependencies(projectDependency) parameter must be instanceof " + ProjectDependency.class.getName());
        }
        this.getDependencies().add(projectDependency);
    }

    public void addDeveloper(ProjectDeveloper projectDeveloper) {
        if (!(projectDeveloper instanceof ProjectDeveloper)) {
            throw new ClassCastException("Project.addDevelopers(projectDeveloper) parameter must be instanceof " + ProjectDeveloper.class.getName());
        }
        this.getDevelopers().add(projectDeveloper);
    }

    public void addNotifier(ProjectNotifier projectNotifier) {
        if (!(projectNotifier instanceof ProjectNotifier)) {
            throw new ClassCastException("Project.addNotifiers(projectNotifier) parameter must be instanceof " + ProjectNotifier.class.getName());
        }
        this.getNotifiers().add(projectNotifier);
    }

    public void breakBuildResultAssociation(BuildResult buildResult) {
        if (!this.getBuildResults().contains(buildResult)) {
            throw new IllegalStateException("buildResult isn't associated.");
        }
        this.getBuildResults().remove(buildResult);
    }

    public void breakProjectGroupAssociation(ProjectGroup projectGroup) {
        if (Project.jdoGetprojectGroup(this) != projectGroup) {
            throw new IllegalStateException("projectGroup isn't associated.");
        }
        Project.jdoSetprojectGroup(this, null);
    }

    public void createBuildResultAssociation(BuildResult buildResult) {
        List buildResults = this.getBuildResults();
        if (this.getBuildResults().contains(buildResult)) {
            throw new IllegalStateException("buildResult is already assigned.");
        }
        buildResults.add(buildResult);
    }

    public void createProjectGroupAssociation(ProjectGroup projectGroup) {
        if (Project.jdoGetprojectGroup(this) != null) {
            this.breakProjectGroupAssociation(Project.jdoGetprojectGroup(this));
        }
        Project.jdoSetprojectGroup(this, projectGroup);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Project)) {
            return false;
        }
        Project that = (Project)other;
        boolean result = true;
        result = result && this.id == that.id;
        return result;
    }

    public String getArtifactId() {
        return Project.jdoGetartifactId(this);
    }

    public List getBuildDefinitions() {
        if (Project.jdoGetbuildDefinitions(this) == null) {
            Project.jdoSetbuildDefinitions(this, new ArrayList());
        }
        return Project.jdoGetbuildDefinitions(this);
    }

    public int getBuildNumber() {
        return Project.jdoGetbuildNumber(this);
    }

    public List getBuildResults() {
        if (Project.jdoGetbuildResults(this) == null) {
            Project.jdoSetbuildResults(this, new ArrayList());
        }
        return Project.jdoGetbuildResults(this);
    }

    public ScmResult getCheckoutResult() {
        return Project.jdoGetcheckoutResult(this);
    }

    public List getDependencies() {
        if (Project.jdoGetdependencies(this) == null) {
            Project.jdoSetdependencies(this, new ArrayList());
        }
        return Project.jdoGetdependencies(this);
    }

    public String getDescription() {
        return Project.jdoGetdescription(this);
    }

    public List getDevelopers() {
        if (Project.jdoGetdevelopers(this) == null) {
            Project.jdoSetdevelopers(this, new ArrayList());
        }
        return Project.jdoGetdevelopers(this);
    }

    public String getExecutorId() {
        return Project.jdoGetexecutorId(this);
    }

    public String getGroupId() {
        return Project.jdoGetgroupId(this);
    }

    public int getId() {
        return this.id;
    }

    public int getLatestBuildId() {
        return Project.jdoGetlatestBuildId(this);
    }

    public String getName() {
        return Project.jdoGetname(this);
    }

    public List getNotifiers() {
        if (Project.jdoGetnotifiers(this) == null) {
            Project.jdoSetnotifiers(this, new ArrayList());
        }
        return Project.jdoGetnotifiers(this);
    }

    public int getOldState() {
        return Project.jdoGetoldState(this);
    }

    public ProjectDependency getParent() {
        return Project.jdoGetparent(this);
    }

    public ProjectGroup getProjectGroup() {
        return Project.jdoGetprojectGroup(this);
    }

    public String getScmPassword() {
        return Project.jdoGetscmPassword(this);
    }

    public String getScmTag() {
        return Project.jdoGetscmTag(this);
    }

    public String getScmUrl() {
        return Project.jdoGetscmUrl(this);
    }

    public String getScmUsername() {
        return Project.jdoGetscmUsername(this);
    }

    public int getState() {
        return Project.jdoGetstate(this);
    }

    public String getUrl() {
        return Project.jdoGeturl(this);
    }

    public String getVersion() {
        return Project.jdoGetversion(this);
    }

    public String getWorkingDirectory() {
        return Project.jdoGetworkingDirectory(this);
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.id;
        return result;
    }

    public boolean isScmUseCache() {
        return Project.jdoGetscmUseCache(this);
    }

    public void removeBuildDefinition(BuildDefinition buildDefinition) {
        if (!(buildDefinition instanceof BuildDefinition)) {
            throw new ClassCastException("Project.removeBuildDefinitions(buildDefinition) parameter must be instanceof " + BuildDefinition.class.getName());
        }
        this.getBuildDefinitions().remove(buildDefinition);
    }

    public void removeBuildResult(BuildResult buildResult) {
        if (!(buildResult instanceof BuildResult)) {
            throw new ClassCastException("Project.removeBuildResults(buildResult) parameter must be instanceof " + BuildResult.class.getName());
        }
        buildResult.breakProjectAssociation(this);
        this.getBuildResults().remove(buildResult);
    }

    public void removeDependency(ProjectDependency projectDependency) {
        if (!(projectDependency instanceof ProjectDependency)) {
            throw new ClassCastException("Project.removeDependencies(projectDependency) parameter must be instanceof " + ProjectDependency.class.getName());
        }
        this.getDependencies().remove(projectDependency);
    }

    public void removeDeveloper(ProjectDeveloper projectDeveloper) {
        if (!(projectDeveloper instanceof ProjectDeveloper)) {
            throw new ClassCastException("Project.removeDevelopers(projectDeveloper) parameter must be instanceof " + ProjectDeveloper.class.getName());
        }
        this.getDevelopers().remove(projectDeveloper);
    }

    public void removeNotifier(ProjectNotifier projectNotifier) {
        if (!(projectNotifier instanceof ProjectNotifier)) {
            throw new ClassCastException("Project.removeNotifiers(projectNotifier) parameter must be instanceof " + ProjectNotifier.class.getName());
        }
        this.getNotifiers().remove(projectNotifier);
    }

    public void setArtifactId(String artifactId) {
        Project.jdoSetartifactId(this, artifactId);
    }

    public void setBuildDefinitions(List buildDefinitions) {
        Project.jdoSetbuildDefinitions(this, buildDefinitions);
    }

    public void setBuildNumber(int buildNumber) {
        Project.jdoSetbuildNumber(this, buildNumber);
    }

    public void setBuildResults(List buildResults) {
        Project.jdoSetbuildResults(this, buildResults);
    }

    public void setCheckoutResult(ScmResult checkoutResult) {
        Project.jdoSetcheckoutResult(this, checkoutResult);
    }

    public void setDependencies(List dependencies) {
        Project.jdoSetdependencies(this, dependencies);
    }

    public void setDescription(String description) {
        Project.jdoSetdescription(this, description);
    }

    public void setDevelopers(List developers) {
        Project.jdoSetdevelopers(this, developers);
    }

    public void setExecutorId(String executorId) {
        Project.jdoSetexecutorId(this, executorId);
    }

    public void setGroupId(String groupId) {
        Project.jdoSetgroupId(this, groupId);
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setLatestBuildId(int latestBuildId) {
        Project.jdoSetlatestBuildId(this, latestBuildId);
    }

    public void setName(String name) {
        Project.jdoSetname(this, name);
    }

    public void setNotifiers(List notifiers) {
        Project.jdoSetnotifiers(this, notifiers);
    }

    public void setOldState(int oldState) {
        Project.jdoSetoldState(this, oldState);
    }

    public void setParent(ProjectDependency parent) {
        Project.jdoSetparent(this, parent);
    }

    public void setProjectGroup(ProjectGroup projectGroup) {
        if (Project.jdoGetprojectGroup(this) != null) {
            Project.jdoGetprojectGroup(this).breakProjectAssociation(this);
        }
        Project.jdoSetprojectGroup(this, projectGroup);
        if (projectGroup != null) {
            Project.jdoGetprojectGroup(this).createProjectAssociation(this);
        }
    }

    public void setScmPassword(String scmPassword) {
        Project.jdoSetscmPassword(this, scmPassword);
    }

    public void setScmTag(String scmTag) {
        Project.jdoSetscmTag(this, scmTag);
    }

    public void setScmUrl(String scmUrl) {
        Project.jdoSetscmUrl(this, scmUrl);
    }

    public void setScmUseCache(boolean scmUseCache) {
        Project.jdoSetscmUseCache(this, scmUseCache);
    }

    public void setScmUsername(String scmUsername) {
        Project.jdoSetscmUsername(this, scmUsername);
    }

    public void setState(int state) {
        Project.jdoSetstate(this, state);
    }

    public void setUrl(String url) {
        Project.jdoSeturl(this, url);
    }

    public void setVersion(String version) {
        Project.jdoSetversion(this, version);
    }

    public void setWorkingDirectory(String workingDirectory) {
        Project.jdoSetworkingDirectory(this, workingDirectory);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("id = '");
        buf.append(this.getId() + "'");
        return buf.toString();
    }

    public void setModelEncoding(String modelEncoding) {
        Project.jdoSetmodelEncoding(this, modelEncoding);
    }

    public String getModelEncoding() {
        return Project.jdoGetmodelEncoding(this);
    }

    public void jdoCopyKeyFieldsFromObjectId(PersistenceCapable.ObjectIdFieldConsumer fc, Object oid) {
        if (fc == null) {
            throw new IllegalArgumentException("ObjectIdFieldConsumer is null");
        }
        if (!(oid instanceof IntIdentity)) {
            throw new ClassCastException("oid is not instanceof javax.jdo.identity.IntIdentity");
        }
        IntIdentity o = (IntIdentity)oid;
        fc.storeIntField(10, o.getKey());
    }

    protected void jdoCopyKeyFieldsFromObjectId(Object oid) {
        if (!(oid instanceof IntIdentity)) {
            throw new ClassCastException("key class is not javax.jdo.identity.IntIdentity or null");
        }
        IntIdentity o = (IntIdentity)oid;
        this.id = o.getKey();
    }

    public final void jdoCopyKeyFieldsToObjectId(Object oid) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with Single Field Identity.");
    }

    public final void jdoCopyKeyFieldsToObjectId(PersistenceCapable.ObjectIdFieldSupplier fs, Object oid) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with Single Field Identity.");
    }

    public final Object jdoGetObjectId() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getObjectId((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[0];
    }

    public final Object jdoGetVersion() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getVersion((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[1];
    }

    protected final void jdoPreSerialize() {
        block0: {
            if (this.jdoStateManager == null) break block0;
            this.jdoStateManager.preSerialize((PersistenceCapable)this);
        }
    }

    public final PersistenceManager jdoGetPersistenceManager() {
        return this.jdoStateManager != null ? this.jdoStateManager.getPersistenceManager((PersistenceCapable)this) : null;
    }

    public final Object jdoGetTransactionalObjectId() {
        return this.jdoStateManager != null ? this.jdoStateManager.getTransactionalObjectId((PersistenceCapable)this) : null;
    }

    public final boolean jdoIsDeleted() {
        return this.jdoStateManager != null ? this.jdoStateManager.isDeleted((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsDirty() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.isDirty((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return false;
        }
        return ((BitSet)this.jdoDetachedState[3]).length() > 0;
    }

    public final boolean jdoIsNew() {
        return this.jdoStateManager != null ? this.jdoStateManager.isNew((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsPersistent() {
        return this.jdoStateManager != null ? this.jdoStateManager.isPersistent((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsTransactional() {
        return this.jdoStateManager != null ? this.jdoStateManager.isTransactional((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsDetached() {
        return this.jdoIsDetachedInternal();
    }

    public final void jdoMakeDirty(String fieldName) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.makeDirty((PersistenceCapable)this, fieldName);
        }
    }

    public final Object jdoNewObjectIdInstance() {
        return new IntIdentity(this.getClass(), this.id);
    }

    public final Object jdoNewObjectIdInstance(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (!(key instanceof String)) {
            return new IntIdentity(this.getClass(), (Integer)key);
        }
        return new IntIdentity(this.getClass(), (String)key);
    }

    public final void jdoProvideFields(int[] fieldId) {
        if (fieldId == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = fieldId.length - 1;
        if (i >= 0) {
            do {
                this.jdoProvideField(fieldId[i]);
            } while (--i >= 0);
        }
    }

    public final void jdoReplaceFields(int[] fieldId) {
        if (fieldId == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = fieldId.length;
        if (i > 0) {
            int n = 0;
            do {
                this.jdoReplaceField(fieldId[n]);
            } while (++n < i);
        }
    }

    public final void jdoReplaceFlags() {
        if (this.jdoStateManager != null) {
            this.jdoFlags = this.jdoStateManager.replacingFlags((PersistenceCapable)this);
        }
    }

    public final synchronized void jdoReplaceStateManager(StateManager stateManager) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager = this.jdoStateManager.replacingStateManager((PersistenceCapable)this, stateManager);
            return;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission((Permission)new JDOPermission("setStateManager"));
        }
        this.jdoStateManager = stateManager;
        this.jdoFlags = 1;
    }

    public final synchronized void jdoReplaceDetachedState() {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        this.jdoDetachedState = this.jdoStateManager.replacingDetachedState((Detachable)this, this.jdoDetachedState);
    }

    protected boolean jdoIsDetachedInternal() {
        if (this.jdoStateManager == null) {
            return this.jdoDetachedState != null;
        }
        return false;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm) {
        Project result = new Project();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        return result;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm, Object o) {
        Project result = new Project();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        result.jdoCopyKeyFieldsFromObjectId(o);
        return result;
    }

    public void jdoReplaceField(int fieldIndex) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (fieldIndex) {
            case 0: {
                this.artifactId = this.jdoStateManager.replacingStringField((PersistenceCapable)this, fieldIndex);
                return;
            }
            case 1: {
                this.buildDefinitions = (List)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, fieldIndex);
                return;
            }
            case 2: {
                this.buildNumber = this.jdoStateManager.replacingIntField((PersistenceCapable)this, fieldIndex);
                return;
            }
            case 3: {
                this.buildResults = (List)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, fieldIndex);
                return;
            }
            case 4: {
                this.checkoutResult = (ScmResult)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, fieldIndex);
                return;
            }
            case 5: {
                this.dependencies = (List)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, fieldIndex);
                return;
            }
            case 6: {
                this.description = this.jdoStateManager.replacingStringField((PersistenceCapable)this, fieldIndex);
                return;
            }
            case 7: {
                this.developers = (List)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, fieldIndex);
                return;
            }
            case 8: {
                this.executorId = this.jdoStateManager.replacingStringField((PersistenceCapable)this, fieldIndex);
                return;
            }
            case 9: {
                this.groupId = this.jdoStateManager.replacingStringField((PersistenceCapable)this, fieldIndex);
                return;
            }
            case 10: {
                this.id = this.jdoStateManager.replacingIntField((PersistenceCapable)this, fieldIndex);
                return;
            }
            case 11: {
                this.latestBuildId = this.jdoStateManager.replacingIntField((PersistenceCapable)this, fieldIndex);
                return;
            }
            case 12: {
                this.modelEncoding = this.jdoStateManager.replacingStringField((PersistenceCapable)this, fieldIndex);
                return;
            }
            case 13: {
                this.name = this.jdoStateManager.replacingStringField((PersistenceCapable)this, fieldIndex);
                return;
            }
            case 14: {
                this.notifiers = (List)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, fieldIndex);
                return;
            }
            case 15: {
                this.oldState = this.jdoStateManager.replacingIntField((PersistenceCapable)this, fieldIndex);
                return;
            }
            case 16: {
                this.parent = (ProjectDependency)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, fieldIndex);
                return;
            }
            case 17: {
                this.projectGroup = (ProjectGroup)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, fieldIndex);
                return;
            }
            case 18: {
                this.scmPassword = this.jdoStateManager.replacingStringField((PersistenceCapable)this, fieldIndex);
                return;
            }
            case 19: {
                this.scmTag = this.jdoStateManager.replacingStringField((PersistenceCapable)this, fieldIndex);
                return;
            }
            case 20: {
                this.scmUrl = this.jdoStateManager.replacingStringField((PersistenceCapable)this, fieldIndex);
                return;
            }
            case 21: {
                this.scmUseCache = this.jdoStateManager.replacingBooleanField((PersistenceCapable)this, fieldIndex);
                return;
            }
            case 22: {
                this.scmUsername = this.jdoStateManager.replacingStringField((PersistenceCapable)this, fieldIndex);
                return;
            }
            case 23: {
                this.state = this.jdoStateManager.replacingIntField((PersistenceCapable)this, fieldIndex);
                return;
            }
            case 24: {
                this.url = this.jdoStateManager.replacingStringField((PersistenceCapable)this, fieldIndex);
                return;
            }
            case 25: {
                this.version = this.jdoStateManager.replacingStringField((PersistenceCapable)this, fieldIndex);
                return;
            }
            case 26: {
                this.workingDirectory = this.jdoStateManager.replacingStringField((PersistenceCapable)this, fieldIndex);
                return;
            }
        }
        throw new IllegalArgumentException(new StringBuffer("out of field index :").append(fieldIndex).toString());
    }

    public void jdoProvideField(int fieldIndex) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (fieldIndex) {
            case 0: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, fieldIndex, this.artifactId);
                return;
            }
            case 1: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, fieldIndex, (Object)this.buildDefinitions);
                return;
            }
            case 2: {
                this.jdoStateManager.providedIntField((PersistenceCapable)this, fieldIndex, this.buildNumber);
                return;
            }
            case 3: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, fieldIndex, (Object)this.buildResults);
                return;
            }
            case 4: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, fieldIndex, (Object)this.checkoutResult);
                return;
            }
            case 5: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, fieldIndex, (Object)this.dependencies);
                return;
            }
            case 6: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, fieldIndex, this.description);
                return;
            }
            case 7: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, fieldIndex, (Object)this.developers);
                return;
            }
            case 8: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, fieldIndex, this.executorId);
                return;
            }
            case 9: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, fieldIndex, this.groupId);
                return;
            }
            case 10: {
                this.jdoStateManager.providedIntField((PersistenceCapable)this, fieldIndex, this.id);
                return;
            }
            case 11: {
                this.jdoStateManager.providedIntField((PersistenceCapable)this, fieldIndex, this.latestBuildId);
                return;
            }
            case 12: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, fieldIndex, this.modelEncoding);
                return;
            }
            case 13: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, fieldIndex, this.name);
                return;
            }
            case 14: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, fieldIndex, (Object)this.notifiers);
                return;
            }
            case 15: {
                this.jdoStateManager.providedIntField((PersistenceCapable)this, fieldIndex, this.oldState);
                return;
            }
            case 16: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, fieldIndex, (Object)this.parent);
                return;
            }
            case 17: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, fieldIndex, (Object)this.projectGroup);
                return;
            }
            case 18: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, fieldIndex, this.scmPassword);
                return;
            }
            case 19: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, fieldIndex, this.scmTag);
                return;
            }
            case 20: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, fieldIndex, this.scmUrl);
                return;
            }
            case 21: {
                this.jdoStateManager.providedBooleanField((PersistenceCapable)this, fieldIndex, this.scmUseCache);
                return;
            }
            case 22: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, fieldIndex, this.scmUsername);
                return;
            }
            case 23: {
                this.jdoStateManager.providedIntField((PersistenceCapable)this, fieldIndex, this.state);
                return;
            }
            case 24: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, fieldIndex, this.url);
                return;
            }
            case 25: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, fieldIndex, this.version);
                return;
            }
            case 26: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, fieldIndex, this.workingDirectory);
                return;
            }
        }
        throw new IllegalArgumentException(new StringBuffer("out of field index :").append(fieldIndex).toString());
    }

    protected final /* synthetic */ void jdoCopyField(Project obj, int index) {
        switch (index) {
            case 0: {
                this.artifactId = obj.artifactId;
                break;
            }
            case 1: {
                this.buildDefinitions = obj.buildDefinitions;
                break;
            }
            case 2: {
                this.buildNumber = obj.buildNumber;
                break;
            }
            case 3: {
                this.buildResults = obj.buildResults;
                break;
            }
            case 4: {
                this.checkoutResult = obj.checkoutResult;
                break;
            }
            case 5: {
                this.dependencies = obj.dependencies;
                break;
            }
            case 6: {
                this.description = obj.description;
                break;
            }
            case 7: {
                this.developers = obj.developers;
                break;
            }
            case 8: {
                this.executorId = obj.executorId;
                break;
            }
            case 9: {
                this.groupId = obj.groupId;
                break;
            }
            case 10: {
                this.id = obj.id;
                break;
            }
            case 11: {
                this.latestBuildId = obj.latestBuildId;
                break;
            }
            case 12: {
                this.modelEncoding = obj.modelEncoding;
                break;
            }
            case 13: {
                this.name = obj.name;
                break;
            }
            case 14: {
                this.notifiers = obj.notifiers;
                break;
            }
            case 15: {
                this.oldState = obj.oldState;
                break;
            }
            case 16: {
                this.parent = obj.parent;
                break;
            }
            case 17: {
                this.projectGroup = obj.projectGroup;
                break;
            }
            case 18: {
                this.scmPassword = obj.scmPassword;
                break;
            }
            case 19: {
                this.scmTag = obj.scmTag;
                break;
            }
            case 20: {
                this.scmUrl = obj.scmUrl;
                break;
            }
            case 21: {
                this.scmUseCache = obj.scmUseCache;
                break;
            }
            case 22: {
                this.scmUsername = obj.scmUsername;
                break;
            }
            case 23: {
                this.state = obj.state;
                break;
            }
            case 24: {
                this.url = obj.url;
                break;
            }
            case 25: {
                this.version = obj.version;
                break;
            }
            case 26: {
                this.workingDirectory = obj.workingDirectory;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoCopyFields(Object obj, int[] fieldNumbers) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (fieldNumbers == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof Project)) {
            throw new IllegalArgumentException("object is not org.apache.maven.continuum.model.project.Project");
        }
        Project me = (Project)obj;
        if (this.jdoStateManager != me.jdoStateManager) {
            throw new IllegalArgumentException("state manager unmatch");
        }
        int i = fieldNumbers.length - 1;
        if (i >= 0) {
            do {
                this.jdoCopyField(me, fieldNumbers[i]);
            } while (--i >= 0);
        }
    }

    private static final /* synthetic */ String[] __jdoFieldNamesInit() {
        return new String[]{"artifactId", "buildDefinitions", "buildNumber", "buildResults", "checkoutResult", "dependencies", "description", "developers", "executorId", "groupId", "id", "latestBuildId", "modelEncoding", "name", "notifiers", "oldState", "parent", "projectGroup", "scmPassword", "scmTag", "scmUrl", "scmUseCache", "scmUsername", "state", "url", "version", "workingDirectory"};
    }

    private static final /* synthetic */ Class[] __jdoFieldTypesInit() {
        return new Class[]{Project.___jdo$loadClass("java.lang.String"), Project.___jdo$loadClass("java.util.List"), Integer.TYPE, Project.___jdo$loadClass("java.util.List"), Project.___jdo$loadClass("org.apache.maven.continuum.model.scm.ScmResult"), Project.___jdo$loadClass("java.util.List"), Project.___jdo$loadClass("java.lang.String"), Project.___jdo$loadClass("java.util.List"), Project.___jdo$loadClass("java.lang.String"), Project.___jdo$loadClass("java.lang.String"), Integer.TYPE, Integer.TYPE, Project.___jdo$loadClass("java.lang.String"), Project.___jdo$loadClass("java.lang.String"), Project.___jdo$loadClass("java.util.List"), Integer.TYPE, Project.___jdo$loadClass("org.apache.maven.continuum.model.project.ProjectDependency"), Project.___jdo$loadClass("org.apache.maven.continuum.model.project.ProjectGroup"), Project.___jdo$loadClass("java.lang.String"), Project.___jdo$loadClass("java.lang.String"), Project.___jdo$loadClass("java.lang.String"), Boolean.TYPE, Project.___jdo$loadClass("java.lang.String"), Integer.TYPE, Project.___jdo$loadClass("java.lang.String"), Project.___jdo$loadClass("java.lang.String"), Project.___jdo$loadClass("java.lang.String")};
    }

    private static final /* synthetic */ byte[] __jdoFieldFlagsInit() {
        return new byte[]{21, 10, 21, 10, 26, 10, 21, 10, 21, 21, 24, 21, 21, 21, 10, 21, 26, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21};
    }

    protected static /* synthetic */ int __jdoGetInheritedFieldCount() {
        return 0;
    }

    protected static /* synthetic */ int jdoGetManagedFieldCount() {
        return 27;
    }

    private static /* synthetic */ Class __jdoPersistenceCapableSuperclassInit() {
        return null;
    }

    public static /* synthetic */ Class ___jdo$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private /* synthetic */ Object jdoSuperClone() throws CloneNotSupportedException {
        Project o = (Project)super.clone();
        o.jdoFlags = 0;
        o.jdoStateManager = null;
        return o;
    }

    private final /* synthetic */ void writeObject(ObjectOutputStream out) throws IOException {
        this.jdoPreSerialize();
        out.defaultWriteObject();
    }

    private static /* synthetic */ void jdoSetartifactId(Project objPC, String artifactId_c) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 0, objPC.artifactId, artifactId_c);
            return;
        }
        objPC.artifactId = artifactId_c;
        if (!objPC.jdoIsDetached()) {
            return;
        }
        ((BitSet)objPC.jdoDetachedState[3]).set(0);
    }

    private static /* synthetic */ String jdoGetartifactId(Project objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 0)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 0, objPC.artifactId);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(0)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"artifactId\" yet this field was not detached when you detached the object. Either dont access this field, or detach the field when detaching the object.");
        }
        return objPC.artifactId;
    }

    private static /* synthetic */ void jdoSetbuildDefinitions(Project objPC, List buildDefinitions_m) {
        if (objPC.jdoStateManager == null) {
            objPC.buildDefinitions = buildDefinitions_m;
        } else {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 1, (Object)objPC.buildDefinitions, (Object)buildDefinitions_m);
        }
        if (!objPC.jdoIsDetached()) {
            return;
        }
        ((BitSet)objPC.jdoDetachedState[3]).set(1);
    }

    private static /* synthetic */ List jdoGetbuildDefinitions(Project objPC) {
        if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 1)) {
            return (List)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 1, (Object)objPC.buildDefinitions);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(1) && !((BitSet)objPC.jdoDetachedState[3]).get(1)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"buildDefinitions\" yet this field was not detached when you detached the object. Either dont access this field, or detach the field when detaching the object.");
        }
        return objPC.buildDefinitions;
    }

    private static /* synthetic */ void jdoSetbuildNumber(Project objPC, int buildNumber_c) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setIntField((PersistenceCapable)objPC, 2, objPC.buildNumber, buildNumber_c);
            return;
        }
        objPC.buildNumber = buildNumber_c;
        if (!objPC.jdoIsDetached()) {
            return;
        }
        ((BitSet)objPC.jdoDetachedState[3]).set(2);
    }

    private static /* synthetic */ int jdoGetbuildNumber(Project objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 2)) {
            return objPC.jdoStateManager.getIntField((PersistenceCapable)objPC, 2, objPC.buildNumber);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(2)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"buildNumber\" yet this field was not detached when you detached the object. Either dont access this field, or detach the field when detaching the object.");
        }
        return objPC.buildNumber;
    }

    private static /* synthetic */ void jdoSetbuildResults(Project objPC, List buildResults_m) {
        if (objPC.jdoStateManager == null) {
            objPC.buildResults = buildResults_m;
        } else {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 3, (Object)objPC.buildResults, (Object)buildResults_m);
        }
        if (!objPC.jdoIsDetached()) {
            return;
        }
        ((BitSet)objPC.jdoDetachedState[3]).set(3);
    }

    private static /* synthetic */ List jdoGetbuildResults(Project objPC) {
        if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 3)) {
            return (List)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 3, (Object)objPC.buildResults);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(3) && !((BitSet)objPC.jdoDetachedState[3]).get(3)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"buildResults\" yet this field was not detached when you detached the object. Either dont access this field, or detach the field when detaching the object.");
        }
        return objPC.buildResults;
    }

    private static /* synthetic */ void jdoSetcheckoutResult(Project objPC, ScmResult checkoutResult_m) {
        if (objPC.jdoStateManager == null) {
            objPC.checkoutResult = checkoutResult_m;
        } else {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 4, (Object)objPC.checkoutResult, (Object)checkoutResult_m);
        }
        if (!objPC.jdoIsDetached()) {
            return;
        }
        ((BitSet)objPC.jdoDetachedState[3]).set(4);
    }

    private static /* synthetic */ ScmResult jdoGetcheckoutResult(Project objPC) {
        if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 4)) {
            return (ScmResult)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 4, (Object)objPC.checkoutResult);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(4) && !((BitSet)objPC.jdoDetachedState[3]).get(4)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"checkoutResult\" yet this field was not detached when you detached the object. Either dont access this field, or detach the field when detaching the object.");
        }
        return objPC.checkoutResult;
    }

    private static /* synthetic */ void jdoSetdependencies(Project objPC, List dependencies_m) {
        if (objPC.jdoStateManager == null) {
            objPC.dependencies = dependencies_m;
        } else {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 5, (Object)objPC.dependencies, (Object)dependencies_m);
        }
        if (!objPC.jdoIsDetached()) {
            return;
        }
        ((BitSet)objPC.jdoDetachedState[3]).set(5);
    }

    private static /* synthetic */ List jdoGetdependencies(Project objPC) {
        if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 5)) {
            return (List)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 5, (Object)objPC.dependencies);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(5) && !((BitSet)objPC.jdoDetachedState[3]).get(5)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"dependencies\" yet this field was not detached when you detached the object. Either dont access this field, or detach the field when detaching the object.");
        }
        return objPC.dependencies;
    }

    private static /* synthetic */ void jdoSetdescription(Project objPC, String description_c) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 6, objPC.description, description_c);
            return;
        }
        objPC.description = description_c;
        if (!objPC.jdoIsDetached()) {
            return;
        }
        ((BitSet)objPC.jdoDetachedState[3]).set(6);
    }

    private static /* synthetic */ String jdoGetdescription(Project objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 6)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 6, objPC.description);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(6)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"description\" yet this field was not detached when you detached the object. Either dont access this field, or detach the field when detaching the object.");
        }
        return objPC.description;
    }

    private static /* synthetic */ void jdoSetdevelopers(Project objPC, List developers_m) {
        if (objPC.jdoStateManager == null) {
            objPC.developers = developers_m;
        } else {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 7, (Object)objPC.developers, (Object)developers_m);
        }
        if (!objPC.jdoIsDetached()) {
            return;
        }
        ((BitSet)objPC.jdoDetachedState[3]).set(7);
    }

    private static /* synthetic */ List jdoGetdevelopers(Project objPC) {
        if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 7)) {
            return (List)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 7, (Object)objPC.developers);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(7) && !((BitSet)objPC.jdoDetachedState[3]).get(7)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"developers\" yet this field was not detached when you detached the object. Either dont access this field, or detach the field when detaching the object.");
        }
        return objPC.developers;
    }

    private static /* synthetic */ void jdoSetexecutorId(Project objPC, String executorId_c) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 8, objPC.executorId, executorId_c);
            return;
        }
        objPC.executorId = executorId_c;
        if (!objPC.jdoIsDetached()) {
            return;
        }
        ((BitSet)objPC.jdoDetachedState[3]).set(8);
    }

    private static /* synthetic */ String jdoGetexecutorId(Project objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 8)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 8, objPC.executorId);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(8)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"executorId\" yet this field was not detached when you detached the object. Either dont access this field, or detach the field when detaching the object.");
        }
        return objPC.executorId;
    }

    private static /* synthetic */ void jdoSetgroupId(Project objPC, String groupId_c) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 9, objPC.groupId, groupId_c);
            return;
        }
        objPC.groupId = groupId_c;
        if (!objPC.jdoIsDetached()) {
            return;
        }
        ((BitSet)objPC.jdoDetachedState[3]).set(9);
    }

    private static /* synthetic */ String jdoGetgroupId(Project objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 9)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 9, objPC.groupId);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(9)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"groupId\" yet this field was not detached when you detached the object. Either dont access this field, or detach the field when detaching the object.");
        }
        return objPC.groupId;
    }

    private static /* synthetic */ void jdoSetlatestBuildId(Project objPC, int latestBuildId_c) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setIntField((PersistenceCapable)objPC, 11, objPC.latestBuildId, latestBuildId_c);
            return;
        }
        objPC.latestBuildId = latestBuildId_c;
        if (!objPC.jdoIsDetached()) {
            return;
        }
        ((BitSet)objPC.jdoDetachedState[3]).set(11);
    }

    private static /* synthetic */ int jdoGetlatestBuildId(Project objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 11)) {
            return objPC.jdoStateManager.getIntField((PersistenceCapable)objPC, 11, objPC.latestBuildId);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(11)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"latestBuildId\" yet this field was not detached when you detached the object. Either dont access this field, or detach the field when detaching the object.");
        }
        return objPC.latestBuildId;
    }

    private static /* synthetic */ void jdoSetmodelEncoding(Project objPC, String modelEncoding_c) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 12, objPC.modelEncoding, modelEncoding_c);
            return;
        }
        objPC.modelEncoding = modelEncoding_c;
        if (!objPC.jdoIsDetached()) {
            return;
        }
        ((BitSet)objPC.jdoDetachedState[3]).set(12);
    }

    private static /* synthetic */ String jdoGetmodelEncoding(Project objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 12)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 12, objPC.modelEncoding);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(12)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"modelEncoding\" yet this field was not detached when you detached the object. Either dont access this field, or detach the field when detaching the object.");
        }
        return objPC.modelEncoding;
    }

    private static /* synthetic */ void jdoSetname(Project objPC, String name_c) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 13, objPC.name, name_c);
            return;
        }
        objPC.name = name_c;
        if (!objPC.jdoIsDetached()) {
            return;
        }
        ((BitSet)objPC.jdoDetachedState[3]).set(13);
    }

    private static /* synthetic */ String jdoGetname(Project objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 13)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 13, objPC.name);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(13)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"name\" yet this field was not detached when you detached the object. Either dont access this field, or detach the field when detaching the object.");
        }
        return objPC.name;
    }

    private static /* synthetic */ void jdoSetnotifiers(Project objPC, List notifiers_m) {
        if (objPC.jdoStateManager == null) {
            objPC.notifiers = notifiers_m;
        } else {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 14, (Object)objPC.notifiers, (Object)notifiers_m);
        }
        if (!objPC.jdoIsDetached()) {
            return;
        }
        ((BitSet)objPC.jdoDetachedState[3]).set(14);
    }

    private static /* synthetic */ List jdoGetnotifiers(Project objPC) {
        if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 14)) {
            return (List)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 14, (Object)objPC.notifiers);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(14) && !((BitSet)objPC.jdoDetachedState[3]).get(14)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"notifiers\" yet this field was not detached when you detached the object. Either dont access this field, or detach the field when detaching the object.");
        }
        return objPC.notifiers;
    }

    private static /* synthetic */ void jdoSetoldState(Project objPC, int oldState_c) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setIntField((PersistenceCapable)objPC, 15, objPC.oldState, oldState_c);
            return;
        }
        objPC.oldState = oldState_c;
        if (!objPC.jdoIsDetached()) {
            return;
        }
        ((BitSet)objPC.jdoDetachedState[3]).set(15);
    }

    private static /* synthetic */ int jdoGetoldState(Project objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 15)) {
            return objPC.jdoStateManager.getIntField((PersistenceCapable)objPC, 15, objPC.oldState);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(15)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"oldState\" yet this field was not detached when you detached the object. Either dont access this field, or detach the field when detaching the object.");
        }
        return objPC.oldState;
    }

    private static /* synthetic */ void jdoSetparent(Project objPC, ProjectDependency parent_m) {
        if (objPC.jdoStateManager == null) {
            objPC.parent = parent_m;
        } else {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 16, (Object)objPC.parent, (Object)parent_m);
        }
        if (!objPC.jdoIsDetached()) {
            return;
        }
        ((BitSet)objPC.jdoDetachedState[3]).set(16);
    }

    private static /* synthetic */ ProjectDependency jdoGetparent(Project objPC) {
        if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 16)) {
            return (ProjectDependency)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 16, (Object)objPC.parent);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(16) && !((BitSet)objPC.jdoDetachedState[3]).get(16)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"parent\" yet this field was not detached when you detached the object. Either dont access this field, or detach the field when detaching the object.");
        }
        return objPC.parent;
    }

    private static /* synthetic */ void jdoSetprojectGroup(Project objPC, ProjectGroup projectGroup_c) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 17, (Object)objPC.projectGroup, (Object)projectGroup_c);
            return;
        }
        objPC.projectGroup = projectGroup_c;
        if (!objPC.jdoIsDetached()) {
            return;
        }
        ((BitSet)objPC.jdoDetachedState[3]).set(17);
    }

    private static /* synthetic */ ProjectGroup jdoGetprojectGroup(Project objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 17)) {
            return (ProjectGroup)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 17, (Object)objPC.projectGroup);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(17)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"projectGroup\" yet this field was not detached when you detached the object. Either dont access this field, or detach the field when detaching the object.");
        }
        return objPC.projectGroup;
    }

    private static /* synthetic */ void jdoSetscmPassword(Project objPC, String scmPassword_c) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 18, objPC.scmPassword, scmPassword_c);
            return;
        }
        objPC.scmPassword = scmPassword_c;
        if (!objPC.jdoIsDetached()) {
            return;
        }
        ((BitSet)objPC.jdoDetachedState[3]).set(18);
    }

    private static /* synthetic */ String jdoGetscmPassword(Project objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 18)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 18, objPC.scmPassword);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(18)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"scmPassword\" yet this field was not detached when you detached the object. Either dont access this field, or detach the field when detaching the object.");
        }
        return objPC.scmPassword;
    }

    private static /* synthetic */ void jdoSetscmTag(Project objPC, String scmTag_c) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 19, objPC.scmTag, scmTag_c);
            return;
        }
        objPC.scmTag = scmTag_c;
        if (!objPC.jdoIsDetached()) {
            return;
        }
        ((BitSet)objPC.jdoDetachedState[3]).set(19);
    }

    private static /* synthetic */ String jdoGetscmTag(Project objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 19)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 19, objPC.scmTag);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(19)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"scmTag\" yet this field was not detached when you detached the object. Either dont access this field, or detach the field when detaching the object.");
        }
        return objPC.scmTag;
    }

    private static /* synthetic */ void jdoSetscmUrl(Project objPC, String scmUrl_c) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 20, objPC.scmUrl, scmUrl_c);
            return;
        }
        objPC.scmUrl = scmUrl_c;
        if (!objPC.jdoIsDetached()) {
            return;
        }
        ((BitSet)objPC.jdoDetachedState[3]).set(20);
    }

    private static /* synthetic */ String jdoGetscmUrl(Project objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 20)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 20, objPC.scmUrl);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(20)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"scmUrl\" yet this field was not detached when you detached the object. Either dont access this field, or detach the field when detaching the object.");
        }
        return objPC.scmUrl;
    }

    private static /* synthetic */ void jdoSetscmUseCache(Project objPC, boolean scmUseCache_c) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setBooleanField((PersistenceCapable)objPC, 21, objPC.scmUseCache, scmUseCache_c);
            return;
        }
        objPC.scmUseCache = scmUseCache_c;
        if (!objPC.jdoIsDetached()) {
            return;
        }
        ((BitSet)objPC.jdoDetachedState[3]).set(21);
    }

    private static /* synthetic */ boolean jdoGetscmUseCache(Project objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 21)) {
            return objPC.jdoStateManager.getBooleanField((PersistenceCapable)objPC, 21, objPC.scmUseCache);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(21)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"scmUseCache\" yet this field was not detached when you detached the object. Either dont access this field, or detach the field when detaching the object.");
        }
        return objPC.scmUseCache;
    }

    private static /* synthetic */ void jdoSetscmUsername(Project objPC, String scmUsername_c) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 22, objPC.scmUsername, scmUsername_c);
            return;
        }
        objPC.scmUsername = scmUsername_c;
        if (!objPC.jdoIsDetached()) {
            return;
        }
        ((BitSet)objPC.jdoDetachedState[3]).set(22);
    }

    private static /* synthetic */ String jdoGetscmUsername(Project objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 22)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 22, objPC.scmUsername);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(22)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"scmUsername\" yet this field was not detached when you detached the object. Either dont access this field, or detach the field when detaching the object.");
        }
        return objPC.scmUsername;
    }

    private static /* synthetic */ void jdoSetstate(Project objPC, int state_c) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setIntField((PersistenceCapable)objPC, 23, objPC.state, state_c);
            return;
        }
        objPC.state = state_c;
        if (!objPC.jdoIsDetached()) {
            return;
        }
        ((BitSet)objPC.jdoDetachedState[3]).set(23);
    }

    private static /* synthetic */ int jdoGetstate(Project objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 23)) {
            return objPC.jdoStateManager.getIntField((PersistenceCapable)objPC, 23, objPC.state);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(23)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"state\" yet this field was not detached when you detached the object. Either dont access this field, or detach the field when detaching the object.");
        }
        return objPC.state;
    }

    private static /* synthetic */ void jdoSeturl(Project objPC, String url_c) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 24, objPC.url, url_c);
            return;
        }
        objPC.url = url_c;
        if (!objPC.jdoIsDetached()) {
            return;
        }
        ((BitSet)objPC.jdoDetachedState[3]).set(24);
    }

    private static /* synthetic */ String jdoGeturl(Project objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 24)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 24, objPC.url);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(24)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"url\" yet this field was not detached when you detached the object. Either dont access this field, or detach the field when detaching the object.");
        }
        return objPC.url;
    }

    private static /* synthetic */ void jdoSetversion(Project objPC, String version_c) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 25, objPC.version, version_c);
            return;
        }
        objPC.version = version_c;
        if (!objPC.jdoIsDetached()) {
            return;
        }
        ((BitSet)objPC.jdoDetachedState[3]).set(25);
    }

    private static /* synthetic */ String jdoGetversion(Project objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 25)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 25, objPC.version);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(25)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"version\" yet this field was not detached when you detached the object. Either dont access this field, or detach the field when detaching the object.");
        }
        return objPC.version;
    }

    private static /* synthetic */ void jdoSetworkingDirectory(Project objPC, String workingDirectory_c) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 26, objPC.workingDirectory, workingDirectory_c);
            return;
        }
        objPC.workingDirectory = workingDirectory_c;
        if (!objPC.jdoIsDetached()) {
            return;
        }
        ((BitSet)objPC.jdoDetachedState[3]).set(26);
    }

    private static /* synthetic */ String jdoGetworkingDirectory(Project objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 26)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 26, objPC.workingDirectory);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(26)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"workingDirectory\" yet this field was not detached when you detached the object. Either dont access this field, or detach the field when detaching the object.");
        }
        return objPC.workingDirectory;
    }

    public Project() {
        this.id = 0;
        Project.jdoSetscmUseCache(this, false);
        Project.jdoSetstate(this, 1);
        Project.jdoSetoldState(this, 0);
        Project.jdoSetlatestBuildId(this, 0);
        Project.jdoSetbuildNumber(this, 0);
        Project.jdoSetmodelEncoding(this, "UTF-8");
    }
}

