/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.model.project;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.Permission;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;
import java.util.List;
import javax.jdo.JDODetachedFieldAccessException;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.PersistenceManager;
import javax.jdo.identity.IntIdentity;
import javax.jdo.spi.Detachable;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.JDOPermission;
import javax.jdo.spi.PersistenceCapable;
import javax.jdo.spi.StateManager;
import org.apache.maven.continuum.model.project.BuildDefinition;
import org.apache.maven.continuum.model.project.Project;
import org.apache.maven.continuum.model.project.ProjectDependency;
import org.apache.maven.continuum.model.scm.ScmResult;
import org.apache.maven.continuum.model.scm.TestResult;

public class BuildResult
implements Serializable,
PersistenceCapable,
Detachable {
    private Project project;
    private BuildDefinition buildDefinition;
    private int id;
    private int buildNumber;
    private int state;
    private int trigger;
    private long startTime;
    private long endTime;
    private String error;
    private boolean success;
    private int exitCode;
    private ScmResult scmResult;
    private TestResult testResult;
    private List modifiedDependencies;
    private String modelEncoding;
    protected transient /* synthetic */ StateManager jdoStateManager;
    protected transient /* synthetic */ byte jdoFlags;
    protected /* synthetic */ Object[] jdoDetachedState;
    private static final /* synthetic */ byte[] jdoFieldFlags;
    private static final /* synthetic */ Class jdoPersistenceCapableSuperclass;
    private static final /* synthetic */ Class[] jdoFieldTypes;
    private static final /* synthetic */ String[] jdoFieldNames;
    private static final /* synthetic */ int jdoInheritedFieldCount;
    private static final /* synthetic */ long serialVersionUID;

    static {
        serialVersionUID = 3794453480602394916L;
        jdoFieldNames = BuildResult.__jdoFieldNamesInit();
        jdoFieldTypes = BuildResult.__jdoFieldTypesInit();
        jdoFieldFlags = BuildResult.__jdoFieldFlagsInit();
        jdoInheritedFieldCount = BuildResult.__jdoGetInheritedFieldCount();
        jdoPersistenceCapableSuperclass = BuildResult.__jdoPersistenceCapableSuperclassInit();
        JDOImplHelper.registerClass((Class)BuildResult.___jdo$loadClass("org.apache.maven.continuum.model.project.BuildResult"), (String[])jdoFieldNames, (Class[])jdoFieldTypes, (byte[])jdoFieldFlags, (Class)jdoPersistenceCapableSuperclass, (PersistenceCapable)new BuildResult());
    }

    public void addModifiedDependency(ProjectDependency projectDependency) {
        if (!(projectDependency instanceof ProjectDependency)) {
            throw new ClassCastException("BuildResult.addModifiedDependencies(projectDependency) parameter must be instanceof " + ProjectDependency.class.getName());
        }
        this.getModifiedDependencies().add(projectDependency);
    }

    public void breakProjectAssociation(Project project) {
        if (BuildResult.jdoGetproject(this) != project) {
            throw new IllegalStateException("project isn't associated.");
        }
        BuildResult.jdoSetproject(this, null);
    }

    public void createProjectAssociation(Project project) {
        if (BuildResult.jdoGetproject(this) != null) {
            this.breakProjectAssociation(BuildResult.jdoGetproject(this));
        }
        BuildResult.jdoSetproject(this, project);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BuildResult)) {
            return false;
        }
        BuildResult that = (BuildResult)other;
        boolean result = true;
        result = result && this.id == that.id;
        return result;
    }

    public BuildDefinition getBuildDefinition() {
        return BuildResult.jdoGetbuildDefinition(this);
    }

    public int getBuildNumber() {
        return BuildResult.jdoGetbuildNumber(this);
    }

    public long getEndTime() {
        return BuildResult.jdoGetendTime(this);
    }

    public String getError() {
        return BuildResult.jdoGeterror(this);
    }

    public int getExitCode() {
        return BuildResult.jdoGetexitCode(this);
    }

    public int getId() {
        return this.id;
    }

    public List getModifiedDependencies() {
        if (BuildResult.jdoGetmodifiedDependencies(this) == null) {
            BuildResult.jdoSetmodifiedDependencies(this, new ArrayList());
        }
        return BuildResult.jdoGetmodifiedDependencies(this);
    }

    public Project getProject() {
        return BuildResult.jdoGetproject(this);
    }

    public ScmResult getScmResult() {
        return BuildResult.jdoGetscmResult(this);
    }

    public long getStartTime() {
        return BuildResult.jdoGetstartTime(this);
    }

    public int getState() {
        return BuildResult.jdoGetstate(this);
    }

    public TestResult getTestResult() {
        return BuildResult.jdoGettestResult(this);
    }

    public int getTrigger() {
        return BuildResult.jdoGettrigger(this);
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.id;
        return result;
    }

    public boolean isSuccess() {
        return BuildResult.jdoGetsuccess(this);
    }

    public void removeModifiedDependency(ProjectDependency projectDependency) {
        if (!(projectDependency instanceof ProjectDependency)) {
            throw new ClassCastException("BuildResult.removeModifiedDependencies(projectDependency) parameter must be instanceof " + ProjectDependency.class.getName());
        }
        this.getModifiedDependencies().remove(projectDependency);
    }

    public void setBuildDefinition(BuildDefinition buildDefinition) {
        BuildResult.jdoSetbuildDefinition(this, buildDefinition);
    }

    public void setBuildNumber(int buildNumber) {
        BuildResult.jdoSetbuildNumber(this, buildNumber);
    }

    public void setEndTime(long endTime) {
        BuildResult.jdoSetendTime(this, endTime);
    }

    public void setError(String error) {
        BuildResult.jdoSeterror(this, error);
    }

    public void setExitCode(int exitCode) {
        BuildResult.jdoSetexitCode(this, exitCode);
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setModifiedDependencies(List modifiedDependencies) {
        BuildResult.jdoSetmodifiedDependencies(this, modifiedDependencies);
    }

    public void setProject(Project project) {
        if (BuildResult.jdoGetproject(this) != null) {
            BuildResult.jdoGetproject(this).breakBuildResultAssociation(this);
        }
        BuildResult.jdoSetproject(this, project);
        if (project != null) {
            BuildResult.jdoGetproject(this).createBuildResultAssociation(this);
        }
    }

    public void setScmResult(ScmResult scmResult) {
        BuildResult.jdoSetscmResult(this, scmResult);
    }

    public void setStartTime(long startTime) {
        BuildResult.jdoSetstartTime(this, startTime);
    }

    public void setState(int state) {
        BuildResult.jdoSetstate(this, state);
    }

    public void setSuccess(boolean success) {
        BuildResult.jdoSetsuccess(this, success);
    }

    public void setTestResult(TestResult testResult) {
        BuildResult.jdoSettestResult(this, testResult);
    }

    public void setTrigger(int trigger) {
        BuildResult.jdoSettrigger(this, trigger);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("id = '");
        buf.append(this.getId() + "'");
        return buf.toString();
    }

    public String getElapsedTime() {
        return this.getTimeDifference(BuildResult.jdoGetstartTime(this), this.getSystemTime());
    }

    public String getDurationTime() {
        return this.getTimeDifference(BuildResult.jdoGetstartTime(this), BuildResult.jdoGetendTime(this));
    }

    private long getSystemTime() {
        return Calendar.getInstance().getTime().getTime();
    }

    private String getTimeDifference(long startTime, long endTime) {
        long start = startTime;
        long end = endTime;
        if (start == 0L) {
            return "";
        }
        if (end == 0L) {
            end = this.getSystemTime();
        }
        int timeInSeconds = (int)((end - start) / 1000L);
        int days = timeInSeconds / 86400;
        int hours = (timeInSeconds -= days * 86400) / 3600;
        int minutes = (timeInSeconds -= hours * 3600) / 60;
        int seconds = timeInSeconds -= minutes * 60;
        String elapsedTime = "";
        if (days > 0) {
            elapsedTime = days + " d ";
            elapsedTime = elapsedTime + hours + " h ";
            elapsedTime = elapsedTime + minutes + " min ";
            elapsedTime = elapsedTime + seconds + " sec";
        } else if (hours > 0) {
            elapsedTime = hours + " h ";
            elapsedTime = elapsedTime + minutes + " min ";
            elapsedTime = elapsedTime + seconds + " sec";
        } else if (minutes > 0) {
            elapsedTime = minutes + " min ";
            elapsedTime = elapsedTime + seconds + " sec";
        } else {
            elapsedTime = seconds + " sec";
        }
        return elapsedTime;
    }

    public void setModelEncoding(String modelEncoding) {
        BuildResult.jdoSetmodelEncoding(this, modelEncoding);
    }

    public String getModelEncoding() {
        return BuildResult.jdoGetmodelEncoding(this);
    }

    public void jdoCopyKeyFieldsFromObjectId(PersistenceCapable.ObjectIdFieldConsumer fc, Object oid) {
        if (fc == null) {
            throw new IllegalArgumentException("ObjectIdFieldConsumer is null");
        }
        if (!(oid instanceof IntIdentity)) {
            throw new ClassCastException("oid is not instanceof javax.jdo.identity.IntIdentity");
        }
        IntIdentity o = (IntIdentity)oid;
        fc.storeIntField(5, o.getKey());
    }

    protected void jdoCopyKeyFieldsFromObjectId(Object oid) {
        if (!(oid instanceof IntIdentity)) {
            throw new ClassCastException("key class is not javax.jdo.identity.IntIdentity or null");
        }
        IntIdentity o = (IntIdentity)oid;
        this.id = o.getKey();
    }

    public final void jdoCopyKeyFieldsToObjectId(Object oid) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with Single Field Identity.");
    }

    public final void jdoCopyKeyFieldsToObjectId(PersistenceCapable.ObjectIdFieldSupplier fs, Object oid) {
        throw new JDOFatalInternalException("It's illegal to call jdoCopyKeyFieldsToObjectId for a class with Single Field Identity.");
    }

    public final Object jdoGetObjectId() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getObjectId((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[0];
    }

    public final Object jdoGetVersion() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getVersion((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return null;
        }
        return this.jdoDetachedState[1];
    }

    protected final void jdoPreSerialize() {
        block0: {
            if (this.jdoStateManager == null) break block0;
            this.jdoStateManager.preSerialize((PersistenceCapable)this);
        }
    }

    public final PersistenceManager jdoGetPersistenceManager() {
        return this.jdoStateManager != null ? this.jdoStateManager.getPersistenceManager((PersistenceCapable)this) : null;
    }

    public final Object jdoGetTransactionalObjectId() {
        return this.jdoStateManager != null ? this.jdoStateManager.getTransactionalObjectId((PersistenceCapable)this) : null;
    }

    public final boolean jdoIsDeleted() {
        return this.jdoStateManager != null ? this.jdoStateManager.isDeleted((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsDirty() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.isDirty((PersistenceCapable)this);
        }
        if (!this.jdoIsDetached()) {
            return false;
        }
        return ((BitSet)this.jdoDetachedState[3]).length() > 0;
    }

    public final boolean jdoIsNew() {
        return this.jdoStateManager != null ? this.jdoStateManager.isNew((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsPersistent() {
        return this.jdoStateManager != null ? this.jdoStateManager.isPersistent((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsTransactional() {
        return this.jdoStateManager != null ? this.jdoStateManager.isTransactional((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsDetached() {
        return this.jdoIsDetachedInternal();
    }

    public final void jdoMakeDirty(String fieldName) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.makeDirty((PersistenceCapable)this, fieldName);
        }
    }

    public final Object jdoNewObjectIdInstance() {
        return new IntIdentity(this.getClass(), this.id);
    }

    public final Object jdoNewObjectIdInstance(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (!(key instanceof String)) {
            return new IntIdentity(this.getClass(), (Integer)key);
        }
        return new IntIdentity(this.getClass(), (String)key);
    }

    public final void jdoProvideFields(int[] fieldId) {
        if (fieldId == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = fieldId.length - 1;
        if (i >= 0) {
            do {
                this.jdoProvideField(fieldId[i]);
            } while (--i >= 0);
        }
    }

    public final void jdoReplaceFields(int[] fieldId) {
        if (fieldId == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = fieldId.length;
        if (i > 0) {
            int n = 0;
            do {
                this.jdoReplaceField(fieldId[n]);
            } while (++n < i);
        }
    }

    public final void jdoReplaceFlags() {
        if (this.jdoStateManager != null) {
            this.jdoFlags = this.jdoStateManager.replacingFlags((PersistenceCapable)this);
        }
    }

    public final synchronized void jdoReplaceStateManager(StateManager stateManager) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager = this.jdoStateManager.replacingStateManager((PersistenceCapable)this, stateManager);
            return;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission((Permission)new JDOPermission("setStateManager"));
        }
        this.jdoStateManager = stateManager;
        this.jdoFlags = 1;
    }

    public final synchronized void jdoReplaceDetachedState() {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        this.jdoDetachedState = this.jdoStateManager.replacingDetachedState((Detachable)this, this.jdoDetachedState);
    }

    protected boolean jdoIsDetachedInternal() {
        if (this.jdoStateManager == null) {
            return this.jdoDetachedState != null;
        }
        return false;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm) {
        BuildResult result = new BuildResult();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        return result;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm, Object o) {
        BuildResult result = new BuildResult();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        result.jdoCopyKeyFieldsFromObjectId(o);
        return result;
    }

    public void jdoReplaceField(int fieldIndex) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (fieldIndex) {
            case 0: {
                this.buildDefinition = (BuildDefinition)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, fieldIndex);
                return;
            }
            case 1: {
                this.buildNumber = this.jdoStateManager.replacingIntField((PersistenceCapable)this, fieldIndex);
                return;
            }
            case 2: {
                this.endTime = this.jdoStateManager.replacingLongField((PersistenceCapable)this, fieldIndex);
                return;
            }
            case 3: {
                this.error = this.jdoStateManager.replacingStringField((PersistenceCapable)this, fieldIndex);
                return;
            }
            case 4: {
                this.exitCode = this.jdoStateManager.replacingIntField((PersistenceCapable)this, fieldIndex);
                return;
            }
            case 5: {
                this.id = this.jdoStateManager.replacingIntField((PersistenceCapable)this, fieldIndex);
                return;
            }
            case 6: {
                this.modelEncoding = this.jdoStateManager.replacingStringField((PersistenceCapable)this, fieldIndex);
                return;
            }
            case 7: {
                this.modifiedDependencies = (List)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, fieldIndex);
                return;
            }
            case 8: {
                this.project = (Project)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, fieldIndex);
                return;
            }
            case 9: {
                this.scmResult = (ScmResult)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, fieldIndex);
                return;
            }
            case 10: {
                this.startTime = this.jdoStateManager.replacingLongField((PersistenceCapable)this, fieldIndex);
                return;
            }
            case 11: {
                this.state = this.jdoStateManager.replacingIntField((PersistenceCapable)this, fieldIndex);
                return;
            }
            case 12: {
                this.success = this.jdoStateManager.replacingBooleanField((PersistenceCapable)this, fieldIndex);
                return;
            }
            case 13: {
                this.testResult = (TestResult)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, fieldIndex);
                return;
            }
            case 14: {
                this.trigger = this.jdoStateManager.replacingIntField((PersistenceCapable)this, fieldIndex);
                return;
            }
        }
        throw new IllegalArgumentException(new StringBuffer("out of field index :").append(fieldIndex).toString());
    }

    public void jdoProvideField(int fieldIndex) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (fieldIndex) {
            case 0: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, fieldIndex, (Object)this.buildDefinition);
                return;
            }
            case 1: {
                this.jdoStateManager.providedIntField((PersistenceCapable)this, fieldIndex, this.buildNumber);
                return;
            }
            case 2: {
                this.jdoStateManager.providedLongField((PersistenceCapable)this, fieldIndex, this.endTime);
                return;
            }
            case 3: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, fieldIndex, this.error);
                return;
            }
            case 4: {
                this.jdoStateManager.providedIntField((PersistenceCapable)this, fieldIndex, this.exitCode);
                return;
            }
            case 5: {
                this.jdoStateManager.providedIntField((PersistenceCapable)this, fieldIndex, this.id);
                return;
            }
            case 6: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, fieldIndex, this.modelEncoding);
                return;
            }
            case 7: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, fieldIndex, (Object)this.modifiedDependencies);
                return;
            }
            case 8: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, fieldIndex, (Object)this.project);
                return;
            }
            case 9: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, fieldIndex, (Object)this.scmResult);
                return;
            }
            case 10: {
                this.jdoStateManager.providedLongField((PersistenceCapable)this, fieldIndex, this.startTime);
                return;
            }
            case 11: {
                this.jdoStateManager.providedIntField((PersistenceCapable)this, fieldIndex, this.state);
                return;
            }
            case 12: {
                this.jdoStateManager.providedBooleanField((PersistenceCapable)this, fieldIndex, this.success);
                return;
            }
            case 13: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, fieldIndex, (Object)this.testResult);
                return;
            }
            case 14: {
                this.jdoStateManager.providedIntField((PersistenceCapable)this, fieldIndex, this.trigger);
                return;
            }
        }
        throw new IllegalArgumentException(new StringBuffer("out of field index :").append(fieldIndex).toString());
    }

    protected final /* synthetic */ void jdoCopyField(BuildResult obj, int index) {
        switch (index) {
            case 0: {
                this.buildDefinition = obj.buildDefinition;
                break;
            }
            case 1: {
                this.buildNumber = obj.buildNumber;
                break;
            }
            case 2: {
                this.endTime = obj.endTime;
                break;
            }
            case 3: {
                this.error = obj.error;
                break;
            }
            case 4: {
                this.exitCode = obj.exitCode;
                break;
            }
            case 5: {
                this.id = obj.id;
                break;
            }
            case 6: {
                this.modelEncoding = obj.modelEncoding;
                break;
            }
            case 7: {
                this.modifiedDependencies = obj.modifiedDependencies;
                break;
            }
            case 8: {
                this.project = obj.project;
                break;
            }
            case 9: {
                this.scmResult = obj.scmResult;
                break;
            }
            case 10: {
                this.startTime = obj.startTime;
                break;
            }
            case 11: {
                this.state = obj.state;
                break;
            }
            case 12: {
                this.success = obj.success;
                break;
            }
            case 13: {
                this.testResult = obj.testResult;
                break;
            }
            case 14: {
                this.trigger = obj.trigger;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoCopyFields(Object obj, int[] fieldNumbers) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (fieldNumbers == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof BuildResult)) {
            throw new IllegalArgumentException("object is not org.apache.maven.continuum.model.project.BuildResult");
        }
        BuildResult me = (BuildResult)obj;
        if (this.jdoStateManager != me.jdoStateManager) {
            throw new IllegalArgumentException("state manager unmatch");
        }
        int i = fieldNumbers.length - 1;
        if (i >= 0) {
            do {
                this.jdoCopyField(me, fieldNumbers[i]);
            } while (--i >= 0);
        }
    }

    private static final /* synthetic */ String[] __jdoFieldNamesInit() {
        return new String[]{"buildDefinition", "buildNumber", "endTime", "error", "exitCode", "id", "modelEncoding", "modifiedDependencies", "project", "scmResult", "startTime", "state", "success", "testResult", "trigger"};
    }

    private static final /* synthetic */ Class[] __jdoFieldTypesInit() {
        return new Class[]{BuildResult.___jdo$loadClass("org.apache.maven.continuum.model.project.BuildDefinition"), Integer.TYPE, Long.TYPE, BuildResult.___jdo$loadClass("java.lang.String"), Integer.TYPE, Integer.TYPE, BuildResult.___jdo$loadClass("java.lang.String"), BuildResult.___jdo$loadClass("java.util.List"), BuildResult.___jdo$loadClass("org.apache.maven.continuum.model.project.Project"), BuildResult.___jdo$loadClass("org.apache.maven.continuum.model.scm.ScmResult"), Long.TYPE, Integer.TYPE, Boolean.TYPE, BuildResult.___jdo$loadClass("org.apache.maven.continuum.model.scm.TestResult"), Integer.TYPE};
    }

    private static final /* synthetic */ byte[] __jdoFieldFlagsInit() {
        return new byte[]{21, 21, 21, 21, 21, 24, 21, 10, 21, 26, 21, 21, 21, 26, 21};
    }

    protected static /* synthetic */ int __jdoGetInheritedFieldCount() {
        return 0;
    }

    protected static /* synthetic */ int jdoGetManagedFieldCount() {
        return 15;
    }

    private static /* synthetic */ Class __jdoPersistenceCapableSuperclassInit() {
        return null;
    }

    public static /* synthetic */ Class ___jdo$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private /* synthetic */ Object jdoSuperClone() throws CloneNotSupportedException {
        BuildResult o = (BuildResult)super.clone();
        o.jdoFlags = 0;
        o.jdoStateManager = null;
        return o;
    }

    private final /* synthetic */ void writeObject(ObjectOutputStream out) throws IOException {
        this.jdoPreSerialize();
        out.defaultWriteObject();
    }

    private static /* synthetic */ void jdoSetbuildDefinition(BuildResult objPC, BuildDefinition buildDefinition_c) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 0, (Object)objPC.buildDefinition, (Object)buildDefinition_c);
            return;
        }
        objPC.buildDefinition = buildDefinition_c;
        if (!objPC.jdoIsDetached()) {
            return;
        }
        ((BitSet)objPC.jdoDetachedState[3]).set(0);
    }

    private static /* synthetic */ BuildDefinition jdoGetbuildDefinition(BuildResult objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 0)) {
            return (BuildDefinition)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 0, (Object)objPC.buildDefinition);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(0)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"buildDefinition\" yet this field was not detached when you detached the object. Either dont access this field, or detach the field when detaching the object.");
        }
        return objPC.buildDefinition;
    }

    private static /* synthetic */ void jdoSetbuildNumber(BuildResult objPC, int buildNumber_c) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setIntField((PersistenceCapable)objPC, 1, objPC.buildNumber, buildNumber_c);
            return;
        }
        objPC.buildNumber = buildNumber_c;
        if (!objPC.jdoIsDetached()) {
            return;
        }
        ((BitSet)objPC.jdoDetachedState[3]).set(1);
    }

    private static /* synthetic */ int jdoGetbuildNumber(BuildResult objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 1)) {
            return objPC.jdoStateManager.getIntField((PersistenceCapable)objPC, 1, objPC.buildNumber);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(1)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"buildNumber\" yet this field was not detached when you detached the object. Either dont access this field, or detach the field when detaching the object.");
        }
        return objPC.buildNumber;
    }

    private static /* synthetic */ void jdoSetendTime(BuildResult objPC, long endTime_c) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setLongField((PersistenceCapable)objPC, 2, objPC.endTime, endTime_c);
            return;
        }
        objPC.endTime = endTime_c;
        if (!objPC.jdoIsDetached()) {
            return;
        }
        ((BitSet)objPC.jdoDetachedState[3]).set(2);
    }

    private static /* synthetic */ long jdoGetendTime(BuildResult objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 2)) {
            return objPC.jdoStateManager.getLongField((PersistenceCapable)objPC, 2, objPC.endTime);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(2)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"endTime\" yet this field was not detached when you detached the object. Either dont access this field, or detach the field when detaching the object.");
        }
        return objPC.endTime;
    }

    private static /* synthetic */ void jdoSeterror(BuildResult objPC, String error_c) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 3, objPC.error, error_c);
            return;
        }
        objPC.error = error_c;
        if (!objPC.jdoIsDetached()) {
            return;
        }
        ((BitSet)objPC.jdoDetachedState[3]).set(3);
    }

    private static /* synthetic */ String jdoGeterror(BuildResult objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 3)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 3, objPC.error);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(3)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"error\" yet this field was not detached when you detached the object. Either dont access this field, or detach the field when detaching the object.");
        }
        return objPC.error;
    }

    private static /* synthetic */ void jdoSetexitCode(BuildResult objPC, int exitCode_c) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setIntField((PersistenceCapable)objPC, 4, objPC.exitCode, exitCode_c);
            return;
        }
        objPC.exitCode = exitCode_c;
        if (!objPC.jdoIsDetached()) {
            return;
        }
        ((BitSet)objPC.jdoDetachedState[3]).set(4);
    }

    private static /* synthetic */ int jdoGetexitCode(BuildResult objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 4)) {
            return objPC.jdoStateManager.getIntField((PersistenceCapable)objPC, 4, objPC.exitCode);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(4)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"exitCode\" yet this field was not detached when you detached the object. Either dont access this field, or detach the field when detaching the object.");
        }
        return objPC.exitCode;
    }

    private static /* synthetic */ void jdoSetmodelEncoding(BuildResult objPC, String modelEncoding_c) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 6, objPC.modelEncoding, modelEncoding_c);
            return;
        }
        objPC.modelEncoding = modelEncoding_c;
        if (!objPC.jdoIsDetached()) {
            return;
        }
        ((BitSet)objPC.jdoDetachedState[3]).set(6);
    }

    private static /* synthetic */ String jdoGetmodelEncoding(BuildResult objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 6)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 6, objPC.modelEncoding);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(6)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"modelEncoding\" yet this field was not detached when you detached the object. Either dont access this field, or detach the field when detaching the object.");
        }
        return objPC.modelEncoding;
    }

    private static /* synthetic */ void jdoSetmodifiedDependencies(BuildResult objPC, List modifiedDependencies_m) {
        if (objPC.jdoStateManager == null) {
            objPC.modifiedDependencies = modifiedDependencies_m;
        } else {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 7, (Object)objPC.modifiedDependencies, (Object)modifiedDependencies_m);
        }
        if (!objPC.jdoIsDetached()) {
            return;
        }
        ((BitSet)objPC.jdoDetachedState[3]).set(7);
    }

    private static /* synthetic */ List jdoGetmodifiedDependencies(BuildResult objPC) {
        if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 7)) {
            return (List)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 7, (Object)objPC.modifiedDependencies);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(7) && !((BitSet)objPC.jdoDetachedState[3]).get(7)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"modifiedDependencies\" yet this field was not detached when you detached the object. Either dont access this field, or detach the field when detaching the object.");
        }
        return objPC.modifiedDependencies;
    }

    private static /* synthetic */ void jdoSetproject(BuildResult objPC, Project project_c) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 8, (Object)objPC.project, (Object)project_c);
            return;
        }
        objPC.project = project_c;
        if (!objPC.jdoIsDetached()) {
            return;
        }
        ((BitSet)objPC.jdoDetachedState[3]).set(8);
    }

    private static /* synthetic */ Project jdoGetproject(BuildResult objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 8)) {
            return (Project)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 8, (Object)objPC.project);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(8)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"project\" yet this field was not detached when you detached the object. Either dont access this field, or detach the field when detaching the object.");
        }
        return objPC.project;
    }

    private static /* synthetic */ void jdoSetscmResult(BuildResult objPC, ScmResult scmResult_m) {
        if (objPC.jdoStateManager == null) {
            objPC.scmResult = scmResult_m;
        } else {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 9, (Object)objPC.scmResult, (Object)scmResult_m);
        }
        if (!objPC.jdoIsDetached()) {
            return;
        }
        ((BitSet)objPC.jdoDetachedState[3]).set(9);
    }

    private static /* synthetic */ ScmResult jdoGetscmResult(BuildResult objPC) {
        if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 9)) {
            return (ScmResult)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 9, (Object)objPC.scmResult);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(9) && !((BitSet)objPC.jdoDetachedState[3]).get(9)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"scmResult\" yet this field was not detached when you detached the object. Either dont access this field, or detach the field when detaching the object.");
        }
        return objPC.scmResult;
    }

    private static /* synthetic */ void jdoSetstartTime(BuildResult objPC, long startTime_c) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setLongField((PersistenceCapable)objPC, 10, objPC.startTime, startTime_c);
            return;
        }
        objPC.startTime = startTime_c;
        if (!objPC.jdoIsDetached()) {
            return;
        }
        ((BitSet)objPC.jdoDetachedState[3]).set(10);
    }

    private static /* synthetic */ long jdoGetstartTime(BuildResult objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 10)) {
            return objPC.jdoStateManager.getLongField((PersistenceCapable)objPC, 10, objPC.startTime);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(10)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"startTime\" yet this field was not detached when you detached the object. Either dont access this field, or detach the field when detaching the object.");
        }
        return objPC.startTime;
    }

    private static /* synthetic */ void jdoSetstate(BuildResult objPC, int state_c) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setIntField((PersistenceCapable)objPC, 11, objPC.state, state_c);
            return;
        }
        objPC.state = state_c;
        if (!objPC.jdoIsDetached()) {
            return;
        }
        ((BitSet)objPC.jdoDetachedState[3]).set(11);
    }

    private static /* synthetic */ int jdoGetstate(BuildResult objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 11)) {
            return objPC.jdoStateManager.getIntField((PersistenceCapable)objPC, 11, objPC.state);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(11)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"state\" yet this field was not detached when you detached the object. Either dont access this field, or detach the field when detaching the object.");
        }
        return objPC.state;
    }

    private static /* synthetic */ void jdoSetsuccess(BuildResult objPC, boolean success_c) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setBooleanField((PersistenceCapable)objPC, 12, objPC.success, success_c);
            return;
        }
        objPC.success = success_c;
        if (!objPC.jdoIsDetached()) {
            return;
        }
        ((BitSet)objPC.jdoDetachedState[3]).set(12);
    }

    private static /* synthetic */ boolean jdoGetsuccess(BuildResult objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 12)) {
            return objPC.jdoStateManager.getBooleanField((PersistenceCapable)objPC, 12, objPC.success);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(12)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"success\" yet this field was not detached when you detached the object. Either dont access this field, or detach the field when detaching the object.");
        }
        return objPC.success;
    }

    private static /* synthetic */ void jdoSettestResult(BuildResult objPC, TestResult testResult_m) {
        if (objPC.jdoStateManager == null) {
            objPC.testResult = testResult_m;
        } else {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 13, (Object)objPC.testResult, (Object)testResult_m);
        }
        if (!objPC.jdoIsDetached()) {
            return;
        }
        ((BitSet)objPC.jdoDetachedState[3]).set(13);
    }

    private static /* synthetic */ TestResult jdoGettestResult(BuildResult objPC) {
        if (objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 13)) {
            return (TestResult)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 13, (Object)objPC.testResult);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(13) && !((BitSet)objPC.jdoDetachedState[3]).get(13)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"testResult\" yet this field was not detached when you detached the object. Either dont access this field, or detach the field when detaching the object.");
        }
        return objPC.testResult;
    }

    private static /* synthetic */ void jdoSettrigger(BuildResult objPC, int trigger_c) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setIntField((PersistenceCapable)objPC, 14, objPC.trigger, trigger_c);
            return;
        }
        objPC.trigger = trigger_c;
        if (!objPC.jdoIsDetached()) {
            return;
        }
        ((BitSet)objPC.jdoDetachedState[3]).set(14);
    }

    private static /* synthetic */ int jdoGettrigger(BuildResult objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 14)) {
            return objPC.jdoStateManager.getIntField((PersistenceCapable)objPC, 14, objPC.trigger);
        }
        if (objPC.jdoIsDetached() && !((BitSet)objPC.jdoDetachedState[2]).get(14)) {
            throw new JDODetachedFieldAccessException("You have just attempted to access field \"trigger\" yet this field was not detached when you detached the object. Either dont access this field, or detach the field when detaching the object.");
        }
        return objPC.trigger;
    }

    public BuildResult() {
        this.id = 0;
        BuildResult.jdoSetbuildNumber(this, 0);
        BuildResult.jdoSetstate(this, 0);
        BuildResult.jdoSettrigger(this, 0);
        BuildResult.jdoSetstartTime(this, 0L);
        BuildResult.jdoSetendTime(this, 0L);
        BuildResult.jdoSetsuccess(this, false);
        BuildResult.jdoSetexitCode(this, 0);
        BuildResult.jdoSetmodelEncoding(this, "UTF-8");
    }
}

