/*
 * $Id$
 */

package org.apache.maven.continuum.model.project.io.stax;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.*;
import org.apache.maven.continuum.model.project.BuildDefinition;
import org.apache.maven.continuum.model.project.BuildResult;
import org.apache.maven.continuum.model.project.ContinuumDatabase;
import org.apache.maven.continuum.model.project.Project;
import org.apache.maven.continuum.model.project.ProjectDependency;
import org.apache.maven.continuum.model.project.ProjectDeveloper;
import org.apache.maven.continuum.model.project.ProjectGroup;
import org.apache.maven.continuum.model.project.ProjectNotifier;
import org.apache.maven.continuum.model.project.Schedule;
import org.apache.maven.continuum.model.scm.ChangeFile;
import org.apache.maven.continuum.model.scm.ChangeSet;
import org.apache.maven.continuum.model.scm.ScmResult;
import org.apache.maven.continuum.model.scm.SuiteResult;
import org.apache.maven.continuum.model.scm.TestCaseFailure;
import org.apache.maven.continuum.model.scm.TestResult;
import org.apache.maven.continuum.model.system.Installation;
import org.apache.maven.continuum.model.system.NotificationAddress;
import org.apache.maven.continuum.model.system.Profile;
import org.apache.maven.continuum.model.system.SystemConfiguration;
import org.apache.maven.continuum.project.ContinuumProjectState;
import org.codehaus.plexus.util.xml.Xpp3Dom;

/**
 * Class ContinuumStaxReader.
 * 
 * @version $Revision$ $Date$
 */
public class ContinuumStaxReader {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field projectGroupInstances
     */
    private java.util.Map projectGroupInstances;

    /**
     * Field projectInstances
     */
    private java.util.Map projectInstances;

    /**
     * Field projectGroupReferences
     */
    private java.util.Map projectGroupReferences;

    /**
     * Field projectReferences
     */
    private java.util.Map projectReferences;

    /**
     * Field buildDefinitionReferences
     */
    private java.util.Map buildDefinitionReferences;

    /**
     * Field buildDefinitionInstances
     */
    private java.util.Map buildDefinitionInstances;

    /**
     * Field scheduleReferences
     */
    private java.util.Map scheduleReferences;

    /**
     * Field profileReferences
     */
    private java.util.Map profileReferences;

    /**
     * Field scheduleInstances
     */
    private java.util.Map scheduleInstances;

    /**
     * Field profileInstances
     */
    private java.util.Map profileInstances;

    /**
     * Field installationReferences
     */
    private java.util.Map installationReferences;

    /**
     * Field installationInstances
     */
    private java.util.Map installationInstances;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method buildDom
     * 
     * @param xmlStreamReader
     */
    public Xpp3Dom buildDom(XMLStreamReader xmlStreamReader)
        throws XMLStreamException
    {
        java.util.List elements = new java.util.ArrayList();
        java.util.List values = new java.util.ArrayList();
        int eventType = xmlStreamReader.getEventType();
        while ( xmlStreamReader.hasNext() )
        {
            if ( eventType == XMLStreamConstants.START_ELEMENT )
            {
                String rawName = xmlStreamReader.getLocalName();
                Xpp3Dom childConfiguration = new Xpp3Dom( rawName );
                int depth = elements.size();
                if ( depth > 0 )
                {
                    Xpp3Dom parent = (Xpp3Dom) elements.get( depth - 1 );
                    parent.addChild( childConfiguration );
                }
                elements.add( childConfiguration );
                if ( xmlStreamReader.isEndElement() )
                {
                    values.add( null );
                }
                else
                {
                    values.add( new StringBuffer() );
                }
                int attributesSize = xmlStreamReader.getAttributeCount();
                for ( int i = 0; i < attributesSize; i++ )
                {
                    String name = xmlStreamReader.getAttributeLocalName( i );
                    String value = xmlStreamReader.getAttributeValue( i );
                    childConfiguration.setAttribute( name, value );
                }
            }
            else if ( eventType == XMLStreamConstants.CHARACTERS )
            {
                int depth = values.size() - 1;
                StringBuffer valueBuffer = (StringBuffer) values.get( depth );
                String text = xmlStreamReader.getText();
                text = text.trim();
                valueBuffer.append( text );
            }
            else if ( eventType == XMLStreamConstants.END_ELEMENT )
            {
                int depth = elements.size() - 1;
                Xpp3Dom finishedConfiguration = (Xpp3Dom) elements.remove( depth );
                // this Object could be null if it is a singleton tag
                Object accumulatedValue = values.remove( depth );
                if ( finishedConfiguration.getChildCount() == 0 )
                {
                    if ( accumulatedValue == null )
                    {
                        finishedConfiguration.setValue( null );
                    }
                    else
                    {
                        finishedConfiguration.setValue( accumulatedValue.toString() );
                    }
                }
                if ( depth == 0 )
                {
                    return finishedConfiguration;
                }
            }
            eventType = xmlStreamReader.next();
        }
        throw new IllegalStateException( "End of document found before returning to 0 depth" );
    } //-- Xpp3Dom buildDom(XMLStreamReader) 

    /**
     * Method getBooleanValue
     * 
     * @param s
     * @param xmlStreamReader
     * @param attribute
     */
    public boolean getBooleanValue(String s, String attribute, XMLStreamReader xmlStreamReader)
        throws XMLStreamException
    {
        if ( s != null )
        {
            return Boolean.valueOf( s ).booleanValue();
        }
        return false;
    } //-- boolean getBooleanValue(String, String, XMLStreamReader) 

    /**
     * Method getCharacterValue
     * 
     * @param s
     * @param xmlStreamReader
     * @param attribute
     */
    public char getCharacterValue(String s, String attribute, XMLStreamReader xmlStreamReader)
        throws XMLStreamException
    {
        if ( s != null )
        {
            return s.charAt( 0 );
        }
        return 0;
    } //-- char getCharacterValue(String, String, XMLStreamReader) 

    /**
     * Method getDateValue
     * 
     * @param s
     * @param xmlStreamReader
     * @param dateFormat
     * @param attribute
     */
    public java.util.Date getDateValue(String s, String attribute, String dateFormat, XMLStreamReader xmlStreamReader)
        throws XMLStreamException
    {
        if ( s != null )
        {
            if ( dateFormat == null )
            {
                return new java.util.Date( Long.valueOf( s ).longValue() );
            }
            else
            {
                DateFormat dateParser = new java.text.SimpleDateFormat( dateFormat, Locale.US );
                try
                {
                    return dateParser.parse( s );
                }
                catch ( java.text.ParseException e )
                {
                    throw new XMLStreamException( e.getMessage() );
                }
            }
        }
        return null;
    } //-- java.util.Date getDateValue(String, String, String, XMLStreamReader) 

    /**
     * Method getDoubleValue
     * 
     * @param s
     * @param strict
     * @param xmlStreamReader
     * @param attribute
     */
    public double getDoubleValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict)
        throws XMLStreamException
    {
        if ( s != null )
        {
            try
            {
                return Double.valueOf( s ).doubleValue();
            }
            catch ( NumberFormatException e )
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unable to parse element '" + attribute + "', must be a floating point number but was '" + s + "'", xmlStreamReader.getLocation() );
                }
            }
        }
        return 0;
    } //-- double getDoubleValue(String, String, XMLStreamReader, boolean) 

    /**
     * Method getFloatValue
     * 
     * @param s
     * @param strict
     * @param xmlStreamReader
     * @param attribute
     */
    public float getFloatValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict)
        throws XMLStreamException
    {
        if ( s != null )
        {
            try
            {
                return Float.valueOf( s ).floatValue();
            }
            catch ( NumberFormatException e )
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unable to parse element '" + attribute + "', must be a floating point number but was '" + s + "'", xmlStreamReader.getLocation() );
                }
            }
        }
        return 0;
    } //-- float getFloatValue(String, String, XMLStreamReader, boolean) 

    /**
     * Method getIntegerValue
     * 
     * @param s
     * @param strict
     * @param xmlStreamReader
     * @param attribute
     */
    public int getIntegerValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict)
        throws XMLStreamException
    {
        if ( s != null )
        {
            try
            {
                return Integer.valueOf( s ).intValue();
            }
            catch ( NumberFormatException e )
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unable to parse element '" + attribute + "', must be an integer but was '" + s + "'", xmlStreamReader.getLocation() );
                }
            }
        }
        return 0;
    } //-- int getIntegerValue(String, String, XMLStreamReader, boolean) 

    /**
     * Method getLongValue
     * 
     * @param s
     * @param strict
     * @param xmlStreamReader
     * @param attribute
     */
    public long getLongValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict)
        throws XMLStreamException
    {
        if ( s != null )
        {
            try
            {
                return Long.valueOf( s ).longValue();
            }
            catch ( NumberFormatException e )
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unable to parse element '" + attribute + "', must be a long integer but was '" + s + "'", xmlStreamReader.getLocation() );
                }
            }
        }
        return 0;
    } //-- long getLongValue(String, String, XMLStreamReader, boolean) 

    /**
     * Method getRequiredAttributeValue
     * 
     * @param s
     * @param strict
     * @param xmlStreamReader
     * @param attribute
     */
    public String getRequiredAttributeValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict)
        throws XMLStreamException
    {
        if ( s == null )
        {
            if ( strict )
            {
                throw new XMLStreamException( "Missing required value for attribute '" + attribute + "'", xmlStreamReader.getLocation() );
            }
        }
        return s;
    } //-- String getRequiredAttributeValue(String, String, XMLStreamReader, boolean) 

    /**
     * Method getShortValue
     * 
     * @param s
     * @param strict
     * @param xmlStreamReader
     * @param attribute
     */
    public short getShortValue(String s, String attribute, XMLStreamReader xmlStreamReader, boolean strict)
        throws XMLStreamException
    {
        if ( s != null )
        {
            try
            {
                return Short.valueOf( s ).shortValue();
            }
            catch ( NumberFormatException e )
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unable to parse element '" + attribute + "', must be a short integer but was '" + s + "'", xmlStreamReader.getLocation() );
                }
            }
        }
        return 0;
    } //-- short getShortValue(String, String, XMLStreamReader, boolean) 

    /**
     * Method getTrimmedValue
     * 
     * @param s
     */
    public String getTrimmedValue(String s)
    {
        if ( s != null )
        {
            s = s.trim();
        }
        return s;
    } //-- String getTrimmedValue(String) 

    /**
     * Method parseBuildDefinition
     * 
     * @param tagName
     * @param encoding
     * @param strict
     * @param xmlStreamReader
     */
    private BuildDefinition parseBuildDefinition(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding)
        throws IOException, XMLStreamException
    {
        BuildDefinition buildDefinition = new BuildDefinition();
        buildDefinition.setModelEncoding( encoding );
        java.util.Set parsed = new java.util.HashSet();
        if ( buildDefinitionInstances == null )
        {
            buildDefinitionInstances = new java.util.HashMap();
        }
        String v = xmlStreamReader.getAttributeValue( null, "modello.id" );
        if ( v != null )
        {
            buildDefinitionInstances.put( v, buildDefinition);
        }
        while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
        {
            if ( xmlStreamReader.getLocalName().equals( "id" )  )
            {
                if ( parsed.contains( "id" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "id" );
                buildDefinition.setId( getIntegerValue( getTrimmedValue( xmlStreamReader.getElementText()), "id", xmlStreamReader, strict ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "defaultForProject" )  )
            {
                if ( parsed.contains( "defaultForProject" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "defaultForProject" );
                buildDefinition.setDefaultForProject( getBooleanValue( getTrimmedValue( xmlStreamReader.getElementText()), "defaultForProject", xmlStreamReader ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "goals" )  )
            {
                if ( parsed.contains( "goals" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "goals" );
                buildDefinition.setGoals( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "arguments" )  )
            {
                if ( parsed.contains( "arguments" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "arguments" );
                buildDefinition.setArguments( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "buildFile" )  )
            {
                if ( parsed.contains( "buildFile" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "buildFile" );
                buildDefinition.setBuildFile( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "buildFresh" )  )
            {
                if ( parsed.contains( "buildFresh" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "buildFresh" );
                buildDefinition.setBuildFresh( getBooleanValue( getTrimmedValue( xmlStreamReader.getElementText()), "buildFresh", xmlStreamReader ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "schedule" )  )
            {
                if ( parsed.contains( "schedule" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "schedule" );
                String value = xmlStreamReader.getAttributeValue( null, "id" );
                if ( value != null )
                {
                    // This is a reference to an element elsewhere in the model
                    if ( scheduleReferences == null )
                    {
                        scheduleReferences = new java.util.HashMap();
                    }
                    java.util.Map refs = (java.util.Map) scheduleReferences.get( buildDefinition );
                    if ( refs == null )
                    {
                        refs = new java.util.HashMap();
                        scheduleReferences.put( buildDefinition, refs );
                    }
                    refs.put( "schedule", value );
                }
                while ( xmlStreamReader.getEventType() != XMLStreamConstants.END_ELEMENT )
                {
                    xmlStreamReader.next();
                }
            }
            else if ( xmlStreamReader.getLocalName().equals( "profile" )  )
            {
                if ( parsed.contains( "profile" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "profile" );
                String value = xmlStreamReader.getAttributeValue( null, "id" );
                if ( value != null )
                {
                    // This is a reference to an element elsewhere in the model
                    if ( profileReferences == null )
                    {
                        profileReferences = new java.util.HashMap();
                    }
                    java.util.Map refs = (java.util.Map) profileReferences.get( buildDefinition );
                    if ( refs == null )
                    {
                        refs = new java.util.HashMap();
                        profileReferences.put( buildDefinition, refs );
                    }
                    refs.put( "profile", value );
                }
                while ( xmlStreamReader.getEventType() != XMLStreamConstants.END_ELEMENT )
                {
                    xmlStreamReader.next();
                }
            }
            else
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
            }
        }
        buildDefinitionInstances.put( String.valueOf( buildDefinition.getId() ), buildDefinition);
        return buildDefinition;
    } //-- BuildDefinition parseBuildDefinition(String, XMLStreamReader, boolean, String) 

    /**
     * Method parseBuildResult
     * 
     * @param tagName
     * @param encoding
     * @param strict
     * @param xmlStreamReader
     */
    private BuildResult parseBuildResult(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding)
        throws IOException, XMLStreamException
    {
        BuildResult buildResult = new BuildResult();
        buildResult.setModelEncoding( encoding );
        java.util.Set parsed = new java.util.HashSet();
        while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
        {
            if ( xmlStreamReader.getLocalName().equals( "project" )  )
            {
                if ( parsed.contains( "project" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "project" );
                String value = xmlStreamReader.getAttributeValue( null, "id" );
                if ( value != null )
                {
                    // This is a reference to an element elsewhere in the model
                    if ( projectReferences == null )
                    {
                        projectReferences = new java.util.HashMap();
                    }
                    java.util.Map refs = (java.util.Map) projectReferences.get( buildResult );
                    if ( refs == null )
                    {
                        refs = new java.util.HashMap();
                        projectReferences.put( buildResult, refs );
                    }
                    refs.put( "project", value );
                }
                while ( xmlStreamReader.getEventType() != XMLStreamConstants.END_ELEMENT )
                {
                    xmlStreamReader.next();
                }
            }
            else if ( xmlStreamReader.getLocalName().equals( "buildDefinition" )  )
            {
                if ( parsed.contains( "buildDefinition" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "buildDefinition" );
                String value = xmlStreamReader.getAttributeValue( null, "id" );
                if ( value != null )
                {
                    // This is a reference to an element elsewhere in the model
                    if ( buildDefinitionReferences == null )
                    {
                        buildDefinitionReferences = new java.util.HashMap();
                    }
                    java.util.Map refs = (java.util.Map) buildDefinitionReferences.get( buildResult );
                    if ( refs == null )
                    {
                        refs = new java.util.HashMap();
                        buildDefinitionReferences.put( buildResult, refs );
                    }
                    refs.put( "buildDefinition", value );
                }
                while ( xmlStreamReader.getEventType() != XMLStreamConstants.END_ELEMENT )
                {
                    xmlStreamReader.next();
                }
            }
            else if ( xmlStreamReader.getLocalName().equals( "id" )  )
            {
                if ( parsed.contains( "id" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "id" );
                buildResult.setId( getIntegerValue( getTrimmedValue( xmlStreamReader.getElementText()), "id", xmlStreamReader, strict ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "buildNumber" )  )
            {
                if ( parsed.contains( "buildNumber" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "buildNumber" );
                buildResult.setBuildNumber( getIntegerValue( getTrimmedValue( xmlStreamReader.getElementText()), "buildNumber", xmlStreamReader, strict ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "state" )  )
            {
                if ( parsed.contains( "state" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "state" );
                buildResult.setState( getIntegerValue( getTrimmedValue( xmlStreamReader.getElementText()), "state", xmlStreamReader, strict ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "trigger" )  )
            {
                if ( parsed.contains( "trigger" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "trigger" );
                buildResult.setTrigger( getIntegerValue( getTrimmedValue( xmlStreamReader.getElementText()), "trigger", xmlStreamReader, strict ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "startTime" )  )
            {
                if ( parsed.contains( "startTime" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "startTime" );
                buildResult.setStartTime( getLongValue( getTrimmedValue( xmlStreamReader.getElementText()), "startTime", xmlStreamReader, strict ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "endTime" )  )
            {
                if ( parsed.contains( "endTime" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "endTime" );
                buildResult.setEndTime( getLongValue( getTrimmedValue( xmlStreamReader.getElementText()), "endTime", xmlStreamReader, strict ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "error" )  )
            {
                if ( parsed.contains( "error" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "error" );
                buildResult.setError( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "success" )  )
            {
                if ( parsed.contains( "success" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "success" );
                buildResult.setSuccess( getBooleanValue( getTrimmedValue( xmlStreamReader.getElementText()), "success", xmlStreamReader ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "exitCode" )  )
            {
                if ( parsed.contains( "exitCode" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "exitCode" );
                buildResult.setExitCode( getIntegerValue( getTrimmedValue( xmlStreamReader.getElementText()), "exitCode", xmlStreamReader, strict ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "scmResult" )  )
            {
                if ( parsed.contains( "scmResult" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "scmResult" );
                buildResult.setScmResult( parseScmResult( "scmResult", xmlStreamReader, strict, encoding ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "testResult" )  )
            {
                if ( parsed.contains( "testResult" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "testResult" );
                buildResult.setTestResult( parseTestResult( "testResult", xmlStreamReader, strict, encoding ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "modifiedDependencies" )  )
            {
                if ( parsed.contains( "modifiedDependencies" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "modifiedDependencies" );
                java.util.List modifiedDependencies = new java.util.ArrayList();
                buildResult.setModifiedDependencies( modifiedDependencies );
                while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
                {
                    if ( xmlStreamReader.getLocalName().equals( "modifiedDependency" ) )
                    {
                        buildResult.addModifiedDependency( parseProjectDependency( "modifiedDependency", xmlStreamReader, strict, encoding ) );
                    }
                    else
                    {
                        throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                    }
                }
            }
            else
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
            }
        }
        return buildResult;
    } //-- BuildResult parseBuildResult(String, XMLStreamReader, boolean, String) 

    /**
     * Method parseChangeFile
     * 
     * @param tagName
     * @param encoding
     * @param strict
     * @param xmlStreamReader
     */
    private ChangeFile parseChangeFile(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding)
        throws IOException, XMLStreamException
    {
        ChangeFile changeFile = new ChangeFile();
        changeFile.setModelEncoding( encoding );
        java.util.Set parsed = new java.util.HashSet();
        while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
        {
            if ( xmlStreamReader.getLocalName().equals( "name" )  )
            {
                if ( parsed.contains( "name" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "name" );
                changeFile.setName( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "revision" )  )
            {
                if ( parsed.contains( "revision" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "revision" );
                changeFile.setRevision( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "status" )  )
            {
                if ( parsed.contains( "status" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "status" );
                changeFile.setStatus( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
            }
        }
        return changeFile;
    } //-- ChangeFile parseChangeFile(String, XMLStreamReader, boolean, String) 

    /**
     * Method parseChangeSet
     * 
     * @param tagName
     * @param encoding
     * @param strict
     * @param xmlStreamReader
     */
    private ChangeSet parseChangeSet(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding)
        throws IOException, XMLStreamException
    {
        ChangeSet changeSet = new ChangeSet();
        changeSet.setModelEncoding( encoding );
        java.util.Set parsed = new java.util.HashSet();
        while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
        {
            if ( xmlStreamReader.getLocalName().equals( "id" )  )
            {
                if ( parsed.contains( "id" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "id" );
                changeSet.setId( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "author" )  )
            {
                if ( parsed.contains( "author" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "author" );
                changeSet.setAuthor( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "comment" )  )
            {
                if ( parsed.contains( "comment" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "comment" );
                changeSet.setComment( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "date" )  )
            {
                if ( parsed.contains( "date" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "date" );
                changeSet.setDate( getLongValue( getTrimmedValue( xmlStreamReader.getElementText()), "date", xmlStreamReader, strict ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "files" )  )
            {
                if ( parsed.contains( "files" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "files" );
                java.util.List files = new java.util.ArrayList();
                changeSet.setFiles( files );
                while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
                {
                    if ( xmlStreamReader.getLocalName().equals( "file" ) )
                    {
                        changeSet.addFile( parseChangeFile( "file", xmlStreamReader, strict, encoding ) );
                    }
                    else
                    {
                        throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                    }
                }
            }
            else
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
            }
        }
        return changeSet;
    } //-- ChangeSet parseChangeSet(String, XMLStreamReader, boolean, String) 

    /**
     * Method parseContinuumDatabase
     * 
     * @param tagName
     * @param encoding
     * @param strict
     * @param xmlStreamReader
     */
    private ContinuumDatabase parseContinuumDatabase(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding)
        throws IOException, XMLStreamException
    {
        ContinuumDatabase continuumDatabase = new ContinuumDatabase();
        continuumDatabase.setModelEncoding( encoding );
        java.util.Set parsed = new java.util.HashSet();
        boolean foundRoot = false;
        while ( xmlStreamReader.hasNext() )
        {
            int eventType = xmlStreamReader.next();
            if ( eventType == XMLStreamConstants.START_ELEMENT )
            {
                if ( xmlStreamReader.getLocalName().equals( tagName ) )
                {
                    foundRoot = true;
                }
                else if ( xmlStreamReader.getLocalName().equals( "projectGroups" )  )
                {
                    if ( parsed.contains( "projectGroups" ) )
                    {
                        throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                    }
                    parsed.add( "projectGroups" );
                    java.util.List projectGroups = new java.util.ArrayList();
                    continuumDatabase.setProjectGroups( projectGroups );
                    while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
                    {
                        if ( xmlStreamReader.getLocalName().equals( "projectGroup" ) )
                        {
                            continuumDatabase.addProjectGroup( parseProjectGroup( "projectGroup", xmlStreamReader, strict, encoding ) );
                        }
                        else
                        {
                            throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                        }
                    }
                }
                else if ( xmlStreamReader.getLocalName().equals( "systemConfiguration" )  )
                {
                    if ( parsed.contains( "systemConfiguration" ) )
                    {
                        throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                    }
                    parsed.add( "systemConfiguration" );
                    continuumDatabase.setSystemConfiguration( parseSystemConfiguration( "systemConfiguration", xmlStreamReader, strict, encoding ) );
                }
                else if ( xmlStreamReader.getLocalName().equals( "installations" )  )
                {
                    if ( parsed.contains( "installations" ) )
                    {
                        throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                    }
                    parsed.add( "installations" );
                    java.util.List installations = new java.util.ArrayList();
                    continuumDatabase.setInstallations( installations );
                    while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
                    {
                        if ( xmlStreamReader.getLocalName().equals( "installation" ) )
                        {
                            continuumDatabase.addInstallation( parseInstallation( "installation", xmlStreamReader, strict, encoding ) );
                        }
                        else
                        {
                            throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                        }
                    }
                }
                else if ( xmlStreamReader.getLocalName().equals( "schedules" )  )
                {
                    if ( parsed.contains( "schedules" ) )
                    {
                        throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                    }
                    parsed.add( "schedules" );
                    java.util.List schedules = new java.util.ArrayList();
                    continuumDatabase.setSchedules( schedules );
                    while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
                    {
                        if ( xmlStreamReader.getLocalName().equals( "schedule" ) )
                        {
                            continuumDatabase.addSchedule( parseSchedule( "schedule", xmlStreamReader, strict, encoding ) );
                        }
                        else
                        {
                            throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                        }
                    }
                }
                else if ( xmlStreamReader.getLocalName().equals( "profiles" )  )
                {
                    if ( parsed.contains( "profiles" ) )
                    {
                        throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                    }
                    parsed.add( "profiles" );
                    java.util.List profiles = new java.util.ArrayList();
                    continuumDatabase.setProfiles( profiles );
                    while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
                    {
                        if ( xmlStreamReader.getLocalName().equals( "profile" ) )
                        {
                            continuumDatabase.addProfile( parseProfile( "profile", xmlStreamReader, strict, encoding ) );
                        }
                        else
                        {
                            throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                        }
                    }
                }
                else
                {
                    if ( foundRoot )
                    {
                        if ( strict )
                        {
                            throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                        }
                    }
                }
            }
        }
        return continuumDatabase;
    } //-- ContinuumDatabase parseContinuumDatabase(String, XMLStreamReader, boolean, String) 

    /**
     * Method parseContinuumProjectState
     * 
     * @param tagName
     * @param encoding
     * @param strict
     * @param xmlStreamReader
     */
    private ContinuumProjectState parseContinuumProjectState(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding)
        throws IOException, XMLStreamException
    {
        ContinuumProjectState continuumProjectState = new ContinuumProjectState();
        continuumProjectState.setModelEncoding( encoding );
        java.util.Set parsed = new java.util.HashSet();
        while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
        {
            if ( xmlStreamReader.getLocalName().equals( "name" )  )
            {
                if ( parsed.contains( "name" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "name" );
                continuumProjectState.setName( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
            }
        }
        return continuumProjectState;
    } //-- ContinuumProjectState parseContinuumProjectState(String, XMLStreamReader, boolean, String) 

    /**
     * Method parseInstallation
     * 
     * @param tagName
     * @param encoding
     * @param strict
     * @param xmlStreamReader
     */
    private Installation parseInstallation(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding)
        throws IOException, XMLStreamException
    {
        Installation installation = new Installation();
        installation.setModelEncoding( encoding );
        java.util.Set parsed = new java.util.HashSet();
        if ( installationInstances == null )
        {
            installationInstances = new java.util.HashMap();
        }
        String v = xmlStreamReader.getAttributeValue( null, "modello.id" );
        if ( v != null )
        {
            installationInstances.put( v, installation);
        }
        while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
        {
            if ( xmlStreamReader.getLocalName().equals( "type" )  )
            {
                if ( parsed.contains( "type" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "type" );
                installation.setType( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "varValue" )  )
            {
                if ( parsed.contains( "varValue" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "varValue" );
                installation.setVarValue( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "varName" )  )
            {
                if ( parsed.contains( "varName" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "varName" );
                installation.setVarName( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "name" )  )
            {
                if ( parsed.contains( "name" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "name" );
                installation.setName( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
            }
        }
        installationInstances.put( installation.getName(), installation);
        return installation;
    } //-- Installation parseInstallation(String, XMLStreamReader, boolean, String) 

    /**
     * Method parseNotificationAddress
     * 
     * @param tagName
     * @param encoding
     * @param strict
     * @param xmlStreamReader
     */
    private NotificationAddress parseNotificationAddress(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding)
        throws IOException, XMLStreamException
    {
        NotificationAddress notificationAddress = new NotificationAddress();
        notificationAddress.setModelEncoding( encoding );
        java.util.Set parsed = new java.util.HashSet();
        while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
        {
            if ( xmlStreamReader.getLocalName().equals( "type" )  )
            {
                if ( parsed.contains( "type" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "type" );
                notificationAddress.setType( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "address" )  )
            {
                if ( parsed.contains( "address" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "address" );
                notificationAddress.setAddress( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "configuration" )  )
            {
                if ( parsed.contains( "configuration" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "configuration" );
                while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
                {
                    String key = xmlStreamReader.getLocalName();
                    String value = xmlStreamReader.getElementText()
                    .trim()
                    ;
                    notificationAddress.addConfiguration( key, value );
                }
            }
            else
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
            }
        }
        return notificationAddress;
    } //-- NotificationAddress parseNotificationAddress(String, XMLStreamReader, boolean, String) 

    /**
     * Method parseProfile
     * 
     * @param tagName
     * @param encoding
     * @param strict
     * @param xmlStreamReader
     */
    private Profile parseProfile(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding)
        throws IOException, XMLStreamException
    {
        Profile profile = new Profile();
        profile.setModelEncoding( encoding );
        java.util.Set parsed = new java.util.HashSet();
        if ( profileInstances == null )
        {
            profileInstances = new java.util.HashMap();
        }
        String v = xmlStreamReader.getAttributeValue( null, "modello.id" );
        if ( v != null )
        {
            profileInstances.put( v, profile);
        }
        while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
        {
            if ( xmlStreamReader.getLocalName().equals( "id" )  )
            {
                if ( parsed.contains( "id" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "id" );
                profile.setId( getIntegerValue( getTrimmedValue( xmlStreamReader.getElementText()), "id", xmlStreamReader, strict ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "active" )  )
            {
                if ( parsed.contains( "active" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "active" );
                profile.setActive( getBooleanValue( getTrimmedValue( xmlStreamReader.getElementText()), "active", xmlStreamReader ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "name" )  )
            {
                if ( parsed.contains( "name" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "name" );
                profile.setName( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "description" )  )
            {
                if ( parsed.contains( "description" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "description" );
                profile.setDescription( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "scmMode" )  )
            {
                if ( parsed.contains( "scmMode" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "scmMode" );
                profile.setScmMode( getIntegerValue( getTrimmedValue( xmlStreamReader.getElementText()), "scmMode", xmlStreamReader, strict ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "buildWithoutChanges" )  )
            {
                if ( parsed.contains( "buildWithoutChanges" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "buildWithoutChanges" );
                profile.setBuildWithoutChanges( getBooleanValue( getTrimmedValue( xmlStreamReader.getElementText()), "buildWithoutChanges", xmlStreamReader ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "jdk" )  )
            {
                if ( parsed.contains( "jdk" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "jdk" );
                String value = xmlStreamReader.getAttributeValue( null, "name" );
                if ( value != null )
                {
                    // This is a reference to an element elsewhere in the model
                    if ( installationReferences == null )
                    {
                        installationReferences = new java.util.HashMap();
                    }
                    java.util.Map refs = (java.util.Map) installationReferences.get( profile );
                    if ( refs == null )
                    {
                        refs = new java.util.HashMap();
                        installationReferences.put( profile, refs );
                    }
                    refs.put( "jdk", value );
                }
                while ( xmlStreamReader.getEventType() != XMLStreamConstants.END_ELEMENT )
                {
                    xmlStreamReader.next();
                }
            }
            else if ( xmlStreamReader.getLocalName().equals( "builder" )  )
            {
                if ( parsed.contains( "builder" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "builder" );
                String value = xmlStreamReader.getAttributeValue( null, "name" );
                if ( value != null )
                {
                    // This is a reference to an element elsewhere in the model
                    if ( installationReferences == null )
                    {
                        installationReferences = new java.util.HashMap();
                    }
                    java.util.Map refs = (java.util.Map) installationReferences.get( profile );
                    if ( refs == null )
                    {
                        refs = new java.util.HashMap();
                        installationReferences.put( profile, refs );
                    }
                    refs.put( "builder", value );
                }
                while ( xmlStreamReader.getEventType() != XMLStreamConstants.END_ELEMENT )
                {
                    xmlStreamReader.next();
                }
            }
            else if ( xmlStreamReader.getLocalName().equals( "environmentVariables" )  )
            {
                if ( parsed.contains( "environmentVariables" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "environmentVariables" );
                java.util.List environmentVariables = new java.util.ArrayList();
                profile.setEnvironmentVariables( environmentVariables );
                while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
                {
                    if ( xmlStreamReader.getLocalName().equals( "environmentVariable" ) )
                    {
                        String value = xmlStreamReader.getAttributeValue( null, "name" );
                        if ( value != null )
                        {
                            // This is a reference to an element elsewhere in the model
                            if ( installationReferences == null )
                            {
                                installationReferences = new java.util.HashMap();
                            }
                            java.util.Map refs = (java.util.Map) installationReferences.get( profile );
                            if ( refs == null )
                            {
                                refs = new java.util.HashMap();
                                installationReferences.put( profile, refs );
                            }
                            refs.put( "environmentVariables." + environmentVariables.size(), value );
                        }
                        profile.addEnvironmentVariable( parseInstallation( "environmentVariable", xmlStreamReader, strict, encoding ) );
                    }
                    else
                    {
                        throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                    }
                }
            }
            else
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
            }
        }
        profileInstances.put( String.valueOf( profile.getId() ), profile);
        return profile;
    } //-- Profile parseProfile(String, XMLStreamReader, boolean, String) 

    /**
     * Method parseProject
     * 
     * @param tagName
     * @param encoding
     * @param strict
     * @param xmlStreamReader
     */
    private Project parseProject(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding)
        throws IOException, XMLStreamException
    {
        Project project = new Project();
        project.setModelEncoding( encoding );
        java.util.Set parsed = new java.util.HashSet();
        if ( projectInstances == null )
        {
            projectInstances = new java.util.HashMap();
        }
        String v = xmlStreamReader.getAttributeValue( null, "modello.id" );
        if ( v != null )
        {
            projectInstances.put( v, project);
        }
        while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
        {
            if ( xmlStreamReader.getLocalName().equals( "id" )  )
            {
                if ( parsed.contains( "id" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "id" );
                project.setId( getIntegerValue( getTrimmedValue( xmlStreamReader.getElementText()), "id", xmlStreamReader, strict ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "groupId" )  )
            {
                if ( parsed.contains( "groupId" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "groupId" );
                project.setGroupId( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "artifactId" )  )
            {
                if ( parsed.contains( "artifactId" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "artifactId" );
                project.setArtifactId( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "executorId" )  )
            {
                if ( parsed.contains( "executorId" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "executorId" );
                project.setExecutorId( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "name" )  )
            {
                if ( parsed.contains( "name" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "name" );
                project.setName( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "description" )  )
            {
                if ( parsed.contains( "description" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "description" );
                project.setDescription( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "url" )  )
            {
                if ( parsed.contains( "url" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "url" );
                project.setUrl( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "scmUrl" )  )
            {
                if ( parsed.contains( "scmUrl" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "scmUrl" );
                project.setScmUrl( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "scmTag" )  )
            {
                if ( parsed.contains( "scmTag" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "scmTag" );
                project.setScmTag( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "scmUsername" )  )
            {
                if ( parsed.contains( "scmUsername" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "scmUsername" );
                project.setScmUsername( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "scmPassword" )  )
            {
                if ( parsed.contains( "scmPassword" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "scmPassword" );
                project.setScmPassword( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "scmUseCache" )  )
            {
                if ( parsed.contains( "scmUseCache" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "scmUseCache" );
                project.setScmUseCache( getBooleanValue( getTrimmedValue( xmlStreamReader.getElementText()), "scmUseCache", xmlStreamReader ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "version" )  )
            {
                if ( parsed.contains( "version" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "version" );
                project.setVersion( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "state" )  )
            {
                if ( parsed.contains( "state" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "state" );
                project.setState( getIntegerValue( getTrimmedValue( xmlStreamReader.getElementText()), "state", xmlStreamReader, strict ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "oldState" )  )
            {
                if ( parsed.contains( "oldState" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "oldState" );
                project.setOldState( getIntegerValue( getTrimmedValue( xmlStreamReader.getElementText()), "oldState", xmlStreamReader, strict ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "latestBuildId" )  )
            {
                if ( parsed.contains( "latestBuildId" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "latestBuildId" );
                project.setLatestBuildId( getIntegerValue( getTrimmedValue( xmlStreamReader.getElementText()), "latestBuildId", xmlStreamReader, strict ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "buildNumber" )  )
            {
                if ( parsed.contains( "buildNumber" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "buildNumber" );
                project.setBuildNumber( getIntegerValue( getTrimmedValue( xmlStreamReader.getElementText()), "buildNumber", xmlStreamReader, strict ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "workingDirectory" )  )
            {
                if ( parsed.contains( "workingDirectory" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "workingDirectory" );
                project.setWorkingDirectory( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "buildResults" )  )
            {
                if ( parsed.contains( "buildResults" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "buildResults" );
                java.util.List buildResults = new java.util.ArrayList();
                project.setBuildResults( buildResults );
                while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
                {
                    if ( xmlStreamReader.getLocalName().equals( "buildResult" ) )
                    {
                        project.addBuildResult( parseBuildResult( "buildResult", xmlStreamReader, strict, encoding ) );
                    }
                    else
                    {
                        throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                    }
                }
            }
            else if ( xmlStreamReader.getLocalName().equals( "checkoutResult" )  )
            {
                if ( parsed.contains( "checkoutResult" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "checkoutResult" );
                project.setCheckoutResult( parseScmResult( "checkoutResult", xmlStreamReader, strict, encoding ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "developers" )  )
            {
                if ( parsed.contains( "developers" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "developers" );
                java.util.List developers = new java.util.ArrayList();
                project.setDevelopers( developers );
                while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
                {
                    if ( xmlStreamReader.getLocalName().equals( "developer" ) )
                    {
                        project.addDeveloper( parseProjectDeveloper( "developer", xmlStreamReader, strict, encoding ) );
                    }
                    else
                    {
                        throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                    }
                }
            }
            else if ( xmlStreamReader.getLocalName().equals( "parent" )  )
            {
                if ( parsed.contains( "parent" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "parent" );
                project.setParent( parseProjectDependency( "parent", xmlStreamReader, strict, encoding ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "dependencies" )  )
            {
                if ( parsed.contains( "dependencies" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "dependencies" );
                java.util.List dependencies = new java.util.ArrayList();
                project.setDependencies( dependencies );
                while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
                {
                    if ( xmlStreamReader.getLocalName().equals( "dependency" ) )
                    {
                        project.addDependency( parseProjectDependency( "dependency", xmlStreamReader, strict, encoding ) );
                    }
                    else
                    {
                        throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                    }
                }
            }
            else if ( xmlStreamReader.getLocalName().equals( "projectGroup" )  )
            {
                if ( parsed.contains( "projectGroup" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "projectGroup" );
                String value = xmlStreamReader.getAttributeValue( null, "id" );
                if ( value != null )
                {
                    // This is a reference to an element elsewhere in the model
                    if ( projectGroupReferences == null )
                    {
                        projectGroupReferences = new java.util.HashMap();
                    }
                    java.util.Map refs = (java.util.Map) projectGroupReferences.get( project );
                    if ( refs == null )
                    {
                        refs = new java.util.HashMap();
                        projectGroupReferences.put( project, refs );
                    }
                    refs.put( "projectGroup", value );
                }
                while ( xmlStreamReader.getEventType() != XMLStreamConstants.END_ELEMENT )
                {
                    xmlStreamReader.next();
                }
            }
            else if ( xmlStreamReader.getLocalName().equals( "notifiers" )  )
            {
                if ( parsed.contains( "notifiers" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "notifiers" );
                java.util.List notifiers = new java.util.ArrayList();
                project.setNotifiers( notifiers );
                while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
                {
                    if ( xmlStreamReader.getLocalName().equals( "notifier" ) )
                    {
                        project.addNotifier( parseProjectNotifier( "notifier", xmlStreamReader, strict, encoding ) );
                    }
                    else
                    {
                        throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                    }
                }
            }
            else if ( xmlStreamReader.getLocalName().equals( "buildDefinitions" )  )
            {
                if ( parsed.contains( "buildDefinitions" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "buildDefinitions" );
                java.util.List buildDefinitions = new java.util.ArrayList();
                project.setBuildDefinitions( buildDefinitions );
                while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
                {
                    if ( xmlStreamReader.getLocalName().equals( "buildDefinition" ) )
                    {
                        project.addBuildDefinition( parseBuildDefinition( "buildDefinition", xmlStreamReader, strict, encoding ) );
                    }
                    else
                    {
                        throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                    }
                }
            }
            else
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
            }
        }
        projectInstances.put( String.valueOf( project.getId() ), project);
        return project;
    } //-- Project parseProject(String, XMLStreamReader, boolean, String) 

    /**
     * Method parseProjectDependency
     * 
     * @param tagName
     * @param encoding
     * @param strict
     * @param xmlStreamReader
     */
    private ProjectDependency parseProjectDependency(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding)
        throws IOException, XMLStreamException
    {
        ProjectDependency projectDependency = new ProjectDependency();
        projectDependency.setModelEncoding( encoding );
        java.util.Set parsed = new java.util.HashSet();
        while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
        {
            if ( xmlStreamReader.getLocalName().equals( "groupId" )  )
            {
                if ( parsed.contains( "groupId" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "groupId" );
                projectDependency.setGroupId( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "artifactId" )  )
            {
                if ( parsed.contains( "artifactId" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "artifactId" );
                projectDependency.setArtifactId( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "version" )  )
            {
                if ( parsed.contains( "version" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "version" );
                projectDependency.setVersion( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
            }
        }
        return projectDependency;
    } //-- ProjectDependency parseProjectDependency(String, XMLStreamReader, boolean, String) 

    /**
     * Method parseProjectDeveloper
     * 
     * @param tagName
     * @param encoding
     * @param strict
     * @param xmlStreamReader
     */
    private ProjectDeveloper parseProjectDeveloper(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding)
        throws IOException, XMLStreamException
    {
        ProjectDeveloper projectDeveloper = new ProjectDeveloper();
        projectDeveloper.setModelEncoding( encoding );
        java.util.Set parsed = new java.util.HashSet();
        while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
        {
            if ( xmlStreamReader.getLocalName().equals( "scmId" )  )
            {
                if ( parsed.contains( "scmId" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "scmId" );
                projectDeveloper.setScmId( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "name" )  )
            {
                if ( parsed.contains( "name" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "name" );
                projectDeveloper.setName( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "email" )  )
            {
                if ( parsed.contains( "email" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "email" );
                projectDeveloper.setEmail( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "continuumId" )  )
            {
                if ( parsed.contains( "continuumId" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "continuumId" );
                projectDeveloper.setContinuumId( getIntegerValue( getTrimmedValue( xmlStreamReader.getElementText()), "continuumId", xmlStreamReader, strict ) );
            }
            else
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
            }
        }
        return projectDeveloper;
    } //-- ProjectDeveloper parseProjectDeveloper(String, XMLStreamReader, boolean, String) 

    /**
     * Method parseProjectGroup
     * 
     * @param tagName
     * @param encoding
     * @param strict
     * @param xmlStreamReader
     */
    private ProjectGroup parseProjectGroup(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding)
        throws IOException, XMLStreamException
    {
        ProjectGroup projectGroup = new ProjectGroup();
        projectGroup.setModelEncoding( encoding );
        java.util.Set parsed = new java.util.HashSet();
        if ( projectGroupInstances == null )
        {
            projectGroupInstances = new java.util.HashMap();
        }
        String v = xmlStreamReader.getAttributeValue( null, "modello.id" );
        if ( v != null )
        {
            projectGroupInstances.put( v, projectGroup);
        }
        while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
        {
            if ( xmlStreamReader.getLocalName().equals( "id" )  )
            {
                if ( parsed.contains( "id" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "id" );
                projectGroup.setId( getIntegerValue( getTrimmedValue( xmlStreamReader.getElementText()), "id", xmlStreamReader, strict ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "groupId" )  )
            {
                if ( parsed.contains( "groupId" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "groupId" );
                projectGroup.setGroupId( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "name" )  )
            {
                if ( parsed.contains( "name" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "name" );
                projectGroup.setName( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "description" )  )
            {
                if ( parsed.contains( "description" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "description" );
                projectGroup.setDescription( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "projects" )  )
            {
                if ( parsed.contains( "projects" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "projects" );
                java.util.List projects = new java.util.ArrayList();
                projectGroup.setProjects( projects );
                while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
                {
                    if ( xmlStreamReader.getLocalName().equals( "project" ) )
                    {
                        projectGroup.addProject( parseProject( "project", xmlStreamReader, strict, encoding ) );
                    }
                    else
                    {
                        throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                    }
                }
            }
            else if ( xmlStreamReader.getLocalName().equals( "notifiers" )  )
            {
                if ( parsed.contains( "notifiers" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "notifiers" );
                java.util.List notifiers = new java.util.ArrayList();
                projectGroup.setNotifiers( notifiers );
                while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
                {
                    if ( xmlStreamReader.getLocalName().equals( "notifier" ) )
                    {
                        projectGroup.addNotifier( parseProjectNotifier( "notifier", xmlStreamReader, strict, encoding ) );
                    }
                    else
                    {
                        throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                    }
                }
            }
            else if ( xmlStreamReader.getLocalName().equals( "buildDefinitions" )  )
            {
                if ( parsed.contains( "buildDefinitions" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "buildDefinitions" );
                java.util.List buildDefinitions = new java.util.ArrayList();
                projectGroup.setBuildDefinitions( buildDefinitions );
                while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
                {
                    if ( xmlStreamReader.getLocalName().equals( "buildDefinition" ) )
                    {
                        projectGroup.addBuildDefinition( parseBuildDefinition( "buildDefinition", xmlStreamReader, strict, encoding ) );
                    }
                    else
                    {
                        throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                    }
                }
            }
            else
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
            }
        }
        projectGroupInstances.put( String.valueOf( projectGroup.getId() ), projectGroup);
        return projectGroup;
    } //-- ProjectGroup parseProjectGroup(String, XMLStreamReader, boolean, String) 

    /**
     * Method parseProjectNotifier
     * 
     * @param tagName
     * @param encoding
     * @param strict
     * @param xmlStreamReader
     */
    private ProjectNotifier parseProjectNotifier(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding)
        throws IOException, XMLStreamException
    {
        ProjectNotifier projectNotifier = new ProjectNotifier();
        projectNotifier.setModelEncoding( encoding );
        java.util.Set parsed = new java.util.HashSet();
        while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
        {
            if ( xmlStreamReader.getLocalName().equals( "id" )  )
            {
                if ( parsed.contains( "id" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "id" );
                projectNotifier.setId( getIntegerValue( getTrimmedValue( xmlStreamReader.getElementText()), "id", xmlStreamReader, strict ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "type" )  )
            {
                if ( parsed.contains( "type" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "type" );
                projectNotifier.setType( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "from" )  )
            {
                if ( parsed.contains( "from" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "from" );
                projectNotifier.setFrom( getIntegerValue( getTrimmedValue( xmlStreamReader.getElementText()), "from", xmlStreamReader, strict ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "enabled" )  )
            {
                if ( parsed.contains( "enabled" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "enabled" );
                projectNotifier.setEnabled( getBooleanValue( getTrimmedValue( xmlStreamReader.getElementText()), "enabled", xmlStreamReader ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "recipientType" )  )
            {
                if ( parsed.contains( "recipientType" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "recipientType" );
                projectNotifier.setRecipientType( getIntegerValue( getTrimmedValue( xmlStreamReader.getElementText()), "recipientType", xmlStreamReader, strict ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "sendOnSuccess" )  )
            {
                if ( parsed.contains( "sendOnSuccess" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "sendOnSuccess" );
                projectNotifier.setSendOnSuccess( getBooleanValue( getTrimmedValue( xmlStreamReader.getElementText()), "sendOnSuccess", xmlStreamReader ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "sendOnFailure" )  )
            {
                if ( parsed.contains( "sendOnFailure" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "sendOnFailure" );
                projectNotifier.setSendOnFailure( getBooleanValue( getTrimmedValue( xmlStreamReader.getElementText()), "sendOnFailure", xmlStreamReader ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "sendOnError" )  )
            {
                if ( parsed.contains( "sendOnError" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "sendOnError" );
                projectNotifier.setSendOnError( getBooleanValue( getTrimmedValue( xmlStreamReader.getElementText()), "sendOnError", xmlStreamReader ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "sendOnWarning" )  )
            {
                if ( parsed.contains( "sendOnWarning" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "sendOnWarning" );
                projectNotifier.setSendOnWarning( getBooleanValue( getTrimmedValue( xmlStreamReader.getElementText()), "sendOnWarning", xmlStreamReader ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "configuration" )  )
            {
                if ( parsed.contains( "configuration" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "configuration" );
                while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
                {
                    String key = xmlStreamReader.getLocalName();
                    String value = xmlStreamReader.getElementText()
                    .trim()
                    ;
                    projectNotifier.addConfiguration( key, value );
                }
            }
            else
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
            }
        }
        return projectNotifier;
    } //-- ProjectNotifier parseProjectNotifier(String, XMLStreamReader, boolean, String) 

    /**
     * Method parseSchedule
     * 
     * @param tagName
     * @param encoding
     * @param strict
     * @param xmlStreamReader
     */
    private Schedule parseSchedule(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding)
        throws IOException, XMLStreamException
    {
        Schedule schedule = new Schedule();
        schedule.setModelEncoding( encoding );
        java.util.Set parsed = new java.util.HashSet();
        if ( scheduleInstances == null )
        {
            scheduleInstances = new java.util.HashMap();
        }
        String v = xmlStreamReader.getAttributeValue( null, "modello.id" );
        if ( v != null )
        {
            scheduleInstances.put( v, schedule);
        }
        while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
        {
            if ( xmlStreamReader.getLocalName().equals( "id" )  )
            {
                if ( parsed.contains( "id" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "id" );
                schedule.setId( getIntegerValue( getTrimmedValue( xmlStreamReader.getElementText()), "id", xmlStreamReader, strict ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "active" )  )
            {
                if ( parsed.contains( "active" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "active" );
                schedule.setActive( getBooleanValue( getTrimmedValue( xmlStreamReader.getElementText()), "active", xmlStreamReader ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "name" )  )
            {
                if ( parsed.contains( "name" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "name" );
                schedule.setName( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "description" )  )
            {
                if ( parsed.contains( "description" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "description" );
                schedule.setDescription( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "delay" )  )
            {
                if ( parsed.contains( "delay" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "delay" );
                schedule.setDelay( getIntegerValue( getTrimmedValue( xmlStreamReader.getElementText()), "delay", xmlStreamReader, strict ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "maxJobExecutionTime" )  )
            {
                if ( parsed.contains( "maxJobExecutionTime" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "maxJobExecutionTime" );
                schedule.setMaxJobExecutionTime( getIntegerValue( getTrimmedValue( xmlStreamReader.getElementText()), "maxJobExecutionTime", xmlStreamReader, strict ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "cronExpression" )  )
            {
                if ( parsed.contains( "cronExpression" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "cronExpression" );
                schedule.setCronExpression( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
            }
        }
        scheduleInstances.put( String.valueOf( schedule.getId() ), schedule);
        return schedule;
    } //-- Schedule parseSchedule(String, XMLStreamReader, boolean, String) 

    /**
     * Method parseScmResult
     * 
     * @param tagName
     * @param encoding
     * @param strict
     * @param xmlStreamReader
     */
    private ScmResult parseScmResult(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding)
        throws IOException, XMLStreamException
    {
        ScmResult scmResult = new ScmResult();
        scmResult.setModelEncoding( encoding );
        java.util.Set parsed = new java.util.HashSet();
        while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
        {
            if ( xmlStreamReader.getLocalName().equals( "success" )  )
            {
                if ( parsed.contains( "success" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "success" );
                scmResult.setSuccess( getBooleanValue( getTrimmedValue( xmlStreamReader.getElementText()), "success", xmlStreamReader ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "commandLine" )  )
            {
                if ( parsed.contains( "commandLine" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "commandLine" );
                scmResult.setCommandLine( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "providerMessage" )  )
            {
                if ( parsed.contains( "providerMessage" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "providerMessage" );
                scmResult.setProviderMessage( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "commandOutput" )  )
            {
                if ( parsed.contains( "commandOutput" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "commandOutput" );
                scmResult.setCommandOutput( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "exception" )  )
            {
                if ( parsed.contains( "exception" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "exception" );
                scmResult.setException( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "changes" )  )
            {
                if ( parsed.contains( "changes" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "changes" );
                java.util.List changes = new java.util.ArrayList();
                scmResult.setChanges( changes );
                while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
                {
                    if ( xmlStreamReader.getLocalName().equals( "change" ) )
                    {
                        scmResult.addChange( parseChangeSet( "change", xmlStreamReader, strict, encoding ) );
                    }
                    else
                    {
                        throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                    }
                }
            }
            else
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
            }
        }
        return scmResult;
    } //-- ScmResult parseScmResult(String, XMLStreamReader, boolean, String) 

    /**
     * Method parseSuiteResult
     * 
     * @param tagName
     * @param encoding
     * @param strict
     * @param xmlStreamReader
     */
    private SuiteResult parseSuiteResult(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding)
        throws IOException, XMLStreamException
    {
        SuiteResult suiteResult = new SuiteResult();
        suiteResult.setModelEncoding( encoding );
        java.util.Set parsed = new java.util.HashSet();
        while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
        {
            if ( xmlStreamReader.getLocalName().equals( "name" )  )
            {
                if ( parsed.contains( "name" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "name" );
                suiteResult.setName( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "testCount" )  )
            {
                if ( parsed.contains( "testCount" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "testCount" );
                suiteResult.setTestCount( getIntegerValue( getTrimmedValue( xmlStreamReader.getElementText()), "testCount", xmlStreamReader, strict ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "failureCount" )  )
            {
                if ( parsed.contains( "failureCount" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "failureCount" );
                suiteResult.setFailureCount( getIntegerValue( getTrimmedValue( xmlStreamReader.getElementText()), "failureCount", xmlStreamReader, strict ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "totalTime" )  )
            {
                if ( parsed.contains( "totalTime" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "totalTime" );
                suiteResult.setTotalTime( getLongValue( getTrimmedValue( xmlStreamReader.getElementText()), "totalTime", xmlStreamReader, strict ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "failures" )  )
            {
                if ( parsed.contains( "failures" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "failures" );
                java.util.List failures = new java.util.ArrayList();
                suiteResult.setFailures( failures );
                while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
                {
                    if ( xmlStreamReader.getLocalName().equals( "failure" ) )
                    {
                        suiteResult.addFailure( parseTestCaseFailure( "failure", xmlStreamReader, strict, encoding ) );
                    }
                    else
                    {
                        throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                    }
                }
            }
            else
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
            }
        }
        return suiteResult;
    } //-- SuiteResult parseSuiteResult(String, XMLStreamReader, boolean, String) 

    /**
     * Method parseSystemConfiguration
     * 
     * @param tagName
     * @param encoding
     * @param strict
     * @param xmlStreamReader
     */
    private SystemConfiguration parseSystemConfiguration(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding)
        throws IOException, XMLStreamException
    {
        SystemConfiguration systemConfiguration = new SystemConfiguration();
        systemConfiguration.setModelEncoding( encoding );
        java.util.Set parsed = new java.util.HashSet();
        while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
        {
            if ( xmlStreamReader.getLocalName().equals( "guestAccountEnabled" )  )
            {
                if ( parsed.contains( "guestAccountEnabled" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "guestAccountEnabled" );
                systemConfiguration.setGuestAccountEnabled( getBooleanValue( getTrimmedValue( xmlStreamReader.getElementText()), "guestAccountEnabled", xmlStreamReader ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "defaultScheduleDescription" )  )
            {
                if ( parsed.contains( "defaultScheduleDescription" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "defaultScheduleDescription" );
                systemConfiguration.setDefaultScheduleDescription( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "defaultScheduleCronExpression" )  )
            {
                if ( parsed.contains( "defaultScheduleCronExpression" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "defaultScheduleCronExpression" );
                systemConfiguration.setDefaultScheduleCronExpression( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "workingDirectory" )  )
            {
                if ( parsed.contains( "workingDirectory" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "workingDirectory" );
                systemConfiguration.setWorkingDirectory( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "buildOutputDirectory" )  )
            {
                if ( parsed.contains( "buildOutputDirectory" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "buildOutputDirectory" );
                systemConfiguration.setBuildOutputDirectory( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "deploymentRepositoryDirectory" )  )
            {
                if ( parsed.contains( "deploymentRepositoryDirectory" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "deploymentRepositoryDirectory" );
                systemConfiguration.setDeploymentRepositoryDirectory( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "baseUrl" )  )
            {
                if ( parsed.contains( "baseUrl" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "baseUrl" );
                systemConfiguration.setBaseUrl( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "initialized" )  )
            {
                if ( parsed.contains( "initialized" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "initialized" );
                systemConfiguration.setInitialized( getBooleanValue( getTrimmedValue( xmlStreamReader.getElementText()), "initialized", xmlStreamReader ) );
            }
            else
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
            }
        }
        return systemConfiguration;
    } //-- SystemConfiguration parseSystemConfiguration(String, XMLStreamReader, boolean, String) 

    /**
     * Method parseTestCaseFailure
     * 
     * @param tagName
     * @param encoding
     * @param strict
     * @param xmlStreamReader
     */
    private TestCaseFailure parseTestCaseFailure(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding)
        throws IOException, XMLStreamException
    {
        TestCaseFailure testCaseFailure = new TestCaseFailure();
        testCaseFailure.setModelEncoding( encoding );
        java.util.Set parsed = new java.util.HashSet();
        while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
        {
            if ( xmlStreamReader.getLocalName().equals( "name" )  )
            {
                if ( parsed.contains( "name" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "name" );
                testCaseFailure.setName( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "exception" )  )
            {
                if ( parsed.contains( "exception" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "exception" );
                testCaseFailure.setException( getTrimmedValue( xmlStreamReader.getElementText()) );
            }
            else
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
            }
        }
        return testCaseFailure;
    } //-- TestCaseFailure parseTestCaseFailure(String, XMLStreamReader, boolean, String) 

    /**
     * Method parseTestResult
     * 
     * @param tagName
     * @param encoding
     * @param strict
     * @param xmlStreamReader
     */
    private TestResult parseTestResult(String tagName, XMLStreamReader xmlStreamReader, boolean strict, String encoding)
        throws IOException, XMLStreamException
    {
        TestResult testResult = new TestResult();
        testResult.setModelEncoding( encoding );
        java.util.Set parsed = new java.util.HashSet();
        while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
        {
            if ( xmlStreamReader.getLocalName().equals( "testCount" )  )
            {
                if ( parsed.contains( "testCount" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "testCount" );
                testResult.setTestCount( getIntegerValue( getTrimmedValue( xmlStreamReader.getElementText()), "testCount", xmlStreamReader, strict ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "failureCount" )  )
            {
                if ( parsed.contains( "failureCount" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "failureCount" );
                testResult.setFailureCount( getIntegerValue( getTrimmedValue( xmlStreamReader.getElementText()), "failureCount", xmlStreamReader, strict ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "totalTime" )  )
            {
                if ( parsed.contains( "totalTime" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "totalTime" );
                testResult.setTotalTime( getLongValue( getTrimmedValue( xmlStreamReader.getElementText()), "totalTime", xmlStreamReader, strict ) );
            }
            else if ( xmlStreamReader.getLocalName().equals( "suiteResults" )  )
            {
                if ( parsed.contains( "suiteResults" ) )
                {
                    throw new XMLStreamException( "Duplicated tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
                parsed.add( "suiteResults" );
                java.util.List suiteResults = new java.util.ArrayList();
                testResult.setSuiteResults( suiteResults );
                while ( xmlStreamReader.nextTag() == XMLStreamConstants.START_ELEMENT )
                {
                    if ( xmlStreamReader.getLocalName().equals( "suiteResult" ) )
                    {
                        testResult.addSuiteResult( parseSuiteResult( "suiteResult", xmlStreamReader, strict, encoding ) );
                    }
                    else
                    {
                        throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                    }
                }
            }
            else
            {
                if ( strict )
                {
                    throw new XMLStreamException( "Unrecognised tag: '" + xmlStreamReader.getLocalName() + "'", xmlStreamReader.getLocation() );
                }
            }
        }
        return testResult;
    } //-- TestResult parseTestResult(String, XMLStreamReader, boolean, String) 

    /**
     * Method read
     * 
     * @param reader
     * @param strict
     */
    public ContinuumDatabase read(Reader reader, boolean strict)
        throws IOException, XMLStreamException
    {
        XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader( reader );
        
        String encoding = xmlStreamReader.getCharacterEncodingScheme();
        ContinuumDatabase value = parseContinuumDatabase( "continuumDatabase", xmlStreamReader, strict, encoding );
        resolveReferences( value );
        return value;
    } //-- ContinuumDatabase read(Reader, boolean) 

    /**
     * Method read
     * 
     * @param reader
     */
    public ContinuumDatabase read(Reader reader)
        throws IOException, XMLStreamException
    {
        return read( reader, true );
    } //-- ContinuumDatabase read(Reader) 

    /**
     * Method read
     * 
     * @param filePath
     * @param strict
     */
    public ContinuumDatabase read(String filePath, boolean strict)
        throws IOException, XMLStreamException
    {
        File file = new File(filePath);
        XMLStreamReader xmlStreamReader = XMLInputFactory.newInstance().createXMLStreamReader( file.toURL().toExternalForm(), new FileInputStream(file) );
        
        String encoding = xmlStreamReader.getCharacterEncodingScheme();
        ContinuumDatabase value = parseContinuumDatabase( "continuumDatabase", xmlStreamReader, strict, encoding );
        resolveReferences( value );
        return value;
    } //-- ContinuumDatabase read(String, boolean) 

    /**
     * Method read
     * 
     * @param filePath
     */
    public ContinuumDatabase read(String filePath)
        throws IOException, XMLStreamException
    {
        return read( filePath, true );
    } //-- ContinuumDatabase read(String) 

    /**
     * Method resolveReferences
     * 
     * @param value
     */
    private void resolveReferences(ContinuumDatabase value)
    {
        java.util.Map refs;
        for ( java.util.Iterator i = value.getProjectGroups().iterator(); i.hasNext(); )
        {
            resolveReferences( (ProjectGroup) i.next() );
        }
        for ( java.util.Iterator i = value.getProfiles().iterator(); i.hasNext(); )
        {
            resolveReferences( (Profile) i.next() );
        }
    } //-- void resolveReferences(ContinuumDatabase) 

    /**
     * Method resolveReferences
     * 
     * @param value
     */
    private void resolveReferences(Profile value)
    {
        java.util.Map refs;
        if ( installationReferences != null )
        {
            refs = (java.util.Map) installationReferences.get( value );
            if ( refs != null )
            {
                String id = (String) refs.get( "jdk" );
                Installation ref = (Installation) installationInstances.get( id );
                if ( ref != null && !ref.equals( value.getJdk() ) )
                {
                    value.setJdk( ref );
                }
            }
        }
        if ( installationReferences != null )
        {
            refs = (java.util.Map) installationReferences.get( value );
            if ( refs != null )
            {
                String id = (String) refs.get( "builder" );
                Installation ref = (Installation) installationInstances.get( id );
                if ( ref != null && !ref.equals( value.getBuilder() ) )
                {
                    value.setBuilder( ref );
                }
            }
        }
        if ( installationReferences != null )
        {
            refs = (java.util.Map) installationReferences.get( value );
            if ( refs != null )
            {
                for ( int i = 0; i < value.getEnvironmentVariables().size(); i++ )
                {
                    String id = (String) refs.get( "environmentVariables." + i );
                    Installation ref = (Installation) installationInstances.get( id );
                    if ( ref != null )
                    {
                        value.getEnvironmentVariables().set( i, ref );
                    }
                }
            }
        }
    } //-- void resolveReferences(Profile) 

    /**
     * Method resolveReferences
     * 
     * @param value
     */
    private void resolveReferences(ProjectGroup value)
    {
        java.util.Map refs;
        for ( java.util.Iterator i = value.getProjects().iterator(); i.hasNext(); )
        {
            resolveReferences( (Project) i.next() );
        }
        for ( java.util.Iterator i = value.getBuildDefinitions().iterator(); i.hasNext(); )
        {
            resolveReferences( (BuildDefinition) i.next() );
        }
    } //-- void resolveReferences(ProjectGroup) 

    /**
     * Method resolveReferences
     * 
     * @param value
     */
    private void resolveReferences(BuildDefinition value)
    {
        java.util.Map refs;
        if ( scheduleReferences != null )
        {
            refs = (java.util.Map) scheduleReferences.get( value );
            if ( refs != null )
            {
                String id = (String) refs.get( "schedule" );
                Schedule ref = (Schedule) scheduleInstances.get( id );
                if ( ref != null && !ref.equals( value.getSchedule() ) )
                {
                    value.setSchedule( ref );
                }
            }
        }
        if ( profileReferences != null )
        {
            refs = (java.util.Map) profileReferences.get( value );
            if ( refs != null )
            {
                String id = (String) refs.get( "profile" );
                Profile ref = (Profile) profileInstances.get( id );
                if ( ref != null && !ref.equals( value.getProfile() ) )
                {
                    value.setProfile( ref );
                }
            }
        }
    } //-- void resolveReferences(BuildDefinition) 

    /**
     * Method resolveReferences
     * 
     * @param value
     */
    private void resolveReferences(Project value)
    {
        java.util.Map refs;
        for ( java.util.Iterator i = value.getBuildResults().iterator(); i.hasNext(); )
        {
            resolveReferences( (BuildResult) i.next() );
        }
        if ( projectGroupReferences != null )
        {
            refs = (java.util.Map) projectGroupReferences.get( value );
            if ( refs != null )
            {
                String id = (String) refs.get( "projectGroup" );
                ProjectGroup ref = (ProjectGroup) projectGroupInstances.get( id );
                if ( ref != null && !ref.equals( value.getProjectGroup() ) )
                {
                    value.setProjectGroup( ref );
                }
            }
        }
        for ( java.util.Iterator i = value.getBuildDefinitions().iterator(); i.hasNext(); )
        {
            resolveReferences( (BuildDefinition) i.next() );
        }
    } //-- void resolveReferences(Project) 

    /**
     * Method resolveReferences
     * 
     * @param value
     */
    private void resolveReferences(BuildResult value)
    {
        java.util.Map refs;
        if ( projectReferences != null )
        {
            refs = (java.util.Map) projectReferences.get( value );
            if ( refs != null )
            {
                String id = (String) refs.get( "project" );
                Project ref = (Project) projectInstances.get( id );
                if ( ref != null && !ref.equals( value.getProject() ) )
                {
                    value.setProject( ref );
                }
            }
        }
        if ( buildDefinitionReferences != null )
        {
            refs = (java.util.Map) buildDefinitionReferences.get( value );
            if ( refs != null )
            {
                String id = (String) refs.get( "buildDefinition" );
                BuildDefinition ref = (BuildDefinition) buildDefinitionInstances.get( id );
                if ( ref != null && !ref.equals( value.getBuildDefinition() ) )
                {
                    value.setBuildDefinition( ref );
                }
            }
        }
    } //-- void resolveReferences(BuildResult) 


}
