/*
 * $Id$
 */

package org.apache.maven.continuum.configuration.io.xpp3;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.io.Writer;
import java.text.DateFormat;
import java.util.Iterator;
import java.util.Locale;
import org.apache.maven.continuum.configuration.Configuration;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

/**
 * Class ConfigurationXpp3Writer.
 * 
 * @version $Revision$ $Date$
 */
public class ConfigurationXpp3Writer {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field NAMESPACE
     */
    private String NAMESPACE;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method write
     * 
     * @param writer
     * @param configuration
     */
    public void write(Writer writer, Configuration configuration)
        throws java.io.IOException
    {
        XmlSerializer serializer = new MXSerializer();
        serializer.setProperty( "http://xmlpull.org/v1/doc/properties.html#serializer-indentation", "  " );
        serializer.setProperty( "http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", "\n" );
        serializer.setOutput( writer );
        serializer.startDocument( configuration.getModelEncoding(), null );
        writeConfiguration( configuration, "configuration", serializer );
        serializer.endDocument();
    } //-- void write(Writer, Configuration) 

    /**
     * Method writeConfiguration
     * 
     * @param configuration
     * @param serializer
     * @param tagName
     */
    private void writeConfiguration(Configuration configuration, String tagName, XmlSerializer serializer)
        throws java.io.IOException
    {
        if ( configuration != null )
        {
            serializer.startTag( NAMESPACE, tagName );
            serializer.endTag( NAMESPACE, tagName );
        }
    } //-- void writeConfiguration(Configuration, String, XmlSerializer) 


}
