/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.project.builder.cc;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.continuum.model.project.BuildDefinition;
import org.apache.maven.continuum.model.project.Project;
import org.apache.maven.continuum.model.project.ProjectNotifier;
import org.apache.maven.continuum.project.builder.AbstractContinuumProjectBuilder;
import org.apache.maven.continuum.project.builder.ContinuumProjectBuilderException;
import org.apache.maven.continuum.project.builder.ContinuumProjectBuildingResult;
import org.codehaus.plexus.formica.util.MungedHttpsURL;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class CruiseControlProjectBuilder
extends AbstractContinuumProjectBuilder {
    public static final String ID = "cc-builder";
    private static final String[] IGNORED_MODIFICATION_SET_TYPES = new String[]{"alwaysbuild", "buildstatus", "forceonly"};
    private static final String[] IGNORED_SCHEDULE_TYPES = new String[]{"pause"};

    public ContinuumProjectBuildingResult buildProjectsFromMetadata(URL url, String username, String password) throws ContinuumProjectBuilderException {
        ContinuumProjectBuildingResult result = new ContinuumProjectBuildingResult();
        Xpp3Dom dom = this.downloadAndBuildDom(url, username, password);
        Xpp3Dom[] projects = dom.getChildren("project");
        for (int i = 0; i < projects.length; ++i) {
            Xpp3Dom project = projects[i];
            Project continuumProject = this.findProject(project.getChild("schedule"));
            String name = project.getAttribute("name");
            if (StringUtils.isEmpty((String)name)) {
                throw new ContinuumProjectBuilderException("Missing required attribute 'name' from 'project' element.");
            }
            continuumProject.setName(name);
            Xpp3Dom modifactionsets = project.getChild("modificationset");
            if (modifactionsets == null) {
                throw new ContinuumProjectBuilderException("The configuration must contain at a 'modificationset' element.");
            }
            String scmUrl = this.findScmUrl(modifactionsets.getChildren());
            continuumProject.setScmUrl(scmUrl);
            Xpp3Dom publishers = project.getChild("publishers");
            if (publishers != null) {
                String emailAddress = this.findNagEmailAddress(publishers.getChild("email"));
                if (emailAddress == null) {
                    emailAddress = this.findNagEmailAddress(publishers.getChild("htmlemail"));
                }
                ProjectNotifier notifier = new ProjectNotifier();
                Properties props = new Properties();
                ((Hashtable)props).put("address", emailAddress);
                notifier.setConfiguration((Map)props);
                ArrayList notifiers = new ArrayList();
                continuumProject.setNotifiers(notifiers);
            }
            continuumProject.setVersion("UNKNOWN");
            result.addProject(continuumProject);
        }
        return result;
    }

    private Project findProject(Xpp3Dom schedule) throws ContinuumProjectBuilderException {
        if (schedule == null) {
            throw new ContinuumProjectBuilderException("The configuration has to include a 'schedule' element.");
        }
        Project project = null;
        Xpp3Dom[] children = schedule.getChildren();
        for (int i = 0; i < children.length; ++i) {
            BuildDefinition bd;
            Xpp3Dom child = children[i];
            if (this.contains(child.getName(), IGNORED_SCHEDULE_TYPES)) continue;
            if (child.getName().equals("ant")) {
                if (project != null) {
                    throw new ContinuumProjectBuilderException("A configuration can only have a single 'ant' or 'maven' schedule.");
                }
                project = new Project();
                project.setExecutorId("ant");
                bd = new BuildDefinition();
                bd.setArguments("");
                bd.setGoals("clean build");
                bd.setBuildFile("build.xml");
                project.addBuildDefinition(bd);
                continue;
            }
            if (child.getName().equals("maven")) {
                if (project != null) {
                    throw new ContinuumProjectBuilderException("A configuration can only have a single 'ant' or 'maven' schedule.");
                }
                project = new Project();
                project.setExecutorId("maven-1");
                bd = new BuildDefinition();
                bd.setArguments("");
                bd.setGoals("clean:clean jar:install");
                bd.setBuildFile("project.xml");
                project.addBuildDefinition(bd);
                continue;
            }
            throw new ContinuumProjectBuilderException("Can't handle schedule '" + schedule.getName() + "'. Continuum only supports 'ant' and 'maven' schedules.");
        }
        if (project == null) {
            throw new ContinuumProjectBuilderException("There must be exactly one 'ant' or 'maven' build scheduled..");
        }
        return project;
    }

    private String findScmUrl(Xpp3Dom[] modifactionsets) throws ContinuumProjectBuilderException {
        String scmUrl = null;
        for (int j = 0; j < modifactionsets.length; ++j) {
            Xpp3Dom modifactionset = modifactionsets[j];
            if (this.contains(modifactionset.getName(), IGNORED_MODIFICATION_SET_TYPES)) continue;
            if (modifactionset.getName().equals("cvs")) {
                if (scmUrl != null) {
                    throw new ContinuumProjectBuilderException("A 'modificationset' element can only contain a single 'cvs' or 'svn' element.");
                }
                String cvsrot = modifactionset.getAttribute("cvsroot");
                if (StringUtils.isEmpty((String)cvsrot)) {
                    throw new ContinuumProjectBuilderException("A 'cvsroot' attribute is required when using a cvs modification set. The usage of 'localworkingcopy' is not supported.");
                }
                String tag = modifactionset.getAttribute("tag");
                if (StringUtils.isEmpty((String)tag)) {
                    throw new ContinuumProjectBuilderException("Continuum doesn't support CVS tags.");
                }
                scmUrl = "scm:cvs:" + cvsrot;
                break;
            }
            if (modifactionset.getName().equals("svn")) {
                if (scmUrl != null) {
                    throw new ContinuumProjectBuilderException("A 'modificationset' element can only contain a single 'cvs' or 'svn' element.");
                }
                String repositoryLocation = modifactionset.getAttribute("repositoryLocation");
                if (StringUtils.isEmpty((String)repositoryLocation)) {
                    throw new ContinuumProjectBuilderException("A 'repositoryLocation' attribute is required when using a svn modification set. The usage of 'localworkingcopy' is not supported.");
                }
                scmUrl = "scm:svn:" + repositoryLocation;
                break;
            }
            throw new ContinuumProjectBuilderException("Unsupported modification set found '" + modifactionset.getName() + "'.");
        }
        if (scmUrl == null) {
            throw new ContinuumProjectBuilderException("The configuration must contain at least one 'modificationset'.");
        }
        return scmUrl;
    }

    private String findNagEmailAddress(Xpp3Dom email) {
        if (email == null) {
            return null;
        }
        Xpp3Dom[] failure = email.getChildren("failure");
        if (failure.length == 0) {
            return null;
        }
        String nagEmailAddress = failure[0].getAttribute("address");
        if (StringUtils.isEmpty((String)nagEmailAddress)) {
            return null;
        }
        return nagEmailAddress;
    }

    private boolean contains(String target, String[] data) {
        for (int i = 0; i < data.length; ++i) {
            if (!data[i].equals(target)) continue;
            return true;
        }
        return false;
    }

    private Xpp3Dom downloadAndBuildDom(URL url, String username, String password) throws ContinuumProjectBuilderException {
        try {
            this.getLogger().info("Downloading " + url);
            URL u = url;
            if (url.getProtocol().startsWith("http")) {
                u = new MungedHttpsURL(url.toString()).getURL();
            }
            return Xpp3DomBuilder.build((Reader)new InputStreamReader(u.openStream()));
        }
        catch (XmlPullParserException e) {
            throw new ContinuumProjectBuilderException("Error while parsing the CruiseControl configuration file.", (Throwable)e);
        }
        catch (IOException e) {
            throw new ContinuumProjectBuilderException("Error while downloading the CruiseControl configuration file.", (Throwable)e);
        }
    }
}

