/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store.instantiated;

import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermPositionVector;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.store.instantiated.FieldSetting;
import org.apache.lucene.store.instantiated.FieldSettings;
import org.apache.lucene.store.instantiated.InstantiatedDocument;
import org.apache.lucene.store.instantiated.InstantiatedIndexReader;
import org.apache.lucene.store.instantiated.InstantiatedIndexWriter;
import org.apache.lucene.store.instantiated.InstantiatedTerm;
import org.apache.lucene.store.instantiated.InstantiatedTermDocumentInformation;
import org.apache.lucene.util.BitVector;
import org.apache.lucene.util.ReaderUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class InstantiatedIndex
implements Serializable,
Closeable {
    private static final long serialVersionUID = 1L;
    private long version = System.currentTimeMillis();
    private InstantiatedDocument[] documentsByNumber;
    private BitVector deletedDocuments;
    private Map<String, Map<String, InstantiatedTerm>> termsByFieldAndText;
    private InstantiatedTerm[] orderedTerms;
    private Map<String, byte[]> normsByFieldNameAndDocumentNumber;
    private FieldSettings fieldSettings;
    private transient FieldInfos fieldInfos;

    public InstantiatedIndex() {
        this.initialize();
    }

    void initialize() {
        this.termsByFieldAndText = new HashMap<String, Map<String, InstantiatedTerm>>();
        this.fieldSettings = new FieldSettings();
        this.orderedTerms = new InstantiatedTerm[0];
        this.documentsByNumber = new InstantiatedDocument[0];
        this.normsByFieldNameAndDocumentNumber = new HashMap<String, byte[]>();
        this.rebuildFieldInfos();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.rebuildFieldInfos();
    }

    void rebuildFieldInfos() {
        this.fieldInfos = new FieldInfos();
        for (FieldSetting fieldSetting : this.fieldSettings.values()) {
            this.fieldInfos.add(fieldSetting.fieldName, fieldSetting.indexed, fieldSetting.storeTermVector, false, fieldSetting.storePayloads, FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
        }
    }

    public FieldInfos getFieldInfos() {
        return this.fieldInfos;
    }

    public InstantiatedIndex(IndexReader sourceIndexReader) throws IOException {
        this(sourceIndexReader, null);
    }

    public InstantiatedIndex(IndexReader sourceIndexReader, Set<String> fields) throws IOException {
        String fieldName;
        if (sourceIndexReader.getSequentialSubReaders().length != 1) {
            System.out.println("Source index has more than one segment.");
        }
        this.initialize();
        for (FieldInfo fieldInfo : ReaderUtil.getMergedFieldInfos((IndexReader)sourceIndexReader)) {
            FieldSetting setting = this.fieldSettings.get(fieldInfo.name, true);
            setting.indexed = fieldInfo.isIndexed;
            setting.storeTermVector = fieldInfo.storeTermVector;
            setting.storeOffsetWithTermVector = true;
            setting.storePositionWithTermVector = true;
            setting.storePayloads = fieldInfo.storePayloads;
        }
        this.documentsByNumber = new InstantiatedDocument[sourceIndexReader.maxDoc()];
        if (sourceIndexReader.hasDeletions()) {
            this.deletedDocuments = new BitVector(sourceIndexReader.maxDoc());
        }
        for (int i = 0; i < sourceIndexReader.maxDoc(); ++i) {
            if (sourceIndexReader.hasDeletions() && sourceIndexReader.isDeleted(i)) {
                this.deletedDocuments.set(i);
                continue;
            }
            InstantiatedDocument document = new InstantiatedDocument();
            Document sourceDocument = sourceIndexReader.document(i);
            for (Fieldable field : sourceDocument.getFields()) {
                if (fields != null && !fields.contains(field.name())) continue;
                document.getDocument().add(field);
            }
            document.setDocumentNumber(i);
            this.documentsByNumber[i] = document;
            for (Fieldable field : document.getDocument().getFields()) {
                if (fields != null && !fields.contains(field.name()) || !field.isTermVectorStored()) continue;
                if (document.getVectorSpace() == null) {
                    document.setVectorSpace(new HashMap<String, List<InstantiatedTermDocumentInformation>>());
                }
                document.getVectorSpace().put(field.name(), new ArrayList());
            }
        }
        for (FieldInfo fieldInfo : ReaderUtil.getMergedFieldInfos((IndexReader)sourceIndexReader)) {
            fieldName = fieldInfo.name;
            if (fields != null && !fields.contains(fieldName)) continue;
            this.getNormsByFieldNameAndDocumentNumber().put(fieldName, sourceIndexReader.norms(fieldName));
        }
        for (FieldInfo fieldInfo : ReaderUtil.getMergedFieldInfos((IndexReader)sourceIndexReader)) {
            fieldName = fieldInfo.name;
            if (fields != null && !fields.contains(fieldName)) continue;
            this.getTermsByFieldAndText().put(fieldName, new HashMap(5000));
        }
        ArrayList<InstantiatedTerm> terms = new ArrayList<InstantiatedTerm>(5000 * this.getTermsByFieldAndText().size());
        TermEnum termEnum = sourceIndexReader.terms();
        while (termEnum.next()) {
            if (fields != null && !fields.contains(termEnum.term().field())) continue;
            InstantiatedTerm instantiatedTerm = new InstantiatedTerm(termEnum.term().field(), termEnum.term().text());
            this.getTermsByFieldAndText().get(termEnum.term().field()).put(termEnum.term().text(), instantiatedTerm);
            instantiatedTerm.setTermIndex(terms.size());
            terms.add(instantiatedTerm);
            instantiatedTerm.setAssociatedDocuments(new InstantiatedTermDocumentInformation[termEnum.docFreq()]);
        }
        termEnum.close();
        this.orderedTerms = terms.toArray(new InstantiatedTerm[terms.size()]);
        for (InstantiatedTerm instantiatedTerm : this.orderedTerms) {
            TermPositions termPositions = sourceIndexReader.termPositions(instantiatedTerm.getTerm());
            int position = 0;
            while (termPositions.next()) {
                InstantiatedDocument document = this.documentsByNumber[termPositions.doc()];
                byte[][] payloads = new byte[termPositions.freq()][];
                int[] positions = new int[termPositions.freq()];
                for (int i = 0; i < termPositions.freq(); ++i) {
                    positions[i] = termPositions.nextPosition();
                    if (!termPositions.isPayloadAvailable()) continue;
                    payloads[i] = new byte[termPositions.getPayloadLength()];
                    termPositions.getPayload(payloads[i], 0);
                }
                InstantiatedTermDocumentInformation termDocumentInformation = new InstantiatedTermDocumentInformation(instantiatedTerm, document, positions, payloads);
                instantiatedTerm.getAssociatedDocuments()[position++] = termDocumentInformation;
                if (document.getVectorSpace() == null || !document.getVectorSpace().containsKey(instantiatedTerm.field())) continue;
                document.getVectorSpace().get(instantiatedTerm.field()).add(termDocumentInformation);
            }
        }
        for (Serializable serializable : this.getDocumentsByNumber()) {
            if (serializable == null) continue;
            for (Fieldable field : ((InstantiatedDocument)serializable).getDocument().getFields()) {
                TermPositionVector termPositionVector = (TermPositionVector)sourceIndexReader.getTermFreqVector(((InstantiatedDocument)serializable).getDocumentNumber().intValue(), field.name());
                if (termPositionVector == null) continue;
                for (int i = 0; i < termPositionVector.getTerms().length; ++i) {
                    String token = termPositionVector.getTerms()[i];
                    InstantiatedTerm term = this.findTerm(field.name(), token);
                    InstantiatedTermDocumentInformation termDocumentInformation = term.getAssociatedDocument(((InstantiatedDocument)serializable).getDocumentNumber());
                    termDocumentInformation.setTermOffsets(termPositionVector.getOffsets(i));
                }
            }
        }
    }

    public InstantiatedIndexWriter indexWriterFactory(Analyzer analyzer, boolean create) throws IOException {
        return new InstantiatedIndexWriter(this, analyzer, create);
    }

    public InstantiatedIndexReader indexReaderFactory() throws IOException {
        return new InstantiatedIndexReader(this);
    }

    @Override
    public void close() throws IOException {
    }

    InstantiatedTerm findTerm(Term term) {
        return this.findTerm(term.field(), term.text());
    }

    InstantiatedTerm findTerm(String field, String text) {
        Map<String, InstantiatedTerm> termsByField = this.termsByFieldAndText.get(field);
        if (termsByField == null) {
            return null;
        }
        return termsByField.get(text);
    }

    public Map<String, Map<String, InstantiatedTerm>> getTermsByFieldAndText() {
        return this.termsByFieldAndText;
    }

    public InstantiatedTerm[] getOrderedTerms() {
        return this.orderedTerms;
    }

    public InstantiatedDocument[] getDocumentsByNumber() {
        return this.documentsByNumber;
    }

    public Map<String, byte[]> getNormsByFieldNameAndDocumentNumber() {
        return this.normsByFieldNameAndDocumentNumber;
    }

    void setNormsByFieldNameAndDocumentNumber(Map<String, byte[]> normsByFieldNameAndDocumentNumber) {
        this.normsByFieldNameAndDocumentNumber = normsByFieldNameAndDocumentNumber;
    }

    public BitVector getDeletedDocuments() {
        return this.deletedDocuments;
    }

    void setDeletedDocuments(BitVector deletedDocuments) {
        this.deletedDocuments = deletedDocuments;
    }

    void setOrderedTerms(InstantiatedTerm[] orderedTerms) {
        this.orderedTerms = orderedTerms;
    }

    void setDocumentsByNumber(InstantiatedDocument[] documentsByNumber) {
        this.documentsByNumber = documentsByNumber;
    }

    public long getVersion() {
        return this.version;
    }

    void setVersion(long version) {
        this.version = version;
    }

    FieldSettings getFieldSettings() {
        return this.fieldSettings;
    }
}

