/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store.instantiated;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.index.TermVectorMapper;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.instantiated.FieldSetting;
import org.apache.lucene.store.instantiated.InstantiatedAllTermDocs;
import org.apache.lucene.store.instantiated.InstantiatedDocument;
import org.apache.lucene.store.instantiated.InstantiatedIndex;
import org.apache.lucene.store.instantiated.InstantiatedTerm;
import org.apache.lucene.store.instantiated.InstantiatedTermDocs;
import org.apache.lucene.store.instantiated.InstantiatedTermDocumentInformation;
import org.apache.lucene.store.instantiated.InstantiatedTermEnum;
import org.apache.lucene.store.instantiated.InstantiatedTermPositionVector;
import org.apache.lucene.store.instantiated.InstantiatedTermPositions;
import org.apache.lucene.util.BitVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstantiatedIndexReader
extends IndexReader {
    private final InstantiatedIndex index;
    private BitVector uncommittedDeletedDocuments;
    private Map<String, List<NormUpdate>> uncommittedNormsByFieldNameAndDocumentNumber = null;

    public InstantiatedIndexReader(InstantiatedIndex index) {
        this.index = index;
        this.readerFinishedListeners = Collections.synchronizedSet(new HashSet());
    }

    @Deprecated
    public boolean isOptimized() {
        return true;
    }

    public long getVersion() {
        return this.index.getVersion();
    }

    public Directory directory() {
        throw new UnsupportedOperationException();
    }

    public boolean isCurrent() throws IOException {
        return true;
    }

    public InstantiatedIndex getIndex() {
        return this.index;
    }

    public int numDocs() {
        int numDocs = this.getIndex().getDocumentsByNumber().length;
        if (this.uncommittedDeletedDocuments != null) {
            numDocs -= this.uncommittedDeletedDocuments.count();
        }
        if (this.index.getDeletedDocuments() != null) {
            numDocs -= this.index.getDeletedDocuments().count();
        }
        return numDocs;
    }

    public int maxDoc() {
        return this.getIndex().getDocumentsByNumber().length;
    }

    public boolean hasDeletions() {
        return this.index.getDeletedDocuments() != null || this.uncommittedDeletedDocuments != null;
    }

    public boolean isDeleted(int n) {
        return this.index.getDeletedDocuments() != null && this.index.getDeletedDocuments().get(n) || this.uncommittedDeletedDocuments != null && this.uncommittedDeletedDocuments.get(n);
    }

    protected void doDelete(int docNum) throws IOException {
        if (this.index.getDeletedDocuments() != null && this.index.getDeletedDocuments().get(docNum) || this.uncommittedDeletedDocuments != null && this.uncommittedDeletedDocuments.get(docNum)) {
            return;
        }
        if (this.uncommittedDeletedDocuments == null) {
            this.uncommittedDeletedDocuments = new BitVector(this.maxDoc());
        }
        this.uncommittedDeletedDocuments.set(docNum);
    }

    protected void doUndeleteAll() throws IOException {
        this.uncommittedDeletedDocuments = null;
    }

    protected void doCommit(Map<String, String> commitUserData) throws IOException {
        if (this.uncommittedNormsByFieldNameAndDocumentNumber != null) {
            for (Map.Entry<String, List<NormUpdate>> e : this.uncommittedNormsByFieldNameAndDocumentNumber.entrySet()) {
                byte[] norms = this.getIndex().getNormsByFieldNameAndDocumentNumber().get(e.getKey());
                for (NormUpdate normUpdate : e.getValue()) {
                    norms[((NormUpdate)normUpdate).doc] = normUpdate.value;
                }
            }
            this.uncommittedNormsByFieldNameAndDocumentNumber = null;
        }
        if (this.uncommittedDeletedDocuments != null) {
            if (this.index.getDeletedDocuments() == null) {
                this.index.setDeletedDocuments(this.uncommittedDeletedDocuments);
            } else {
                for (int d = 0; d < this.uncommittedDeletedDocuments.size(); ++d) {
                    if (!this.uncommittedDeletedDocuments.get(d)) continue;
                    this.index.getDeletedDocuments().set(d);
                }
            }
            this.uncommittedDeletedDocuments = null;
        }
    }

    protected void doClose() throws IOException {
    }

    public Collection<String> getFieldNames(IndexReader.FieldOption fieldOption) {
        HashSet<String> fieldSet = new HashSet<String>();
        for (FieldSetting fi : this.index.getFieldSettings().values()) {
            if (fieldOption == IndexReader.FieldOption.ALL) {
                fieldSet.add(fi.fieldName);
                continue;
            }
            if (!fi.indexed && fieldOption == IndexReader.FieldOption.UNINDEXED) {
                fieldSet.add(fi.fieldName);
                continue;
            }
            if (fi.storePayloads && fieldOption == IndexReader.FieldOption.STORES_PAYLOADS) {
                fieldSet.add(fi.fieldName);
                continue;
            }
            if (fi.indexed && fieldOption == IndexReader.FieldOption.INDEXED) {
                fieldSet.add(fi.fieldName);
                continue;
            }
            if (fi.indexed && !fi.storeTermVector && fieldOption == IndexReader.FieldOption.INDEXED_NO_TERMVECTOR) {
                fieldSet.add(fi.fieldName);
                continue;
            }
            if (fi.storeTermVector && !fi.storePositionWithTermVector && !fi.storeOffsetWithTermVector && fieldOption == IndexReader.FieldOption.TERMVECTOR) {
                fieldSet.add(fi.fieldName);
                continue;
            }
            if (fi.indexed && fi.storeTermVector && fieldOption == IndexReader.FieldOption.INDEXED_WITH_TERMVECTOR) {
                fieldSet.add(fi.fieldName);
                continue;
            }
            if (fi.storePositionWithTermVector && !fi.storeOffsetWithTermVector && fieldOption == IndexReader.FieldOption.TERMVECTOR_WITH_POSITION) {
                fieldSet.add(fi.fieldName);
                continue;
            }
            if (fi.storeOffsetWithTermVector && !fi.storePositionWithTermVector && fieldOption == IndexReader.FieldOption.TERMVECTOR_WITH_OFFSET) {
                fieldSet.add(fi.fieldName);
                continue;
            }
            if (!fi.storeOffsetWithTermVector || !fi.storePositionWithTermVector || fieldOption != IndexReader.FieldOption.TERMVECTOR_WITH_POSITION_OFFSET) continue;
            fieldSet.add(fi.fieldName);
        }
        return fieldSet;
    }

    public Document document(int n, FieldSelector fieldSelector) throws CorruptIndexException, IOException {
        return this.document(n);
    }

    public Document document(int n) throws IOException {
        return this.isDeleted(n) ? null : this.getIndex().getDocumentsByNumber()[n].getDocument();
    }

    public byte[] norms(String field) throws IOException {
        byte[] norms = this.getIndex().getNormsByFieldNameAndDocumentNumber().get(field);
        if (norms == null) {
            return new byte[0];
        }
        if (this.uncommittedNormsByFieldNameAndDocumentNumber != null) {
            norms = (byte[])norms.clone();
            List<NormUpdate> updated = this.uncommittedNormsByFieldNameAndDocumentNumber.get(field);
            if (updated != null) {
                for (NormUpdate normUpdate : updated) {
                    norms[((NormUpdate)normUpdate).doc] = normUpdate.value;
                }
            }
        }
        return norms;
    }

    public void norms(String field, byte[] bytes, int offset) throws IOException {
        byte[] norms = this.getIndex().getNormsByFieldNameAndDocumentNumber().get(field);
        if (norms == null) {
            return;
        }
        System.arraycopy(norms, 0, bytes, offset, norms.length);
    }

    protected void doSetNorm(int doc, String field, byte value) throws IOException {
        List<NormUpdate> list;
        if (this.uncommittedNormsByFieldNameAndDocumentNumber == null) {
            this.uncommittedNormsByFieldNameAndDocumentNumber = new HashMap<String, List<NormUpdate>>(this.getIndex().getNormsByFieldNameAndDocumentNumber().size());
        }
        if ((list = this.uncommittedNormsByFieldNameAndDocumentNumber.get(field)) == null) {
            list = new LinkedList<NormUpdate>();
            this.uncommittedNormsByFieldNameAndDocumentNumber.put(field, list);
        }
        list.add(new NormUpdate(doc, value));
    }

    public int docFreq(Term t) throws IOException {
        InstantiatedTerm term = this.getIndex().findTerm(t);
        if (term == null) {
            return 0;
        }
        return term.getAssociatedDocuments().length;
    }

    public TermEnum terms() throws IOException {
        return new InstantiatedTermEnum(this);
    }

    public TermEnum terms(Term t) throws IOException {
        InstantiatedTerm it = this.getIndex().findTerm(t);
        if (it != null) {
            return new InstantiatedTermEnum(this, it.getTermIndex());
        }
        int startPos = Arrays.binarySearch(this.index.getOrderedTerms(), t, InstantiatedTerm.termComparator);
        if (startPos < 0) {
            startPos = -1 - startPos;
        }
        return new InstantiatedTermEnum(this, startPos);
    }

    public TermDocs termDocs() throws IOException {
        return new InstantiatedTermDocs(this);
    }

    public TermDocs termDocs(Term term) throws IOException {
        if (term == null) {
            return new InstantiatedAllTermDocs(this);
        }
        InstantiatedTermDocs termDocs = new InstantiatedTermDocs(this);
        termDocs.seek(term);
        return termDocs;
    }

    public TermPositions termPositions() throws IOException {
        return new InstantiatedTermPositions(this);
    }

    public TermFreqVector[] getTermFreqVectors(int docNumber) throws IOException {
        InstantiatedDocument doc = this.getIndex().getDocumentsByNumber()[docNumber];
        if (doc.getVectorSpace() == null) {
            return null;
        }
        TermFreqVector[] ret = new TermFreqVector[doc.getVectorSpace().size()];
        Iterator<String> it = doc.getVectorSpace().keySet().iterator();
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = new InstantiatedTermPositionVector(this.getIndex().getDocumentsByNumber()[docNumber], it.next());
        }
        return ret;
    }

    public TermFreqVector getTermFreqVector(int docNumber, String field) throws IOException {
        InstantiatedDocument doc = this.getIndex().getDocumentsByNumber()[docNumber];
        if (doc.getVectorSpace() == null || doc.getVectorSpace().get(field) == null) {
            return null;
        }
        return new InstantiatedTermPositionVector(doc, field);
    }

    public void getTermFreqVector(int docNumber, String field, TermVectorMapper mapper) throws IOException {
        InstantiatedDocument doc = this.getIndex().getDocumentsByNumber()[docNumber];
        if (doc.getVectorSpace() != null && doc.getVectorSpace().get(field) == null) {
            List<InstantiatedTermDocumentInformation> tv = doc.getVectorSpace().get(field);
            mapper.setExpectations(field, tv.size(), true, true);
            for (InstantiatedTermDocumentInformation tdi : tv) {
                mapper.map(tdi.getTerm().text(), tdi.getTermPositions().length, tdi.getTermOffsets(), tdi.getTermPositions());
            }
        }
    }

    public void getTermFreqVector(int docNumber, TermVectorMapper mapper) throws IOException {
        InstantiatedDocument doc = this.getIndex().getDocumentsByNumber()[docNumber];
        for (Map.Entry<String, List<InstantiatedTermDocumentInformation>> e : doc.getVectorSpace().entrySet()) {
            mapper.setExpectations(e.getKey(), e.getValue().size(), true, true);
            for (InstantiatedTermDocumentInformation tdi : e.getValue()) {
                mapper.map(tdi.getTerm().text(), tdi.getTermPositions().length, tdi.getTermOffsets(), tdi.getTermPositions());
            }
        }
    }

    private class NormUpdate {
        private int doc;
        private byte value;

        public NormUpdate(int doc, byte value) {
            this.doc = doc;
            this.value = value;
        }
    }
}

