/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store.instantiated;

import java.io.IOException;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.store.instantiated.InstantiatedIndexReader;
import org.apache.lucene.store.instantiated.InstantiatedTermDocs;

public class InstantiatedTermPositions
extends InstantiatedTermDocs
implements TermPositions {
    private int currentTermPositionIndex;

    public int getPayloadLength() {
        return this.currentDocumentInformation.getPayloads()[this.currentTermPositionIndex].length;
    }

    public byte[] getPayload(byte[] data, int offset) throws IOException {
        byte[] payloads = this.currentDocumentInformation.getPayloads()[this.currentTermPositionIndex];
        if (data == null || data.length - offset < this.getPayloadLength()) {
            return payloads;
        }
        System.arraycopy(payloads, 0, data, offset, payloads.length);
        return data;
    }

    public boolean isPayloadAvailable() {
        return this.currentDocumentInformation.getPayloads()[this.currentTermPositionIndex] != null;
    }

    public InstantiatedTermPositions(InstantiatedIndexReader reader) {
        super(reader);
    }

    public int nextPosition() {
        ++this.currentTermPositionIndex;
        return this.currentDocumentInformation.getTermPositions()[this.currentTermPositionIndex];
    }

    public boolean next() {
        this.currentTermPositionIndex = -1;
        return super.next();
    }

    public boolean skipTo(int target) {
        this.currentTermPositionIndex = -1;
        return super.skipTo(target);
    }
}

