/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store.instantiated;

import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.store.instantiated.InstantiatedIndexReader;
import org.apache.lucene.store.instantiated.InstantiatedTerm;
import org.apache.lucene.store.instantiated.InstantiatedTermDocumentInformation;

public class InstantiatedTermDocs
implements TermDocs {
    private final InstantiatedIndexReader reader;
    private int currentDocumentIndex;
    protected InstantiatedTermDocumentInformation currentDocumentInformation;
    protected InstantiatedTerm currentTerm;

    public InstantiatedTermDocs(InstantiatedIndexReader reader) {
        this.reader = reader;
    }

    public void seek(Term term) {
        this.currentTerm = this.reader.getIndex().findTerm(term);
        this.currentDocumentIndex = -1;
    }

    public void seek(TermEnum termEnum) {
        this.seek(termEnum.term());
    }

    public int doc() {
        return this.currentDocumentInformation.getDocument().getDocumentNumber();
    }

    public int freq() {
        return this.currentDocumentInformation.getTermPositions().length;
    }

    public boolean next() {
        if (this.currentTerm != null) {
            ++this.currentDocumentIndex;
            if (this.currentDocumentIndex < this.currentTerm.getAssociatedDocuments().length) {
                this.currentDocumentInformation = this.currentTerm.getAssociatedDocuments()[this.currentDocumentIndex];
                if (this.reader.isDeleted(this.currentDocumentInformation.getDocument().getDocumentNumber())) {
                    return this.next();
                }
                return true;
            }
            this.currentDocumentIndex = this.currentTerm.getAssociatedDocuments().length - 1;
        }
        return false;
    }

    public int read(int[] docs, int[] freqs) {
        int i;
        for (i = 0; i < docs.length && this.next(); ++i) {
            docs[i] = this.doc();
            freqs[i] = this.freq();
        }
        return i;
    }

    public boolean skipTo(int target) {
        if (this.currentTerm == null) {
            return false;
        }
        if (this.currentDocumentIndex >= target) {
            return this.next();
        }
        int startOffset = this.currentDocumentIndex >= 0 ? this.currentDocumentIndex : 0;
        int pos = this.currentTerm.seekCeilingDocumentInformationIndex(target, startOffset);
        if (pos == -1) {
            this.currentDocumentIndex = this.currentTerm.getAssociatedDocuments().length - 1;
            return false;
        }
        this.currentDocumentInformation = this.currentTerm.getAssociatedDocuments()[pos];
        this.currentDocumentIndex = pos;
        if (this.reader.hasDeletions() && this.reader.isDeleted(this.currentDocumentInformation.getDocument().getDocumentNumber())) {
            return this.next();
        }
        return true;
    }

    public void close() {
    }
}

