/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.vectorhighlight;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.MapFieldSelector;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.vectorhighlight.FieldFragList;
import org.apache.lucene.search.vectorhighlight.FieldPhraseList;
import org.apache.lucene.search.vectorhighlight.FragmentsBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseFragmentsBuilder
implements FragmentsBuilder {
    protected String[] preTags;
    protected String[] postTags;
    public static final String[] COLORED_PRE_TAGS = new String[]{"<b style=\"background:yellow\">", "<b style=\"background:lawngreen\">", "<b style=\"background:aquamarine\">", "<b style=\"background:magenta\">", "<b style=\"background:palegreen\">", "<b style=\"background:coral\">", "<b style=\"background:wheat\">", "<b style=\"background:khaki\">", "<b style=\"background:lime\">", "<b style=\"background:deepskyblue\">", "<b style=\"background:deeppink\">", "<b style=\"background:salmon\">", "<b style=\"background:peachpuff\">", "<b style=\"background:violet\">", "<b style=\"background:mediumpurple\">", "<b style=\"background:palegoldenrod\">", "<b style=\"background:darkkhaki\">", "<b style=\"background:springgreen\">", "<b style=\"background:turquoise\">", "<b style=\"background:powderblue\">"};
    public static final String[] COLORED_POST_TAGS = new String[]{"</b>"};

    protected BaseFragmentsBuilder() {
        this(new String[]{"<b>"}, new String[]{"</b>"});
    }

    protected BaseFragmentsBuilder(String[] preTags, String[] postTags) {
        this.preTags = preTags;
        this.postTags = postTags;
    }

    static Object checkTagsArgument(Object tags) {
        if (tags instanceof String) {
            return tags;
        }
        if (tags instanceof String[]) {
            return tags;
        }
        throw new IllegalArgumentException("type of preTags/postTags must be a String or String[]");
    }

    public abstract List<FieldFragList.WeightedFragInfo> getWeightedFragInfoList(List<FieldFragList.WeightedFragInfo> var1);

    @Override
    public String createFragment(IndexReader reader, int docId, String fieldName, FieldFragList fieldFragList) throws IOException {
        String[] fragments = this.createFragments(reader, docId, fieldName, fieldFragList, 1);
        if (fragments == null || fragments.length == 0) {
            return null;
        }
        return fragments[0];
    }

    @Override
    public String[] createFragments(IndexReader reader, int docId, String fieldName, FieldFragList fieldFragList, int maxNumFragments) throws IOException {
        if (maxNumFragments < 0) {
            throw new IllegalArgumentException("maxNumFragments(" + maxNumFragments + ") must be positive number.");
        }
        List<FieldFragList.WeightedFragInfo> fragInfos = this.getWeightedFragInfoList(fieldFragList.fragInfos);
        ArrayList<String> fragments = new ArrayList<String>(maxNumFragments);
        Field[] values = this.getFields(reader, docId, fieldName);
        if (values.length == 0) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        int[] nextValueIndex = new int[]{0};
        for (int n = 0; n < maxNumFragments && n < fragInfos.size(); ++n) {
            FieldFragList.WeightedFragInfo fragInfo = fragInfos.get(n);
            fragments.add(this.makeFragment(buffer, nextValueIndex, values, fragInfo));
        }
        return fragments.toArray(new String[fragments.size()]);
    }

    @Deprecated
    protected String[] getFieldValues(IndexReader reader, int docId, String fieldName) throws IOException {
        Document doc = reader.document(docId, (FieldSelector)new MapFieldSelector(new String[]{fieldName}));
        return doc.getValues(fieldName);
    }

    protected Field[] getFields(IndexReader reader, int docId, String fieldName) throws IOException {
        Document doc = reader.document(docId, (FieldSelector)new MapFieldSelector(new String[]{fieldName}));
        return doc.getFields(fieldName);
    }

    @Deprecated
    protected String makeFragment(StringBuilder buffer, int[] index, String[] values, FieldFragList.WeightedFragInfo fragInfo) {
        int s = fragInfo.startOffset;
        return this.makeFragment(fragInfo, this.getFragmentSource(buffer, index, values, s, fragInfo.endOffset), s);
    }

    protected String makeFragment(StringBuilder buffer, int[] index, Field[] values, FieldFragList.WeightedFragInfo fragInfo) {
        int s = fragInfo.startOffset;
        return this.makeFragment(fragInfo, this.getFragmentSource(buffer, index, values, s, fragInfo.endOffset), s);
    }

    private String makeFragment(FieldFragList.WeightedFragInfo fragInfo, String src, int s) {
        StringBuilder fragment = new StringBuilder();
        int srcIndex = 0;
        for (FieldFragList.WeightedFragInfo.SubInfo subInfo : fragInfo.subInfos) {
            for (FieldPhraseList.WeightedPhraseInfo.Toffs to : subInfo.termsOffsets) {
                fragment.append(src.substring(srcIndex, to.startOffset - s)).append(this.getPreTag(subInfo.seqnum)).append(src.substring(to.startOffset - s, to.endOffset - s)).append(this.getPostTag(subInfo.seqnum));
                srcIndex = to.endOffset - s;
            }
        }
        fragment.append(src.substring(srcIndex));
        return fragment.toString();
    }

    @Deprecated
    protected String getFragmentSource(StringBuilder buffer, int[] index, String[] values, int startOffset, int endOffset) {
        while (buffer.length() < endOffset && index[0] < values.length) {
            buffer.append(values[index[0]]);
            if (values[index[0]].length() > 0 && index[0] + 1 < values.length) {
                buffer.append(' ');
            }
            index[0] = index[0] + 1;
        }
        int eo = buffer.length() < endOffset ? buffer.length() : endOffset;
        return buffer.substring(startOffset, eo);
    }

    protected String getFragmentSource(StringBuilder buffer, int[] index, Field[] values, int startOffset, int endOffset) {
        while (buffer.length() < endOffset && index[0] < values.length) {
            buffer.append(values[index[0]].stringValue());
            if (values[index[0]].isTokenized() && values[index[0]].stringValue().length() > 0 && index[0] + 1 < values.length) {
                buffer.append(' ');
            }
            index[0] = index[0] + 1;
        }
        int eo = buffer.length() < endOffset ? buffer.length() : endOffset;
        return buffer.substring(startOffset, eo);
    }

    protected String getPreTag(int num) {
        int n = num % this.preTags.length;
        return this.preTags[n];
    }

    protected String getPostTag(int num) {
        int n = num % this.postTags.length;
        return this.postTags[n];
    }
}

