/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.demo.facet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.demo.facet.FacetExamples;
import org.apache.lucene.document.Document;
import org.apache.lucene.facet.DrillDownQuery;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.taxonomy.FloatAssociationFacetField;
import org.apache.lucene.facet.taxonomy.IntAssociationFacetField;
import org.apache.lucene.facet.taxonomy.TaxonomyFacetSumFloatAssociations;
import org.apache.lucene.facet.taxonomy.TaxonomyFacetSumIntAssociations;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.facet.taxonomy.TaxonomyWriter;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyReader;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyWriter;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;

public class AssociationsFacetsExample {
    private final Directory indexDir = new RAMDirectory();
    private final Directory taxoDir = new RAMDirectory();
    private final FacetsConfig config = new FacetsConfig();

    public AssociationsFacetsExample() {
        this.config.setMultiValued("tags", true);
        this.config.setIndexFieldName("tags", "$tags");
        this.config.setMultiValued("genre", true);
        this.config.setIndexFieldName("genre", "$genre");
    }

    private void index() throws IOException {
        IndexWriterConfig iwc = new IndexWriterConfig(FacetExamples.EXAMPLES_VER, (Analyzer)new WhitespaceAnalyzer(FacetExamples.EXAMPLES_VER));
        IndexWriter indexWriter = new IndexWriter(this.indexDir, iwc);
        DirectoryTaxonomyWriter taxoWriter = new DirectoryTaxonomyWriter(this.taxoDir);
        Document doc = new Document();
        doc.add((IndexableField)new IntAssociationFacetField(3, "tags", new String[]{"lucene"}));
        doc.add((IndexableField)new FloatAssociationFacetField(0.87f, "genre", new String[]{"computing"}));
        indexWriter.addDocument((Iterable)this.config.build((TaxonomyWriter)taxoWriter, doc));
        doc = new Document();
        doc.add((IndexableField)new IntAssociationFacetField(1, "tags", new String[]{"lucene"}));
        doc.add((IndexableField)new IntAssociationFacetField(2, "tags", new String[]{"solr"}));
        doc.add((IndexableField)new FloatAssociationFacetField(0.75f, "genre", new String[]{"computing"}));
        doc.add((IndexableField)new FloatAssociationFacetField(0.34f, "genre", new String[]{"software"}));
        indexWriter.addDocument((Iterable)this.config.build((TaxonomyWriter)taxoWriter, doc));
        indexWriter.close();
        taxoWriter.close();
    }

    private List<FacetResult> sumAssociations() throws IOException {
        DirectoryReader indexReader = DirectoryReader.open((Directory)this.indexDir);
        IndexSearcher searcher = new IndexSearcher((IndexReader)indexReader);
        DirectoryTaxonomyReader taxoReader = new DirectoryTaxonomyReader(this.taxoDir);
        FacetsCollector fc = new FacetsCollector();
        FacetsCollector.search((IndexSearcher)searcher, (Query)new MatchAllDocsQuery(), (int)10, (Collector)fc);
        TaxonomyFacetSumIntAssociations tags = new TaxonomyFacetSumIntAssociations("$tags", (TaxonomyReader)taxoReader, this.config, fc);
        TaxonomyFacetSumFloatAssociations genre = new TaxonomyFacetSumFloatAssociations("$genre", (TaxonomyReader)taxoReader, this.config, fc);
        ArrayList<FacetResult> results = new ArrayList<FacetResult>();
        results.add(tags.getTopChildren(10, "tags", new String[0]));
        results.add(genre.getTopChildren(10, "genre", new String[0]));
        indexReader.close();
        taxoReader.close();
        return results;
    }

    private FacetResult drillDown() throws IOException {
        DirectoryReader indexReader = DirectoryReader.open((Directory)this.indexDir);
        IndexSearcher searcher = new IndexSearcher((IndexReader)indexReader);
        DirectoryTaxonomyReader taxoReader = new DirectoryTaxonomyReader(this.taxoDir);
        DrillDownQuery q = new DrillDownQuery(this.config);
        q.add("tags", new String[]{"solr"});
        FacetsCollector fc = new FacetsCollector();
        FacetsCollector.search((IndexSearcher)searcher, (Query)q, (int)10, (Collector)fc);
        TaxonomyFacetSumFloatAssociations facets = new TaxonomyFacetSumFloatAssociations("$genre", (TaxonomyReader)taxoReader, this.config, fc);
        FacetResult result = facets.getTopChildren(10, "genre", new String[0]);
        indexReader.close();
        taxoReader.close();
        return result;
    }

    public List<FacetResult> runSumAssociations() throws IOException {
        this.index();
        return this.sumAssociations();
    }

    public FacetResult runDrillDown() throws IOException {
        this.index();
        return this.drillDown();
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Sum associations example:");
        System.out.println("-------------------------");
        List<FacetResult> results = new AssociationsFacetsExample().runSumAssociations();
        System.out.println("tags: " + results.get(0));
        System.out.println("genre: " + results.get(1));
    }
}

