/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.demo.facet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.demo.facet.FacetExamples;
import org.apache.lucene.document.Document;
import org.apache.lucene.facet.params.FacetSearchParams;
import org.apache.lucene.facet.search.CountFacetRequest;
import org.apache.lucene.facet.search.DrillDownQuery;
import org.apache.lucene.facet.search.FacetRequest;
import org.apache.lucene.facet.search.FacetResult;
import org.apache.lucene.facet.search.FacetsAccumulator;
import org.apache.lucene.facet.search.FacetsCollector;
import org.apache.lucene.facet.sortedset.SortedSetDocValuesAccumulator;
import org.apache.lucene.facet.sortedset.SortedSetDocValuesFacetFields;
import org.apache.lucene.facet.sortedset.SortedSetDocValuesReaderState;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;

public class SimpleSortedSetFacetsExample {
    private final Directory indexDir = new RAMDirectory();

    private void add(IndexWriter indexWriter, SortedSetDocValuesFacetFields facetFields, String ... categoryPaths) throws IOException {
        Document doc = new Document();
        ArrayList<CategoryPath> paths = new ArrayList<CategoryPath>();
        for (String categoryPath : categoryPaths) {
            paths.add(new CategoryPath(categoryPath, '/'));
        }
        facetFields.addFields(doc, paths);
        indexWriter.addDocument((Iterable)doc);
    }

    private void index() throws IOException {
        IndexWriter indexWriter = new IndexWriter(this.indexDir, new IndexWriterConfig(FacetExamples.EXAMPLES_VER, (Analyzer)new WhitespaceAnalyzer(FacetExamples.EXAMPLES_VER)));
        SortedSetDocValuesFacetFields facetFields = new SortedSetDocValuesFacetFields();
        this.add(indexWriter, facetFields, "Author/Bob", "Publish Year/2010");
        this.add(indexWriter, facetFields, "Author/Lisa", "Publish Year/2010");
        this.add(indexWriter, facetFields, "Author/Lisa", "Publish Year/2012");
        this.add(indexWriter, facetFields, "Author/Susan", "Publish Year/2012");
        this.add(indexWriter, facetFields, "Author/Frank", "Publish Year/1999");
        indexWriter.close();
    }

    private List<FacetResult> search() throws IOException {
        DirectoryReader indexReader = DirectoryReader.open((Directory)this.indexDir);
        IndexSearcher searcher = new IndexSearcher((IndexReader)indexReader);
        SortedSetDocValuesReaderState state = new SortedSetDocValuesReaderState((IndexReader)indexReader);
        FacetSearchParams fsp = new FacetSearchParams(new FacetRequest[]{new CountFacetRequest(new CategoryPath(new String[]{"Publish Year"}), 10), new CountFacetRequest(new CategoryPath(new String[]{"Author"}), 10)});
        FacetsCollector fc = FacetsCollector.create((FacetsAccumulator)new SortedSetDocValuesAccumulator(state, fsp));
        searcher.search((Query)new MatchAllDocsQuery(), (Collector)fc);
        List facetResults = fc.getFacetResults();
        indexReader.close();
        return facetResults;
    }

    private List<FacetResult> drillDown() throws IOException {
        DirectoryReader indexReader = DirectoryReader.open((Directory)this.indexDir);
        IndexSearcher searcher = new IndexSearcher((IndexReader)indexReader);
        SortedSetDocValuesReaderState state = new SortedSetDocValuesReaderState((IndexReader)indexReader);
        FacetSearchParams fsp = new FacetSearchParams(new FacetRequest[]{new CountFacetRequest(new CategoryPath(new String[]{"Author"}), 10)});
        DrillDownQuery q = new DrillDownQuery(fsp.indexingParams, (Query)new MatchAllDocsQuery());
        q.add(new CategoryPath[]{new CategoryPath("Publish Year/2010", '/')});
        FacetsCollector fc = FacetsCollector.create((FacetsAccumulator)new SortedSetDocValuesAccumulator(state, fsp));
        searcher.search((Query)q, (Collector)fc);
        List facetResults = fc.getFacetResults();
        indexReader.close();
        return facetResults;
    }

    public List<FacetResult> runSearch() throws IOException {
        this.index();
        return this.search();
    }

    public List<FacetResult> runDrillDown() throws IOException {
        this.index();
        return this.drillDown();
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Facet counting example:");
        System.out.println("-----------------------");
        List<FacetResult> results = new SimpleSortedSetFacetsExample().runSearch();
        for (FacetResult res : results) {
            System.out.println(res);
        }
        System.out.println("\n");
        System.out.println("Facet drill-down example (Publish Year/2010):");
        System.out.println("---------------------------------------------");
        results = new SimpleSortedSetFacetsExample().runDrillDown();
        for (FacetResult res : results) {
            System.out.println(res);
        }
    }
}

