/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.demo.facet;

import java.io.IOException;
import java.text.ParseException;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.demo.facet.FacetExamples;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.expressions.Bindings;
import org.apache.lucene.expressions.Expression;
import org.apache.lucene.expressions.SimpleBindings;
import org.apache.lucene.expressions.js.JavascriptCompiler;
import org.apache.lucene.facet.index.FacetFields;
import org.apache.lucene.facet.params.FacetSearchParams;
import org.apache.lucene.facet.search.FacetRequest;
import org.apache.lucene.facet.search.FacetResult;
import org.apache.lucene.facet.search.FacetsCollector;
import org.apache.lucene.facet.search.SumValueSourceFacetRequest;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.facet.taxonomy.TaxonomyWriter;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyReader;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyWriter;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;

public class ExpressionAggregationFacetsExample {
    private final Directory indexDir = new RAMDirectory();
    private final Directory taxoDir = new RAMDirectory();

    private void add(IndexWriter indexWriter, FacetFields facetFields, String text, String category, long popularity) throws IOException {
        Document doc = new Document();
        doc.add((IndexableField)new TextField("c", text, Field.Store.NO));
        doc.add((IndexableField)new NumericDocValuesField("popularity", popularity));
        facetFields.addFields(doc, Collections.singletonList(new CategoryPath(category, '/')));
        indexWriter.addDocument((Iterable)doc);
    }

    private void index() throws IOException {
        IndexWriter indexWriter = new IndexWriter(this.indexDir, new IndexWriterConfig(FacetExamples.EXAMPLES_VER, (Analyzer)new WhitespaceAnalyzer(FacetExamples.EXAMPLES_VER)));
        DirectoryTaxonomyWriter taxoWriter = new DirectoryTaxonomyWriter(this.taxoDir);
        FacetFields facetFields = new FacetFields((TaxonomyWriter)taxoWriter);
        this.add(indexWriter, facetFields, "foo bar", "A/B", 5L);
        this.add(indexWriter, facetFields, "foo foo bar", "A/C", 3L);
        indexWriter.close();
        taxoWriter.close();
    }

    private List<FacetResult> search() throws IOException, ParseException {
        DirectoryReader indexReader = DirectoryReader.open((Directory)this.indexDir);
        IndexSearcher searcher = new IndexSearcher((IndexReader)indexReader);
        DirectoryTaxonomyReader taxoReader = new DirectoryTaxonomyReader(this.taxoDir);
        Expression expr = JavascriptCompiler.compile((String)"_score * sqrt(popularity)");
        SimpleBindings bindings = new SimpleBindings();
        bindings.add(new SortField("_score", SortField.Type.SCORE));
        bindings.add(new SortField("popularity", SortField.Type.LONG));
        FacetSearchParams fsp = new FacetSearchParams(new FacetRequest[]{new SumValueSourceFacetRequest(new CategoryPath(new String[]{"A"}), 10, expr.getValueSource((Bindings)bindings), true)});
        FacetsCollector fc = FacetsCollector.create((FacetSearchParams)fsp, (IndexReader)searcher.getIndexReader(), (TaxonomyReader)taxoReader);
        searcher.search((Query)new MatchAllDocsQuery(), (Collector)fc);
        List facetResults = fc.getFacetResults();
        indexReader.close();
        taxoReader.close();
        return facetResults;
    }

    public List<FacetResult> runSearch() throws IOException, ParseException {
        this.index();
        return this.search();
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Facet counting example:");
        System.out.println("-----------------------");
        List<FacetResult> results = new ExpressionAggregationFacetsExample().runSearch();
        for (FacetResult res : results) {
            System.out.println(res);
        }
    }
}

