/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.demo.facet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.demo.facet.FacetExamples;
import org.apache.lucene.document.Document;
import org.apache.lucene.facet.index.FacetFields;
import org.apache.lucene.facet.params.FacetSearchParams;
import org.apache.lucene.facet.search.CountFacetRequest;
import org.apache.lucene.facet.search.DrillDownQuery;
import org.apache.lucene.facet.search.FacetRequest;
import org.apache.lucene.facet.search.FacetResult;
import org.apache.lucene.facet.search.FacetsCollector;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.facet.taxonomy.TaxonomyWriter;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyReader;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyWriter;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;

public class SimpleFacetsExample {
    private final Directory indexDir = new RAMDirectory();
    private final Directory taxoDir = new RAMDirectory();

    private void add(IndexWriter indexWriter, FacetFields facetFields, String ... categoryPaths) throws IOException {
        Document doc = new Document();
        ArrayList<CategoryPath> paths = new ArrayList<CategoryPath>();
        for (String categoryPath : categoryPaths) {
            paths.add(new CategoryPath(categoryPath, '/'));
        }
        facetFields.addFields(doc, paths);
        indexWriter.addDocument((Iterable)doc);
    }

    private void index() throws IOException {
        IndexWriter indexWriter = new IndexWriter(this.indexDir, new IndexWriterConfig(FacetExamples.EXAMPLES_VER, (Analyzer)new WhitespaceAnalyzer(FacetExamples.EXAMPLES_VER)));
        DirectoryTaxonomyWriter taxoWriter = new DirectoryTaxonomyWriter(this.taxoDir);
        FacetFields facetFields = new FacetFields((TaxonomyWriter)taxoWriter);
        this.add(indexWriter, facetFields, "Author/Bob", "Publish Date/2010/10/15");
        this.add(indexWriter, facetFields, "Author/Lisa", "Publish Date/2010/10/20");
        this.add(indexWriter, facetFields, "Author/Lisa", "Publish Date/2012/1/1");
        this.add(indexWriter, facetFields, "Author/Susan", "Publish Date/2012/1/7");
        this.add(indexWriter, facetFields, "Author/Frank", "Publish Date/1999/5/5");
        indexWriter.close();
        taxoWriter.close();
    }

    private List<FacetResult> search() throws IOException {
        DirectoryReader indexReader = DirectoryReader.open((Directory)this.indexDir);
        IndexSearcher searcher = new IndexSearcher((IndexReader)indexReader);
        DirectoryTaxonomyReader taxoReader = new DirectoryTaxonomyReader(this.taxoDir);
        FacetSearchParams fsp = new FacetSearchParams(new FacetRequest[]{new CountFacetRequest(new CategoryPath(new String[]{"Publish Date"}), 10), new CountFacetRequest(new CategoryPath(new String[]{"Author"}), 10)});
        FacetsCollector fc = FacetsCollector.create((FacetSearchParams)fsp, (IndexReader)searcher.getIndexReader(), (TaxonomyReader)taxoReader);
        searcher.search((Query)new MatchAllDocsQuery(), (Collector)fc);
        List facetResults = fc.getFacetResults();
        indexReader.close();
        taxoReader.close();
        return facetResults;
    }

    private List<FacetResult> drillDown() throws IOException {
        DirectoryReader indexReader = DirectoryReader.open((Directory)this.indexDir);
        IndexSearcher searcher = new IndexSearcher((IndexReader)indexReader);
        DirectoryTaxonomyReader taxoReader = new DirectoryTaxonomyReader(this.taxoDir);
        FacetSearchParams fsp = new FacetSearchParams(new FacetRequest[]{new CountFacetRequest(new CategoryPath(new String[]{"Author"}), 10)});
        DrillDownQuery q = new DrillDownQuery(fsp.indexingParams);
        q.add(new CategoryPath[]{new CategoryPath("Publish Date/2010", '/')});
        FacetsCollector fc = FacetsCollector.create((FacetSearchParams)fsp, (IndexReader)searcher.getIndexReader(), (TaxonomyReader)taxoReader);
        searcher.search((Query)q, (Collector)fc);
        List facetResults = fc.getFacetResults();
        indexReader.close();
        taxoReader.close();
        return facetResults;
    }

    public List<FacetResult> runSearch() throws IOException {
        this.index();
        return this.search();
    }

    public List<FacetResult> runDrillDown() throws IOException {
        this.index();
        return this.drillDown();
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Facet counting example:");
        System.out.println("-----------------------");
        List<FacetResult> results = new SimpleFacetsExample().runSearch();
        for (FacetResult res : results) {
            System.out.println(res);
        }
        System.out.println("\n");
        System.out.println("Facet drill-down example (Publish Date/2010):");
        System.out.println("---------------------------------------------");
        results = new SimpleFacetsExample().runDrillDown();
        for (FacetResult res : results) {
            System.out.println(res);
        }
    }
}

