/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.demo.facet;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.demo.facet.FacetExamples;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.facet.params.FacetIndexingParams;
import org.apache.lucene.facet.range.LongRange;
import org.apache.lucene.facet.range.Range;
import org.apache.lucene.facet.range.RangeAccumulator;
import org.apache.lucene.facet.range.RangeFacetRequest;
import org.apache.lucene.facet.search.DrillDownQuery;
import org.apache.lucene.facet.search.FacetRequest;
import org.apache.lucene.facet.search.FacetResult;
import org.apache.lucene.facet.search.FacetsAccumulator;
import org.apache.lucene.facet.search.FacetsCollector;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;

public class RangeFacetsExample
implements Closeable {
    private final Directory indexDir = new RAMDirectory();
    private IndexSearcher searcher;
    private final long nowSec = System.currentTimeMillis();

    public void index() throws IOException {
        IndexWriter indexWriter = new IndexWriter(this.indexDir, new IndexWriterConfig(FacetExamples.EXAMPLES_VER, (Analyzer)new WhitespaceAnalyzer(FacetExamples.EXAMPLES_VER)));
        for (int i = 0; i < 100; ++i) {
            Document doc = new Document();
            long then = this.nowSec - (long)(i * 1000);
            doc.add((IndexableField)new NumericDocValuesField("timestamp", then));
            doc.add((IndexableField)new LongField("timestamp", then, Field.Store.NO));
            indexWriter.addDocument((Iterable)doc);
        }
        this.searcher = new IndexSearcher((IndexReader)DirectoryReader.open((IndexWriter)indexWriter, (boolean)true));
        indexWriter.close();
    }

    public List<FacetResult> search() throws IOException {
        RangeFacetRequest rangeFacetRequest = new RangeFacetRequest("timestamp", (Range[])new LongRange[]{new LongRange("Past hour", this.nowSec - 3600L, true, this.nowSec, true), new LongRange("Past six hours", this.nowSec - 21600L, true, this.nowSec, true), new LongRange("Past day", this.nowSec - 86400L, true, this.nowSec, true)});
        FacetsCollector fc = FacetsCollector.create((FacetsAccumulator)new RangeAccumulator(new FacetRequest[]{rangeFacetRequest}));
        this.searcher.search((Query)new MatchAllDocsQuery(), (Collector)fc);
        return fc.getFacetResults();
    }

    public TopDocs drillDown(LongRange range) throws IOException {
        DrillDownQuery q = new DrillDownQuery(FacetIndexingParams.DEFAULT);
        q.add("timestamp", (Query)NumericRangeQuery.newLongRange((String)"timestamp", (Long)range.min, (Long)range.max, (boolean)range.minInclusive, (boolean)range.maxInclusive));
        return this.searcher.search((Query)q, 10);
    }

    @Override
    public void close() throws IOException {
        this.searcher.getIndexReader().close();
        this.indexDir.close();
    }

    public static void main(String[] args) throws Exception {
        RangeFacetsExample example = new RangeFacetsExample();
        example.index();
        System.out.println("Facet counting example:");
        System.out.println("-----------------------");
        List<FacetResult> results = example.search();
        for (FacetResult res : results) {
            System.out.println(res);
        }
        System.out.println("\n");
        System.out.println("Facet drill-down example (timestamp/Past six hours):");
        System.out.println("---------------------------------------------");
        TopDocs hits = example.drillDown((LongRange)((RangeFacetRequest)results.get((int)0).getFacetRequest()).ranges[1]);
        System.out.println(hits.totalHits + " totalHits");
        example.close();
    }
}

