/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.demo.facet;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.demo.facet.FacetExamples;
import org.apache.lucene.document.Document;
import org.apache.lucene.facet.associations.AssociationFloatSumFacetRequest;
import org.apache.lucene.facet.associations.AssociationIntSumFacetRequest;
import org.apache.lucene.facet.associations.AssociationsFacetFields;
import org.apache.lucene.facet.associations.CategoryAssociation;
import org.apache.lucene.facet.associations.CategoryAssociationsContainer;
import org.apache.lucene.facet.associations.CategoryFloatAssociation;
import org.apache.lucene.facet.associations.CategoryIntAssociation;
import org.apache.lucene.facet.associations.MultiAssociationsFacetsAggregator;
import org.apache.lucene.facet.associations.SumFloatAssociationFacetsAggregator;
import org.apache.lucene.facet.associations.SumIntAssociationFacetsAggregator;
import org.apache.lucene.facet.params.FacetSearchParams;
import org.apache.lucene.facet.search.FacetRequest;
import org.apache.lucene.facet.search.FacetResult;
import org.apache.lucene.facet.search.FacetsAccumulator;
import org.apache.lucene.facet.search.FacetsAggregator;
import org.apache.lucene.facet.search.FacetsCollector;
import org.apache.lucene.facet.taxonomy.CategoryPath;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.facet.taxonomy.TaxonomyWriter;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyReader;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyWriter;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;

public class AssociationsFacetsExample {
    public static CategoryPath[][] CATEGORIES = new CategoryPath[][]{{new CategoryPath(new String[]{"tags", "lucene"}), new CategoryPath(new String[]{"genre", "computing"})}, {new CategoryPath(new String[]{"tags", "lucene"}), new CategoryPath(new String[]{"tags", "solr"}), new CategoryPath(new String[]{"genre", "computing"}), new CategoryPath(new String[]{"genre", "software"})}};
    public static CategoryAssociation[][] ASSOCIATIONS = new CategoryAssociation[][]{{new CategoryIntAssociation(3), new CategoryFloatAssociation(0.87f)}, {new CategoryIntAssociation(1), new CategoryIntAssociation(2), new CategoryFloatAssociation(0.75f), new CategoryFloatAssociation(0.34f)}};
    private final Directory indexDir = new RAMDirectory();
    private final Directory taxoDir = new RAMDirectory();

    private void index() throws IOException {
        IndexWriter indexWriter = new IndexWriter(this.indexDir, new IndexWriterConfig(FacetExamples.EXAMPLES_VER, (Analyzer)new WhitespaceAnalyzer(FacetExamples.EXAMPLES_VER)));
        DirectoryTaxonomyWriter taxoWriter = new DirectoryTaxonomyWriter(this.taxoDir, IndexWriterConfig.OpenMode.CREATE);
        AssociationsFacetFields facetFields = new AssociationsFacetFields((TaxonomyWriter)taxoWriter);
        for (int i = 0; i < CATEGORIES.length; ++i) {
            Document doc = new Document();
            CategoryAssociationsContainer associations = new CategoryAssociationsContainer();
            for (int j = 0; j < CATEGORIES[i].length; ++j) {
                associations.setAssociation(CATEGORIES[i][j], ASSOCIATIONS[i][j]);
            }
            facetFields.addFields(doc, (Iterable)associations);
            indexWriter.addDocument((Iterable)doc);
        }
        indexWriter.close();
        taxoWriter.close();
    }

    private List<FacetResult> sumAssociations() throws IOException {
        DirectoryReader indexReader = DirectoryReader.open((Directory)this.indexDir);
        IndexSearcher searcher = new IndexSearcher((IndexReader)indexReader);
        DirectoryTaxonomyReader taxoReader = new DirectoryTaxonomyReader(this.taxoDir);
        CategoryPath tags = new CategoryPath(new String[]{"tags"});
        CategoryPath genre = new CategoryPath(new String[]{"genre"});
        FacetSearchParams fsp = new FacetSearchParams(new FacetRequest[]{new AssociationIntSumFacetRequest(tags, 10), new AssociationFloatSumFacetRequest(genre, 10)});
        final HashMap<CategoryPath, Object> aggregators = new HashMap<CategoryPath, Object>();
        aggregators.put(tags, new SumIntAssociationFacetsAggregator());
        aggregators.put(genre, new SumFloatAssociationFacetsAggregator());
        FacetsAccumulator fa = new FacetsAccumulator(fsp, (IndexReader)indexReader, (TaxonomyReader)taxoReader){

            public FacetsAggregator getAggregator() {
                return new MultiAssociationsFacetsAggregator(aggregators);
            }
        };
        FacetsCollector fc = FacetsCollector.create((FacetsAccumulator)fa);
        searcher.search((Query)new MatchAllDocsQuery(), (Collector)fc);
        List facetResults = fc.getFacetResults();
        indexReader.close();
        taxoReader.close();
        return facetResults;
    }

    public List<FacetResult> runSumAssociations() throws IOException {
        this.index();
        return this.sumAssociations();
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Sum associations example:");
        System.out.println("-------------------------");
        List<FacetResult> results = new AssociationsFacetsExample().runSumAssociations();
        for (FacetResult res : results) {
            System.out.println(res);
        }
    }
}

