/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.demo;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Date;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.document.NumericField;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;

public class IndexFiles {
    private IndexFiles() {
    }

    public static void main(String[] args) {
        File docDir;
        String usage = "java org.apache.lucene.demo.IndexFiles [-index INDEX_PATH] [-docs DOCS_PATH] [-update]\n\nThis indexes the documents in DOCS_PATH, creating a Lucene indexin INDEX_PATH that can be searched with SearchFiles";
        String indexPath = "index";
        String docsPath = null;
        boolean create = true;
        for (int i = 0; i < args.length; ++i) {
            if ("-index".equals(args[i])) {
                indexPath = args[i + 1];
                ++i;
                continue;
            }
            if ("-docs".equals(args[i])) {
                docsPath = args[i + 1];
                ++i;
                continue;
            }
            if (!"-update".equals(args[i])) continue;
            create = false;
        }
        if (docsPath == null) {
            System.err.println("Usage: " + usage);
            System.exit(1);
        }
        if (!(docDir = new File(docsPath)).exists() || !docDir.canRead()) {
            System.out.println("Document directory '" + docDir.getAbsolutePath() + "' does not exist or is not readable, please check the path");
            System.exit(1);
        }
        Date start = new Date();
        try {
            System.out.println("Indexing to directory '" + indexPath + "'...");
            FSDirectory dir = FSDirectory.open((File)new File(indexPath));
            StandardAnalyzer analyzer = new StandardAnalyzer(Version.LUCENE_31);
            IndexWriterConfig iwc = new IndexWriterConfig(Version.LUCENE_31, (Analyzer)analyzer);
            if (create) {
                iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
            } else {
                iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
            }
            IndexWriter writer = new IndexWriter((Directory)dir, iwc);
            IndexFiles.indexDocs(writer, docDir);
            writer.close();
            Date end = new Date();
            System.out.println(end.getTime() - start.getTime() + " total milliseconds");
        }
        catch (IOException e) {
            System.out.println(" caught a " + e.getClass() + "\n with message: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void indexDocs(IndexWriter writer, File file) throws IOException {
        block7: {
            FileInputStream fis;
            block8: {
                if (!file.canRead()) break block7;
                if (!file.isDirectory()) break block8;
                String[] files = file.list();
                if (files == null) break block7;
                for (int i = 0; i < files.length; ++i) {
                    IndexFiles.indexDocs(writer, new File(file, files[i]));
                }
                break block7;
            }
            try {
                fis = new FileInputStream(file);
            }
            catch (FileNotFoundException fnfe) {
                return;
            }
            try {
                Document doc = new Document();
                Field pathField = new Field("path", file.getPath(), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS);
                pathField.setIndexOptions(FieldInfo.IndexOptions.DOCS_ONLY);
                doc.add((Fieldable)pathField);
                NumericField modifiedField = new NumericField("modified");
                modifiedField.setLongValue(file.lastModified());
                doc.add((Fieldable)modifiedField);
                doc.add((Fieldable)new Field("contents", (Reader)new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"))));
                if (writer.getConfig().getOpenMode() == IndexWriterConfig.OpenMode.CREATE) {
                    System.out.println("adding " + file);
                    writer.addDocument(doc);
                }
                System.out.println("updating " + file);
                writer.updateDocument(new Term("path", file.getPath()), doc);
            }
            finally {
                fis.close();
            }
        }
    }
}

