/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.slf4j;

import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.spi.ThreadContextMap;
import org.apache.logging.log4j.util.SortedArrayStringMap;
import org.apache.logging.log4j.util.StringMap;
import org.slf4j.MDC;

public class MDCContextMap
implements ThreadContextMap {
    private static final StringMap EMPTY_CONTEXT_DATA = new SortedArrayStringMap(1);

    public void put(String key, String value) {
        MDC.put((String)key, (String)value);
    }

    public void putAll(Map<String, String> m) {
        for (Map.Entry<String, String> entry : m.entrySet()) {
            MDC.put((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public String get(String key) {
        return MDC.get((String)key);
    }

    public void remove(String key) {
        MDC.remove((String)key);
    }

    public void removeAll(Iterable<String> keys) {
        for (String key : keys) {
            MDC.remove((String)key);
        }
    }

    public void clear() {
        MDC.clear();
    }

    public boolean containsKey(String key) {
        Map map = MDC.getCopyOfContextMap();
        return map != null && map.containsKey(key);
    }

    public Map<String, String> getCopy() {
        Map contextMap = MDC.getCopyOfContextMap();
        return contextMap != null ? contextMap : new HashMap();
    }

    public Map<String, String> getImmutableMapOrNull() {
        return MDC.getCopyOfContextMap();
    }

    public boolean isEmpty() {
        Map map = MDC.getCopyOfContextMap();
        return map == null || map.isEmpty();
    }

    public StringMap getReadOnlyContextData() {
        Map<String, String> copy = this.getCopy();
        if (copy.isEmpty()) {
            return EMPTY_CONTEXT_DATA;
        }
        SortedArrayStringMap result = new SortedArrayStringMap();
        for (Map.Entry<String, String> entry : copy.entrySet()) {
            result.putValue(entry.getKey(), (Object)entry.getValue());
        }
        return result;
    }

    static {
        EMPTY_CONTEXT_DATA.freeze();
    }
}

