/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json.resolver;

import org.apache.logging.log4j.layout.template.json.resolver.EventResolver;
import org.apache.logging.log4j.layout.template.json.resolver.EventResolverContext;
import org.apache.logging.log4j.layout.template.json.resolver.TemplateResolverConfig;

abstract class ExceptionInternalResolverFactory {
    private static final EventResolver NULL_RESOLVER = (ignored, jsonGenerator) -> jsonGenerator.writeNull();

    ExceptionInternalResolverFactory() {
    }

    EventResolver createInternalResolver(EventResolverContext context, TemplateResolverConfig config) {
        String fieldName;
        switch (fieldName = config.getString("field")) {
            case "className": {
                return this.createClassNameResolver();
            }
            case "message": {
                return this.createMessageResolver(context);
            }
            case "stackTrace": {
                return this.createStackTraceResolver(context, config);
            }
        }
        throw new IllegalArgumentException("unknown field: " + config);
    }

    abstract EventResolver createClassNameResolver();

    abstract EventResolver createMessageResolver(EventResolverContext var1);

    private EventResolver createStackTraceResolver(EventResolverContext context, TemplateResolverConfig config) {
        if (!context.isStackTraceEnabled()) {
            return NULL_RESOLVER;
        }
        boolean stringified = config.getBoolean("stringified", false);
        return stringified ? this.createStackTraceStringResolver(context) : this.createStackTraceObjectResolver(context);
    }

    abstract EventResolver createStackTraceStringResolver(EventResolverContext var1);

    abstract EventResolver createStackTraceObjectResolver(EventResolverContext var1);
}

