/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.jmx.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.management.JMException;
import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import org.apache.logging.log4j.core.jmx.LoggerContextAdminMBean;
import org.apache.logging.log4j.core.jmx.Server;
import org.apache.logging.log4j.core.jmx.StatusLoggerAdminMBean;
import org.apache.logging.log4j.core.util.Assert;

public class Client {
    private JMXConnector connector;
    private final MBeanServerConnection connection;

    public Client(JMXConnector connector) throws MalformedObjectNameException, IOException {
        this.connector = (JMXConnector)Assert.requireNonNull((Object)connector, (String)"JMXConnector");
        this.connector.connect();
        this.connection = connector.getMBeanServerConnection();
        this.init();
    }

    public Client(MBeanServerConnection mBeanServerConnection) throws MalformedObjectNameException, IOException {
        this.connection = mBeanServerConnection;
        this.init();
    }

    private void init() throws MalformedObjectNameException, IOException {
    }

    private Set<ObjectName> find(String pattern) throws JMException, IOException {
        ObjectName search = new ObjectName(String.format(pattern, "*"));
        Set<ObjectName> result = this.connection.queryNames(search, null);
        return result;
    }

    public List<LoggerContextAdminMBean> getLoggerContextAdmins() throws JMException, IOException {
        ArrayList<LoggerContextAdminMBean> result = new ArrayList<LoggerContextAdminMBean>();
        Set<ObjectName> contextNames = this.find("org.apache.logging.log4j2:type=%s");
        for (ObjectName contextName : contextNames) {
            result.add(this.getLoggerContextAdmin(contextName));
        }
        return result;
    }

    public LoggerContextAdminMBean getLoggerContextAdmin(ObjectName name) {
        LoggerContextAdminMBean ctx = JMX.newMBeanProxy(this.connection, name, LoggerContextAdminMBean.class, false);
        return ctx;
    }

    public void close() {
        try {
            this.connector.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public MBeanServerConnection getConnection() {
        return this.connection;
    }

    public StatusLoggerAdminMBean getStatusLoggerAdmin(String contextName) throws MalformedObjectNameException, IOException {
        String pattern = "org.apache.logging.log4j2:type=%s,component=StatusLogger";
        String mbean = String.format("org.apache.logging.log4j2:type=%s,component=StatusLogger", Server.escape((String)contextName));
        ObjectName search = new ObjectName(mbean);
        Set<ObjectName> result = this.connection.queryNames(search, null);
        if (result.size() == 0) {
            return null;
        }
        if (result.size() > 1) {
            System.err.println("WARN: multiple status loggers found for " + contextName + ": " + result);
        }
        StatusLoggerAdminMBean proxy = JMX.newMBeanProxy(this.connection, result.iterator().next(), StatusLoggerAdminMBean.class, true);
        return proxy;
    }

    public boolean isLoggerContext(ObjectName mbeanName) {
        return "org.apache.logging.log4j2".equals(mbeanName.getDomain()) && mbeanName.getKeyPropertyList().containsKey("type") && mbeanName.getKeyPropertyList().size() == 1;
    }

    public ObjectName getStatusLoggerObjectName(ObjectName loggerContextObjName) {
        if (!this.isLoggerContext(loggerContextObjName)) {
            throw new IllegalArgumentException("Not a LoggerContext: " + loggerContextObjName);
        }
        String cxtName = loggerContextObjName.getKeyProperty("type");
        String name = String.format("org.apache.logging.log4j2:type=%s,component=StatusLogger", cxtName);
        try {
            return new ObjectName(name);
        }
        catch (MalformedObjectNameException ex) {
            throw new IllegalStateException(name, ex);
        }
    }
}

