/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.flume.appender;

import java.util.Properties;
import org.apache.flume.Event;
import org.apache.flume.api.RpcClient;
import org.apache.flume.api.RpcClientFactory;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.flume.appender.AbstractFlumeManager;
import org.apache.logging.log4j.flume.appender.Agent;
import org.apache.logging.log4j.flume.appender.BatchEvent;

public class FlumeAvroManager
extends AbstractFlumeManager {
    private static final int MAX_RECONNECTS = 3;
    private static final int MINIMUM_TIMEOUT = 1000;
    private static AvroManagerFactory factory = new AvroManagerFactory();
    private final Agent[] agents;
    private final int batchSize;
    private final int retries;
    private final int connectTimeout;
    private final int requestTimeout;
    private final int current = 0;
    private RpcClient rpcClient = null;

    protected FlumeAvroManager(String name, String shortName, Agent[] agents, int batchSize, int retries, int connectTimeout, int requestTimeout) {
        super(name);
        this.agents = agents;
        this.batchSize = batchSize;
        this.retries = retries;
        this.connectTimeout = connectTimeout;
        this.requestTimeout = requestTimeout;
        this.rpcClient = this.connect(agents, retries, connectTimeout, requestTimeout);
    }

    public static FlumeAvroManager getManager(String name, Agent[] agents, int batchSize, int retries, int connectTimeout, int requestTimeout) {
        if (agents == null || agents.length == 0) {
            throw new IllegalArgumentException("At least one agent is required");
        }
        if (batchSize <= 0) {
            batchSize = 1;
        }
        StringBuilder sb = new StringBuilder("FlumeAvro[");
        boolean first = true;
        for (Agent agent : agents) {
            if (!first) {
                sb.append(',');
            }
            sb.append(agent.getHost()).append(':').append(agent.getPort());
            first = false;
        }
        sb.append(']');
        return (FlumeAvroManager)FlumeAvroManager.getManager((String)sb.toString(), (ManagerFactory)factory, (Object)new FactoryData(name, agents, batchSize, retries, connectTimeout, requestTimeout));
    }

    public Agent[] getAgents() {
        return this.agents;
    }

    public int getCurrent() {
        return 0;
    }

    public int getRetries() {
        return this.retries;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public synchronized void send(BatchEvent events) {
        if (this.rpcClient == null) {
            this.rpcClient = this.connect(this.agents, this.retries, this.connectTimeout, this.requestTimeout);
        }
        if (this.rpcClient != null) {
            try {
                LOGGER.trace("Sending batch of {} events", new Object[]{events.getEvents().size()});
                this.rpcClient.appendBatch(events.getEvents());
            }
            catch (Exception ex) {
                this.rpcClient.close();
                this.rpcClient = null;
                String msg = "Unable to write to " + this.getName() + " at " + this.agents[0].getHost() + ':' + this.agents[0].getPort();
                LOGGER.warn(msg, (Throwable)ex);
                throw new AppenderLoggingException("No Flume agents are available");
            }
        } else {
            String msg = "Unable to write to " + this.getName() + " at " + this.agents[0].getHost() + ':' + this.agents[0].getPort();
            LOGGER.warn(msg);
            throw new AppenderLoggingException("No Flume agents are available");
        }
    }

    @Override
    public synchronized void send(Event event) {
        if (this.rpcClient == null) {
            this.rpcClient = this.connect(this.agents, this.retries, this.connectTimeout, this.requestTimeout);
        }
        if (this.rpcClient != null) {
            try {
                this.rpcClient.append(event);
            }
            catch (Exception ex) {
                this.rpcClient.close();
                this.rpcClient = null;
                String msg = "Unable to write to " + this.getName() + " at " + this.agents[0].getHost() + ':' + this.agents[0].getPort();
                LOGGER.warn(msg, (Throwable)ex);
                throw new AppenderLoggingException("No Flume agents are available");
            }
        } else {
            String msg = "Unable to write to " + this.getName() + " at " + this.agents[0].getHost() + ':' + this.agents[0].getPort();
            LOGGER.warn(msg);
            throw new AppenderLoggingException("No Flume agents are available");
        }
    }

    private RpcClient connect(Agent[] agents, int retries, int connectTimeout, int requestTimeout) {
        try {
            Properties props = new Properties();
            props.put("client.type", "default_failover");
            int count = 1;
            StringBuilder sb = new StringBuilder();
            for (Agent agent : agents) {
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                String hostName = "host" + count++;
                props.put("hosts." + hostName, agent.getHost() + ':' + agent.getPort());
                sb.append(hostName);
            }
            props.put("hosts", sb.toString());
            if (this.batchSize > 0) {
                props.put("batch-size", Integer.toString(this.batchSize));
            }
            if (retries > 1) {
                if (retries > 3) {
                    retries = 3;
                }
                props.put("max-attempts", Integer.toString(retries * agents.length));
            }
            if (requestTimeout >= 1000) {
                props.put("request-timeout", Integer.toString(requestTimeout));
            }
            if (connectTimeout >= 1000) {
                props.put("connect-timeout", Integer.toString(connectTimeout));
            }
            return RpcClientFactory.getInstance((Properties)props);
        }
        catch (Exception ex) {
            LOGGER.error("Unable to create Flume RPCClient: {}", new Object[]{ex.getMessage()});
            return null;
        }
    }

    protected void releaseSub() {
        if (this.rpcClient != null) {
            try {
                this.rpcClient.close();
            }
            catch (Exception ex) {
                LOGGER.error("Attempt to close RPC client failed", (Throwable)ex);
            }
        }
        this.rpcClient = null;
    }

    private static class AvroManagerFactory
    implements ManagerFactory<FlumeAvroManager, FactoryData> {
        private AvroManagerFactory() {
        }

        public FlumeAvroManager createManager(String name, FactoryData data) {
            try {
                return new FlumeAvroManager(name, data.name, data.agents, data.batchSize, data.retries, data.conntectTimeout, data.requestTimeout);
            }
            catch (Exception ex) {
                LOGGER.error("Could not create FlumeAvroManager", (Throwable)ex);
                return null;
            }
        }
    }

    private static class FactoryData {
        private final String name;
        private final Agent[] agents;
        private final int batchSize;
        private final int retries;
        private final int conntectTimeout;
        private final int requestTimeout;

        public FactoryData(String name, Agent[] agents, int batchSize, int retries, int connectTimeout, int requestTimeout) {
            this.name = name;
            this.agents = agents;
            this.batchSize = batchSize;
            this.retries = retries;
            this.conntectTimeout = connectTimeout;
            this.requestTimeout = requestTimeout;
        }
    }
}

