/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.flume.appender;

import java.util.Locale;
import java.util.Properties;
import org.apache.flume.Event;
import org.apache.flume.SourceRunner;
import org.apache.flume.node.NodeConfiguration;
import org.apache.flume.node.NodeManager;
import org.apache.flume.node.nodemanager.DefaultLogicalNodeManager;
import org.apache.flume.node.nodemanager.NodeConfigurationAware;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.core.config.ConfigurationException;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.helpers.NameUtil;
import org.apache.logging.log4j.flume.appender.AbstractFlumeManager;
import org.apache.logging.log4j.flume.appender.Agent;
import org.apache.logging.log4j.flume.appender.FlumeConfigurationBuilder;
import org.apache.logging.log4j.flume.appender.FlumeNode;
import org.apache.logging.log4j.flume.appender.Log4jEventSource;
import org.apache.logging.log4j.util.PropertiesUtil;

public class FlumeEmbeddedManager
extends AbstractFlumeManager {
    protected static final String SOURCE_NAME = "log4j-source";
    private static FlumeManagerFactory factory = new FlumeManagerFactory();
    private static final String FiLE_SEP = PropertiesUtil.getProperties().getStringProperty("file.separator");
    private static final String IN_MEMORY = "InMemory";
    private final FlumeNode node;
    private NodeConfiguration conf;
    private final Log4jEventSource source;
    private final String shortName;

    protected FlumeEmbeddedManager(String name, String shortName, FlumeNode node) {
        super(name);
        this.node = node;
        this.shortName = shortName;
        SourceRunner runner = (SourceRunner)node.getConfiguration().getSourceRunners().get(SOURCE_NAME);
        if (runner == null || runner.getSource() == null) {
            throw new IllegalStateException("No Source has been created for Appender " + shortName);
        }
        this.source = (Log4jEventSource)runner.getSource();
    }

    public static FlumeEmbeddedManager getManager(String name, Agent[] agents, Property[] properties, int batchSize, String dataDir) {
        if (batchSize <= 0) {
            batchSize = 1;
        }
        if (!(agents != null && agents.length != 0 || properties != null && properties.length != 0)) {
            throw new IllegalArgumentException("Either an Agent or properties are required");
        }
        if (agents != null && agents.length > 0 && properties != null && properties.length > 0) {
            throw new IllegalArgumentException("Cannot configure both Agents and Properties.");
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        if (agents != null && agents.length > 0) {
            sb.append("FlumeEmbedded[");
            for (Agent agent : agents) {
                if (!first) {
                    sb.append(",");
                }
                sb.append(agent.getHost()).append(":").append(agent.getPort());
                first = false;
            }
            sb.append("]");
        } else {
            String sep = "";
            sb.append(name).append(":");
            StringBuilder props = new StringBuilder();
            for (Property prop : properties) {
                props.append(sep);
                props.append(prop.getName()).append("=").append(prop.getValue());
                sep = ",";
            }
            sb.append(NameUtil.md5((String)props.toString()));
        }
        return (FlumeEmbeddedManager)FlumeEmbeddedManager.getManager((String)sb.toString(), (ManagerFactory)factory, (Object)new FactoryData(name, agents, properties, batchSize, dataDir));
    }

    @Override
    public void send(Event event) {
        this.source.send(event);
    }

    protected void releaseSub() {
        this.node.stop();
    }

    private static class FlumeManagerFactory
    implements ManagerFactory<FlumeEmbeddedManager, FactoryData> {
        private static final String SOURCE_TYPE = Log4jEventSource.class.getName();

        private FlumeManagerFactory() {
        }

        public FlumeEmbeddedManager createManager(String name, FactoryData data) {
            try {
                DefaultLogicalNodeManager nodeManager = new DefaultLogicalNodeManager();
                Properties props = this.createProperties(data.name, data.agents, data.properties, data.batchSize, data.dataDir);
                FlumeConfigurationBuilder builder = new FlumeConfigurationBuilder();
                NodeConfiguration conf = builder.load(data.name, props, (NodeConfigurationAware)nodeManager);
                FlumeNode node = new FlumeNode((NodeConfigurationAware)nodeManager, (NodeManager)nodeManager, conf);
                node.start();
                return new FlumeEmbeddedManager(name, data.name, node);
            }
            catch (Exception ex) {
                LOGGER.error("Could not create FlumeEmbeddedManager", (Throwable)ex);
                return null;
            }
        }

        private Properties createProperties(String name, Agent[] agents, Property[] properties, int batchSize, String dataDir) {
            Properties props = new Properties();
            if (!(agents != null && agents.length != 0 || properties != null && properties.length != 0)) {
                LOGGER.error("No Flume configuration provided");
                throw new ConfigurationException("No Flume configuration provided");
            }
            if (agents != null && agents.length > 0 && properties != null && properties.length > 0) {
                LOGGER.error("Agents and Flume configuration cannot both be specified");
                throw new ConfigurationException("Agents and Flume configuration cannot both be specified");
            }
            if (agents != null && agents.length > 0) {
                props.put(name + ".sources", FlumeEmbeddedManager.SOURCE_NAME);
                props.put(name + ".sources." + FlumeEmbeddedManager.SOURCE_NAME + ".type", SOURCE_TYPE);
                if (dataDir != null && dataDir.length() > 0) {
                    if (dataDir.equals(FlumeEmbeddedManager.IN_MEMORY)) {
                        props.put(name + ".channels", "primary");
                        props.put(name + ".channels.primary.type", "memory");
                    } else {
                        props.put(name + ".channels", "primary");
                        props.put(name + ".channels.primary.type", "file");
                        if (!dataDir.endsWith(FiLE_SEP)) {
                            dataDir = dataDir + FiLE_SEP;
                        }
                        props.put(name + ".channels.primary.checkpointDir", dataDir + "checkpoint");
                        props.put(name + ".channels.primary.dataDirs", dataDir + "data");
                    }
                } else {
                    props.put(name + ".channels", "primary");
                    props.put(name + ".channels.primary.type", "file");
                }
                StringBuilder sb = new StringBuilder();
                String leading = "";
                int priority = agents.length;
                for (int i = 0; i < agents.length; ++i) {
                    sb.append(leading).append("agent").append(i);
                    leading = " ";
                    String prefix = name + ".sinks.agent" + i;
                    props.put(prefix + ".channel", "primary");
                    props.put(prefix + ".type", "avro");
                    props.put(prefix + ".hostname", agents[i].getHost());
                    props.put(prefix + ".port", Integer.toString(agents[i].getPort()));
                    props.put(prefix + ".batch-size", Integer.toString(batchSize));
                    props.put(name + ".sinkgroups.group1.processor.priority.agent" + i, Integer.toString(priority));
                    --priority;
                }
                props.put(name + ".sinks", sb.toString());
                props.put(name + ".sinkgroups", "group1");
                props.put(name + ".sinkgroups.group1.sinks", sb.toString());
                props.put(name + ".sinkgroups.group1.processor.type", "failover");
                String sourceChannels = "primary";
                props.put(name + ".channels", "primary");
                props.put(name + ".sources." + FlumeEmbeddedManager.SOURCE_NAME + ".channels", "primary");
            } else {
                String channels = null;
                String[] sinks = null;
                props.put(name + ".sources", FlumeEmbeddedManager.SOURCE_NAME);
                props.put(name + ".sources." + FlumeEmbeddedManager.SOURCE_NAME + ".type", SOURCE_TYPE);
                for (Property property : properties) {
                    String msg;
                    String key = property.getName();
                    if (key == null || key.length() == 0) {
                        String msg2 = "A property name must be provided";
                        LOGGER.error("A property name must be provided");
                        throw new ConfigurationException("A property name must be provided");
                    }
                    String upperKey = key.toUpperCase(Locale.ENGLISH);
                    if (upperKey.startsWith(name.toUpperCase(Locale.ENGLISH))) {
                        msg = "Specification of the agent name is not allowed in Flume Appender configuration: " + key;
                        LOGGER.error(msg);
                        throw new ConfigurationException(msg);
                    }
                    if (upperKey.startsWith("SOURCES.") && !upperKey.startsWith("SOURCES.LOG4J-SOURCE.INTERCEPTORS")) {
                        msg = "Specification of Sources is not allowed in Flume Appender: " + key;
                        LOGGER.error(msg);
                        throw new ConfigurationException(msg);
                    }
                    String value = property.getValue();
                    if (value == null || value.length() == 0) {
                        String msg3 = "A value for property " + key + " must be provided";
                        LOGGER.error(msg3);
                        throw new ConfigurationException(msg3);
                    }
                    if (upperKey.equals("CHANNELS")) {
                        channels = value.trim();
                    } else if (upperKey.equals("SINKS")) {
                        sinks = value.trim().split(" ");
                    }
                    props.put(name + '.' + key, value);
                }
                String sourceChannels = channels;
                if (channels == null) {
                    sourceChannels = "primary";
                    props.put(name + ".channels", sourceChannels);
                }
                props.put(name + ".sources." + FlumeEmbeddedManager.SOURCE_NAME + ".channels", sourceChannels);
                if (sinks == null || sinks.length == 0) {
                    String msg = "At least one Sink must be specified";
                    LOGGER.error("At least one Sink must be specified");
                    throw new ConfigurationException("At least one Sink must be specified");
                }
            }
            return props;
        }
    }

    private static class FactoryData {
        private final Agent[] agents;
        private final Property[] properties;
        private final int batchSize;
        private final String dataDir;
        private final String name;

        public FactoryData(String name, Agent[] agents, Property[] properties, int batchSize, String dataDir) {
            this.name = name;
            this.agents = agents;
            this.batchSize = batchSize;
            this.properties = properties;
            this.dataDir = dataDir;
        }
    }
}

