/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.flume.appender;

import java.io.Serializable;
import java.util.Locale;
import org.apache.flume.Event;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttr;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.RFC5424Layout;
import org.apache.logging.log4j.flume.appender.AbstractFlumeManager;
import org.apache.logging.log4j.flume.appender.Agent;
import org.apache.logging.log4j.flume.appender.FlumeAvroManager;
import org.apache.logging.log4j.flume.appender.FlumeEmbeddedManager;
import org.apache.logging.log4j.flume.appender.FlumeEvent;
import org.apache.logging.log4j.flume.appender.FlumeEventFactory;
import org.apache.logging.log4j.flume.appender.FlumePersistentManager;

@Plugin(name="Flume", category="Core", elementType="appender", printObject=true)
public final class FlumeAppender<T extends Serializable>
extends AbstractAppender<T>
implements FlumeEventFactory {
    private final AbstractFlumeManager manager;
    private final String mdcIncludes;
    private final String mdcExcludes;
    private final String mdcRequired;
    private final String eventPrefix;
    private final String mdcPrefix;
    private final boolean compressBody;
    private final FlumeEventFactory factory;

    private FlumeAppender(String name, Filter filter, Layout<T> layout, boolean handleException, String includes, String excludes, String required, String mdcPrefix, String eventPrefix, boolean compress, FlumeEventFactory factory, AbstractFlumeManager manager) {
        super(name, filter, layout, handleException);
        this.manager = manager;
        this.mdcIncludes = includes;
        this.mdcExcludes = excludes;
        this.mdcRequired = required;
        this.eventPrefix = eventPrefix;
        this.mdcPrefix = mdcPrefix;
        this.compressBody = compress;
        this.factory = factory == null ? this : factory;
    }

    public void append(LogEvent event) {
        FlumeEvent flumeEvent = this.factory.createEvent(event, this.mdcIncludes, this.mdcExcludes, this.mdcRequired, this.mdcPrefix, this.eventPrefix, this.compressBody);
        flumeEvent.setBody(this.getLayout().toByteArray((LogEvent)flumeEvent));
        this.manager.send((Event)flumeEvent);
    }

    public void stop() {
        super.stop();
        this.manager.release();
    }

    @Override
    public FlumeEvent createEvent(LogEvent event, String includes, String excludes, String required, String mdcPrefix, String eventPrefix, boolean compress) {
        return new FlumeEvent(event, this.mdcIncludes, this.mdcExcludes, this.mdcRequired, mdcPrefix, eventPrefix, this.compressBody);
    }

    @PluginFactory
    public static <S extends Serializable> FlumeAppender<S> createAppender(@PluginElement(value="agents") Agent[] agents, @PluginElement(value="properties") Property[] properties, @PluginAttr(value="embedded") String embedded, @PluginAttr(value="type") String type, @PluginAttr(value="dataDir") String dataDir, @PluginAttr(value="connectTimeout") String connectionTimeout, @PluginAttr(value="requestTimeout") String requestTimeout, @PluginAttr(value="agentRetries") String agentRetries, @PluginAttr(value="maxDelay") String maxDelay, @PluginAttr(value="name") String name, @PluginAttr(value="suppressExceptions") String suppress, @PluginAttr(value="mdcExcludes") String excludes, @PluginAttr(value="mdcIncludes") String includes, @PluginAttr(value="mdcRequired") String required, @PluginAttr(value="mdcPrefix") String mdcPrefix, @PluginAttr(value="eventPrefix") String eventPrefix, @PluginAttr(value="compress") String compressBody, @PluginAttr(value="batchSize") String batchSize, @PluginElement(value="flumeEventFactory") FlumeEventFactory factory, @PluginElement(value="layout") Layout<S> layout, @PluginElement(value="filters") Filter filter) {
        AbstractFlumeManager manager;
        int delay;
        ManagerType managerType;
        boolean compress;
        boolean embed = embedded != null ? Boolean.valueOf(embedded) : (agents == null || agents.length == 0) && properties != null && properties.length > 0;
        boolean handleExceptions = suppress == null ? true : Boolean.valueOf(suppress);
        boolean bl = compress = compressBody == null ? true : Boolean.valueOf(compressBody);
        if (type != null) {
            if (embed && embedded != null) {
                try {
                    managerType = ManagerType.getType(type);
                    LOGGER.warn("Embedded and type attributes are mutually exclusive. Using type " + type);
                }
                catch (Exception ex) {
                    LOGGER.warn("Embedded and type attributes are mutually exclusive and type " + type + " is invalid.");
                    managerType = ManagerType.EMBEDDED;
                }
            } else {
                try {
                    managerType = ManagerType.getType(type);
                }
                catch (Exception ex) {
                    LOGGER.warn("Type " + type + " is invalid.");
                    managerType = ManagerType.EMBEDDED;
                }
            }
        } else {
            managerType = embed ? ManagerType.EMBEDDED : ManagerType.AVRO;
        }
        int batchCount = batchSize == null ? 1 : Integer.parseInt(batchSize);
        int connectTimeout = connectionTimeout == null ? 0 : Integer.parseInt(connectionTimeout);
        int reqTimeout = requestTimeout == null ? 0 : Integer.parseInt(requestTimeout);
        int retries = agentRetries == null ? 0 : Integer.parseInt(agentRetries);
        int n = delay = maxDelay == null ? 60000 : Integer.parseInt(maxDelay);
        if (layout == null) {
            RFC5424Layout l;
            layout = l = RFC5424Layout.createLayout(null, null, null, (String)"True", null, (String)mdcPrefix, (String)eventPrefix, null, null, null, (String)excludes, (String)includes, (String)required, null, null, null);
        }
        if (name == null) {
            LOGGER.error("No name provided for Appender");
            return null;
        }
        switch (managerType) {
            case EMBEDDED: {
                manager = FlumeEmbeddedManager.getManager(name, agents, properties, batchCount, dataDir);
                break;
            }
            case AVRO: {
                if (agents == null || agents.length == 0) {
                    LOGGER.debug("No agents provided, using defaults");
                    agents = new Agent[]{Agent.createAgent(null, null)};
                }
                manager = FlumeAvroManager.getManager(name, agents, batchCount, retries, connectTimeout, reqTimeout);
                break;
            }
            case PERSISTENT: {
                if (agents == null || agents.length == 0) {
                    LOGGER.debug("No agents provided, using defaults");
                    agents = new Agent[]{Agent.createAgent(null, null)};
                }
                manager = FlumePersistentManager.getManager(name, agents, properties, batchCount, retries, connectTimeout, reqTimeout, delay, dataDir);
                break;
            }
            default: {
                LOGGER.debug("No manager type specified. Defaulting to AVRO");
                if (agents == null || agents.length == 0) {
                    LOGGER.debug("No agents provided, using defaults");
                    agents = new Agent[]{Agent.createAgent(null, null)};
                }
                manager = FlumeAvroManager.getManager(name, agents, batchCount, retries, connectTimeout, reqTimeout);
            }
        }
        if (manager == null) {
            return null;
        }
        return new FlumeAppender(name, filter, layout, handleExceptions, includes, excludes, required, mdcPrefix, eventPrefix, compress, factory, manager);
    }

    private static enum ManagerType {
        AVRO,
        EMBEDDED,
        PERSISTENT;


        public static ManagerType getType(String type) {
            return ManagerType.valueOf(type.toUpperCase(Locale.US));
        }
    }
}

