/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.test;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.test.ConsumerRecordFactory;
import org.junit.Assert;
import org.junit.Test;

@Deprecated
public class ConsumerRecordFactoryTest {
    private final StringSerializer stringSerializer = new StringSerializer();
    private final IntegerSerializer integerSerializer = new IntegerSerializer();
    private final String topicName = "topic";
    private final String otherTopicName = "otherTopic";
    private final String key = "key";
    private final Integer value = 42;
    private final long timestamp = 21L;
    private final byte[] rawKey = this.stringSerializer.serialize("topic", "key");
    private final byte[] rawValue = this.integerSerializer.serialize("topic", this.value);
    private final ConsumerRecordFactory<byte[], Integer> factory = new ConsumerRecordFactory("topic", (Serializer)new ByteArraySerializer(), (Serializer)this.integerSerializer, 0L);
    private final ConsumerRecordFactory<byte[], Integer> defaultFactory = new ConsumerRecordFactory((Serializer)new ByteArraySerializer(), (Serializer)this.integerSerializer);

    @Test
    public void shouldAdvanceTime() {
        this.factory.advanceTimeMs(3L);
        this.verifyRecord("topic", this.rawKey, this.rawValue, 3L, (ConsumerRecord<byte[], byte[]>)this.factory.create("topic", (Object)this.rawKey, (Object)this.value));
        this.factory.advanceTimeMs(2L);
        this.verifyRecord("topic", this.rawKey, this.rawValue, 5L, (ConsumerRecord<byte[], byte[]>)this.factory.create("topic", (Object)this.rawKey, (Object)this.value));
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowToCreateTopicWithNullTopicName() {
        this.factory.create(null, (Object)this.rawKey, (Object)this.value, 21L);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowToCreateTopicWithNullHeaders() {
        this.factory.create("topic", (Object)this.rawKey, (Object)this.value, null, 21L);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowToCreateTopicWithNullTopicNameWithDefaultTimestamp() {
        this.factory.create(null, (Object)this.rawKey, (Object)this.value);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowToCreateTopicWithNullTopicNameWithNullKey() {
        this.factory.create((String)null, (Object)this.value, 21L);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowToCreateTopicWithNullTopicNameWithNullKeyAndDefaultTimestamp() {
        this.factory.create((String)null, (Object)this.value);
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowToCreateTopicWithNullTopicNameWithKeyValuePairs() {
        this.factory.create(null, Collections.singletonList(KeyValue.pair((Object)this.rawKey, (Object)this.value)));
    }

    @Test(expected=NullPointerException.class)
    public void shouldNotAllowToCreateTopicWithNullTopicNameWithKeyValuePairsAndCustomTimestamps() {
        this.factory.create(null, Collections.singletonList(KeyValue.pair((Object)this.rawKey, (Object)this.value)), 21L, 2L);
    }

    @Test(expected=IllegalStateException.class)
    public void shouldRequireCustomTopicNameIfNotDefaultFactoryTopicName() {
        this.defaultFactory.create((Object)this.rawKey, (Object)this.value, 21L);
    }

    @Test(expected=IllegalStateException.class)
    public void shouldRequireCustomTopicNameIfNotDefaultFactoryTopicNameWithDefaultTimestamp() {
        this.defaultFactory.create((Object)this.rawKey, (Object)this.value);
    }

    @Test(expected=IllegalStateException.class)
    public void shouldRequireCustomTopicNameIfNotDefaultFactoryTopicNameWithNullKey() {
        this.defaultFactory.create((Object)this.value, 21L);
    }

    @Test(expected=IllegalStateException.class)
    public void shouldRequireCustomTopicNameIfNotDefaultFactoryTopicNameWithNullKeyAndDefaultTimestamp() {
        this.defaultFactory.create((Object)this.value);
    }

    @Test(expected=IllegalStateException.class)
    public void shouldRequireCustomTopicNameIfNotDefaultFactoryTopicNameWithKeyValuePairs() {
        this.defaultFactory.create(Collections.singletonList(KeyValue.pair((Object)this.rawKey, (Object)this.value)));
    }

    @Test(expected=IllegalStateException.class)
    public void shouldRequireCustomTopicNameIfNotDefaultFactoryTopicNameWithKeyValuePairsAndCustomTimestamps() {
        this.defaultFactory.create(Collections.singletonList(KeyValue.pair((Object)this.rawKey, (Object)this.value)), 21L, 2L);
    }

    @Test
    public void shouldCreateConsumerRecordWithOtherTopicNameAndTimestamp() {
        this.verifyRecord("otherTopic", this.rawKey, this.rawValue, 21L, (ConsumerRecord<byte[], byte[]>)this.factory.create("otherTopic", (Object)this.rawKey, (Object)this.value, 21L));
    }

    @Test
    public void shouldCreateConsumerRecordWithTimestamp() {
        this.verifyRecord("topic", this.rawKey, this.rawValue, 21L, (ConsumerRecord<byte[], byte[]>)this.factory.create((Object)this.rawKey, (Object)this.value, 21L));
    }

    @Test
    public void shouldCreateConsumerRecordWithOtherTopicName() {
        this.verifyRecord("otherTopic", this.rawKey, this.rawValue, 0L, (ConsumerRecord<byte[], byte[]>)this.factory.create("otherTopic", (Object)this.rawKey, (Object)this.value));
        this.factory.advanceTimeMs(3L);
        this.verifyRecord("otherTopic", this.rawKey, this.rawValue, 3L, (ConsumerRecord<byte[], byte[]>)this.factory.create("otherTopic", (Object)this.rawKey, (Object)this.value));
    }

    @Test
    public void shouldCreateConsumerRecord() {
        this.verifyRecord("topic", this.rawKey, this.rawValue, 0L, (ConsumerRecord<byte[], byte[]>)this.factory.create((Object)this.rawKey, (Object)this.value));
        this.factory.advanceTimeMs(3L);
        this.verifyRecord("topic", this.rawKey, this.rawValue, 3L, (ConsumerRecord<byte[], byte[]>)this.factory.create((Object)this.rawKey, (Object)this.value));
    }

    @Test
    public void shouldCreateNullKeyConsumerRecordWithOtherTopicNameAndTimestampWithTimetamp() {
        this.verifyRecord("topic", null, this.rawValue, 21L, (ConsumerRecord<byte[], byte[]>)this.factory.create((Object)this.value, 21L));
    }

    @Test
    public void shouldCreateNullKeyConsumerRecordWithTimestampWithTimestamp() {
        this.verifyRecord("topic", null, this.rawValue, 21L, (ConsumerRecord<byte[], byte[]>)this.factory.create((Object)this.value, 21L));
    }

    @Test
    public void shouldCreateNullKeyConsumerRecord() {
        this.verifyRecord("topic", null, this.rawValue, 0L, (ConsumerRecord<byte[], byte[]>)this.factory.create((Object)this.value));
        this.factory.advanceTimeMs(3L);
        this.verifyRecord("topic", null, this.rawValue, 3L, (ConsumerRecord<byte[], byte[]>)this.factory.create((Object)this.value));
    }

    @Test
    public void shouldCreateConsumerRecordsFromKeyValuePairs() {
        ConsumerRecordFactory factory = new ConsumerRecordFactory("topic", (Serializer)this.stringSerializer, (Serializer)this.integerSerializer, 0L);
        KeyValue[] keyValuePairs = new KeyValue[5];
        KeyValue[] rawKeyValuePairs = new KeyValue[keyValuePairs.length];
        for (int i = 0; i < keyValuePairs.length; ++i) {
            keyValuePairs[i] = KeyValue.pair((Object)("key-" + i), (Object)(this.value + i));
            rawKeyValuePairs[i] = KeyValue.pair((Object)this.stringSerializer.serialize("topic", "key-" + i), (Object)this.integerSerializer.serialize("topic", Integer.valueOf(this.value + i)));
        }
        List records = factory.create(Arrays.asList(keyValuePairs));
        for (int i = 0; i < keyValuePairs.length; ++i) {
            this.verifyRecord("topic", (byte[])rawKeyValuePairs[i].key, (byte[])rawKeyValuePairs[i].value, 0L, (ConsumerRecord<byte[], byte[]>)((ConsumerRecord)records.get(i)));
        }
    }

    @Test
    public void shouldCreateConsumerRecordsFromKeyValuePairsWithTimestampAndIncrements() {
        ConsumerRecordFactory factory = new ConsumerRecordFactory("topic", (Serializer)this.stringSerializer, (Serializer)this.integerSerializer, 21L, 2L);
        KeyValue[] keyValuePairs = new KeyValue[5];
        KeyValue[] rawKeyValuePairs = new KeyValue[keyValuePairs.length];
        for (int i = 0; i < keyValuePairs.length; ++i) {
            keyValuePairs[i] = KeyValue.pair((Object)("key-" + i), (Object)(this.value + i));
            rawKeyValuePairs[i] = KeyValue.pair((Object)this.stringSerializer.serialize("topic", "key-" + i), (Object)this.integerSerializer.serialize("topic", Integer.valueOf(this.value + i)));
        }
        List records = factory.create(Arrays.asList(keyValuePairs));
        for (int i = 0; i < keyValuePairs.length; ++i) {
            this.verifyRecord("topic", (byte[])rawKeyValuePairs[i].key, (byte[])rawKeyValuePairs[i].value, 21L + 2L * (long)i, (ConsumerRecord<byte[], byte[]>)((ConsumerRecord)records.get(i)));
        }
    }

    @Test
    public void shouldCreateConsumerRecordsFromKeyValuePairsWithCustomTimestampAndIncrementsAndNotAdvanceTime() {
        ConsumerRecordFactory factory = new ConsumerRecordFactory("topic", (Serializer)this.stringSerializer, (Serializer)this.integerSerializer, 0L);
        KeyValue[] keyValuePairs = new KeyValue[5];
        KeyValue[] rawKeyValuePairs = new KeyValue[keyValuePairs.length];
        for (int i = 0; i < keyValuePairs.length; ++i) {
            keyValuePairs[i] = KeyValue.pair((Object)("key-" + i), (Object)(this.value + i));
            rawKeyValuePairs[i] = KeyValue.pair((Object)this.stringSerializer.serialize("topic", "key-" + i), (Object)this.integerSerializer.serialize("topic", Integer.valueOf(this.value + i)));
        }
        List records = factory.create(Arrays.asList(keyValuePairs), 21L, 2L);
        for (int i = 0; i < keyValuePairs.length; ++i) {
            this.verifyRecord("topic", (byte[])rawKeyValuePairs[i].key, (byte[])rawKeyValuePairs[i].value, 21L + 2L * (long)i, (ConsumerRecord<byte[], byte[]>)((ConsumerRecord)records.get(i)));
        }
        this.verifyRecord("topic", null, this.rawValue, 0L, (ConsumerRecord<byte[], byte[]>)factory.create((Object)this.value));
    }

    private void verifyRecord(String topicName, byte[] rawKey, byte[] rawValue, long timestamp, ConsumerRecord<byte[], byte[]> record) {
        Assert.assertEquals((Object)topicName, (Object)record.topic());
        Assert.assertArrayEquals((byte[])rawKey, (byte[])((byte[])record.key()));
        Assert.assertArrayEquals((byte[])rawValue, (byte[])((byte[])record.value()));
        Assert.assertEquals((long)timestamp, (long)record.timestamp());
    }
}

