/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams;

import java.io.File;
import java.util.Iterator;
import java.util.Properties;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.processor.AbstractProcessor;
import org.apache.kafka.streams.processor.MockProcessorContext;
import org.apache.kafka.streams.processor.Processor;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.PunctuationType;
import org.apache.kafka.streams.processor.Punctuator;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.To;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.internals.InMemoryKeyValueStore;
import org.junit.Assert;
import org.junit.Test;

public class MockProcessorContextTest {
    @Test
    public void shouldCaptureOutputRecords() {
        AbstractProcessor<String, Long> processor = new AbstractProcessor<String, Long>(){

            public void process(String key, Long value) {
                this.context().forward((Object)(key + value), (Object)((long)key.length() + value));
            }
        };
        MockProcessorContext context = new MockProcessorContext();
        processor.init((ProcessorContext)context);
        processor.process((Object)"foo", (Object)5L);
        processor.process((Object)"barbaz", (Object)50L);
        Iterator forwarded = context.forwarded().iterator();
        Assert.assertEquals((Object)new KeyValue((Object)"foo5", (Object)8L), (Object)((MockProcessorContext.CapturedForward)forwarded.next()).keyValue());
        Assert.assertEquals((Object)new KeyValue((Object)"barbaz50", (Object)56L), (Object)((MockProcessorContext.CapturedForward)forwarded.next()).keyValue());
        Assert.assertFalse((boolean)forwarded.hasNext());
        context.resetForwards();
        Assert.assertEquals((long)0L, (long)context.forwarded().size());
    }

    @Test
    public void shouldCaptureOutputRecordsUsingTo() {
        AbstractProcessor<String, Long> processor = new AbstractProcessor<String, Long>(){

            public void process(String key, Long value) {
                this.context().forward((Object)(key + value), (Object)((long)key.length() + value), To.all());
            }
        };
        MockProcessorContext context = new MockProcessorContext();
        processor.init((ProcessorContext)context);
        processor.process((Object)"foo", (Object)5L);
        processor.process((Object)"barbaz", (Object)50L);
        Iterator forwarded = context.forwarded().iterator();
        Assert.assertEquals((Object)new KeyValue((Object)"foo5", (Object)8L), (Object)((MockProcessorContext.CapturedForward)forwarded.next()).keyValue());
        Assert.assertEquals((Object)new KeyValue((Object)"barbaz50", (Object)56L), (Object)((MockProcessorContext.CapturedForward)forwarded.next()).keyValue());
        Assert.assertFalse((boolean)forwarded.hasNext());
        context.resetForwards();
        Assert.assertEquals((long)0L, (long)context.forwarded().size());
    }

    @Test
    public void shouldCaptureRecordsOutputToChildByName() {
        AbstractProcessor<String, Long> processor = new AbstractProcessor<String, Long>(){
            private int count = 0;

            public void process(String key, Long value) {
                if (this.count == 0) {
                    this.context().forward((Object)"start", (Object)-1L, To.all());
                }
                To toChild = this.count % 2 == 0 ? To.child((String)"george") : To.child((String)"pete");
                this.context().forward((Object)(key + value), (Object)((long)key.length() + value), toChild);
                ++this.count;
            }
        };
        MockProcessorContext context = new MockProcessorContext();
        processor.init((ProcessorContext)context);
        processor.process((Object)"foo", (Object)5L);
        processor.process((Object)"barbaz", (Object)50L);
        Iterator forwarded = context.forwarded().iterator();
        MockProcessorContext.CapturedForward forward1 = (MockProcessorContext.CapturedForward)forwarded.next();
        Assert.assertEquals((Object)new KeyValue((Object)"start", (Object)-1L), (Object)forward1.keyValue());
        Assert.assertEquals(null, (Object)forward1.childName());
        MockProcessorContext.CapturedForward forward2 = (MockProcessorContext.CapturedForward)forwarded.next();
        Assert.assertEquals((Object)new KeyValue((Object)"foo5", (Object)8L), (Object)forward2.keyValue());
        Assert.assertEquals((Object)"george", (Object)forward2.childName());
        MockProcessorContext.CapturedForward forward3 = (MockProcessorContext.CapturedForward)forwarded.next();
        Assert.assertEquals((Object)new KeyValue((Object)"barbaz50", (Object)56L), (Object)forward3.keyValue());
        Assert.assertEquals((Object)"pete", (Object)forward3.childName());
        Assert.assertFalse((boolean)forwarded.hasNext());
        forwarded = context.forwarded("george").iterator();
        Assert.assertEquals((Object)new KeyValue((Object)"start", (Object)-1L), (Object)((MockProcessorContext.CapturedForward)forwarded.next()).keyValue());
        Assert.assertEquals((Object)new KeyValue((Object)"foo5", (Object)8L), (Object)((MockProcessorContext.CapturedForward)forwarded.next()).keyValue());
        Assert.assertFalse((boolean)forwarded.hasNext());
        forwarded = context.forwarded("pete").iterator();
        Assert.assertEquals((Object)new KeyValue((Object)"start", (Object)-1L), (Object)((MockProcessorContext.CapturedForward)forwarded.next()).keyValue());
        Assert.assertEquals((Object)new KeyValue((Object)"barbaz50", (Object)56L), (Object)((MockProcessorContext.CapturedForward)forwarded.next()).keyValue());
        Assert.assertFalse((boolean)forwarded.hasNext());
        forwarded = context.forwarded("steve").iterator();
        Assert.assertEquals((Object)new KeyValue((Object)"start", (Object)-1L), (Object)((MockProcessorContext.CapturedForward)forwarded.next()).keyValue());
        Assert.assertFalse((boolean)forwarded.hasNext());
    }

    @Test
    public void shouldThrowIfForwardedWithDeprecatedChildIndex() {
        AbstractProcessor<String, Long> processor = new AbstractProcessor<String, Long>(){

            public void process(String key, Long value) {
                this.context().forward((Object)key, (Object)value, 0);
            }
        };
        MockProcessorContext context = new MockProcessorContext();
        processor.init((ProcessorContext)context);
        try {
            processor.process((Object)"foo", (Object)5L);
            Assert.fail((String)"Should have thrown an UnsupportedOperationException.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void shouldThrowIfForwardedWithDeprecatedChildName() {
        AbstractProcessor<String, Long> processor = new AbstractProcessor<String, Long>(){

            public void process(String key, Long value) {
                this.context().forward((Object)key, (Object)value, "child1");
            }
        };
        MockProcessorContext context = new MockProcessorContext();
        processor.init((ProcessorContext)context);
        try {
            processor.process((Object)"foo", (Object)5L);
            Assert.fail((String)"Should have thrown an UnsupportedOperationException.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void shouldCaptureCommitsAndAllowReset() {
        AbstractProcessor<String, Long> processor = new AbstractProcessor<String, Long>(){
            private int count = 0;

            public void process(String key, Long value) {
                if (++this.count > 2) {
                    this.context().commit();
                }
            }
        };
        MockProcessorContext context = new MockProcessorContext();
        processor.init((ProcessorContext)context);
        processor.process((Object)"foo", (Object)5L);
        processor.process((Object)"barbaz", (Object)50L);
        Assert.assertFalse((boolean)context.committed());
        processor.process((Object)"foobar", (Object)500L);
        Assert.assertTrue((boolean)context.committed());
        context.resetCommit();
        Assert.assertFalse((boolean)context.committed());
    }

    @Test
    public void shouldStoreAndReturnStateStores() {
        AbstractProcessor<String, Long> processor = new AbstractProcessor<String, Long>(){

            public void process(String key, Long value) {
                KeyValueStore stateStore;
                stateStore.put((Object)key, (Object)(((stateStore = (KeyValueStore)this.context().getStateStore("my-state")).get((Object)key) == null ? 0L : (Long)stateStore.get((Object)key)) + value));
                stateStore.put((Object)"all", (Object)((stateStore.get((Object)"all") == null ? 0L : (Long)stateStore.get((Object)"all")) + value));
            }
        };
        MockProcessorContext context = new MockProcessorContext();
        InMemoryKeyValueStore store = new InMemoryKeyValueStore("my-state", Serdes.String(), Serdes.Long());
        context.register((StateStore)store, null);
        store.init((ProcessorContext)context, (StateStore)store);
        processor.init((ProcessorContext)context);
        processor.process((Object)"foo", (Object)5L);
        processor.process((Object)"bar", (Object)50L);
        Assert.assertEquals((long)5L, (long)((Long)store.get((Object)"foo")));
        Assert.assertEquals((long)50L, (long)((Long)store.get((Object)"bar")));
        Assert.assertEquals((long)55L, (long)((Long)store.get((Object)"all")));
    }

    @Test
    public void shouldCaptureApplicationAndRecordMetadata() {
        Properties config = new Properties();
        config.put("application.id", "testMetadata");
        config.put("bootstrap.servers", "");
        AbstractProcessor<String, Object> processor = new AbstractProcessor<String, Object>(){

            public void process(String key, Object value) {
                this.context().forward((Object)"appId", (Object)this.context().applicationId());
                this.context().forward((Object)"taskId", (Object)this.context().taskId());
                this.context().forward((Object)"topic", (Object)this.context().topic());
                this.context().forward((Object)"partition", (Object)this.context().partition());
                this.context().forward((Object)"offset", (Object)this.context().offset());
                this.context().forward((Object)"timestamp", (Object)this.context().timestamp());
                this.context().forward((Object)"key", (Object)key);
                this.context().forward((Object)"value", value);
            }
        };
        MockProcessorContext context = new MockProcessorContext(config);
        processor.init((ProcessorContext)context);
        try {
            processor.process((Object)"foo", (Object)5L);
            Assert.fail((String)"Should have thrown an exception.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        context.resetForwards();
        context.setRecordMetadata("t1", 0, 0L, null, 0L);
        processor.process((Object)"foo", (Object)5L);
        Iterator forwarded = context.forwarded().iterator();
        Assert.assertEquals((Object)new KeyValue((Object)"appId", (Object)"testMetadata"), (Object)((MockProcessorContext.CapturedForward)forwarded.next()).keyValue());
        Assert.assertEquals((Object)new KeyValue((Object)"taskId", (Object)new TaskId(0, 0)), (Object)((MockProcessorContext.CapturedForward)forwarded.next()).keyValue());
        Assert.assertEquals((Object)new KeyValue((Object)"topic", (Object)"t1"), (Object)((MockProcessorContext.CapturedForward)forwarded.next()).keyValue());
        Assert.assertEquals((Object)new KeyValue((Object)"partition", (Object)0), (Object)((MockProcessorContext.CapturedForward)forwarded.next()).keyValue());
        Assert.assertEquals((Object)new KeyValue((Object)"offset", (Object)0L), (Object)((MockProcessorContext.CapturedForward)forwarded.next()).keyValue());
        Assert.assertEquals((Object)new KeyValue((Object)"timestamp", (Object)0L), (Object)((MockProcessorContext.CapturedForward)forwarded.next()).keyValue());
        Assert.assertEquals((Object)new KeyValue((Object)"key", (Object)"foo"), (Object)((MockProcessorContext.CapturedForward)forwarded.next()).keyValue());
        Assert.assertEquals((Object)new KeyValue((Object)"value", (Object)5L), (Object)((MockProcessorContext.CapturedForward)forwarded.next()).keyValue());
        context.resetForwards();
        context.setOffset(1L);
        context.setTimestamp(10L);
        processor.process((Object)"bar", (Object)50L);
        forwarded = context.forwarded().iterator();
        Assert.assertEquals((Object)new KeyValue((Object)"appId", (Object)"testMetadata"), (Object)((MockProcessorContext.CapturedForward)forwarded.next()).keyValue());
        Assert.assertEquals((Object)new KeyValue((Object)"taskId", (Object)new TaskId(0, 0)), (Object)((MockProcessorContext.CapturedForward)forwarded.next()).keyValue());
        Assert.assertEquals((Object)new KeyValue((Object)"topic", (Object)"t1"), (Object)((MockProcessorContext.CapturedForward)forwarded.next()).keyValue());
        Assert.assertEquals((Object)new KeyValue((Object)"partition", (Object)0), (Object)((MockProcessorContext.CapturedForward)forwarded.next()).keyValue());
        Assert.assertEquals((Object)new KeyValue((Object)"offset", (Object)1L), (Object)((MockProcessorContext.CapturedForward)forwarded.next()).keyValue());
        Assert.assertEquals((Object)new KeyValue((Object)"timestamp", (Object)10L), (Object)((MockProcessorContext.CapturedForward)forwarded.next()).keyValue());
        Assert.assertEquals((Object)new KeyValue((Object)"key", (Object)"bar"), (Object)((MockProcessorContext.CapturedForward)forwarded.next()).keyValue());
        Assert.assertEquals((Object)new KeyValue((Object)"value", (Object)50L), (Object)((MockProcessorContext.CapturedForward)forwarded.next()).keyValue());
        context.resetForwards();
        context.setTopic("t2");
        context.setPartition(30);
        processor.process((Object)"baz", (Object)500L);
        forwarded = context.forwarded().iterator();
        Assert.assertEquals((Object)new KeyValue((Object)"appId", (Object)"testMetadata"), (Object)((MockProcessorContext.CapturedForward)forwarded.next()).keyValue());
        Assert.assertEquals((Object)new KeyValue((Object)"taskId", (Object)new TaskId(0, 0)), (Object)((MockProcessorContext.CapturedForward)forwarded.next()).keyValue());
        Assert.assertEquals((Object)new KeyValue((Object)"topic", (Object)"t2"), (Object)((MockProcessorContext.CapturedForward)forwarded.next()).keyValue());
        Assert.assertEquals((Object)new KeyValue((Object)"partition", (Object)30), (Object)((MockProcessorContext.CapturedForward)forwarded.next()).keyValue());
        Assert.assertEquals((Object)new KeyValue((Object)"offset", (Object)1L), (Object)((MockProcessorContext.CapturedForward)forwarded.next()).keyValue());
        Assert.assertEquals((Object)new KeyValue((Object)"timestamp", (Object)10L), (Object)((MockProcessorContext.CapturedForward)forwarded.next()).keyValue());
        Assert.assertEquals((Object)new KeyValue((Object)"key", (Object)"baz"), (Object)((MockProcessorContext.CapturedForward)forwarded.next()).keyValue());
        Assert.assertEquals((Object)new KeyValue((Object)"value", (Object)500L), (Object)((MockProcessorContext.CapturedForward)forwarded.next()).keyValue());
    }

    @Test
    public void shouldCapturePunctuator() {
        Processor<String, Long> processor = new Processor<String, Long>(){

            public void init(ProcessorContext context) {
                context.schedule(1000L, PunctuationType.WALL_CLOCK_TIME, timestamp -> context.commit());
            }

            public void process(String key, Long value) {
            }

            public void close() {
            }
        };
        MockProcessorContext context = new MockProcessorContext();
        processor.init((ProcessorContext)context);
        MockProcessorContext.CapturedPunctuator capturedPunctuator = (MockProcessorContext.CapturedPunctuator)context.scheduledPunctuators().get(0);
        Assert.assertEquals((long)1000L, (long)capturedPunctuator.getIntervalMs());
        Assert.assertEquals((Object)PunctuationType.WALL_CLOCK_TIME, (Object)capturedPunctuator.getType());
        Assert.assertFalse((boolean)capturedPunctuator.cancelled());
        Punctuator punctuator = capturedPunctuator.getPunctuator();
        Assert.assertFalse((boolean)context.committed());
        punctuator.punctuate(1234L);
        Assert.assertTrue((boolean)context.committed());
    }

    @Test
    public void fullConstructorShouldSetAllExpectedAttributes() {
        Properties config = new Properties();
        config.put("application.id", "testFullConstructor");
        config.put("bootstrap.servers", "");
        config.put("default.key.serde", Serdes.String().getClass());
        config.put("default.value.serde", Serdes.Long().getClass());
        File dummyFile = new File("");
        MockProcessorContext context = new MockProcessorContext(config, new TaskId(1, 1), dummyFile);
        Assert.assertEquals((Object)"testFullConstructor", (Object)context.applicationId());
        Assert.assertEquals((Object)new TaskId(1, 1), (Object)context.taskId());
        Assert.assertEquals((Object)"testFullConstructor", context.appConfigs().get("application.id"));
        Assert.assertEquals((Object)"testFullConstructor", context.appConfigsWithPrefix("application.").get("id"));
        Assert.assertEquals(Serdes.String().getClass(), context.keySerde().getClass());
        Assert.assertEquals(Serdes.Long().getClass(), context.valueSerde().getClass());
        Assert.assertEquals((Object)dummyFile, (Object)context.stateDir());
    }
}

