/*
 * Decompiled with CFR 0.152.
 */
package kafka.bridge.examples;

import java.io.IOException;
import kafka.bridge.hadoop.KafkaOutputFormat;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;

public class TextPublisher {
    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("usage: <input path> <kafka output url>");
            return;
        }
        Job job = new Job();
        job.setJarByClass(TextPublisher.class);
        job.setInputFormatClass(TextInputFormat.class);
        job.setOutputFormatClass(KafkaOutputFormat.class);
        job.setMapperClass(TheMapper.class);
        job.setNumReduceTasks(0);
        FileInputFormat.addInputPath((Job)job, (Path)new Path(args[0]));
        KafkaOutputFormat.setOutputPath(job, new Path(args[1]));
        if (!job.waitForCompletion(true)) {
            throw new RuntimeException("Job failed!");
        }
    }

    public static class TheMapper
    extends Mapper<Object, Text, Object, Object> {
        protected void map(Object key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            context.write(null, (Object)value.getBytes());
        }
    }
}

