/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.data;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Time;
import org.apache.kafka.connect.errors.DataException;
import org.junit.Assert;
import org.junit.Test;

public class TimeTest {
    private static final GregorianCalendar EPOCH = new GregorianCalendar(1970, 0, 1, 0, 0, 0);
    private static final GregorianCalendar EPOCH_PLUS_DATE_COMPONENT;
    private static final GregorianCalendar EPOCH_PLUS_TEN_THOUSAND_MILLIS;

    @Test
    public void testBuilder() {
        Schema plain = Time.SCHEMA;
        Assert.assertEquals((Object)"org.apache.kafka.connect.data.Time", (Object)plain.name());
        Assert.assertEquals((Object)1, (Object)plain.version());
    }

    @Test
    public void testFromLogical() {
        Assert.assertEquals((long)0L, (long)Time.fromLogical((Schema)Time.SCHEMA, (Date)EPOCH.getTime()));
        Assert.assertEquals((long)10000L, (long)Time.fromLogical((Schema)Time.SCHEMA, (Date)EPOCH_PLUS_TEN_THOUSAND_MILLIS.getTime()));
    }

    @Test(expected=DataException.class)
    public void testFromLogicalInvalidSchema() {
        Time.fromLogical((Schema)Time.builder().name("invalid").build(), (Date)EPOCH.getTime());
    }

    @Test(expected=DataException.class)
    public void testFromLogicalInvalidHasDateComponents() {
        Time.fromLogical((Schema)Time.SCHEMA, (Date)EPOCH_PLUS_DATE_COMPONENT.getTime());
    }

    @Test
    public void testToLogical() {
        Assert.assertEquals((Object)EPOCH.getTime(), (Object)Time.toLogical((Schema)Time.SCHEMA, (int)0));
        Assert.assertEquals((Object)EPOCH_PLUS_TEN_THOUSAND_MILLIS.getTime(), (Object)Time.toLogical((Schema)Time.SCHEMA, (int)10000));
    }

    @Test(expected=DataException.class)
    public void testToLogicalInvalidSchema() {
        Time.toLogical((Schema)Time.builder().name("invalid").build(), (int)0);
    }

    static {
        EPOCH.setTimeZone(TimeZone.getTimeZone("UTC"));
        EPOCH_PLUS_TEN_THOUSAND_MILLIS = new GregorianCalendar(1970, 0, 1, 0, 0, 0);
        EPOCH_PLUS_TEN_THOUSAND_MILLIS.setTimeZone(TimeZone.getTimeZone("UTC"));
        EPOCH_PLUS_TEN_THOUSAND_MILLIS.add(14, 10000);
        EPOCH_PLUS_DATE_COMPONENT = new GregorianCalendar(1970, 0, 1, 0, 0, 0);
        EPOCH_PLUS_DATE_COMPONENT.setTimeZone(TimeZone.getTimeZone("UTC"));
        EPOCH_PLUS_DATE_COMPONENT.add(5, 10000);
    }
}

