/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.data;

import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.kafka.connect.data.Date;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.errors.DataException;
import org.junit.Assert;
import org.junit.Test;

public class DateTest {
    private static final GregorianCalendar EPOCH = new GregorianCalendar(1970, 0, 1, 0, 0, 0);
    private static final GregorianCalendar EPOCH_PLUS_TEN_THOUSAND_DAYS;
    private static final GregorianCalendar EPOCH_PLUS_TIME_COMPONENT;

    @Test
    public void testBuilder() {
        Schema plain = Date.SCHEMA;
        Assert.assertEquals((Object)"org.apache.kafka.connect.data.Date", (Object)plain.name());
        Assert.assertEquals((Object)1, (Object)plain.version());
    }

    @Test
    public void testFromLogical() {
        Assert.assertEquals((long)0L, (long)Date.fromLogical((Schema)Date.SCHEMA, (java.util.Date)EPOCH.getTime()));
        Assert.assertEquals((long)10000L, (long)Date.fromLogical((Schema)Date.SCHEMA, (java.util.Date)EPOCH_PLUS_TEN_THOUSAND_DAYS.getTime()));
    }

    @Test(expected=DataException.class)
    public void testFromLogicalInvalidSchema() {
        Date.fromLogical((Schema)Date.builder().name("invalid").build(), (java.util.Date)EPOCH.getTime());
    }

    @Test(expected=DataException.class)
    public void testFromLogicalInvalidHasTimeComponents() {
        Date.fromLogical((Schema)Date.SCHEMA, (java.util.Date)EPOCH_PLUS_TIME_COMPONENT.getTime());
    }

    @Test
    public void testToLogical() {
        Assert.assertEquals((Object)EPOCH.getTime(), (Object)Date.toLogical((Schema)Date.SCHEMA, (int)0));
        Assert.assertEquals((Object)EPOCH_PLUS_TEN_THOUSAND_DAYS.getTime(), (Object)Date.toLogical((Schema)Date.SCHEMA, (int)10000));
    }

    @Test(expected=DataException.class)
    public void testToLogicalInvalidSchema() {
        Date.toLogical((Schema)Date.builder().name("invalid").build(), (int)0);
    }

    static {
        EPOCH.setTimeZone(TimeZone.getTimeZone("UTC"));
        EPOCH_PLUS_TIME_COMPONENT = new GregorianCalendar(1970, 0, 1, 0, 0, 1);
        EPOCH_PLUS_TIME_COMPONENT.setTimeZone(TimeZone.getTimeZone("UTC"));
        EPOCH_PLUS_TEN_THOUSAND_DAYS = new GregorianCalendar(1970, 0, 1, 0, 0, 0);
        EPOCH_PLUS_TEN_THOUSAND_DAYS.setTimeZone(TimeZone.getTimeZone("UTC"));
        EPOCH_PLUS_TEN_THOUSAND_DAYS.add(5, 10000);
    }
}

