/*
 * Decompiled with CFR 0.152.
 */
package javax.json.bind;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.json.bind.adapter.JsonbAdapter;
import javax.json.bind.config.PropertyNamingStrategy;
import javax.json.bind.config.PropertyVisibilityStrategy;

public class JsonbConfig {
    private final Map<String, Object> configuration = new HashMap<String, Object>();
    public static final String FORMATTING = "jsonb.formatting";
    public static final String ENCODING = "jsonb.encoding";
    public static final String PROPERTY_NAMING_STRATEGY = "jsonb.property-naming-strategy";
    public static final String PROPERTY_ORDER_STRATEGY = "jsonb.property-order-strategy";
    public static final String NULL_VALUES = "jsonb.null-values";
    public static final String STRICT_IJSON = "jsonb.strict-ijson";
    public static final String PROPERTY_VISIBILITY_STRATEGY = "jsonb.property-visibility-strategy";
    public static final String ADAPTERS = "jsonb.adapters";
    public static final String BINARY_DATA_STRATEGY = "jsonb.binary-data-strategy";

    public final JsonbConfig setProperty(String name, Object value) {
        this.configuration.put(name, value);
        return this;
    }

    public final Optional<Object> getProperty(String name) {
        return Optional.ofNullable(this.configuration.get(name));
    }

    public final Map<String, Object> getAsMap() {
        return Collections.unmodifiableMap(this.configuration);
    }

    public final JsonbConfig withFormatting(Boolean formatted) {
        return this.setProperty(FORMATTING, formatted);
    }

    public final JsonbConfig withNullValues(Boolean serializeNullValues) {
        return this.setProperty(NULL_VALUES, serializeNullValues);
    }

    public final JsonbConfig withEncoding(String encoding) {
        return this.setProperty(ENCODING, encoding);
    }

    public final JsonbConfig withStrictIJSON(Boolean enabled) {
        return this.setProperty(STRICT_IJSON, enabled);
    }

    public final JsonbConfig withPropertyNamingStrategy(PropertyNamingStrategy propertyNamingStrategy) {
        return this.setProperty(PROPERTY_NAMING_STRATEGY, propertyNamingStrategy);
    }

    public final JsonbConfig withPropertyNamingStrategy(String propertyNamingStrategy) {
        return this.setProperty(PROPERTY_NAMING_STRATEGY, propertyNamingStrategy);
    }

    public final JsonbConfig withPropertyOrderStrategy(String propertyOrderStrategy) {
        return this.setProperty(PROPERTY_ORDER_STRATEGY, propertyOrderStrategy);
    }

    public final JsonbConfig withPropertyVisibilityStrategy(PropertyVisibilityStrategy propertyVisibilityStrategy) {
        return this.setProperty(PROPERTY_VISIBILITY_STRATEGY, propertyVisibilityStrategy);
    }

    public final JsonbConfig withAdapters(JsonbAdapter ... adapters) {
        return this.setProperty(ADAPTERS, adapters);
    }

    public final JsonbConfig withBinaryDataStrategy(String binaryDataStrategy) {
        return this.setProperty(BINARY_DATA_STRATEGY, binaryDataStrategy);
    }
}

