/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.jsonschema.spi.builtin;

import java.util.function.Function;
import java.util.stream.Stream;
import javax.json.JsonNumber;
import javax.json.JsonValue;
import org.apache.johnzon.jsonschema.ValidationResult;
import org.apache.johnzon.jsonschema.spi.builtin.BaseValidation;

abstract class BaseNumberValidation
extends BaseValidation {
    protected final double bound;

    BaseNumberValidation(String pointer, Function<JsonValue, JsonValue> extractor, double bound) {
        super(pointer, extractor, JsonValue.ValueType.NUMBER);
        this.bound = bound;
    }

    @Override
    protected Stream<ValidationResult.ValidationError> onNumber(JsonNumber number) {
        double val = number.doubleValue();
        if (val <= 0.0) {
            return this.toError(val);
        }
        if (this.isValid(val)) {
            return Stream.empty();
        }
        return this.toError(val);
    }

    protected abstract boolean isValid(double var1);

    protected abstract Stream<ValidationResult.ValidationError> toError(double var1);
}

