/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.jaxrs;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import javax.json.Json;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import javax.json.JsonStructure;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;

@Provider
@Consumes(value={"application/json", "*/json", "*/*+json", "*/x-json", "*/javascript", "*/x-javascript"})
public class JsrMessageBodyReader
implements MessageBodyReader<JsonStructure> {
    private final JsonReaderFactory factory;
    private final boolean closeStream;

    public JsrMessageBodyReader() {
        this(Json.createReaderFactory(Collections.emptyMap()), false);
    }

    public JsrMessageBodyReader(JsonReaderFactory factory, boolean closeStream) {
        this.factory = factory;
        this.closeStream = closeStream;
    }

    public boolean isReadable(Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return JsonStructure.class.isAssignableFrom(aClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonStructure readFrom(Class<JsonStructure> jsonStructureClass, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> stringStringMultivaluedMap, InputStream inputStream) throws IOException, WebApplicationException {
        JsonReader reader = null;
        try {
            reader = this.factory.createReader(inputStream);
            JsonStructure jsonStructure = reader.read();
            return jsonStructure;
        }
        finally {
            if (this.closeStream && reader != null) {
                reader.close();
            }
        }
    }
}

