/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.johnzon.core.BufferStrategy;

public abstract class AbstractJsonFactory
implements Serializable {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    public static final String BUFFER_STRATEGY = "org.apache.johnzon.buffer-strategy";
    public static final BufferStrategy DEFAULT_BUFFER_STRATEGY = BufferStrategy.QUEUE;
    protected final Map<String, Object> internalConfig = new HashMap<String, Object>();

    protected AbstractJsonFactory(Map<String, ?> config, Collection<String> supportedConfigKeys, Collection<String> defaultSupportedConfigKeys) {
        if (config != null) {
            if (defaultSupportedConfigKeys != null) {
                supportedConfigKeys = new ArrayList<String>(supportedConfigKeys);
                supportedConfigKeys.addAll(defaultSupportedConfigKeys);
            }
            for (String configKey : config.keySet()) {
                if (supportedConfigKeys.contains(configKey)) {
                    this.internalConfig.put(configKey, config.get(configKey));
                    continue;
                }
                this.logger.warning(configKey + " is not supported by " + this.getClass().getName());
            }
        }
    }

    protected BufferStrategy getBufferProvider() {
        Object name = this.internalConfig.get(BUFFER_STRATEGY);
        if (name != null) {
            return BufferStrategy.valueOf(name.toString().toUpperCase(Locale.ENGLISH));
        }
        return DEFAULT_BUFFER_STRATEGY;
    }

    protected int getInt(String key, int defaultValue) {
        Object intValue = this.internalConfig.get(key);
        if (intValue == null) {
            return defaultValue;
        }
        if (Number.class.isInstance(intValue)) {
            return ((Number)Number.class.cast(intValue)).intValue();
        }
        return Integer.parseInt(intValue.toString());
    }

    protected boolean getBool(String key, boolean defaultValue) {
        Object boolValue = this.internalConfig.get(key);
        if (boolValue == null) {
            return defaultValue;
        }
        if (Boolean.class.isInstance(boolValue)) {
            return (Boolean)Boolean.class.cast(boolValue);
        }
        return Boolean.parseBoolean(boolValue.toString());
    }
}

