/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.core;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;
import javax.json.stream.JsonGeneratorFactory;
import org.apache.johnzon.core.JsonGeneratorFactoryImpl;
import org.apache.johnzon.core.JsonWriterImpl;

class JsonWriterFactoryImpl
implements JsonWriterFactory,
Serializable {
    private static final Logger LOGGER = Logger.getLogger(JsonWriterFactoryImpl.class.getName());
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private final Map<String, Object> internalConfig = new HashMap<String, Object>();
    private static final Collection<String> SUPPORTED_CONFIG_KEYS = Arrays.asList("javax.json.stream.JsonGenerator.prettyPrinting");
    private final JsonGeneratorFactory factory;

    JsonWriterFactoryImpl(Map<String, ?> config) {
        if (config != null) {
            for (String configKey : config.keySet()) {
                if (SUPPORTED_CONFIG_KEYS.contains(configKey)) {
                    this.internalConfig.put(configKey, config.get(configKey));
                    continue;
                }
                LOGGER.warning(configKey + " not supported by " + this.getClass().getName());
            }
            this.factory = new JsonGeneratorFactoryImpl(this.internalConfig);
        } else {
            this.factory = new JsonGeneratorFactoryImpl(null);
        }
    }

    public JsonWriter createWriter(Writer writer) {
        return new JsonWriterImpl(this.factory.createGenerator(writer));
    }

    public JsonWriter createWriter(OutputStream out) {
        return this.createWriter(new OutputStreamWriter(out, UTF8_CHARSET));
    }

    public JsonWriter createWriter(OutputStream out, Charset charset) {
        return this.createWriter(new OutputStreamWriter(out, charset));
    }

    public Map<String, ?> getConfigInUse() {
        return Collections.unmodifiableMap(this.internalConfig);
    }
}

