/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.core;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import org.apache.johnzon.core.JsonParserFactoryImpl;
import org.apache.johnzon.core.JsonReaderImpl;

class JsonReaderFactoryImpl
implements JsonReaderFactory,
Serializable {
    private static final Logger LOGGER = Logger.getLogger(JsonReaderFactoryImpl.class.getName());
    private final Map<String, Object> internalConfig = new HashMap<String, Object>();
    private static final Collection<String> SUPPORTED_CONFIG_KEYS = Arrays.asList("org.apache.johnzon.buffer-strategy", "org.apache.johnzon.max-string-length", "org.apache.johnzon.default-char-buffer", "org.apache.johnzon.supports-comments");
    private final JsonParserFactoryImpl parserFactory;

    JsonReaderFactoryImpl(Map<String, ?> config) {
        if (config != null) {
            for (String configKey : config.keySet()) {
                if (SUPPORTED_CONFIG_KEYS.contains(configKey)) {
                    this.internalConfig.put(configKey, config.get(configKey));
                    continue;
                }
                LOGGER.warning(configKey + " not supported by " + this.getClass().getName());
            }
            this.parserFactory = new JsonParserFactoryImpl(this.internalConfig);
        } else {
            this.parserFactory = new JsonParserFactoryImpl(null);
        }
    }

    public JsonReader createReader(Reader reader) {
        return new JsonReaderImpl(this.parserFactory.createInternalParser(reader));
    }

    public JsonReader createReader(InputStream in) {
        return new JsonReaderImpl(this.parserFactory.createInternalParser(in));
    }

    public JsonReader createReader(InputStream in, Charset charset) {
        return new JsonReaderImpl(this.parserFactory.createInternalParser(in, charset));
    }

    public Map<String, ?> getConfigInUse() {
        return Collections.unmodifiableMap(this.internalConfig);
    }
}

