/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.core;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.stream.JsonParser;
import javax.json.stream.JsonParserFactory;
import org.apache.johnzon.core.BufferStrategy;
import org.apache.johnzon.core.CommentsJsonStreamParserImpl;
import org.apache.johnzon.core.JsonInMemoryParser;
import org.apache.johnzon.core.JsonStreamParserImpl;

class JsonParserFactoryImpl
implements JsonParserFactory,
Serializable {
    private static final Logger LOGGER = Logger.getLogger(JsonParserFactoryImpl.class.getName());
    public static final String BUFFER_STRATEGY = "org.apache.johnzon.buffer-strategy";
    public static final String MAX_STRING_LENGTH = "org.apache.johnzon.max-string-length";
    public static final String BUFFER_LENGTH = "org.apache.johnzon.default-char-buffer";
    public static final String SUPPORTS_COMMENTS = "org.apache.johnzon.supports-comments";
    public static final int DEFAULT_MAX_SIZE = Integer.getInteger("org.apache.johnzon.max-string-length", 262144);
    public static final boolean DEFAULT_SUPPORTS_COMMENT = false;
    private final Map<String, Object> internalConfig = new HashMap<String, Object>();
    private static final Collection<String> SUPPORTED_CONFIG_KEYS = Arrays.asList("org.apache.johnzon.buffer-strategy", "org.apache.johnzon.max-string-length", "org.apache.johnzon.default-char-buffer", "org.apache.johnzon.supports-comments");
    private final int maxSize;
    private final BufferStrategy.BufferProvider<char[]> bufferProvider;
    private final BufferStrategy.BufferProvider<char[]> valueBufferProvider;
    private final boolean supportsComments;

    JsonParserFactoryImpl(Map<String, ?> config) {
        int bufferSize;
        if (config != null) {
            for (String configKey : config.keySet()) {
                if (SUPPORTED_CONFIG_KEYS.contains(configKey)) {
                    this.internalConfig.put(configKey, config.get(configKey));
                    continue;
                }
                LOGGER.warning(configKey + " is not supported by " + this.getClass().getName());
            }
        }
        if ((bufferSize = this.getInt(BUFFER_LENGTH)) <= 0) {
            throw new IllegalArgumentException("buffer length must be greater than zero");
        }
        this.maxSize = this.getInt(MAX_STRING_LENGTH);
        this.bufferProvider = this.getBufferProvider().newCharProvider(bufferSize);
        this.valueBufferProvider = this.getBufferProvider().newCharProvider(this.maxSize);
        this.supportsComments = this.getBool(SUPPORTS_COMMENTS);
    }

    private BufferStrategy getBufferProvider() {
        Object name = this.internalConfig.get(BUFFER_STRATEGY);
        if (name != null) {
            return BufferStrategy.valueOf(name.toString().toUpperCase(Locale.ENGLISH));
        }
        return BufferStrategy.QUEUE;
    }

    private int getInt(String key) {
        Object maxStringSize = this.internalConfig.get(key);
        if (maxStringSize == null) {
            return DEFAULT_MAX_SIZE;
        }
        if (Number.class.isInstance(maxStringSize)) {
            return ((Number)Number.class.cast(maxStringSize)).intValue();
        }
        return Integer.parseInt(maxStringSize.toString());
    }

    private boolean getBool(String key) {
        Object maxStringSize = this.internalConfig.get(key);
        if (maxStringSize == null) {
            return false;
        }
        if (Boolean.class.isInstance(maxStringSize)) {
            return (Boolean)Boolean.class.cast(maxStringSize);
        }
        return Boolean.parseBoolean(maxStringSize.toString());
    }

    private JsonParser getDefaultJsonParserImpl(InputStream in) {
        if (this.supportsComments) {
            return new CommentsJsonStreamParserImpl(in, this.maxSize, this.bufferProvider, this.valueBufferProvider);
        }
        return new JsonStreamParserImpl(in, this.maxSize, this.bufferProvider, this.valueBufferProvider);
    }

    private JsonParser getDefaultJsonParserImpl(InputStream in, Charset charset) {
        if (this.supportsComments) {
            return new CommentsJsonStreamParserImpl(in, charset, this.maxSize, this.bufferProvider, this.valueBufferProvider);
        }
        return new JsonStreamParserImpl(in, charset, this.maxSize, this.bufferProvider, this.valueBufferProvider);
    }

    private JsonParser getDefaultJsonParserImpl(Reader in) {
        if (this.supportsComments) {
            return new CommentsJsonStreamParserImpl(in, this.maxSize, this.bufferProvider, this.valueBufferProvider);
        }
        return new JsonStreamParserImpl(in, this.maxSize, this.bufferProvider, this.valueBufferProvider);
    }

    public JsonParser createParser(Reader reader) {
        return this.getDefaultJsonParserImpl(reader);
    }

    public JsonParser createParser(InputStream in) {
        return this.getDefaultJsonParserImpl(in);
    }

    public JsonParser createParser(InputStream in, Charset charset) {
        return this.getDefaultJsonParserImpl(in, charset);
    }

    public JsonParser createParser(JsonObject obj) {
        return new JsonInMemoryParser(obj);
    }

    public JsonParser createParser(JsonArray array) {
        return new JsonInMemoryParser(array);
    }

    public Map<String, ?> getConfigInUse() {
        return Collections.unmodifiableMap(this.internalConfig);
    }

    public JsonParser createInternalParser(InputStream in) {
        return this.getDefaultJsonParserImpl(in);
    }

    public JsonParser createInternalParser(InputStream in, Charset charset) {
        return this.getDefaultJsonParserImpl(in, charset);
    }

    public JsonParser createInternalParser(Reader reader) {
        return this.getDefaultJsonParserImpl(reader);
    }
}

