/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.core;

import java.io.OutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;
import org.apache.johnzon.core.BufferStrategy;
import org.apache.johnzon.core.JsonGeneratorImpl;
import org.apache.johnzon.core.JsonPrettyGeneratorImpl;

public class JsonGeneratorFactoryImpl
implements JsonGeneratorFactory,
Serializable {
    public static final String BUFFER_LENGTH = "org.apache.johnzon.default-char-buffer-generator";
    public static final int DEFAULT_BUFFER_LENGTH = Integer.getInteger("org.apache.johnzon.default-char-buffer-generator", 1024);
    private final Map<String, Object> internalConfig = new HashMap<String, Object>();
    private static final Collection<String> SUPPORTED_CONFIG_KEYS = Arrays.asList("javax.json.stream.JsonGenerator.prettyPrinting", "org.apache.johnzon.default-char-buffer-generator", "org.apache.johnzon.buffer-strategy");
    private final ConcurrentMap<String, String> cache = null;
    private final boolean pretty;
    private final BufferStrategy.BufferProvider<char[]> bufferProvider;

    public JsonGeneratorFactoryImpl(Map<String, ?> config) {
        if (config != null) {
            for (String configKey : config.keySet()) {
                if (!SUPPORTED_CONFIG_KEYS.contains(configKey)) continue;
                this.internalConfig.put(configKey, config.get(configKey));
            }
        }
        this.pretty = this.internalConfig.containsKey("javax.json.stream.JsonGenerator.prettyPrinting") ? Boolean.TRUE.equals(this.internalConfig.get("javax.json.stream.JsonGenerator.prettyPrinting")) || "true".equals(this.internalConfig.get("javax.json.stream.JsonGenerator.prettyPrinting")) : false;
        int bufferSize = this.getInt(BUFFER_LENGTH);
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("buffer length must be greater than zero");
        }
        this.bufferProvider = this.getBufferProvider().newCharProvider(bufferSize);
    }

    private BufferStrategy getBufferProvider() {
        Object name = this.internalConfig.get("org.apache.johnzon.buffer-strategy");
        if (name != null) {
            return BufferStrategy.valueOf(name.toString().toUpperCase(Locale.ENGLISH));
        }
        return BufferStrategy.QUEUE;
    }

    private int getInt(String key) {
        Object maxStringSize = this.internalConfig.get(key);
        if (maxStringSize == null) {
            return DEFAULT_BUFFER_LENGTH;
        }
        if (Number.class.isInstance(maxStringSize)) {
            return ((Number)Number.class.cast(maxStringSize)).intValue();
        }
        return Integer.parseInt(maxStringSize.toString());
    }

    public JsonGenerator createGenerator(Writer writer) {
        if (this.pretty) {
            return new JsonPrettyGeneratorImpl(writer, this.bufferProvider, this.cache);
        }
        return new JsonGeneratorImpl(writer, this.bufferProvider, this.cache);
    }

    public JsonGenerator createGenerator(OutputStream out) {
        if (this.pretty) {
            return new JsonPrettyGeneratorImpl(out, this.bufferProvider, this.cache);
        }
        return new JsonGeneratorImpl(out, this.bufferProvider, this.cache);
    }

    public JsonGenerator createGenerator(OutputStream out, Charset charset) {
        if (this.pretty) {
            return new JsonPrettyGeneratorImpl(out, charset, this.bufferProvider, this.cache);
        }
        return new JsonGeneratorImpl(out, charset, this.bufferProvider, this.cache);
    }

    public Map<String, ?> getConfigInUse() {
        return Collections.unmodifiableMap(this.internalConfig);
    }
}

