/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.core;

import java.math.BigDecimal;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.stream.JsonLocation;
import javax.json.stream.JsonParser;
import org.apache.johnzon.core.JsonLocationImpl;
import org.apache.johnzon.core.JsonStringImpl;

class JsonInMemoryParser
implements JsonParser {
    private final Iterator<Entry> iterator;
    private Entry next = null;

    JsonInMemoryParser(JsonObject object) {
        LinkedList<Entry> events = new LinkedList<Entry>();
        JsonInMemoryParser.generateObjectEvents(events, object);
        this.iterator = events.iterator();
    }

    JsonInMemoryParser(JsonArray array) {
        LinkedList<Entry> events = new LinkedList<Entry>();
        JsonInMemoryParser.generateArrayEvents(events, array);
        this.iterator = events.iterator();
    }

    private static void generateObjectEvents(List<Entry> events, JsonObject object) {
        events.add(Entry.START_OBJECT_ENTRY);
        for (Map.Entry entry : object.entrySet()) {
            events.add(new Entry(JsonParser.Event.KEY_NAME, (JsonValue)new JsonStringImpl((String)entry.getKey())));
            JsonValue value = (JsonValue)entry.getValue();
            JsonInMemoryParser.addValueEvents(events, value);
        }
        events.add(Entry.END_OBJECT_ENTRY);
    }

    private static void generateArrayEvents(List<Entry> events, JsonArray array) {
        events.add(Entry.START_ARRAY_ENTRY);
        for (JsonValue value : array) {
            JsonInMemoryParser.addValueEvents(events, value);
        }
        events.add(Entry.END_ARRAY_ENTRY);
    }

    private static void addValueEvents(List<Entry> events, JsonValue value) {
        switch (value.getValueType()) {
            case ARRAY: {
                JsonInMemoryParser.generateArrayEvents(events, (JsonArray)JsonArray.class.cast(value));
                break;
            }
            case OBJECT: {
                JsonInMemoryParser.generateObjectEvents(events, (JsonObject)JsonObject.class.cast(value));
                break;
            }
            case NUMBER: {
                events.add(new Entry(JsonParser.Event.VALUE_NUMBER, value));
                break;
            }
            case STRING: {
                events.add(new Entry(JsonParser.Event.VALUE_STRING, value));
                break;
            }
            case FALSE: {
                events.add(Entry.VALUE_FALSE_ENTRY);
                break;
            }
            case NULL: {
                events.add(Entry.VALUE_NULL_ENTRY);
                break;
            }
            case TRUE: {
                events.add(Entry.VALUE_TRUE_ENTRY);
                break;
            }
            default: {
                throw new IllegalArgumentException(value + " not supported");
            }
        }
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public JsonParser.Event next() {
        this.next = this.iterator.next();
        return this.next.event;
    }

    public String getString() {
        if (this.next.event != JsonParser.Event.KEY_NAME && this.next.event != JsonParser.Event.VALUE_STRING) {
            throw new IllegalStateException("String is for numbers and strings");
        }
        return ((JsonString)JsonString.class.cast(this.next.value)).getString();
    }

    public boolean isIntegralNumber() {
        if (this.next.event != JsonParser.Event.VALUE_NUMBER) {
            throw new IllegalStateException("isIntegralNumber is for numbers");
        }
        return ((JsonNumber)JsonNumber.class.cast(this.next.value)).isIntegral();
    }

    public int getInt() {
        if (this.next.event != JsonParser.Event.VALUE_NUMBER) {
            throw new IllegalStateException("getInt is for numbers");
        }
        return ((JsonNumber)JsonNumber.class.cast(this.next.value)).intValue();
    }

    public long getLong() {
        if (this.next.event != JsonParser.Event.VALUE_NUMBER) {
            throw new IllegalStateException("getLong is for numbers");
        }
        return ((JsonNumber)JsonNumber.class.cast(this.next.value)).longValue();
    }

    public BigDecimal getBigDecimal() {
        if (this.next.event != JsonParser.Event.VALUE_NUMBER) {
            throw new IllegalStateException("getBigDecimal is for numbers");
        }
        return ((JsonNumber)JsonNumber.class.cast(this.next.value)).bigDecimalValue();
    }

    public JsonLocation getLocation() {
        return JsonLocationImpl.UNKNOW_LOCATION;
    }

    public void close() {
    }

    private static class Entry {
        static final Entry VALUE_FALSE_ENTRY = new Entry(JsonParser.Event.VALUE_FALSE, null);
        static final Entry VALUE_TRUE_ENTRY = new Entry(JsonParser.Event.VALUE_TRUE, null);
        static final Entry VALUE_NULL_ENTRY = new Entry(JsonParser.Event.VALUE_NULL, null);
        static final Entry START_OBJECT_ENTRY = new Entry(JsonParser.Event.START_OBJECT, null);
        static final Entry END_OBJECT_ENTRY = new Entry(JsonParser.Event.END_OBJECT, null);
        static final Entry START_ARRAY_ENTRY = new Entry(JsonParser.Event.START_ARRAY, null);
        static final Entry END_ARRAY_ENTRY = new Entry(JsonParser.Event.END_ARRAY, null);
        final JsonParser.Event event;
        final JsonValue value;

        Entry(JsonParser.Event event, JsonValue value) {
            this.event = event;
            this.value = value;
        }
    }
}

