/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.core;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerationException;
import javax.json.stream.JsonGenerator;
import org.apache.johnzon.core.BufferStrategy;
import org.apache.johnzon.core.JsonChars;

class JsonGeneratorImpl
implements JsonGenerator,
JsonChars,
Serializable {
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private final Writer writer;
    private final BufferStrategy.BufferProvider<char[]> bufferProvider;
    private final char[] buffer;
    private int bufferPos = 0;
    protected boolean needComma = false;
    private StructureElement currentStructureElement = null;
    private boolean valid = false;
    protected int depth = 0;
    private static final String UNICODE_PREFIX = "\\u";
    private static final String UNICODE_PREFIX_HELPER = "000";

    JsonGeneratorImpl(Writer writer, BufferStrategy.BufferProvider<char[]> bufferProvider, ConcurrentMap<String, String> cache) {
        this.writer = writer;
        this.buffer = bufferProvider.newBuffer();
        this.bufferProvider = bufferProvider;
    }

    JsonGeneratorImpl(OutputStream out, BufferStrategy.BufferProvider<char[]> bufferProvider, ConcurrentMap<String, String> cache) {
        this(new OutputStreamWriter(out, UTF8_CHARSET), bufferProvider, cache);
    }

    JsonGeneratorImpl(OutputStream out, Charset encoding, BufferStrategy.BufferProvider<char[]> bufferProvider, ConcurrentMap<String, String> cache) {
        this(new OutputStreamWriter(out, encoding), bufferProvider, cache);
    }

    protected void addCommaIfNeeded() {
        if (this.needComma) {
            this.justWrite(',');
            this.needComma = false;
        }
    }

    private void writeCachedOrEscape(String name) {
        this.justWrite('\"');
        this.writeEscaped0(name);
        this.justWrite('\"');
        this.justWrite(':');
    }

    public JsonGenerator writeStartObject() {
        StructureElement localStructureElement;
        if (this.currentStructureElement == null && this.valid) {
            throw new JsonGenerationException("Method must not be called more than once in no context");
        }
        if (this.currentStructureElement != null && !this.currentStructureElement.isArray) {
            throw new JsonGenerationException("Method must not be called within an object context");
        }
        this.currentStructureElement = this.currentStructureElement == null ? new StructureElement(null, false) : (localStructureElement = new StructureElement(this.currentStructureElement, false));
        if (!this.valid) {
            this.valid = true;
        }
        this.noCheckWrite('{');
        ++this.depth;
        return this;
    }

    public JsonGenerator writeStartObject(String name) {
        StructureElement localStructureElement;
        if (this.currentStructureElement == null || this.currentStructureElement.isArray) {
            throw new JsonGenerationException("Method must not be called within an array context");
        }
        this.currentStructureElement = this.currentStructureElement == null ? new StructureElement(null, false) : (localStructureElement = new StructureElement(this.currentStructureElement, false));
        this.addCommaIfNeeded();
        this.writeCachedOrEscape(name);
        this.noCheckWrite('{');
        ++this.depth;
        return this;
    }

    public JsonGenerator writeStartArray() {
        StructureElement localStructureElement;
        if (this.currentStructureElement == null && this.valid) {
            throw new JsonGenerationException("Method must not be called more than once in no context");
        }
        if (this.currentStructureElement != null && !this.currentStructureElement.isArray) {
            throw new JsonGenerationException("Method must not be called within an object context");
        }
        this.currentStructureElement = this.currentStructureElement == null ? new StructureElement(null, true) : (localStructureElement = new StructureElement(this.currentStructureElement, true));
        if (!this.valid) {
            this.valid = true;
        }
        this.noCheckWrite('[');
        ++this.depth;
        return this;
    }

    public JsonGenerator writeStartArray(String name) {
        StructureElement localStructureElement;
        if (this.currentStructureElement == null || this.currentStructureElement.isArray) {
            throw new JsonGenerationException("Method must not be called within an array context");
        }
        this.currentStructureElement = this.currentStructureElement == null ? new StructureElement(null, true) : (localStructureElement = new StructureElement(this.currentStructureElement, true));
        this.addCommaIfNeeded();
        this.writeCachedOrEscape(name);
        this.noCheckWrite('[');
        ++this.depth;
        return this;
    }

    private void writeJsonValue(String name, JsonValue value) {
        if (this.currentStructureElement != null) {
            this.checkObject();
        }
        switch (value.getValueType()) {
            case ARRAY: {
                this.writeStartArray(name);
                JsonArray array = (JsonArray)JsonArray.class.cast(value);
                Iterator ait = array.iterator();
                while (ait.hasNext()) {
                    this.write((JsonValue)ait.next());
                }
                this.writeEnd();
                break;
            }
            case OBJECT: {
                this.writeStartObject(name);
                JsonObject object = (JsonObject)JsonObject.class.cast(value);
                for (Map.Entry keyval : object.entrySet()) {
                    this.write((String)keyval.getKey(), (JsonValue)keyval.getValue());
                }
                this.writeEnd();
                break;
            }
            case STRING: {
                this.write(name, ((JsonString)JsonString.class.cast(value)).getString());
                break;
            }
            case NUMBER: {
                JsonNumber number = (JsonNumber)JsonNumber.class.cast(value);
                if (number.isIntegral()) {
                    this.write(name, number.longValueExact());
                    break;
                }
                this.write(name, number.bigDecimalValue());
                break;
            }
            case TRUE: {
                this.write(name, true);
                break;
            }
            case FALSE: {
                this.write(name, false);
                break;
            }
            case NULL: {
                this.writeNull(name);
                break;
            }
            default: {
                throw new JsonGenerationException("Unknown JsonValue type");
            }
        }
    }

    private void writeJsonValue(JsonValue value) {
        if (this.currentStructureElement != null) {
            this.checkArray();
        }
        switch (value.getValueType()) {
            case ARRAY: {
                this.writeStartArray();
                JsonArray array = (JsonArray)JsonArray.class.cast(value);
                Iterator ait = array.iterator();
                while (ait.hasNext()) {
                    this.write((JsonValue)ait.next());
                }
                this.writeEnd();
                break;
            }
            case OBJECT: {
                this.writeStartObject();
                JsonObject object = (JsonObject)JsonObject.class.cast(value);
                for (Map.Entry keyval : object.entrySet()) {
                    this.write((String)keyval.getKey(), (JsonValue)keyval.getValue());
                }
                this.writeEnd();
                break;
            }
            case STRING: {
                this.write(((JsonString)JsonString.class.cast(value)).getString());
                break;
            }
            case NUMBER: {
                JsonNumber number = (JsonNumber)JsonNumber.class.cast(value);
                if (number.isIntegral()) {
                    this.write(number.longValueExact());
                    break;
                }
                this.write(number.bigDecimalValue());
                break;
            }
            case TRUE: {
                this.write(true);
                break;
            }
            case FALSE: {
                this.write(false);
                break;
            }
            case NULL: {
                this.writeNull();
                break;
            }
            default: {
                throw new JsonGenerationException("Unknown JsonValue type");
            }
        }
    }

    public JsonGenerator write(String name, JsonValue value) {
        this.writeJsonValue(name, value);
        return this;
    }

    public JsonGenerator write(String name, String value) {
        this.checkObject();
        this.addCommaIfNeeded();
        this.writeCachedOrEscape(name);
        this.addCommaIfNeeded();
        this.justWrite('\"');
        this.writeEscaped0(value);
        this.justWrite('\"');
        this.needComma = true;
        return this;
    }

    public JsonGenerator write(String name, BigInteger value) {
        this.checkObject();
        this.addCommaIfNeeded();
        this.writeCachedOrEscape(name);
        this.noCheckWriteAndForceComma(String.valueOf(value));
        return this;
    }

    public JsonGenerator write(String name, BigDecimal value) {
        this.checkObject();
        this.addCommaIfNeeded();
        this.writeCachedOrEscape(name);
        this.noCheckWriteAndForceComma(String.valueOf(value));
        return this;
    }

    public JsonGenerator write(String name, int value) {
        this.checkObject();
        this.addCommaIfNeeded();
        this.writeCachedOrEscape(name);
        this.addCommaIfNeeded();
        this.writeInt0(value);
        this.needComma = true;
        return this;
    }

    public JsonGenerator write(String name, long value) {
        this.checkObject();
        this.addCommaIfNeeded();
        this.writeCachedOrEscape(name);
        this.addCommaIfNeeded();
        this.writeLong0(value);
        this.needComma = true;
        return this;
    }

    public JsonGenerator write(String name, double value) {
        this.checkObject();
        JsonGeneratorImpl.checkDoubleRange(value);
        this.addCommaIfNeeded();
        this.writeCachedOrEscape(name);
        this.noCheckWriteAndForceComma(String.valueOf(value));
        return this;
    }

    public JsonGenerator write(String name, boolean value) {
        this.checkObject();
        this.addCommaIfNeeded();
        this.writeCachedOrEscape(name);
        this.noCheckWriteAndForceComma(String.valueOf(value));
        return this;
    }

    public JsonGenerator writeNull(String name) {
        this.checkObject();
        this.addCommaIfNeeded();
        this.writeCachedOrEscape(name);
        this.noCheckWriteAndForceComma(NULL);
        return this;
    }

    public JsonGenerator writeEnd() {
        if (this.currentStructureElement == null) {
            throw new JsonGenerationException("Method must not be called in no context");
        }
        this.writeEnd(this.currentStructureElement.isArray ? (char)']' : '}');
        this.currentStructureElement = this.currentStructureElement.previous;
        --this.depth;
        return this;
    }

    public JsonGenerator write(JsonValue value) {
        this.writeJsonValue(value);
        if (JsonStructure.class.isInstance(value)) {
            this.valid = true;
        }
        return this;
    }

    public JsonGenerator write(String value) {
        this.checkArray();
        this.addCommaIfNeeded();
        this.justWrite('\"');
        this.writeEscaped0(value);
        this.justWrite('\"');
        this.needComma = true;
        return this;
    }

    public JsonGenerator write(BigDecimal value) {
        this.checkArray();
        this.noCheckWrite(String.valueOf(value));
        this.needComma = true;
        return this;
    }

    public JsonGenerator write(BigInteger value) {
        this.checkArray();
        this.noCheckWrite(String.valueOf(value));
        this.needComma = true;
        return this;
    }

    public JsonGenerator write(int value) {
        this.checkArray();
        this.addCommaIfNeeded();
        this.writeInt0(value);
        this.needComma = true;
        return this;
    }

    public JsonGenerator write(long value) {
        this.checkArray();
        this.addCommaIfNeeded();
        this.writeLong0(value);
        this.needComma = true;
        return this;
    }

    public JsonGenerator write(double value) {
        this.checkArray();
        JsonGeneratorImpl.checkDoubleRange(value);
        this.noCheckWrite(Double.toString(value));
        this.needComma = true;
        return this;
    }

    public JsonGenerator write(boolean value) {
        this.checkArray();
        this.noCheckWrite(Boolean.toString(value));
        this.needComma = true;
        return this;
    }

    public JsonGenerator writeNull() {
        this.checkArray();
        this.noCheckWriteAndForceComma(NULL);
        this.needComma = true;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            if (this.currentStructureElement != null || !this.valid) {
                throw new JsonGenerationException("Invalid json " + this.currentStructureElement + " " + this.valid);
            }
        }
        finally {
            this.flushBuffer();
            try {
                this.writer.close();
            }
            catch (IOException e) {
                throw new JsonException(e.getMessage(), (Throwable)e);
            }
            this.bufferProvider.release(this.buffer);
        }
    }

    public void flush() {
        this.flushBuffer();
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new JsonException(e.getMessage(), (Throwable)e);
        }
    }

    private JsonGenerator noCheckWriteAndForceComma(String value) {
        this.noCheckWrite(value);
        this.needComma = true;
        return this;
    }

    protected JsonGenerator writeEnd(char value) {
        this.justWrite(value);
        this.needComma = true;
        return this;
    }

    protected void noCheckWrite(String value) {
        this.addCommaIfNeeded();
        this.justWrite(value);
    }

    protected void noCheckWrite(char value) {
        this.addCommaIfNeeded();
        this.justWrite(value);
    }

    private void flushBuffer() {
        if (this.bufferPos > 0) {
            try {
                this.writer.write(this.buffer, 0, this.bufferPos);
                this.bufferPos = 0;
            }
            catch (IOException e) {
                throw new JsonException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void writeEscaped0(String value) {
        int len = 0;
        if (value == null || (len = value.length()) == 0) {
            return;
        }
        block10: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            while (c != '\\' && c != '\"' && c >= ' ') {
                this.justWrite(c);
                if (i >= len - 1) {
                    return;
                }
                c = value.charAt(++i);
            }
            switch (c) {
                case '\"': 
                case '\\': {
                    this.justWrite('\\');
                    this.justWrite(c);
                    continue block10;
                }
                default: {
                    if (c < ' ') {
                        switch (c) {
                            case '\n': {
                                this.justWrite("\\n");
                                continue block10;
                            }
                            case '\r': {
                                this.justWrite("\\r");
                                continue block10;
                            }
                            case '\t': {
                                this.justWrite("\\t");
                                continue block10;
                            }
                            case '\b': {
                                this.justWrite("\\b");
                                continue block10;
                            }
                            case '\f': {
                                this.justWrite("\\f");
                                continue block10;
                            }
                        }
                        this.justWrite(JsonGeneratorImpl.toUnicode(c));
                        continue block10;
                    }
                    if (c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        this.justWrite(JsonGeneratorImpl.toUnicode(c));
                        continue block10;
                    }
                    this.justWrite(c);
                }
            }
        }
    }

    private static String toUnicode(char c) {
        String hex = UNICODE_PREFIX_HELPER + Integer.toHexString(c);
        String s = UNICODE_PREFIX + hex.substring(hex.length() - 4);
        return s;
    }

    protected void justWrite(char[] chars) {
        if (this.bufferPos + chars.length >= this.buffer.length) {
            int start = 0;
            int len = this.buffer.length - this.bufferPos;
            while (true) {
                int end;
                if ((end = start + len) > chars.length) {
                    end = chars.length;
                }
                System.arraycopy(chars, start, this.buffer, this.bufferPos, end - start);
                this.bufferPos += end - start;
                if ((start += len) >= chars.length) {
                    return;
                }
                if (this.bufferPos < this.buffer.length) continue;
                this.flushBuffer();
                len = this.buffer.length;
            }
        }
        System.arraycopy(chars, 0, this.buffer, this.bufferPos, chars.length);
        this.bufferPos += chars.length;
    }

    protected void justWrite(String value) {
        int valueLength = value.length();
        if (this.bufferPos + valueLength >= this.buffer.length) {
            int start = 0;
            int len = this.buffer.length - this.bufferPos;
            while (true) {
                int end;
                if ((end = start + len) > valueLength) {
                    end = valueLength;
                }
                value.getChars(start, end, this.buffer, this.bufferPos);
                this.bufferPos += end - start;
                if ((start += len) >= valueLength) {
                    return;
                }
                if (this.bufferPos < this.buffer.length) continue;
                this.flushBuffer();
                len = this.buffer.length;
            }
        }
        value.getChars(0, valueLength, this.buffer, this.bufferPos);
        this.bufferPos += valueLength;
    }

    protected void justWrite(char value) {
        if (this.bufferPos >= this.buffer.length) {
            this.flushBuffer();
        }
        this.buffer[this.bufferPos++] = value;
    }

    private void checkObject() {
        if (this.currentStructureElement == null || this.currentStructureElement.isArray) {
            throw new JsonGenerationException("write(name, param) is only valid in objects");
        }
    }

    private void checkArray() {
        if (this.currentStructureElement == null || !this.currentStructureElement.isArray) {
            throw new JsonGenerationException("write(param) is only valid in arrays");
        }
    }

    private static void checkDoubleRange(double value) {
        if (Double.isInfinite(value) || Double.isNaN(value)) {
            throw new NumberFormatException("double can't be infinite or NaN");
        }
    }

    private void writeLong0(long i) {
        this.justWrite(String.valueOf(i));
    }

    private void writeInt0(int i) {
        this.justWrite(String.valueOf(i));
    }

    private static final class StructureElement {
        final StructureElement previous;
        final boolean isArray;

        StructureElement(StructureElement previous, boolean isArray) {
            this.previous = previous;
            this.isArray = isArray;
        }
    }
}

