/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.core;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.apache.johnzon.core.JsonChars;

class JsonArrayImpl
extends AbstractList<JsonValue>
implements JsonArray,
Serializable {
    private Integer hashCode = null;
    private final List<JsonValue> unmodifieableBackingList;

    JsonArrayImpl(List<JsonValue> backingList) {
        this.unmodifieableBackingList = backingList;
    }

    private <T> T value(int idx, Class<T> type) {
        if (idx > this.unmodifieableBackingList.size()) {
            throw new IndexOutOfBoundsException(idx + "/" + this.unmodifieableBackingList.size());
        }
        return type.cast(this.unmodifieableBackingList.get(idx));
    }

    public JsonObject getJsonObject(int index) {
        return this.value(index, JsonObject.class);
    }

    public JsonArray getJsonArray(int index) {
        return this.value(index, JsonArray.class);
    }

    public JsonNumber getJsonNumber(int index) {
        return this.value(index, JsonNumber.class);
    }

    public JsonString getJsonString(int index) {
        return this.value(index, JsonString.class);
    }

    public <T extends JsonValue> List<T> getValuesAs(Class<T> clazz) {
        return this.unmodifieableBackingList;
    }

    public String getString(int index) {
        return this.value(index, JsonString.class).getString();
    }

    public String getString(int index, String defaultValue) {
        try {
            return this.getString(index);
        }
        catch (IndexOutOfBoundsException ioobe) {
            return defaultValue;
        }
    }

    public int getInt(int index) {
        return this.value(index, JsonNumber.class).intValue();
    }

    public int getInt(int index, int defaultValue) {
        try {
            return this.getInt(index);
        }
        catch (IndexOutOfBoundsException ioobe) {
            return defaultValue;
        }
    }

    public boolean getBoolean(int index) {
        return this.value(index, JsonValue.class) == JsonValue.TRUE;
    }

    public boolean getBoolean(int index, boolean defaultValue) {
        try {
            return this.getBoolean(index);
        }
        catch (IndexOutOfBoundsException ioobe) {
            return defaultValue;
        }
    }

    public boolean isNull(int index) {
        return this.value(index, JsonValue.class) == JsonValue.NULL;
    }

    public JsonValue.ValueType getValueType() {
        return JsonValue.ValueType.ARRAY;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("[");
        Iterator<JsonValue> it = this.unmodifieableBackingList.iterator();
        boolean hasNext = it.hasNext();
        while (hasNext) {
            JsonValue jsonValue = it.next();
            if (JsonString.class.isInstance(jsonValue)) {
                builder.append(jsonValue.toString());
            } else {
                builder.append(jsonValue != JsonValue.NULL ? jsonValue.toString() : JsonChars.NULL);
            }
            if (!(hasNext = it.hasNext())) continue;
            builder.append(",");
        }
        return builder.append(']').toString();
    }

    @Override
    public boolean equals(Object obj) {
        return JsonArrayImpl.class.isInstance(obj) && this.unmodifieableBackingList.equals(((JsonArrayImpl)JsonArrayImpl.class.cast((Object)obj)).unmodifieableBackingList);
    }

    @Override
    public int hashCode() {
        Integer h = this.hashCode;
        if (h == null) {
            h = this.unmodifieableBackingList.hashCode();
            h = this.hashCode;
        }
        return h;
    }

    @Override
    public JsonValue get(int index) {
        return this.unmodifieableBackingList.get(index);
    }

    @Override
    public int size() {
        return this.unmodifieableBackingList.size();
    }
}

