/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.nio.util;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.nio.util.ContentInputBuffer;
import org.apache.http.nio.util.ExpandableBuffer;

public class SharedInputBuffer
extends ExpandableBuffer
implements ContentInputBuffer {
    private final IOControl ioctrl;
    private final Object mutex;
    private volatile boolean shutdown = false;
    private volatile boolean endOfStream = false;

    public SharedInputBuffer(int buffersize, IOControl ioctrl, ByteBufferAllocator allocator) {
        super(buffersize, allocator);
        if (ioctrl == null) {
            throw new IllegalArgumentException("I/O content control may not be null");
        }
        this.ioctrl = ioctrl;
        this.mutex = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        if (this.shutdown) {
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            this.clear();
            this.endOfStream = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int consumeContent(ContentDecoder decoder) throws IOException {
        if (this.shutdown) {
            return -1;
        }
        Object object = this.mutex;
        synchronized (object) {
            int bytesRead;
            this.setInputMode();
            int totalRead = 0;
            while ((bytesRead = decoder.read(this.buffer)) > 0) {
                totalRead += bytesRead;
            }
            if (bytesRead == -1 || decoder.isCompleted()) {
                this.endOfStream = true;
            }
            if (!this.buffer.hasRemaining()) {
                this.ioctrl.suspendInput();
            }
            this.mutex.notifyAll();
            if (totalRead > 0) {
                return totalRead;
            }
            if (this.endOfStream) {
                return -1;
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() {
        Object object = this.mutex;
        synchronized (object) {
            return super.available();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int capacity() {
        Object object = this.mutex;
        synchronized (object) {
            return super.capacity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int length() {
        Object object = this.mutex;
        synchronized (object) {
            return super.length();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForData() throws IOException {
        Object object = this.mutex;
        synchronized (object) {
            try {
                while (!this.hasData() && !this.endOfStream) {
                    if (this.shutdown) {
                        throw new InterruptedIOException("Input operation aborted");
                    }
                    this.ioctrl.requestInput();
                    this.mutex.wait();
                }
            }
            catch (InterruptedException ex) {
                throw new IOException("Interrupted while waiting for more data");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.shutdown) {
            return;
        }
        this.endOfStream = true;
        Object object = this.mutex;
        synchronized (object) {
            this.mutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.shutdown) {
            return;
        }
        this.shutdown = true;
        Object object = this.mutex;
        synchronized (object) {
            this.mutex.notifyAll();
        }
    }

    protected boolean isShutdown() {
        return this.shutdown;
    }

    protected boolean isEndOfStream() {
        return this.shutdown || !this.hasData() && this.endOfStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        if (this.shutdown) {
            return -1;
        }
        Object object = this.mutex;
        synchronized (object) {
            if (!this.hasData()) {
                this.waitForData();
            }
            if (this.isEndOfStream()) {
                return -1;
            }
            return this.buffer.get() & 0xFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.shutdown) {
            return -1;
        }
        if (b == null) {
            return 0;
        }
        Object object = this.mutex;
        synchronized (object) {
            if (!this.hasData()) {
                this.waitForData();
            }
            if (this.isEndOfStream()) {
                return -1;
            }
            this.setOutputMode();
            int chunk = len;
            if (chunk > this.buffer.remaining()) {
                chunk = this.buffer.remaining();
            }
            this.buffer.get(b, off, chunk);
            return chunk;
        }
    }

    public int read(byte[] b) throws IOException {
        if (this.shutdown) {
            return -1;
        }
        if (b == null) {
            return 0;
        }
        return this.read(b, 0, b.length);
    }
}

