/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.benchmark;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.Charset;
import javax.net.SocketFactory;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.benchmark.BenchmarkConnection;
import org.apache.http.benchmark.Config;
import org.apache.http.benchmark.DefaultHeader;
import org.apache.http.benchmark.Stats;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.protocol.HTTP;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.http.protocol.ImmutableHttpProcessor;
import org.apache.http.protocol.RequestConnControl;
import org.apache.http.protocol.RequestContent;
import org.apache.http.protocol.RequestExpectContinue;
import org.apache.http.protocol.RequestTargetHost;
import org.apache.http.protocol.RequestUserAgent;

class BenchmarkWorker
implements Runnable {
    private final byte[] buffer = new byte[4096];
    private final HttpCoreContext context;
    private final HttpProcessor httpProcessor;
    private final HttpRequestExecutor httpexecutor;
    private final ConnectionReuseStrategy connstrategy;
    private final HttpRequest request;
    private final HttpHost targetHost;
    private final Config config;
    private final SocketFactory socketFactory;
    private final Stats stats = new Stats();

    public BenchmarkWorker(HttpRequest request, HttpHost targetHost, SocketFactory socketFactory, Config config) {
        this.context = new HttpCoreContext();
        this.request = request;
        this.targetHost = targetHost;
        this.config = config;
        this.httpProcessor = new ImmutableHttpProcessor(new HttpRequestInterceptor[]{new RequestContent(), new RequestTargetHost(), new RequestConnControl(), new RequestUserAgent("HttpCore-AB/1.1"), new RequestExpectContinue(this.config.isUseExpectContinue())});
        this.httpexecutor = new HttpRequestExecutor();
        this.connstrategy = DefaultConnectionReuseStrategy.INSTANCE;
        this.socketFactory = socketFactory;
    }

    @Override
    public void run() {
        block19: {
            Header header;
            HttpResponse response = null;
            BenchmarkConnection conn = new BenchmarkConnection(8192, this.stats);
            String scheme = this.targetHost.getSchemeName();
            String hostname = this.targetHost.getHostName();
            int port = this.targetHost.getPort();
            if (port == -1) {
                port = scheme.equalsIgnoreCase("https") ? 443 : 80;
            }
            this.context.setTargetHost(this.targetHost);
            this.stats.start();
            int count = this.config.getRequests();
            for (int i = 0; i < count; ++i) {
                try {
                    BenchmarkWorker.resetHeader(this.request);
                    if (!conn.isOpen()) {
                        Socket socket = this.socketFactory != null ? this.socketFactory.createSocket() : new Socket();
                        int timeout = this.config.getSocketTimeout();
                        socket.setSoTimeout(timeout);
                        socket.connect(new InetSocketAddress(hostname, port), timeout);
                        conn.bind(socket);
                    }
                    try {
                        this.httpexecutor.preProcess(this.request, this.httpProcessor, (HttpContext)this.context);
                        response = this.httpexecutor.execute(this.request, (HttpClientConnection)conn, (HttpContext)this.context);
                        this.httpexecutor.postProcess(response, this.httpProcessor, (HttpContext)this.context);
                    }
                    catch (HttpException e) {
                        this.stats.incWriteErrors();
                        if (this.config.getVerbosity() >= 2) {
                            System.err.println("Failed HTTP request : " + e.getMessage());
                        }
                        conn.shutdown();
                        continue;
                    }
                    this.verboseOutput(response);
                    if (response.getStatusLine().getStatusCode() == 200) {
                        this.stats.incSuccessCount();
                    } else {
                        this.stats.incFailureCount();
                    }
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        int l;
                        ContentType ct = ContentType.getOrDefault((HttpEntity)entity);
                        Charset charset = ct.getCharset();
                        if (charset == null) {
                            charset = HTTP.DEF_CONTENT_CHARSET;
                        }
                        long contentlen = 0L;
                        InputStream instream = entity.getContent();
                        while ((l = instream.read(this.buffer)) != -1) {
                            contentlen += (long)l;
                            if (this.config.getVerbosity() < 4) continue;
                            String s = new String(this.buffer, 0, l, charset);
                            System.out.print(s);
                        }
                        instream.close();
                        this.stats.setContentLength(contentlen);
                    }
                    if (this.config.getVerbosity() >= 4) {
                        System.out.println();
                        System.out.println();
                    }
                    if (!this.config.isKeepAlive() || !this.connstrategy.keepAlive(response, (HttpContext)this.context)) {
                        conn.close();
                        continue;
                    }
                    this.stats.incKeepAliveCount();
                    continue;
                }
                catch (IOException ex) {
                    this.stats.incFailureCount();
                    if (this.config.getVerbosity() < 2) continue;
                    System.err.println("I/O error: " + ex.getMessage());
                    continue;
                }
                catch (Exception ex) {
                    this.stats.incFailureCount();
                    if (this.config.getVerbosity() < 2) continue;
                    System.err.println("Generic error: " + ex.getMessage());
                }
            }
            this.stats.finish();
            if (response != null && (header = response.getFirstHeader("Server")) != null) {
                this.stats.setServerName(header.getValue());
            }
            try {
                conn.close();
            }
            catch (IOException ex) {
                this.stats.incFailureCount();
                if (this.config.getVerbosity() < 2) break block19;
                System.err.println("I/O error: " + ex.getMessage());
            }
        }
    }

    private void verboseOutput(HttpResponse response) {
        Header[] headers;
        if (this.config.getVerbosity() >= 3) {
            System.out.println(">> " + this.request.getRequestLine().toString());
            for (Header header : headers = this.request.getAllHeaders()) {
                System.out.println(">> " + header.toString());
            }
            System.out.println();
        }
        if (this.config.getVerbosity() >= 2) {
            System.out.println(response.getStatusLine().getStatusCode());
        }
        if (this.config.getVerbosity() >= 3) {
            System.out.println("<< " + response.getStatusLine().toString());
            for (Header header : headers = response.getAllHeaders()) {
                System.out.println("<< " + header.toString());
            }
            System.out.println();
        }
    }

    private static void resetHeader(HttpRequest request) {
        HeaderIterator it = request.headerIterator();
        while (it.hasNext()) {
            Header header = it.nextHeader();
            if (header instanceof DefaultHeader) continue;
            it.remove();
        }
    }

    public Stats getStats() {
        return this.stats;
    }
}

