/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.benchmark;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.benchmark.BenchmarkWorker;
import org.apache.http.benchmark.CommandLineUtils;
import org.apache.http.benchmark.Config;
import org.apache.http.benchmark.DefaultHeader;
import org.apache.http.benchmark.ResultProcessor;
import org.apache.http.benchmark.Results;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicHttpRequest;

public class HttpBenchmark {
    private final Config config;

    public static void main(String[] args) throws Exception {
        Options options = CommandLineUtils.getOptions();
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(options, args);
        if (args.length == 0 || cmd.hasOption('h') || cmd.getArgs().length != 1) {
            CommandLineUtils.showUsage(options);
            System.exit(1);
        }
        Config config = new Config();
        CommandLineUtils.parseCommandLine(cmd, config);
        if (config.getUrl() == null) {
            CommandLineUtils.showUsage(options);
            System.exit(1);
        }
        HttpBenchmark httpBenchmark = new HttpBenchmark(config);
        httpBenchmark.execute();
    }

    public HttpBenchmark(Config config) {
        this.config = config != null ? config : new Config();
    }

    private HttpRequest createRequest() {
        String[] headers;
        BasicHttpEntityEnclosingRequest request;
        URL url = this.config.getUrl();
        FileEntity entity = null;
        if (this.config.getPayloadFile() != null) {
            FileEntity fe = new FileEntity(this.config.getPayloadFile());
            fe.setContentType(this.config.getContentType());
            fe.setChunked(this.config.isUseChunking());
            entity = fe;
        } else if (this.config.getPayloadText() != null) {
            StringEntity se = new StringEntity(this.config.getPayloadText(), ContentType.parse((String)this.config.getContentType()));
            se.setChunked(this.config.isUseChunking());
            entity = se;
        }
        if ("POST".equals(this.config.getMethod())) {
            BasicHttpEntityEnclosingRequest httppost = new BasicHttpEntityEnclosingRequest("POST", url.getPath());
            httppost.setEntity((HttpEntity)entity);
            request = httppost;
        } else if ("PUT".equals(this.config.getMethod())) {
            BasicHttpEntityEnclosingRequest httpput = new BasicHttpEntityEnclosingRequest("PUT", url.getPath());
            httpput.setEntity((HttpEntity)entity);
            request = httpput;
        } else {
            String path = url.getPath();
            if (url.getQuery() != null && url.getQuery().length() > 0) {
                path = path + "?" + url.getQuery();
            } else if (path.trim().length() == 0) {
                path = "/";
            }
            request = new BasicHttpRequest(this.config.getMethod(), path);
        }
        if (!this.config.isKeepAlive()) {
            request.addHeader((Header)new DefaultHeader("Connection", "Close"));
        }
        if ((headers = this.config.getHeaders()) != null) {
            for (String s : headers) {
                int pos = s.indexOf(58);
                if (pos == -1) continue;
                DefaultHeader header = new DefaultHeader(s.substring(0, pos).trim(), s.substring(pos + 1));
                request.addHeader((Header)header);
            }
        }
        if (this.config.isUseAcceptGZip()) {
            request.addHeader((Header)new DefaultHeader("Accept-Encoding", "gzip"));
        }
        if (this.config.getSoapAction() != null && this.config.getSoapAction().length() > 0) {
            request.addHeader((Header)new DefaultHeader("SOAPAction", this.config.getSoapAction()));
        }
        return request;
    }

    public String execute() throws Exception {
        Results results = this.doExecute();
        ResultProcessor.printResults(results);
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Results doExecute() throws Exception {
        URL url = this.config.getUrl();
        HttpHost host = new HttpHost(url.getHost(), url.getPort(), url.getProtocol());
        ThreadPoolExecutor workerPool = new ThreadPoolExecutor(this.config.getThreads(), this.config.getThreads(), 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "ClientPool");
            }
        });
        workerPool.prestartAllCoreThreads();
        SSLSocketFactory socketFactory = null;
        if ("https".equals(host.getSchemeName())) {
            TrustManager[] trustManagers = null;
            if (this.config.isDisableSSLVerification()) {
                trustManagers = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }};
            } else if (this.config.getTrustStorePath() != null) {
                KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
                FileInputStream instream = new FileInputStream(this.config.getTrustStorePath());
                try {
                    trustStore.load(instream, this.config.getTrustStorePath() != null ? this.config.getTrustStorePath().toCharArray() : null);
                }
                finally {
                    try {
                        instream.close();
                    }
                    catch (IOException ignore) {}
                }
                TrustManagerFactory tmfactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmfactory.init(trustStore);
                trustManagers = tmfactory.getTrustManagers();
            }
            KeyManager[] keyManagers = null;
            if (this.config.getIdentityStorePath() != null) {
                KeyStore identityStore = KeyStore.getInstance(KeyStore.getDefaultType());
                FileInputStream instream = new FileInputStream(this.config.getIdentityStorePath());
                try {
                    identityStore.load(instream, this.config.getIdentityStorePassword() != null ? this.config.getIdentityStorePassword().toCharArray() : null);
                }
                finally {
                    try {
                        instream.close();
                    }
                    catch (IOException ignore) {}
                }
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmf.init(identityStore, this.config.getIdentityStorePassword() != null ? this.config.getIdentityStorePassword().toCharArray() : null);
                keyManagers = kmf.getKeyManagers();
            }
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(keyManagers, trustManagers, null);
            socketFactory = sc.getSocketFactory();
        }
        BenchmarkWorker[] workers = new BenchmarkWorker[this.config.getThreads()];
        for (int i = 0; i < workers.length; ++i) {
            workers[i] = new BenchmarkWorker(this.createRequest(), host, socketFactory, this.config);
            workerPool.execute(workers[i]);
        }
        while (workerPool.getCompletedTaskCount() < (long)this.config.getThreads()) {
            Thread.yield();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ignore) {}
        }
        workerPool.shutdown();
        return ResultProcessor.collectResults(workers, host, this.config.getUrl().toString());
    }
}

