/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.benchmark;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.http.benchmark.Stats;

class CountingOutputStream
extends FilterOutputStream {
    private final Stats stats;

    CountingOutputStream(OutputStream outstream, Stats stats) {
        super(outstream);
        this.stats = stats;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        this.stats.incTotalBytesSent(1L);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
        this.stats.incTotalBytesSent(b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.stats.incTotalBytesSent(len);
    }
}

