/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.cache;

import java.io.IOException;
import java.net.URI;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpHost;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolException;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.cache.CacheResponseStatus;
import org.apache.http.client.cache.HttpCacheEntry;
import org.apache.http.client.cache.HttpCacheStorage;
import org.apache.http.client.cache.ResourceFactory;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.cache.BasicHttpCache;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CacheValidityPolicy;
import org.apache.http.impl.client.cache.CacheableRequestPolicy;
import org.apache.http.impl.client.cache.CachedHttpResponseGenerator;
import org.apache.http.impl.client.cache.CachedResponseSuitabilityChecker;
import org.apache.http.impl.client.cache.ConditionalRequestBuilder;
import org.apache.http.impl.client.cache.HeapResourceFactory;
import org.apache.http.impl.client.cache.HttpCache;
import org.apache.http.impl.client.cache.OptionsHttp11Response;
import org.apache.http.impl.client.cache.RequestProtocolCompliance;
import org.apache.http.impl.client.cache.RequestProtocolError;
import org.apache.http.impl.client.cache.ResponseCachingPolicy;
import org.apache.http.impl.client.cache.ResponseProtocolCompliance;
import org.apache.http.impl.cookie.DateParseException;
import org.apache.http.impl.cookie.DateUtils;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.VersionInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class CachingHttpClient
implements HttpClient {
    public static final String CACHE_RESPONSE_STATUS = "http.cache.response.status";
    private static final boolean SUPPORTS_RANGE_AND_CONTENT_RANGE_HEADERS = false;
    private final AtomicLong cacheHits = new AtomicLong();
    private final AtomicLong cacheMisses = new AtomicLong();
    private final AtomicLong cacheUpdates = new AtomicLong();
    private final HttpClient backend;
    private final HttpCache responseCache;
    private final CacheValidityPolicy validityPolicy;
    private final ResponseCachingPolicy responseCachingPolicy;
    private final CachedHttpResponseGenerator responseGenerator;
    private final CacheableRequestPolicy cacheableRequestPolicy;
    private final CachedResponseSuitabilityChecker suitabilityChecker;
    private final ConditionalRequestBuilder conditionalRequestBuilder;
    private final int maxObjectSizeBytes;
    private final boolean sharedCache;
    private final ResponseProtocolCompliance responseCompliance;
    private final RequestProtocolCompliance requestCompliance;
    private final Log log = LogFactory.getLog(this.getClass());

    CachingHttpClient(HttpClient client, HttpCache cache, CacheConfig config) {
        if (client == null) {
            throw new IllegalArgumentException("HttpClient may not be null");
        }
        if (cache == null) {
            throw new IllegalArgumentException("HttpCache may not be null");
        }
        if (config == null) {
            throw new IllegalArgumentException("CacheConfig may not be null");
        }
        this.maxObjectSizeBytes = config.getMaxObjectSizeBytes();
        this.sharedCache = config.isSharedCache();
        this.backend = client;
        this.responseCache = cache;
        this.validityPolicy = new CacheValidityPolicy();
        this.responseCachingPolicy = new ResponseCachingPolicy(this.maxObjectSizeBytes, this.sharedCache);
        this.responseGenerator = new CachedHttpResponseGenerator(this.validityPolicy);
        this.cacheableRequestPolicy = new CacheableRequestPolicy();
        this.suitabilityChecker = new CachedResponseSuitabilityChecker(this.validityPolicy, config);
        this.conditionalRequestBuilder = new ConditionalRequestBuilder();
        this.responseCompliance = new ResponseProtocolCompliance();
        this.requestCompliance = new RequestProtocolCompliance();
    }

    public CachingHttpClient() {
        this((HttpClient)new DefaultHttpClient(), new BasicHttpCache(), new CacheConfig());
    }

    public CachingHttpClient(CacheConfig config) {
        this((HttpClient)new DefaultHttpClient(), new BasicHttpCache(config), config);
    }

    public CachingHttpClient(HttpClient client) {
        this(client, new BasicHttpCache(), new CacheConfig());
    }

    public CachingHttpClient(HttpClient client, CacheConfig config) {
        this(client, new BasicHttpCache(config), config);
    }

    public CachingHttpClient(HttpClient client, ResourceFactory resourceFactory, HttpCacheStorage storage, CacheConfig config) {
        this(client, new BasicHttpCache(resourceFactory, storage, config), config);
    }

    public CachingHttpClient(HttpClient client, HttpCacheStorage storage, CacheConfig config) {
        this(client, new BasicHttpCache(new HeapResourceFactory(), storage, config), config);
    }

    CachingHttpClient(HttpClient backend, CacheValidityPolicy validityPolicy, ResponseCachingPolicy responseCachingPolicy, HttpCache responseCache, CachedHttpResponseGenerator responseGenerator, CacheableRequestPolicy cacheableRequestPolicy, CachedResponseSuitabilityChecker suitabilityChecker, ConditionalRequestBuilder conditionalRequestBuilder, ResponseProtocolCompliance responseCompliance, RequestProtocolCompliance requestCompliance) {
        CacheConfig config = new CacheConfig();
        this.maxObjectSizeBytes = config.getMaxObjectSizeBytes();
        this.sharedCache = config.isSharedCache();
        this.backend = backend;
        this.validityPolicy = validityPolicy;
        this.responseCachingPolicy = responseCachingPolicy;
        this.responseCache = responseCache;
        this.responseGenerator = responseGenerator;
        this.cacheableRequestPolicy = cacheableRequestPolicy;
        this.suitabilityChecker = suitabilityChecker;
        this.conditionalRequestBuilder = conditionalRequestBuilder;
        this.responseCompliance = responseCompliance;
        this.requestCompliance = requestCompliance;
    }

    public long getCacheHits() {
        return this.cacheHits.get();
    }

    public long getCacheMisses() {
        return this.cacheMisses.get();
    }

    public long getCacheUpdates() {
        return this.cacheUpdates.get();
    }

    public HttpResponse execute(HttpHost target, HttpRequest request) throws IOException {
        HttpContext defaultContext = null;
        return this.execute(target, request, defaultContext);
    }

    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler) throws IOException {
        return this.execute(target, request, responseHandler, null);
    }

    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException {
        HttpResponse resp = this.execute(target, request, context);
        return (T)responseHandler.handleResponse(resp);
    }

    public HttpResponse execute(HttpUriRequest request) throws IOException {
        HttpContext context = null;
        return this.execute(request, context);
    }

    public HttpResponse execute(HttpUriRequest request, HttpContext context) throws IOException {
        URI uri = request.getURI();
        HttpHost httpHost = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
        return this.execute(httpHost, (HttpRequest)request, context);
    }

    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler) throws IOException {
        return this.execute(request, responseHandler, null);
    }

    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException {
        HttpResponse resp = this.execute(request, context);
        return (T)responseHandler.handleResponse(resp);
    }

    public ClientConnectionManager getConnectionManager() {
        return this.backend.getConnectionManager();
    }

    public HttpParams getParams() {
        return this.backend.getParams();
    }

    public HttpResponse execute(HttpHost target, HttpRequest request, HttpContext context) throws IOException {
        this.setResponseStatus(context, CacheResponseStatus.CACHE_MISS);
        String via = this.generateViaHeader((HttpMessage)request);
        if (this.clientRequestsOurOptions(request)) {
            this.setResponseStatus(context, CacheResponseStatus.CACHE_MODULE_RESPONSE);
            return new OptionsHttp11Response();
        }
        List<RequestProtocolError> fatalError = this.requestCompliance.requestIsFatallyNonCompliant(request);
        Iterator<RequestProtocolError> i$ = fatalError.iterator();
        if (i$.hasNext()) {
            RequestProtocolError error = i$.next();
            this.setResponseStatus(context, CacheResponseStatus.CACHE_MODULE_RESPONSE);
            return this.requestCompliance.getErrorForRequest(error);
        }
        try {
            request = this.requestCompliance.makeRequestCompliant(request);
        }
        catch (ProtocolException e) {
            throw new ClientProtocolException((Throwable)e);
        }
        request.addHeader("Via", via);
        try {
            this.responseCache.flushInvalidatedCacheEntriesFor(target, request);
        }
        catch (IOException ioe) {
            this.log.warn((Object)"Unable to flush invalidated entries from cache", (Throwable)ioe);
        }
        if (!this.cacheableRequestPolicy.isServableFromCache(request)) {
            return this.callBackend(target, request, context);
        }
        HttpCacheEntry entry = null;
        try {
            entry = this.responseCache.getCacheEntry(target, request);
        }
        catch (IOException ioe) {
            this.log.warn((Object)"Unable to retrieve entries from cache", (Throwable)ioe);
        }
        if (entry == null) {
            this.cacheMisses.getAndIncrement();
            if (this.log.isDebugEnabled()) {
                RequestLine rl = request.getRequestLine();
                this.log.debug((Object)("Cache miss [host: " + target + "; uri: " + rl.getUri() + "]"));
            }
            if (!this.mayCallBackend(request)) {
                return new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 504, "Gateway Timeout");
            }
            Set variantEntries = null;
            try {
                this.responseCache.getVariantCacheEntries(target, request);
            }
            catch (IOException ioe) {
                this.log.warn((Object)"Unable to retrieve variant entries from cache", (Throwable)ioe);
            }
            if (variantEntries != null && variantEntries.size() > 0) {
                try {
                    return this.negotiateResponseFromVariants(target, request, context, variantEntries);
                }
                catch (ProtocolException e) {
                    throw new ClientProtocolException((Throwable)e);
                }
            }
            return this.callBackend(target, request, context);
        }
        if (this.log.isDebugEnabled()) {
            RequestLine rl = request.getRequestLine();
            this.log.debug((Object)("Cache hit [host: " + target + "; uri: " + rl.getUri() + "]"));
        }
        this.cacheHits.getAndIncrement();
        Date now = this.getCurrentDate();
        if (this.suitabilityChecker.canCachedResponseBeUsed(target, request, entry, now)) {
            HttpResponse cachedResponse = request.containsHeader("If-None-Match") || request.containsHeader("If-Modified-Since") ? this.responseGenerator.generateNotModifiedResponse(entry) : this.responseGenerator.generateResponse(entry);
            this.setResponseStatus(context, CacheResponseStatus.CACHE_HIT);
            if (this.validityPolicy.getStalenessSecs(entry, now) > 0L) {
                cachedResponse.addHeader("Warning", "110 localhost \"Response is stale\"");
            }
            return cachedResponse;
        }
        if (!this.mayCallBackend(request)) {
            return new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 504, "Gateway Timeout");
        }
        if (this.validityPolicy.isRevalidatable(entry)) {
            this.log.debug((Object)"Revalidating the cache entry");
            try {
                return this.revalidateCacheEntry(target, request, context, entry);
            }
            catch (IOException ioex) {
                if (this.validityPolicy.mustRevalidate(entry) || this.isSharedCache() && this.validityPolicy.proxyRevalidate(entry) || this.explicitFreshnessRequest(request, entry, now)) {
                    this.setResponseStatus(context, CacheResponseStatus.CACHE_MODULE_RESPONSE);
                    return new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 504, "Gateway Timeout");
                }
                HttpResponse cachedResponse = this.responseGenerator.generateResponse(entry);
                this.setResponseStatus(context, CacheResponseStatus.CACHE_HIT);
                cachedResponse.addHeader("Warning", "111 localhost \"Revalidation failed\"");
                this.log.debug((Object)("111 revalidation failed due to exception: " + ioex));
                return cachedResponse;
            }
            catch (ProtocolException e) {
                throw new ClientProtocolException((Throwable)e);
            }
        }
        return this.callBackend(target, request, context);
    }

    private boolean mayCallBackend(HttpRequest request) {
        for (Header h : request.getHeaders("Cache-Control")) {
            for (HeaderElement elt : h.getElements()) {
                if (!"only-if-cached".equals(elt.getName())) continue;
                return false;
            }
        }
        return true;
    }

    private boolean explicitFreshnessRequest(HttpRequest request, HttpCacheEntry entry, Date now) {
        for (Header h : request.getHeaders("Cache-Control")) {
            for (HeaderElement elt : h.getElements()) {
                if ("max-stale".equals(elt.getName())) {
                    try {
                        int maxstale = Integer.parseInt(elt.getValue());
                        long age = this.validityPolicy.getCurrentAgeSecs(entry, now);
                        long lifetime = this.validityPolicy.getFreshnessLifetimeSecs(entry);
                        if (age - lifetime <= (long)maxstale) continue;
                        return true;
                    }
                    catch (NumberFormatException nfe) {
                        return true;
                    }
                }
                if (!"min-fresh".equals(elt.getName()) && !"max-age".equals(elt.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private String generateViaHeader(HttpMessage msg) {
        VersionInfo vi = VersionInfo.loadVersionInfo((String)"org.apache.http.client", (ClassLoader)this.getClass().getClassLoader());
        String release = vi != null ? vi.getRelease() : "UNAVAILABLE";
        ProtocolVersion pv = msg.getProtocolVersion();
        if ("http".equalsIgnoreCase(pv.getProtocol())) {
            return String.format("%d.%d localhost (Apache-HttpClient/%s (cache))", pv.getMajor(), pv.getMinor(), release);
        }
        return String.format("%s/%d.%d localhost (Apache-HttpClient/%s (cache))", pv.getProtocol(), pv.getMajor(), pv.getMinor(), release);
    }

    private void setResponseStatus(HttpContext context, CacheResponseStatus value) {
        if (context != null) {
            context.setAttribute(CACHE_RESPONSE_STATUS, (Object)value);
        }
    }

    public boolean supportsRangeAndContentRangeHeaders() {
        return false;
    }

    public boolean isSharedCache() {
        return this.sharedCache;
    }

    Date getCurrentDate() {
        return new Date();
    }

    boolean clientRequestsOurOptions(HttpRequest request) {
        RequestLine line = request.getRequestLine();
        if (!"OPTIONS".equals(line.getMethod())) {
            return false;
        }
        if (!"*".equals(line.getUri())) {
            return false;
        }
        return "0".equals(request.getFirstHeader("Max-Forwards").getValue());
    }

    HttpResponse callBackend(HttpHost target, HttpRequest request, HttpContext context) throws IOException {
        Date requestDate = this.getCurrentDate();
        this.log.debug((Object)"Calling the backend");
        HttpResponse backendResponse = this.backend.execute(target, request, context);
        backendResponse.addHeader("Via", this.generateViaHeader((HttpMessage)backendResponse));
        return this.handleBackendResponse(target, request, requestDate, this.getCurrentDate(), backendResponse);
    }

    HttpResponse negotiateResponseFromVariants(HttpHost target, HttpRequest request, HttpContext context, Set<HttpCacheEntry> variantEntries) throws IOException, ProtocolException {
        HttpRequest conditionalRequest = this.conditionalRequestBuilder.buildConditionalRequestFromVariants(request, variantEntries);
        Date requestDate = this.getCurrentDate();
        HttpResponse backendResponse = this.backend.execute(target, conditionalRequest, context);
        Date responseDate = this.getCurrentDate();
        backendResponse.addHeader("Via", this.generateViaHeader((HttpMessage)backendResponse));
        if (backendResponse.getStatusLine().getStatusCode() != 304) {
            return this.handleBackendResponse(target, conditionalRequest, requestDate, responseDate, backendResponse);
        }
        Header resultEtagHeader = backendResponse.getFirstHeader("ETag");
        if (resultEtagHeader == null) {
            this.log.debug((Object)"304 response did not contain ETag");
            return this.callBackend(target, request, context);
        }
        HttpCacheEntry matchedEntry = null;
        String resultEtag = resultEtagHeader.getValue();
        for (HttpCacheEntry variantEntry : variantEntries) {
            String variantEtag;
            Header variantEtagHeader = variantEntry.getFirstHeader("ETag");
            if (variantEtagHeader == null || !resultEtag.equals(variantEtag = variantEtagHeader.getValue())) continue;
            matchedEntry = variantEntry;
            break;
        }
        if (matchedEntry == null) {
            this.log.debug((Object)"304 response did not contain ETag matching one sent in If-None-Match");
            return this.callBackend(target, request, context);
        }
        Header entryDateHeader = matchedEntry.getFirstHeader("Date");
        Header responseDateHeader = backendResponse.getFirstHeader("Date");
        if (entryDateHeader != null && responseDateHeader != null) {
            try {
                Date entryDate = DateUtils.parseDate((String)entryDateHeader.getValue());
                Date respDate = DateUtils.parseDate((String)responseDateHeader.getValue());
                if (respDate.before(entryDate)) {
                    HttpRequest unconditional = this.conditionalRequestBuilder.buildUnconditionalRequest(request, matchedEntry);
                    return this.callBackend(target, unconditional, context);
                }
            }
            catch (DateParseException e) {
                // empty catch block
            }
        }
        this.cacheUpdates.getAndIncrement();
        this.setResponseStatus(context, CacheResponseStatus.VALIDATED);
        HttpCacheEntry responseEntry = matchedEntry;
        try {
            responseEntry = this.responseCache.updateCacheEntry(target, conditionalRequest, matchedEntry, backendResponse, requestDate, responseDate);
        }
        catch (IOException ioe) {
            this.log.warn((Object)"Could not update cache entry", (Throwable)ioe);
        }
        HttpResponse resp = this.responseGenerator.generateResponse(responseEntry);
        try {
            resp = this.responseCache.cacheAndReturnResponse(target, request, resp, requestDate, responseDate);
        }
        catch (IOException ioe) {
            this.log.warn((Object)"Could not cache entry", (Throwable)ioe);
        }
        if (this.suitabilityChecker.isConditional(request) && this.suitabilityChecker.allConditionalsMatch(request, responseEntry, new Date())) {
            return this.responseGenerator.generateNotModifiedResponse(responseEntry);
        }
        return resp;
    }

    HttpResponse revalidateCacheEntry(HttpHost target, HttpRequest request, HttpContext context, HttpCacheEntry cacheEntry) throws IOException, ProtocolException {
        HttpRequest conditionalRequest = this.conditionalRequestBuilder.buildConditionalRequest(request, cacheEntry);
        Date requestDate = this.getCurrentDate();
        HttpResponse backendResponse = this.backend.execute(target, conditionalRequest, context);
        Date responseDate = this.getCurrentDate();
        Header entryDateHeader = cacheEntry.getFirstHeader("Date");
        Header responseDateHeader = backendResponse.getFirstHeader("Date");
        if (entryDateHeader != null && responseDateHeader != null) {
            try {
                Date entryDate = DateUtils.parseDate((String)entryDateHeader.getValue());
                Date respDate = DateUtils.parseDate((String)responseDateHeader.getValue());
                if (respDate.before(entryDate)) {
                    HttpRequest unconditional = this.conditionalRequestBuilder.buildUnconditionalRequest(request, cacheEntry);
                    requestDate = this.getCurrentDate();
                    backendResponse = this.backend.execute(target, unconditional, context);
                    responseDate = this.getCurrentDate();
                }
            }
            catch (DateParseException e) {
                // empty catch block
            }
        }
        backendResponse.addHeader("Via", this.generateViaHeader((HttpMessage)backendResponse));
        int statusCode = backendResponse.getStatusLine().getStatusCode();
        if (statusCode == 304 || statusCode == 200) {
            this.cacheUpdates.getAndIncrement();
            this.setResponseStatus(context, CacheResponseStatus.VALIDATED);
        }
        if (statusCode == 304) {
            HttpCacheEntry updatedEntry = this.responseCache.updateCacheEntry(target, request, cacheEntry, backendResponse, requestDate, responseDate);
            if (this.suitabilityChecker.isConditional(request) && this.suitabilityChecker.allConditionalsMatch(request, updatedEntry, new Date())) {
                return this.responseGenerator.generateNotModifiedResponse(updatedEntry);
            }
            return this.responseGenerator.generateResponse(updatedEntry);
        }
        return this.handleBackendResponse(target, conditionalRequest, requestDate, responseDate, backendResponse);
    }

    HttpResponse handleBackendResponse(HttpHost target, HttpRequest request, Date requestDate, Date responseDate, HttpResponse backendResponse) throws IOException {
        this.log.debug((Object)"Handling Backend response");
        this.responseCompliance.ensureProtocolCompliance(request, backendResponse);
        boolean cacheable = this.responseCachingPolicy.isResponseCacheable(request, backendResponse);
        if (cacheable && !this.alreadyHaveNewerCacheEntry(target, request, backendResponse)) {
            try {
                return this.responseCache.cacheAndReturnResponse(target, request, backendResponse, requestDate, responseDate);
            }
            catch (IOException ioe) {
                this.log.warn((Object)"Unable to store entries in cache", (Throwable)ioe);
            }
        }
        if (!cacheable) {
            try {
                this.responseCache.flushCacheEntriesFor(target, request);
            }
            catch (IOException ioe) {
                this.log.warn((Object)"Unable to flush invalid cache entries", (Throwable)ioe);
            }
        }
        return backendResponse;
    }

    private boolean alreadyHaveNewerCacheEntry(HttpHost target, HttpRequest request, HttpResponse backendResponse) throws IOException {
        HttpCacheEntry existing = null;
        try {
            existing = this.responseCache.getCacheEntry(target, request);
        }
        catch (IOException ioe) {
            // empty catch block
        }
        if (existing == null) {
            return false;
        }
        Header entryDateHeader = existing.getFirstHeader("Date");
        if (entryDateHeader == null) {
            return false;
        }
        Header responseDateHeader = backendResponse.getFirstHeader("Date");
        if (responseDateHeader == null) {
            return false;
        }
        try {
            Date entryDate = DateUtils.parseDate((String)entryDateHeader.getValue());
            Date responseDate = DateUtils.parseDate((String)responseDateHeader.getValue());
            return responseDate.before(entryDate);
        }
        catch (DateParseException e) {
            return false;
        }
    }
}

